/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.handler.convertQSHandler;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.ICustomDBStrategy;
import com.kingdee.bos.qing.common.strategy.TXDBExcuter;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.source.FileSource;
import com.kingdee.bos.qing.manage.handler.ISubjectManageHandler;
import com.kingdee.bos.qing.manage.handler.convertQSHandler.domain.ConvertQSHandleDomain;
import com.kingdee.bos.qing.manage.handler.convertQSHandler.model.ConvertQSEntityInfo;
import com.kingdee.bos.qing.manage.handler.convertQSHandler.model.ConvertStateEnum;
import com.kingdee.bos.qing.manage.handler.convertQSHandler.task.ConvertQSFileTask;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.MapUtils;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class ConvertQSFileHandler
implements ISubjectManageHandler {
    private QingContext qingContext;
    private ConvertQSHandleDomain convertQSHandleDomain;

    public ConvertQSFileHandler(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    private ConvertQSHandleDomain getConvertQSHandleDomain() {
        if (this.convertQSHandleDomain == null) {
            ICustomDBStrategy customDbService = (ICustomDBStrategy)CustomStrategyRegistrar.getStrategy(ICustomDBStrategy.class);
            TXDBExcuter tXDBExcuter = customDbService.getTXAndDBExecutor(this.qingContext);
            this.convertQSHandleDomain = new ConvertQSHandleDomain(tXDBExcuter.getDbExcuter(), tXDBExcuter.getTx(), this.qingContext);
        }
        return this.convertQSHandleDomain;
    }

    @Override
    public void handleAfterSaveModel(final String themeId, final Box boxModel, final Box originalBoxModel) {
        ThreadPoolManage.excuteThreadWithContext((ThreadPoolManage.QingThreadPoolName)ThreadPoolManage.QingThreadPoolName.QING_RUN_IN_BACKGROUND_HANDLER, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    Map<AbstractSource, List<Entity>> handleEntityMap = ConvertQSFileHandler.this.getConvertQSHandleDomain().getHandleEntityMap(boxModel);
                    HashMap<String, ConvertQSEntityInfo> convertQSEntityInfoMap = new HashMap<String, ConvertQSEntityInfo>();
                    ConvertQSFileHandler.this.collectNeedHandleEntityUniqueKey(handleEntityMap, themeId, convertQSEntityInfoMap);
                    ConvertQSFileHandler.this.collectNeedDeleteEntityUniqueKey(handleEntityMap, originalBoxModel, themeId, convertQSEntityInfoMap);
                    ConvertQSFileHandler.this.getConvertQSHandleDomain().addEntityUniqueKeyToCacheSet(convertQSEntityInfoMap, themeId);
                    ConvertQSFileHandler.this.addThreadPoolExecute(themeId);
                }
                catch (Exception e) {
                    LogUtil.error((String)"convert qs file error", (Throwable)e);
                }
                return true;
            }
        }, (QingContext)this.qingContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addThreadPoolExecute(String themeId) throws QingLockRequireException, InterruptedException {
        String entityThemeUniqueCacheKey = this.createEntityThemeUniqueCacheKey(themeId);
        ILock lock = LockFactory.createLock((String)entityThemeUniqueCacheKey);
        try {
            if (lock.tryLock()) {
                ConvertQSEntityInfo convertQSFileEntityInfo = this.getNotHandleConvertQSEntityInfoFromCache(themeId);
                while (convertQSFileEntityInfo != null) {
                    ConvertQSFileTask convertQSFileTask = new ConvertQSFileTask(convertQSFileEntityInfo, this.qingContext);
                    ThreadPoolManage.excuteThreadWithContext((ThreadPoolManage.QingThreadPoolName)ThreadPoolManage.QingThreadPoolName.QING_RUN_IN_BACKGROUND_HANDLER, (Callable)convertQSFileTask, (QingContext)this.qingContext);
                    convertQSFileEntityInfo = this.getNotHandleConvertQSEntityInfoFromCache(themeId);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public String createEntityThemeUniqueCacheKey(String themeId) {
        return "Qing.Convert.QS.lock_writing_qs_file_theme_" + themeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConvertQSEntityInfo getNotHandleConvertQSEntityInfoFromCache(String themeId) throws QingLockRequireException, InterruptedException {
        String entityUniqueInfoSetCacheKey = this.getConvertQSHandleDomain().createEntityUniqueInfoSetCacheKey(themeId);
        ILock lock = LockFactory.createLock((String)entityUniqueInfoSetCacheKey);
        try {
            lock.lock();
            IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
            String s = globalQingSession.get(entityUniqueInfoSetCacheKey);
            if (StringUtils.isNotBlank((CharSequence)s)) {
                Set convertQSEntityInfoSet = (Set)JsonUtil.decodeFromString((String)s, HashSet.class);
                HashSet<String> newConvertQSEntityInfoSet = new HashSet<String>(convertQSEntityInfoSet);
                if (CollectionUtils.isNotEmpty((Collection)convertQSEntityInfoSet)) {
                    for (String key : convertQSEntityInfoSet) {
                        ConvertQSEntityInfo convertQSEntityInfo = (ConvertQSEntityInfo)JsonUtil.decodeFromString((String)key, ConvertQSEntityInfo.class);
                        if (convertQSEntityInfo.isSubmitHandle()) continue;
                        convertQSEntityInfo.setSubmitHandle(true);
                        newConvertQSEntityInfoSet.remove(key);
                        newConvertQSEntityInfoSet.add(JsonUtil.encodeToString((Object)convertQSEntityInfo));
                        this.getConvertQSHandleDomain().addConvertQSEntityInfoSetToCache(globalQingSession, entityUniqueInfoSetCacheKey, newConvertQSEntityInfoSet);
                        ConvertQSEntityInfo convertQSEntityInfo2 = convertQSEntityInfo;
                        return convertQSEntityInfo2;
                    }
                }
            }
            ConvertQSEntityInfo convertQSEntityInfo = null;
            return convertQSEntityInfo;
        }
        finally {
            lock.unlock();
        }
    }

    private void collectNeedDeleteEntityUniqueKey(Map<AbstractSource, List<Entity>> handleEntityMap, Box originalBoxModel, String themeId, Map<String, ConvertQSEntityInfo> convertQSEntityInfoMap) {
        Map<AbstractSource, List<Entity>> deletedEntityMap = this.getConvertQSHandleDomain().getDeletedEntity(handleEntityMap, originalBoxModel);
        this.addEntityUniqueKeyToSet(deletedEntityMap, ConvertStateEnum.DELETE, themeId, convertQSEntityInfoMap);
    }

    private void collectNeedHandleEntityUniqueKey(Map<AbstractSource, List<Entity>> handleEntityMap, String themeId, Map<String, ConvertQSEntityInfo> convertQSEntityInfoMap) {
        this.addEntityUniqueKeyToSet(handleEntityMap, ConvertStateEnum.ADD, themeId, convertQSEntityInfoMap);
    }

    private void addEntityUniqueKeyToSet(Map<AbstractSource, List<Entity>> handleEntityMap, ConvertStateEnum convertStateEnum, String themeId, Map<String, ConvertQSEntityInfo> convertQSEntityInfoMap) {
        if (MapUtils.isNotEmpty(handleEntityMap)) {
            for (Map.Entry<AbstractSource, List<Entity>> entry : handleEntityMap.entrySet()) {
                AbstractSource source = entry.getKey();
                FileSource fileSource = (FileSource)source;
                List<Entity> entityList = entry.getValue();
                if (!CollectionUtils.isNotEmpty(entityList)) continue;
                for (Entity entity : entityList) {
                    String entityUniqueKey = this.getConvertQSHandleDomain().createEntityUniqueCacheKey(fileSource.getFileUrl(), entity.getName());
                    ConvertQSEntityInfo convertQSEntityInfo = new ConvertQSEntityInfo();
                    convertQSEntityInfo.setFileUrl(fileSource.getFileUrl());
                    convertQSEntityInfo.setEntityName(entity.getName());
                    convertQSEntityInfo.setThemeId(themeId);
                    convertQSEntityInfo.setConvertState(convertStateEnum);
                    convertQSEntityInfoMap.put(entityUniqueKey, convertQSEntityInfo);
                }
            }
        }
    }

    @Override
    public void handleAfterDeleteTheme(final Box box, final String themeId) {
        if (box == null) {
            return;
        }
        ThreadPoolManage.excuteThreadWithContext((ThreadPoolManage.QingThreadPoolName)ThreadPoolManage.QingThreadPoolName.QING_RUN_IN_BACKGROUND_HANDLER, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    Map<AbstractSource, List<Entity>> deleteEntityMap = ConvertQSFileHandler.this.getConvertQSHandleDomain().getHandleEntityMap(box);
                    if (MapUtils.isNotEmpty(deleteEntityMap)) {
                        HashMap<String, ConvertQSEntityInfo> convertQSEntityInfoMap = new HashMap<String, ConvertQSEntityInfo>();
                        ConvertQSFileHandler.this.addEntityUniqueKeyToSet(deleteEntityMap, ConvertStateEnum.DELETE, themeId, convertQSEntityInfoMap);
                        ConvertQSFileHandler.this.getConvertQSHandleDomain().addEntityUniqueKeyToCacheSet(convertQSEntityInfoMap, themeId);
                        ConvertQSFileHandler.this.addThreadPoolExecute(themeId);
                    }
                }
                catch (Exception e) {
                    LogUtil.error((String)"delete qs file error", (Throwable)e);
                }
                return true;
            }
        }, (QingContext)this.qingContext);
    }
}

