/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.handover;

import com.kingdee.bos.qing.behavior.BehaviorAssociate;
import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.manage.handover.domain.HandOverDomain;
import com.kingdee.bos.qing.manage.handover.model.HandOverRecordVO;
import com.kingdee.bos.qing.manage.handover.model.HandOverVO;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.IScheduleEngineable;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HandOverService
implements IDBAccessable,
IQingContextable,
IScheduleEngineable {
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private QingContext qingContext;
    private IScheduleEngine scheduleEngine;
    private HandOverDomain handOverDomain;

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    private HandOverDomain getHandOverDomain() {
        if (this.handOverDomain == null) {
            this.handOverDomain = new HandOverDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.handOverDomain;
    }

    @BehaviorAssociate(behavior=true)
    public byte[] queryDataByUserId(Map<String, String> params) {
        try {
            String userId = params.get("userId");
            List<HandOverVO> handOverVOs = this.getHandOverDomain().queryDataByUserId(userId);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(handOverVOs);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] handOver(Map<String, String> params) {
        try {
            String handOvers = params.get("handOvers");
            String toUserId = params.get("toUserId");
            String publishedRuntimeUrl = params.get("publishedRuntimeUrl");
            String paramPathPrefix = params.get("paramPathPrefix");
            ArrayList<HandOverVO> handOverVOs = new ArrayList<HandOverVO>(10);
            List handOverStrs = (List)JsonUtil.decodeFromString((String)handOvers, List.class);
            for (String handOverStr : handOverStrs) {
                HandOverVO handOverVO = (HandOverVO)JsonUtil.decodeFromString((String)handOverStr, HandOverVO.class);
                handOverVOs.add(handOverVO);
            }
            String publishAppTypeMapStr = params.get("publishAppTypeMap");
            Map publishAppTypeMap = (Map)JsonUtil.decodeFromString((String)publishAppTypeMapStr, HashMap.class);
            Set<String> handOverLappPublishIds = this.getHandOverDomain().handOver(handOverVOs, toUserId, publishedRuntimeUrl, paramPathPrefix, publishAppTypeMap);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(handOverLappPublishIds);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] queryHandOverRecords(Map<String, String> params) {
        try {
            String handOverStr = params.get("handOver");
            List jsonHandOvers = (List)JsonUtil.decodeFromString((String)handOverStr, List.class);
            ArrayList<HandOverVO> handOverVOs = new ArrayList<HandOverVO>(10);
            for (String jsonHandOver : jsonHandOvers) {
                HandOverVO handOverVO = (HandOverVO)JsonUtil.decodeFromString((String)jsonHandOver, HandOverVO.class);
                handOverVOs.add(handOverVO);
            }
            List<HandOverRecordVO> handOverRecords = this.getHandOverDomain().queryHandOverRecords(handOverVOs);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(handOverRecords);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] checkHandOverManagePermission() {
        try {
            boolean flag = IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)flag);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

