/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.imexport.domain;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.imexport.model.po.subject.ExportSchemaProperty;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.map.model.MapVO;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.util.NameUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;

public class SchemaImExportDomain {
    private IDBExcuter dbExcuter;
    protected ITransactionManagement tx;
    private SchemaManageDao schemaDao;
    private MapManageDao mapManageDao;

    private SchemaManageDao getSchemaDao() {
        if (this.schemaDao == null) {
            this.schemaDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaDao;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    private MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    public String importSchema(SchemaBO bo, List<Map<String, String>> outSideRefMap, byte[] content) throws AbstractQingIntegratedException, SQLException {
        int source = bo.getSource();
        String schemaName = bo.getSchemaName();
        String userId = bo.getUserId();
        String bizTag = bo.getBizTag();
        bo.setSchemaType(1);
        String fId = this.dbExcuter.genStringId("T_QING_SASchema");
        bo.setfId(fId);
        while (this.getSchemaDao().isNameExist(schemaName, bizTag, userId, source, bo.getSchemaType()).booleanValue()) {
            if (schemaName.lastIndexOf("_") > 0) {
                String indexStr = schemaName.substring(schemaName.lastIndexOf("_") + 1, schemaName.length());
                schemaName = schemaName.substring(0, schemaName.lastIndexOf("_"));
                try {
                    Integer index = Integer.parseInt(indexStr);
                    index = index + 1;
                    schemaName = schemaName + "_" + index;
                }
                catch (NumberFormatException e) {
                    schemaName = schemaName + "_1";
                }
            } else {
                schemaName = schemaName + "_1";
            }
            bo.setSchemaName(schemaName);
        }
        if (outSideRefMap != null && outSideRefMap.size() > 0) {
            List<OutsideReference> outSideRefList = ImportUtil.createOutSideRef(outSideRefMap, false);
            for (int i = 0; i < outSideRefList.size(); ++i) {
                OutsideReference outSideRef = outSideRefList.get(i);
                outSideRef.setRefToId(null);
                this.getSchemaDao().saveSchemaRef(outSideRef, fId);
            }
        }
        this.getSchemaDao().insertSchema(bo, content);
        this.getSchemaDao().insertSchemaRelation(bo);
        return fId;
    }

    public void exportSchema(String userId, String bizTag, String parentFolder, ZipOutputStream zipOutputStream) throws AbstractQingIntegratedException, IOException, SQLException {
        ArrayList<SchemaBO> schemaList = this.getSchemaDao().getSchemaByBiztag(bizTag, userId);
        if (schemaList.size() == 0) {
            return;
        }
        for (int i = 0; i < schemaList.size(); ++i) {
            SchemaBO schemaBO = schemaList.get(i);
            byte[] schemaContent = this.getSchemaDao().loadSchemaContent(schemaBO.getfId());
            List<OutsideReference> outSideRefList = null;
            if (schemaBO.getSource() == 1) {
                outSideRefList = this.getSchemaDao().loadSchemaRef(schemaBO.getfId());
                for (int j = 0; j < outSideRefList.size(); ++j) {
                    OutsideReference outSideRef = outSideRefList.get(j);
                    if (outSideRef.getRefToFullPath() != null) continue;
                    String mapId = outSideRef.getRefToId();
                    MapVO mapVO = this.getMapManageDao().getMapPath(mapId);
                    String mapNameSpace = NameSpace.getNameSpace((String)mapVO.getNameSpace()).toPersistance();
                    String mapPath = mapNameSpace + "/" + mapVO.getMapGroupName() + "/" + mapVO.getMapName();
                    outSideRef.setRefToFullPath(mapPath);
                }
            }
            SchemaImExportDomain.exportDataToZipOutputStream(schemaBO, schemaContent, outSideRefList, parentFolder, zipOutputStream);
        }
    }

    private static void exportDataToZipOutputStream(SchemaBO schemaBO, byte[] schemaContent, List<OutsideReference> outSideRef, String parentFolder, ZipOutputStream zipOutputStream) throws IOException, AbstractQingIntegratedException, SQLException {
        String folderName = null;
        if (schemaBO.getSource() == 0) {
            folderName = parentFolder + File.separator + "analysis";
        } else if (schemaBO.getSource() == 1) {
            folderName = parentFolder + File.separator + "square";
        }
        String schemaName = schemaBO.getSchemaName();
        if (NameUtil.isFileNameAccept((String)schemaName)) {
            ExportSchemaProperty schemaProperty = null;
            if (schemaBO.IsDefault().booleanValue()) {
                schemaProperty = new ExportSchemaProperty();
                schemaProperty.setIsDefault("true");
            }
            if (outSideRef != null && outSideRef.size() > 0) {
                if (schemaProperty == null) {
                    schemaProperty = new ExportSchemaProperty();
                }
                schemaProperty.setReference(ImportUtil.createRefMap(outSideRef));
            }
            if (schemaProperty != null) {
                zipOutputStream.putNextEntry(new ZipEntry(folderName + File.separator + schemaName + File.separator + "qing-schema.xml"));
                Element propertyElement = schemaProperty.toXml();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XmlUtil.save((Element)propertyElement, (OutputStream)baos);
                zipOutputStream.write(baos.toByteArray());
            }
            zipOutputStream.putNextEntry(new ZipEntry(folderName + File.separator + schemaName + File.separator + schemaName + ".qing-schema"));
            zipOutputStream.write(schemaContent);
        } else {
            String uuid = UUID.randomUUID().toString();
            zipOutputStream.putNextEntry(new ZipEntry(folderName + File.separator + uuid + File.separator + "qing-schema.xml"));
            ExportSchemaProperty schemaProperty = new ExportSchemaProperty();
            schemaProperty.setId(uuid);
            schemaProperty.setName(schemaName);
            if (schemaBO.IsDefault().booleanValue()) {
                schemaProperty.setIsDefault("true");
            }
            if (outSideRef != null && outSideRef.size() > 0) {
                schemaProperty.setReference(ImportUtil.createRefMap(outSideRef));
            }
            Element propertyElement = schemaProperty.toXml();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XmlUtil.save((Element)propertyElement, (OutputStream)baos);
            zipOutputStream.write(baos.toByteArray());
            zipOutputStream.putNextEntry(new ZipEntry(folderName + File.separator + uuid + File.separator + uuid + ".qing-schema"));
            zipOutputStream.write(schemaContent);
        }
    }
}

