/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.imexport.model.runtime;

import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.AbstractExportRefProperty;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.ExportDsbRefProperty;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.ExportDsbSchemaProperty;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractPublishImportModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DashboardPublishImportModel
extends AbstractPublishImportModel {
    private byte[] dsbContent;
    private ExportDsbRefProperty dsbRefProperty;
    private Map<RefTypeEnum, List<AbstractExportRefProperty>> contentPropertiesMap = new HashMap<RefTypeEnum, List<AbstractExportRefProperty>>();
    private Map<RefTypeEnum, List<String>> fileKeysMap = new HashMap<RefTypeEnum, List<String>>();
    private List<ExportDsbSchemaProperty> subjectRef = new ArrayList<ExportDsbSchemaProperty>();
    private List<String> subjectFileKeys = new ArrayList<String>();
    private List<ExportDsbSchemaProperty> cardRef = new ArrayList<ExportDsbSchemaProperty>();
    private List<String> cardFileKeys = new ArrayList<String>();
    private List<ExportDsbSchemaProperty> qingCenterRef = new ArrayList<ExportDsbSchemaProperty>();
    private List<String> qingCenterFileKeys = new ArrayList<String>();
    private List<ExportDsbSchemaProperty> appmenuRef = new ArrayList<ExportDsbSchemaProperty>();
    private List<String> appmenuFileKeys = new ArrayList<String>();
    private List<ExportDsbSchemaProperty> unsupportedSourceProperties = new ArrayList<ExportDsbSchemaProperty>();

    public Set<RefTypeEnum> getImportRefTypes() {
        Set<RefTypeEnum> collectedRefTypes = this.contentPropertiesMap.keySet();
        HashSet<RefTypeEnum> refTypes = new HashSet<RefTypeEnum>(collectedRefTypes.size());
        for (RefTypeEnum refType : collectedRefTypes) {
            refTypes.add(refType);
        }
        List<Map<String, String>> ref = this.dsbRefProperty.getReference();
        int c = ref.size();
        for (int i = 0; i < c; ++i) {
            RefTypeEnum type = RefTypeEnum.valueOf((String)ref.get(i).get("refType"));
            if (type != RefTypeEnum.picture) continue;
            refTypes.add(RefTypeEnum.valueOf((String)ref.get(i).get("refType")));
        }
        return refTypes;
    }

    public byte[] getDsbContent() {
        return this.dsbContent;
    }

    public void setDsbContent(byte[] dsbContent) {
        this.dsbContent = dsbContent;
    }

    public ExportDsbRefProperty getDsbRefProperty() {
        return this.dsbRefProperty;
    }

    public void setDsbRefProperty(ExportDsbRefProperty dsbRefProperty) {
        this.dsbRefProperty = dsbRefProperty;
    }

    public List<AbstractExportRefProperty> getContentProperties(RefTypeEnum refType) {
        return this.contentPropertiesMap.get(refType);
    }

    public void setContentProperties(RefTypeEnum refType, List<AbstractExportRefProperty> contentProperties) {
        this.contentPropertiesMap.put(refType, contentProperties);
    }

    public List<String> getFileKeys(RefTypeEnum refType) {
        return this.fileKeysMap.get(refType);
    }

    public void setFileKeys(RefTypeEnum refType, List<String> fileKeys) {
        this.fileKeysMap.put(refType, fileKeys);
    }

    public void addUnsupportedSourceProperty(ExportDsbSchemaProperty refProperty) {
        this.unsupportedSourceProperties.add(refProperty);
    }

    public List<ExportDsbSchemaProperty> getUnsupportedSourceProperties() {
        return this.unsupportedSourceProperties;
    }

    public List<ExportDsbSchemaProperty> getSubjectRef() {
        return this.subjectRef;
    }

    public List<String> getSubjectFileKeys() {
        return this.subjectFileKeys;
    }

    public List<ExportDsbSchemaProperty> getCardRef() {
        return this.cardRef;
    }

    public List<String> getCardFileKeys() {
        return this.cardFileKeys;
    }

    public List<ExportDsbSchemaProperty> getQingCenterRef() {
        return this.qingCenterRef;
    }

    public List<String> getQingCenterFileKeys() {
        return this.qingCenterFileKeys;
    }

    public List<ExportDsbSchemaProperty> getAppmenuRef() {
        return this.appmenuRef;
    }

    public List<String> getAppmenuFileKeys() {
        return this.appmenuFileKeys;
    }

    public List<ExportDsbSchemaProperty> getRefByType(RefTypeEnum refType) {
        switch (refType) {
            case appmenu: 
            case appmenu_qing: 
            case appmenu_rpt: {
                return this.appmenuRef;
            }
            case qingcenter: 
            case qingcenter_qing: 
            case qingcenter_rpt: {
                return this.qingCenterRef;
            }
            case subject: {
                return this.subjectRef;
            }
            case card: {
                return this.cardRef;
            }
        }
        return null;
    }

    public List<String> getFileKeysByType(RefTypeEnum refType) {
        switch (refType) {
            case appmenu: 
            case appmenu_qing: 
            case appmenu_rpt: {
                return this.appmenuFileKeys;
            }
            case qingcenter: 
            case qingcenter_qing: 
            case qingcenter_rpt: {
                return this.qingCenterFileKeys;
            }
            case subject: {
                return this.subjectFileKeys;
            }
            case card: {
                return this.cardFileKeys;
            }
        }
        return null;
    }
}

