/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.map;

import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.map.domain.MapManageDomain;
import com.kingdee.bos.qing.map.imexport.MapImExportDomain;
import com.kingdee.bos.qing.map.imexport.model.ExportListMapVO;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.map.model.MapGroupVO;
import com.kingdee.bos.qing.map.model.MapVO;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.IScheduleEngineable;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapManageService
implements IQingContextable,
IDBAccessable,
IScheduleEngineable {
    private static final String MODEL = "model";
    private static final String MAPGROUP_ID = "mapGroupId";
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private MapManageDomain mapManageDomain;
    private MapImExportDomain mapImExportDomain;
    private IScheduleEngine scheduleEngine;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    private MapManageDomain getMapManageDomin() {
        if (this.mapManageDomain == null) {
            this.mapManageDomain = new MapManageDomain();
            this.mapManageDomain.setDbExcuter(this.dbExcuter);
            this.mapManageDomain.setQingContext(this.qingContext);
            this.mapManageDomain.setScheduleEngine(this.scheduleEngine);
            this.mapManageDomain.setTx(this.tx);
        }
        return this.mapManageDomain;
    }

    private MapImExportDomain getMapImExportDomain() {
        if (this.mapImExportDomain == null) {
            this.mapImExportDomain = new MapImExportDomain();
            this.mapImExportDomain.setDbExcuter(this.dbExcuter);
            this.mapImExportDomain.setQingContext(this.qingContext);
            this.mapImExportDomain.setTx(this.tx);
        }
        return this.mapImExportDomain;
    }

    public byte[] saveMapGroup(Map<String, String> params) {
        MapGroupVO mapGroupVO = (MapGroupVO)JsonUtil.decodeFromString((String)params.get(MODEL), MapGroupVO.class);
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getMapManageDomin().saveMapGroup(mapGroupVO)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadMapGroupListWithSystem(Map<String, String> params) {
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getMapManageDomin().loadAllMapGroupList()));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadMapGroupList(Map<String, String> params) {
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getMapManageDomin().loadMapGroupList()));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadMapGroupListForMoveMap(Map<String, String> params) {
        try {
            String mapGroupId = params.get(MAPGROUP_ID);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getMapManageDomin().loadMapGroupListForMoveMap(mapGroupId)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] updateMapGroup(Map<String, String> params) {
        try {
            String mapGroupName = params.get("mapGroupName");
            String mapGroupId = params.get(MAPGROUP_ID);
            this.getMapManageDomin().updateMapGroup(mapGroupId, mapGroupName);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] deleteMapGroup(Map<String, String> params) {
        try {
            String mapGroupId = params.get(MAPGROUP_ID);
            this.getMapManageDomin().deleteMapGroup(mapGroupId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] saveOrUpdateMap(Map<String, String> params) {
        try {
            MapVO mapVO = (MapVO)JsonUtil.decodeFromString((String)params.get(MODEL), MapVO.class);
            this.getMapManageDomin().saveOrUpdateMap(mapVO);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)mapVO));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] deleteMap(Map<String, String> params) {
        try {
            MapVO mapVO = (MapVO)JsonUtil.decodeFromString((String)params.get(MODEL), MapVO.class);
            this.getMapManageDomin().deleteMap(mapVO);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadMapList(Map<String, String> params) {
        try {
            String mapGroupId = params.get(MAPGROUP_ID);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getMapManageDomin().loadMapList(mapGroupId)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] moveMap(Map<String, String> params) {
        try {
            MapVO mapVO = (MapVO)JsonUtil.decodeFromString((String)params.get(MODEL), MapVO.class);
            String newGroupId = params.get(MAPGROUP_ID);
            this.getMapManageDomin().moveMap(mapVO, newGroupId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] copyMap(Map<String, String> params) {
        try {
            MapVO mapVO = (MapVO)JsonUtil.decodeFromString((String)params.get(MODEL), MapVO.class);
            String newGroupId = params.get(MAPGROUP_ID);
            String newName = params.get("mapName");
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getMapManageDomin().copyMap(mapVO, newGroupId, newName)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadMapGroupWithSelectedMap(Map<String, String> params) {
        try {
            String refToId = params.get("refToId");
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getMapManageDomin().loadMapGroupWithSelectedMap(refToId)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getOutsideReference(Map<String, String> params) {
        try {
            MapVO mapVO = (MapVO)JsonUtil.decodeFromString((String)params.get(MODEL), MapVO.class);
            String mapGroupName = params.get("mapGroupName");
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getMapManageDomin().getOutsideReference(mapVO, mapGroupName)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getMapForExport(Map<String, String> params) {
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getMapImExportDomain().getExportMapFolder()));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] confirmForExportMap(Map<String, String> params) {
        List<ExportMapModel> mapList = ((ExportListMapVO)JsonUtil.decodeFromString((String)params.get("mapList"), ExportListMapVO.class)).getExportMaps();
        IQingFile exportFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
        try {
            this.getMapImExportDomain().doExportMap(mapList, exportFile);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)exportFile.getName());
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getSelectableForImportMap(Map<String, String> params) {
        String fileName = params.get("fileName");
        try {
            IQingFileVisitor zipFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)fileName);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getMapImExportDomain().parseMapZipFile(zipFile));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] importSelectedMap(Map<String, String> params) {
        List<ExportMapModel> mapList = ((ExportListMapVO)JsonUtil.decodeFromString((String)params.get("mapList"), ExportListMapVO.class)).getExportMaps();
        String fileName = params.get("fileName");
        IQingFileVisitor importZipFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)fileName);
        try {
            HashMap<String, List<ExportMapModel>> result = new HashMap<String, List<ExportMapModel>>();
            List<ExportMapModel> conflictExportMapModel = this.getMapImExportDomain().importMap(importZipFile, mapList);
            result.put("conflictMap", conflictExportMapModel);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] checkMapPermission(QingContext qingContext) {
        try {
            boolean flag = IntegratedHelper.checkMapPermission((QingContext)qingContext);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)flag);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

