/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.map.imexport;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileWriter;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.filesystem.stream.QingOutputStream;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.imexport.domain.ImExportDomain;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportThemeVO;
import com.kingdee.bos.qing.map.dao.MapDesignerDao;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.map.domain.MapDesignerDomain;
import com.kingdee.bos.qing.map.domain.MapManageDomain;
import com.kingdee.bos.qing.map.exception.MapDuplicateNameException;
import com.kingdee.bos.qing.map.exception.MapException;
import com.kingdee.bos.qing.map.exception.MapGroupDuplicateNameException;
import com.kingdee.bos.qing.map.imexport.collector.IMapCollectable;
import com.kingdee.bos.qing.map.imexport.collector.MapCollectorFactory;
import com.kingdee.bos.qing.map.imexport.exception.ImExportException;
import com.kingdee.bos.qing.map.imexport.exception.ImportMapFileParseException;
import com.kingdee.bos.qing.map.imexport.model.ExportMapGroupModel;
import com.kingdee.bos.qing.map.imexport.model.ExportMapModel;
import com.kingdee.bos.qing.map.imexport.model.FolderNode;
import com.kingdee.bos.qing.map.imexport.model.ImportMapModel;
import com.kingdee.bos.qing.map.model.MapGroupVO;
import com.kingdee.bos.qing.map.model.MapModelContent;
import com.kingdee.bos.qing.map.model.MapPO;
import com.kingdee.bos.qing.map.model.MapType;
import com.kingdee.bos.qing.map.model.MapVO;
import com.kingdee.bos.qing.map.oplog.MapOpLog;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.publish.dao.DashboardPublishDao;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.NameUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class MapImExportDomain {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private MapManageDomain mapManageDomain;
    private MapDesignerDomain mapDesignerDomain;
    private MapDesignerDao mapDesignerDao;
    private MapManageDao mapManageDao;
    private SchemaManageDao schemaManageDao;
    private DashboardDao dashboardDao;
    private DashboardPublishDao dashboardPublishDao;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    private MapManageDomain getMapManageDomin() {
        if (this.mapManageDomain == null) {
            this.mapManageDomain = new MapManageDomain();
            this.mapManageDomain.setDbExcuter(this.dbExcuter);
            this.mapManageDomain.setQingContext(this.qingContext);
            this.mapManageDomain.setTx(this.tx);
        }
        return this.mapManageDomain;
    }

    private MapDesignerDomain getMapDesignerDomain() {
        if (this.mapDesignerDomain == null) {
            this.mapDesignerDomain = new MapDesignerDomain();
            this.mapDesignerDomain.setDbExcuter(this.dbExcuter);
            this.mapDesignerDomain.setQingContext(this.qingContext);
            this.mapDesignerDomain.setTx(this.tx);
        }
        return this.mapDesignerDomain;
    }

    private MapDesignerDao getMapDesignerDao() {
        if (this.mapDesignerDao == null) {
            this.mapDesignerDao = new MapDesignerDao();
            this.mapDesignerDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapDesignerDao;
    }

    private MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    private SchemaManageDao getSchemaManageDao() {
        if (this.schemaManageDao == null) {
            this.schemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaManageDao;
    }

    private DashboardDao getDashboardDao() {
        if (this.dashboardDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    private DashboardPublishDao getDashboardPublishDao() {
        if (this.dashboardPublishDao == null) {
            this.dashboardPublishDao = new DashboardPublishDao(this.dbExcuter);
        }
        return this.dashboardPublishDao;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doExportMap(List<ExportMapModel> mapList, IQingFile zipFile) throws AbstractQingIntegratedException, ImExportException, IOException {
        IQingFileWriter zipFileWriter = null;
        QingOutputStream fos = null;
        ZipOutputStream zos = null;
        Object exception = null;
        try {
            zipFileWriter = zipFile.createWriter();
            fos = zipFileWriter.getOutputStream();
            zos = new ZipOutputStream((OutputStream)fos);
            this.compressMapZipFile(mapList, null, zos);
        }
        catch (AbstractQingIntegratedException e) {
            try {
                exception = e;
                throw e;
                catch (MapException e2) {
                    exception = e2;
                    throw new ImExportException((Throwable)((Object)e2));
                }
                catch (IOException e3) {
                    exception = e3;
                    throw new ImExportException(e3);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{zos});
                if (zipFileWriter != null) {
                    zipFileWriter.close((Exception)exception);
                    zipFileWriter = null;
                }
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{zos});
        if (zipFileWriter != null) {
            zipFileWriter.close((Exception)exception);
            zipFileWriter = null;
        }
        ExportMapModel mapModel = mapList.get(0);
        ArrayList<String> params = new ArrayList<String>(3);
        params.add(mapModel.getMapName());
        params.add(mapModel.getMapGroupName());
        MapOpLog mapDir = MapOpLog.MAP_DIR;
        if (mapList.size() > 1) {
            params.add(mapList.size() + "");
            mapDir = MapOpLog.MAPS_DIR;
        }
        mapDir.setLogScene("\u5730\u56fe");
        mapDir.setParamsDesc("\u201c$param\u201d");
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EXPORT, (IOpLogConstant)mapDir, params));
    }

    public void updateMapRef(Map<String, String> mapIdMap) throws AbstractQingIntegratedException, SQLException {
        for (Map.Entry<String, String> mapPath : mapIdMap.entrySet()) {
            String mapId = mapPath.getValue();
            List<String> outSideRefList = this.getSchemaManageDao().loadRefToIdIsNullOutSideRef(mapPath.getKey(), MapType.valueOf("Map").toPersistance());
            for (int i = 0; i < outSideRefList.size(); ++i) {
                String fId = outSideRefList.get(i);
                this.getSchemaManageDao().updateRefToId(fId, mapId);
            }
            List<String> dsbOutSideRefList = this.getDashboardDao().loadRefListByFullPathWidthoutUserId(mapPath.getKey(), "Map");
            for (int i = 0; i < dsbOutSideRefList.size(); ++i) {
                String fId = dsbOutSideRefList.get(i);
                this.getDashboardDao().updateRefToIdByRefId(fId, mapId);
            }
            List<String> dsbPublishOutSideRefList = this.getDashboardPublishDao().loadRefListByFullPathWidthoutUserId(mapPath.getKey(), "Map");
            for (int i = 0; i < dsbPublishOutSideRefList.size(); ++i) {
                String fId = dsbPublishOutSideRefList.get(i);
                this.getDashboardPublishDao().updateRefToIdByRefId(fId, mapId);
            }
        }
    }

    public List<ExportMapModel> importMap(IQingFileVisitor zipFile, List<ExportMapModel> importMapModelList) throws AbstractQingIntegratedException, IOException, ImExportException, ModelParseException, JDOMException, SQLException, MapException {
        Map<String, ImportMapModel> allMapModel = this.collectAllMapInfo(zipFile, importMapModelList);
        ArrayList<ExportMapModel> conflictExportMapModel = new ArrayList<ExportMapModel>();
        Map<String, String> mapIdMap = this.doImportMap(importMapModelList, allMapModel, conflictExportMapModel);
        this.updateMapRef(mapIdMap);
        return conflictExportMapModel;
    }

    public Map<String, String> importMapForThemeImport(IQingFileVisitor zipFile, List<ExportMapModel> importMapModelList) throws AbstractQingIntegratedException, IOException, ImExportException, ModelParseException, JDOMException, SQLException, MapException {
        Map<String, ImportMapModel> allMapModel = this.collectAllMapInfo(zipFile, importMapModelList);
        Map<String, String> mapIdMap = this.doImportMap(importMapModelList, allMapModel, null);
        this.updateMapRef(mapIdMap);
        return mapIdMap;
    }

    public void doImportForPreset(IQingFileVisitor zipFile) throws ModelParseException, IOException, JDOMException, ImExportException, MapException, AbstractQingIntegratedException, SQLException {
        Map<String, ImportMapModel> allMapModel = this.collectAllMapInfo(zipFile, null);
        Map<String, String> mapIdMap = this.doImportMap(null, allMapModel, null);
        this.updateMapRef(mapIdMap);
    }

    public Map<String, String> doImportMap(List<ExportMapModel> impotrMapModelList, Map<String, ImportMapModel> allMapModel, List<ExportMapModel> conflictExportMapModel) throws AbstractQingIntegratedException, ImExportException, MapException {
        HashMap<String, String> mapIdMap = new HashMap<String, String>();
        NameSpace nameSpace = this.qingContext.getUserId().equals(IntegratedHelper.getPresetUserId()) ? NameSpace.system : NameSpace.user;
        try {
            this.tx.beginRequired();
            if (impotrMapModelList == null) {
                for (Map.Entry<String, ImportMapModel> entry : allMapModel.entrySet()) {
                    ImportMapModel importMapModel = allMapModel.get(entry.getKey());
                    importMapModel.setStrategy(ExportThemeVO.StrategyType.overwrite.name());
                    this.saveMap(importMapModel, mapIdMap, conflictExportMapModel, nameSpace);
                }
            } else {
                for (int i = 0; i < impotrMapModelList.size(); ++i) {
                    ExportMapModel exportMapModel = impotrMapModelList.get(i);
                    String path = nameSpace.toString() + "/" + exportMapModel.getMapGroupName() + "/" + exportMapModel.getMapName();
                    ImportMapModel importMapModel = allMapModel.get(path);
                    if (importMapModel == null) continue;
                    importMapModel.setStrategy(exportMapModel.getStrategy());
                    this.saveMap(importMapModel, mapIdMap, conflictExportMapModel, nameSpace);
                }
            }
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ImExportException(e);
        }
        catch (MapException e) {
            this.tx.markRollback();
            throw new ImExportException((Throwable)((Object)e));
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
        return mapIdMap;
    }

    private void saveMap(ImportMapModel importMapModel, Map<String, String> mapIdMap, List<ExportMapModel> conflictExportMapModel, NameSpace nameSpace) throws MapException, AbstractQingIntegratedException, SQLException {
        MapVO mapVO = importMapModel.toMapVO();
        String mapGroupName = importMapModel.getMapGroupName();
        String mapName = mapVO.getMapName();
        String mapPath = nameSpace.toPersistance() + "/" + mapGroupName + "/" + mapName;
        MapPO mapPO = mapVO.toMapPO();
        Date createDate = new Date();
        mapPO.setMapCreateDate(createDate);
        mapPO.setMapModifyDate(createDate);
        String userId = this.qingContext.getUserId();
        mapPO.setCreatorId(userId);
        mapPO.setUpdaterId(userId);
        mapPO.setNameSpace(nameSpace);
        if (!IntegratedHelper.checkMapPermission((QingContext)this.qingContext)) {
            MapVO oldMapVO;
            MapGroupVO mapGroupVO = this.getMapManageDomin().loadMapGroupByName(mapGroupName);
            if (mapGroupVO != null && (oldMapVO = this.getMapManageDomin().loadMapByNameAndGroupId(mapGroupVO.getMapGroupId(), mapName, MapType.Map.toPersistance())) != null) {
                mapIdMap.put(mapPath, oldMapVO.getMapId());
                mapPO.setMapId(oldMapVO.getMapId());
                this.getMapManageDomin().updateRefToIdWithoutTx(mapGroupVO, mapPO);
            }
            return;
        }
        String mapGroupId = null;
        MapGroupVO mapGroupVO = null;
        try {
            mapGroupVO = this.getMapManageDomin().loadMapGroupByName(mapGroupName);
            if (mapGroupVO == null) {
                mapGroupVO = new MapGroupVO();
                mapGroupVO.setMapGroupName(mapGroupName);
                mapGroupId = this.getMapManageDomin().saveMapGroup(mapGroupVO);
            } else {
                mapGroupId = mapGroupVO.getMapGroupId();
            }
        }
        catch (MapGroupDuplicateNameException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)((Object)e));
        }
        mapVO.setMapGroupId(mapGroupId);
        mapPO.setMapGroupId(mapGroupId);
        importMapModel.setMapGroupId(mapGroupId);
        String mapId = null;
        try {
            mapId = this.getMapManageDao().saveMap(mapPO);
            mapPO.setMapId(mapId);
            this.saveMapContent(importMapModel, mapId);
            this.getMapManageDomin().updateRefToIdWithoutTx(mapGroupVO, mapPO);
            mapIdMap.put(mapPath, mapId);
        }
        catch (MapDuplicateNameException e) {
            if (importMapModel.getStrategy() != null) {
                MapVO oldMapVO;
                if (ExportThemeVO.StrategyType.rename == ExportThemeVO.StrategyType.valueOf(importMapModel.getStrategy())) {
                    this.addNameSuffix(mapVO);
                    mapPO.setMapName(mapVO.getMapName());
                    mapId = this.getMapManageDao().saveMap(mapPO);
                    mapPO.setMapId(mapId);
                    this.saveMapContent(importMapModel, mapId);
                } else if (ExportThemeVO.StrategyType.overwrite == ExportThemeVO.StrategyType.valueOf(importMapModel.getStrategy())) {
                    oldMapVO = this.getMapManageDomin().loadMapByNameAndGroupId(mapVO.getMapGroupId(), mapVO.getMapName(), mapVO.getMapType().toPersistance());
                    mapId = oldMapVO.getMapId();
                    mapPO.setMapId(mapId);
                    if (nameSpace == NameSpace.system) {
                        String version;
                        String dbVersion = oldMapVO.getVersion();
                        if (!MapImExportDomain.checkMapDBVersionIsNewest(dbVersion, version = mapPO.getVersion())) {
                            this.getMapManageDao().updateMap(mapPO);
                            this.getMapDesignerDomain().deleteMapContent(oldMapVO.getMapId());
                            this.saveMapContent(importMapModel, mapId);
                        }
                    } else {
                        this.getMapManageDao().updateMap(mapPO);
                        this.getMapDesignerDomain().deleteMapContent(oldMapVO.getMapId());
                        this.saveMapContent(importMapModel, mapId);
                    }
                } else {
                    mapId = null;
                    mapGroupVO = this.getMapManageDomin().loadMapGroupByName(mapGroupName);
                    if (mapGroupVO != null && (oldMapVO = this.getMapManageDomin().loadMapByNameAndGroupId(mapGroupVO.getMapGroupId(), mapGroupName, MapType.Map.toPersistance())) != null) {
                        mapId = oldMapVO.getMapId();
                    }
                }
                mapIdMap.put(mapPath, mapId);
                this.getMapManageDomin().updateRefToIdWithoutTx(mapGroupVO, mapPO);
            }
            ExportMapModel conflictMapModel = new ExportMapModel();
            conflictMapModel.setMapGroupName(mapGroupName);
            conflictMapModel.setMapName(mapName);
            conflictExportMapModel.add(conflictMapModel);
            return;
        }
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(mapPO.getMapName());
        if (mapGroupVO != null) {
            params.add(mapGroupVO.getMapGroupName());
            MapOpLog mapDir = MapOpLog.MAP_DIR;
            mapDir.setLogScene("\u5730\u56fe");
            mapDir.setParamsDesc("\u201c$param\u201d");
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.IMPORT, (IOpLogConstant)mapDir, params));
        }
    }

    public static boolean checkMapDBVersionIsNewest(String dbVersion, String version) {
        return dbVersion != null && version != null && Long.parseLong(dbVersion) >= Long.parseLong(version);
    }

    private void addNameSuffix(MapVO mapVO) throws AbstractQingIntegratedException, SQLException {
        String mapName = mapVO.getMapName();
        String mapGroupId = mapVO.getMapGroupId();
        String mapType = mapVO.getMapType().toPersistance();
        String mapId = mapVO.getMapId();
        NameSpace nameSpace = this.qingContext.getUserId().equals(IntegratedHelper.getPresetUserId()) ? NameSpace.system : NameSpace.user;
        boolean imageNameDuplicate = this.getMapManageDao().checkMapNameExist(mapName, mapGroupId, mapType, mapId, nameSpace.getCode());
        while (imageNameDuplicate) {
            if (mapName.lastIndexOf("_") > 0) {
                String indexStr = mapName.substring(mapName.lastIndexOf("_") + 1, mapName.length());
                mapName = mapName.substring(0, mapName.lastIndexOf("_"));
                try {
                    Integer index = Integer.parseInt(indexStr);
                    index = index + 1;
                    mapName = mapName + "_" + index;
                }
                catch (NumberFormatException e) {
                    mapName = mapName + "_1";
                }
            } else {
                mapName = mapName + "_1";
            }
            imageNameDuplicate = this.getMapManageDao().checkMapNameExist(mapName, mapGroupId, mapType, mapId, nameSpace.getCode());
        }
        mapVO.setMapName(mapName);
    }

    private void saveMapContent(ImportMapModel importMapModel, String mapId) throws MapException, AbstractQingIntegratedException, SQLException {
        String imageFileName = this.getMapDesignerDomain().importMapFile(importMapModel.getBackgeroudImage());
        String modelFileName = this.getMapDesignerDomain().importMapFile(importMapModel.getMapModel());
        String svgFileName = this.getMapDesignerDomain().importMapFile(importMapModel.getMapSvg());
        String configFileName = this.getMapDesignerDomain().importMapFile(importMapModel.getMapConfig());
        String thumbnailFileName = this.getMapDesignerDomain().importMapFile(importMapModel.getThumbnail());
        if (modelFileName != null && svgFileName != null && configFileName != null && thumbnailFileName != null) {
            MapModelContent mapModelContent = new MapModelContent();
            mapModelContent.setImageFileName(imageFileName);
            mapModelContent.setMapConfigFileName(configFileName);
            mapModelContent.setMapModelFileName(modelFileName);
            mapModelContent.setMapSvgFileName(svgFileName);
            mapModelContent.setMapThumbnailFileName(thumbnailFileName);
            mapModelContent.setMapId(mapId);
            mapModelContent.setCreateDate(new Date());
            this.getMapDesignerDao().saveMapContent(mapModelContent);
        }
    }

    public void compressMapZipFile(List<ExportMapModel> mapList, String rootPath, ZipOutputStream zos) throws AbstractQingIntegratedException, IOException, MapException {
        HashMap<String, String> mapGroupFloder = new HashMap<String, String>();
        Date createDate = new Date();
        for (int i = 0; i < mapList.size(); ++i) {
            ExportMapModel exportMapVO = this.getMapManageDomin().loadMapWithGroupNameById(mapList.get(i).getMapId());
            NameSpace nameSpace = NameSpace.getNameSpace((String)exportMapVO.getNameSpace());
            if (exportMapVO == null || nameSpace != NameSpace.user) continue;
            exportMapVO.setCreateDate(createDate);
            String mapGroupName = exportMapVO.getMapGroupName();
            ExportMapGroupModel mapGroupModel = new ExportMapGroupModel();
            String mapGroupPropertyPath = null;
            if (mapGroupFloder.get(mapGroupName) == null) {
                String mapGroupFolderUuid = null;
                if (!NameUtil.isFileNameAccept((String)mapGroupName)) {
                    mapGroupFolderUuid = UUID.randomUUID().toString();
                    mapGroupPropertyPath = mapGroupFolderUuid + File.separator + "qing-map-group.xml";
                } else {
                    mapGroupFolderUuid = mapGroupName;
                    mapGroupPropertyPath = mapGroupName + File.separator + "qing-map-group.xml";
                }
                if (rootPath != null) {
                    mapGroupPropertyPath = rootPath + File.separator + mapGroupPropertyPath;
                }
                mapGroupModel.setId(mapGroupFolderUuid);
                mapGroupModel.setName(mapGroupName);
                mapGroupModel.setNameSpace(exportMapVO.getMapGroupNameSpace());
                mapGroupFloder.put(mapGroupName, mapGroupFolderUuid);
                Element propertyElement = mapGroupModel.toXml();
                zos.putNextEntry(new ZipEntry(mapGroupPropertyPath));
                XmlUtil.save((Element)propertyElement, (OutputStream)zos);
                zos.flush();
            }
            String mapGroupFolderPath = (String)mapGroupFloder.get(mapGroupName);
            if (rootPath != null) {
                mapGroupFolderPath = rootPath + File.separator + mapGroupFolderPath;
            }
            this.getMapManageDomin().exportMap(mapGroupFolderPath, exportMapVO, zos);
        }
    }

    private Map<String, ImportMapModel> collectAllMapInfo(IQingFileVisitor zipFile, List<ExportMapModel> importMapModelList) throws IOException, JDOMException, ModelParseException {
        QingInputStream in = zipFile.getInputStream();
        ZipInputStream zis = new ZipInputStream((InputStream)in);
        ZipEntry zipEntry = null;
        ImportMapModel mapModel = new ImportMapModel();
        HashMap<String, ImportMapModel> allMapModel = new HashMap<String, ImportMapModel>();
        boolean needImport = true;
        while ((zipEntry = zis.getNextEntry()) != null) {
            IMapCollectable collector;
            ByteArrayInputStream byteArrayInputStream;
            String zipEntryName = zipEntry.getName();
            String[] zipEntryPath = ImExportDomain.parseEntryNameToList(zipEntryName);
            if (zipEntryPath == null) continue;
            if (zipEntryName.endsWith("qing-map-group.xml")) {
                byteArrayInputStream = ImExportDomain.getInputStreamFromZipInputStream(zis);
                ExportMapGroupModel mapGroupProperty = this.parseMapGroupModelFromZipFile(byteArrayInputStream);
                mapModel.setNameSpace(mapGroupProperty.getNameSpace());
            }
            if (zipEntryName.endsWith("qing-map.xml")) {
                byteArrayInputStream = ImExportDomain.getInputStreamFromZipInputStream(zis);
                ExportMapModel mapProperty = this.parseMapModelFromZipFile(byteArrayInputStream);
                mapModel.fromImportMapModel(mapProperty);
                ImportMapModel copyMapModel = mapModel.copy();
                String path = copyMapModel.getNameSpace() + "/" + copyMapModel.getMapGroupName() + "/" + copyMapModel.getMapName();
                if (this.checkMapNeedCollect(importMapModelList, copyMapModel.getPath())) {
                    needImport = true;
                    allMapModel.put(path, copyMapModel);
                } else {
                    needImport = false;
                }
            }
            if (!needImport || (collector = MapCollectorFactory.getCollector(zipEntryPath)) == null) continue;
            collector.collect(zis, mapModel, allMapModel);
        }
        return allMapModel;
    }

    private boolean checkMapNeedCollect(List<ExportMapModel> importMapModelList, String mapPath) {
        if (importMapModelList == null) {
            return true;
        }
        for (int i = 0; i < importMapModelList.size(); ++i) {
            ExportMapModel mapModel = importMapModelList.get(i);
            if (!mapModel.getMapPath().equals(mapPath)) continue;
            return true;
        }
        return false;
    }

    private ExportMapGroupModel parseMapGroupModelFromZipFile(ByteArrayInputStream is) throws JDOMException, IOException {
        Element element = XmlUtil.loadRootElement((InputStream)is);
        ExportMapGroupModel mapGroupProperty = new ExportMapGroupModel();
        mapGroupProperty.fromXml(element);
        return mapGroupProperty;
    }

    private ExportMapModel parseMapModelFromZipFile(ByteArrayInputStream is) throws JDOMException, IOException, ModelParseException {
        Element element = XmlUtil.loadRootElement((InputStream)is);
        ExportMapModel mapProperty = new ExportMapModel();
        mapProperty.fromXml(element);
        return mapProperty;
    }

    public final FolderNode getExportMapFolder() throws AbstractQingIntegratedException, ImExportException {
        FolderNode root = new FolderNode();
        try {
            List<MapGroupVO> mapGroupList = this.getMapManageDao().loadMapGroupList(NameSpace.user.getCode());
            for (int i = 0; i <= mapGroupList.size() - 1; ++i) {
                MapGroupVO mapGroupVO = mapGroupList.get(i);
                List<MapVO> mapVOList = this.getMapManageDomin().loadMapList(mapGroupVO.getMapGroupId());
                if (mapVOList.size() <= 0) continue;
                FolderNode mapGroupNode = new FolderNode();
                mapGroupNode.setName(mapGroupVO.getMapGroupName());
                mapGroupNode.setMapId(mapGroupVO.getMapGroupId());
                root.addChild(mapGroupNode);
                for (int j = 0; j < mapVOList.size(); ++j) {
                    MapVO mapVO = mapVOList.get(j);
                    FolderNode mapNode = new FolderNode();
                    mapNode.setName(mapVO.getMapName());
                    mapNode.setMapId(mapVO.getMapId());
                    mapNode.setMapType(mapVO.getMapType().toString());
                    mapGroupNode.addChild(mapNode);
                }
            }
        }
        catch (MapException e) {
            throw new ImExportException((Throwable)((Object)e));
        }
        catch (SQLException e) {
            throw new ImExportException(e);
        }
        return root;
    }

    public FolderNode parseMapZipFile(IQingFileVisitor zipFile) throws ImportMapFileParseException {
        HashMap<String, String> mapGroupUuidMap = new HashMap<String, String>();
        FolderNode root = new FolderNode();
        QingInputStream in = null;
        ZipInputStream zis = null;
        try {
            in = zipFile.getInputStream();
            zis = new ZipInputStream((InputStream)in);
            ZipEntry zipEntry = null;
            while ((zipEntry = zis.getNextEntry()) != null) {
                ByteArrayInputStream byteArrayInputStream;
                ExportMapGroupModel mapGroupProperty;
                String zipEntryName = zipEntry.getName();
                String[] zipEntryPath = MapImExportDomain.parseEntryNameToList(zipEntryName);
                if (zipEntryName.endsWith("qing-map-group.xml") && (mapGroupProperty = this.parseMapGroupModelFromZipFile(byteArrayInputStream = ImportUtil.getInputStreamFromZipInputStream(zis))).getId() != null && mapGroupProperty.getName() != null) {
                    mapGroupUuidMap.put(mapGroupProperty.getId(), mapGroupProperty.getName());
                }
                if (!zipEntryName.endsWith("qing-map.xml")) continue;
                byteArrayInputStream = ImportUtil.getInputStreamFromZipInputStream(zis);
                ExportMapModel mapProperty = this.parseMapModelFromZipFile(byteArrayInputStream);
                if (zipEntryPath != null && mapGroupUuidMap.get(zipEntryPath[0]) != null) {
                    zipEntryPath[0] = (String)mapGroupUuidMap.get(zipEntryPath[0]);
                }
                String mapGroupName = null;
                if (zipEntryPath != null) {
                    mapGroupName = zipEntryPath[0];
                }
                this.addMapFloderNode(root, mapProperty, mapGroupName);
            }
        }
        catch (Exception e) {
            try {
                throw new ImportMapFileParseException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{zis});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{zis});
        return root;
    }

    private void addMapFloderNode(FolderNode root, ExportMapModel mapProperty, String mapGroupName) throws AbstractQingIntegratedException, SQLException {
        FolderNode mapGroupFolderNode = new FolderNode();
        mapGroupFolderNode.setName(mapGroupName);
        if (root.getChildCount() == 0 || !root.containChild(mapGroupFolderNode)) {
            mapGroupFolderNode.setMapId(mapProperty.getMapGroupId());
            root.addChild(mapGroupFolderNode);
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                FolderNode child = root.getChildren().get(i);
                if (!child.getName().equals(mapGroupName)) continue;
                mapGroupFolderNode = child;
                break;
            }
        }
        FolderNode mapFolderNode = new FolderNode();
        mapFolderNode.setName(mapProperty.getMapName());
        mapFolderNode.setMapId(mapProperty.getMapId());
        mapFolderNode.setMapType(mapProperty.getMapType().toString());
        mapGroupFolderNode.addChild(mapFolderNode);
    }

    public static String[] parseEntryNameToList(String zipEntryName) {
        String[] zipEntryPath = null;
        if (zipEntryName.contains("\\")) {
            zipEntryPath = zipEntryName.split("\\\\");
        } else if (zipEntryName.contains("/")) {
            zipEntryPath = zipEntryName.split("/");
        }
        return zipEntryPath;
    }
}

