/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.map.mapload;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.map.MapLoader;
import com.kingdee.bos.qing.map.domain.MapDesignerDomain;
import com.kingdee.bos.qing.map.exception.MapException;
import com.kingdee.bos.qing.map.model.MapModelContent;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractMapLibraryLoader
implements MapLoader.IMapLibraryLoader {
    protected abstract IDBExcuter getDbExcuter();

    protected abstract String getServicePrefixUrl();

    public InputStream loadSvg(MapLoader.Reference reference) throws MapLoader.MapNotFoundException, MapLoader.MapLoaderException {
        try {
            MapDesignerDomain mapDesignerDomain = new MapDesignerDomain();
            mapDesignerDomain.setDbExcuter(this.getDbExcuter());
            MapModelContent mapModelContent = mapDesignerDomain.loadMapContent(reference.getRefToId());
            if (mapModelContent == null) {
                throw new MapLoader.MapNotFoundException("load svg error");
            }
            return this.loadFileContent(mapModelContent.getMapSvgFileName());
        }
        catch (AbstractQingIntegratedException e) {
            throw new MapLoader.MapLoaderException((Throwable)e, "load svg error");
        }
        catch (MapException e) {
            throw new MapLoader.MapNotFoundException((Throwable)((Object)e), "load svg error");
        }
    }

    public InputStream loadConfig(MapLoader.Reference reference) throws MapLoader.MapNotFoundException, MapLoader.MapLoaderException {
        try {
            MapDesignerDomain mapDesignerDomain = new MapDesignerDomain();
            mapDesignerDomain.setDbExcuter(this.getDbExcuter());
            MapModelContent mapModelContent = mapDesignerDomain.loadMapContent(reference.getRefToId());
            if (mapModelContent == null) {
                throw new MapLoader.MapNotFoundException("load config error");
            }
            return this.loadFileContent(mapModelContent.getMapConfigFileName());
        }
        catch (AbstractQingIntegratedException e) {
            throw new MapLoader.MapLoaderException((Throwable)e, "load config error");
        }
        catch (MapException e) {
            throw new MapLoader.MapNotFoundException((Throwable)((Object)e), "load config error");
        }
    }

    public String getBackImageUrl(MapLoader.Reference reference) throws MapLoader.MapNotFoundException, MapLoader.MapLoaderException {
        try {
            MapDesignerDomain mapDesignerDomain = new MapDesignerDomain();
            mapDesignerDomain.setDbExcuter(this.getDbExcuter());
            String mapId = reference.getRefToId();
            MapModelContent mapModelContent = mapDesignerDomain.loadMapContent(mapId);
            if (mapModelContent == null) {
                throw new MapLoader.MapNotFoundException("load image url error");
            }
            String tempFileName = mapDesignerDomain.loadImage(mapModelContent.getImageFileName());
            return this.getServicePrefixUrl() + "/qing/loadImg.do?fileName=" + tempFileName + "&fileType=upload";
        }
        catch (AbstractQingIntegratedException e) {
            throw new MapLoader.MapLoaderException((Throwable)e, "load image url error");
        }
        catch (MapException e) {
            throw new MapLoader.MapNotFoundException((Throwable)((Object)e), "load image url error");
        }
    }

    public QingInputStream loadBackImage(MapLoader.Reference reference) throws MapLoader.MapNotFoundException, MapLoader.MapLoaderException {
        QingInputStream mapStream = null;
        try {
            MapDesignerDomain mapDesignerDomain = new MapDesignerDomain();
            mapDesignerDomain.setDbExcuter(this.getDbExcuter());
            String mapId = reference.getRefToId();
            MapModelContent mapModelContent = mapDesignerDomain.loadMapContent(mapId);
            if (mapModelContent == null) {
                throw new MapLoader.MapNotFoundException("load background image error");
            }
            String mapFileName = mapDesignerDomain.loadImage(mapModelContent.getImageFileName());
            if (mapFileName != null) {
                IQingFileVisitor fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)mapFileName);
                mapStream = fileVisitor.getInputStream();
            }
            return mapStream;
        }
        catch (AbstractQingIntegratedException e) {
            throw new MapLoader.MapLoaderException((Throwable)e, "load background image error");
        }
        catch (MapException e) {
            throw new MapLoader.MapNotFoundException((Throwable)((Object)e), "load background image error");
        }
        catch (IOException e) {
            throw new MapLoader.MapLoaderException((Throwable)e, "load background image error");
        }
    }

    private InputStream loadFileContent(String fileName) throws MapLoader.MapNotFoundException {
        IQingFileVisitor fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.MAP, (String)fileName);
        if (fileVisitor.exists()) {
            try {
                return fileVisitor.getInputStream();
            }
            catch (IOException e) {
                throw new MapLoader.MapNotFoundException((Throwable)e, "laod file error");
            }
        }
        throw new MapLoader.MapNotFoundException("laod file error");
    }
}

