/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.subject;

import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.cache.LinkageContext;
import com.kingdee.bos.qing.common.cache.ThemeDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.trace.TracerUtil;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.exception.db.DBCenterNoPermissionException;
import com.kingdee.bos.qing.data.exception.db.DBCenterOwnerNoPermissionException;
import com.kingdee.bos.qing.data.exception.dmo.DmoNoPermissionException;
import com.kingdee.bos.qing.data.exception.dmo.DmoOwnerNoPermissionException;
import com.kingdee.bos.qing.data.exception.dmo.DmoPermissionException;
import com.kingdee.bos.qing.data.exception.entity.EntityMySQLMoreThan61TableException;
import com.kingdee.bos.qing.data.exception.modeler.DppNoPermissionException;
import com.kingdee.bos.qing.data.exception.modeler.DppOwnerNoPermissionException;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceNoSpaceException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceSizeLimitedException;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.preparedata.exception.DeviceNoSpacePrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.FileSizeLimitPrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.SubjectDBCenterNoPermissionException;
import com.kingdee.bos.qing.preparedata.exception.SubjectDBCenterOwnerNoPermissionException;
import com.kingdee.bos.qing.preparedata.exception.SubjectDBDataSourceException;
import com.kingdee.bos.qing.preparedata.exception.SubjectDataSourceException;
import com.kingdee.bos.qing.preparedata.exception.SubjectDmoNoPermissionException;
import com.kingdee.bos.qing.preparedata.exception.SubjectDmoOwnerNoPermissionException;
import com.kingdee.bos.qing.preparedata.exception.SubjectDmoPermissionException;
import com.kingdee.bos.qing.preparedata.exception.SubjectDppNoPermissionException;
import com.kingdee.bos.qing.preparedata.exception.SubjectDppOwnerNoPermissionException;
import com.kingdee.bos.qing.preparedata.exception.SubjectEntityMySQLMoreThan61TableException;
import com.kingdee.bos.qing.preparedata.exception.SubjectEntityNoPermissionException;
import com.kingdee.bos.qing.preparedata.exception.SubjectEntityNotSupportQingAnalysisException;
import com.kingdee.bos.qing.preparedata.exception.SubjectModelParseException;
import com.kingdee.bos.qing.preparedata.exception.SubjectPrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.subject.ISubjectCallbackFunction;
import com.kingdee.bos.qing.subject.domain.SubjectRuntimeDomain;
import com.kingdee.bos.qing.subject.model.SubjectDataBO;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jdom2.Element;

public abstract class AbstractSubjectDataExtractor {
    protected IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
    protected QingContext qingContext;
    protected SubjectRuntimeDomain subjectDomain;
    protected ProgressModel progressModel;
    protected ThemePO themePO;
    protected Box box;
    protected String creatorId;
    protected boolean startBySchedule;
    protected boolean isSaveModel;
    protected ISubjectCallbackFunction callBackFunction;
    protected String tag;
    protected String shareTag;
    protected String shareProgressCacheKey;
    protected String shareDatasourceCacheKey;
    protected String ownerId;
    protected String themeId;
    protected boolean isSchedule;
    protected String schemaId;
    private static final String SCHEMAID_CACHE_KEY = "Qing.DataExtract.SchemaId";
    protected static final String SCHEMAID_SHARE_TAG_FLAG = "tag_schemaid";

    public AbstractSubjectDataExtractor(QingContext qingContext, SubjectRuntimeDomain subjectDomain, ProgressModel progressModel, ThemePO themePO, Box box, boolean startBySchedule, boolean isSaveModel, String creatorId, String schemaId) {
        this.qingContext = qingContext;
        this.subjectDomain = subjectDomain;
        this.progressModel = progressModel;
        this.themePO = themePO;
        this.box = box;
        this.startBySchedule = startBySchedule;
        this.isSaveModel = isSaveModel;
        this.creatorId = creatorId;
        this.schemaId = schemaId;
        this.tag = progressModel.getTag();
        this.ownerId = themePO.getUserID();
        this.themeId = themePO.getThemeID();
        this.shareTag = this.createShareTag();
        progressModel.setShareTag(this.shareTag);
        this.shareProgressCacheKey = ProgressModel.getCacheKey(this.shareTag);
        this.shareDatasourceCacheKey = ThemeDataSource.getCacheKey(this.shareTag);
        this.isSchedule = box.getSchedule() != null && box.getSchedule().getPeriod() != null;
    }

    protected static String getShareTagSetLockKey(String shareTag) {
        return SCHEMAID_CACHE_KEY + shareTag + "Set";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Set<String> removeCacheSchemaIdSet(String shareTagKey) {
        int iEndIndex = shareTagKey.indexOf(SCHEMAID_SHARE_TAG_FLAG);
        String shareTagLockSchemaIdKey = null;
        if (iEndIndex > -1) {
            shareTagLockSchemaIdKey = shareTagKey.substring(0, iEndIndex);
        }
        String shareTagSetKey = AbstractSubjectDataExtractor.getShareTagSetLockKey(shareTagLockSchemaIdKey);
        CacheSchemaShareTagListVO cacheSchemaShareTagListVO = null;
        List<CacheSchemaShareTagVO> cacheSchemaShareTagVOList = null;
        IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
        ILock lock = null;
        try {
            lock = LockFactory.createGlobalLock((String)shareTagSetKey);
            lock.lock();
            String shareTagSetContent = globalQingSession.get(shareTagSetKey);
            if (shareTagSetContent != null) {
                cacheSchemaShareTagListVO = (CacheSchemaShareTagListVO)JsonUtil.decodeFromString((String)shareTagSetContent, CacheSchemaShareTagListVO.class);
            }
            if (cacheSchemaShareTagListVO != null) {
                cacheSchemaShareTagVOList = cacheSchemaShareTagListVO.getCacheSchemaShareTagList();
            }
            if (cacheSchemaShareTagVOList != null && cacheSchemaShareTagVOList.size() > 0) {
                Iterator<CacheSchemaShareTagVO> iteratorCacheSchemaShareTagVO = cacheSchemaShareTagVOList.iterator();
                CacheSchemaShareTagVO cacheSchemaShareTagVO = null;
                while (iteratorCacheSchemaShareTagVO.hasNext()) {
                    cacheSchemaShareTagVO = iteratorCacheSchemaShareTagVO.next();
                    if (!cacheSchemaShareTagVO.getShareTag().equals(shareTagKey)) continue;
                    iteratorCacheSchemaShareTagVO.remove();
                    break;
                }
                if (cacheSchemaShareTagVO != null) {
                    if (cacheSchemaShareTagVOList.size() > 0) {
                        globalQingSession.set(shareTagSetKey, JsonUtil.encodeToString((Object)cacheSchemaShareTagListVO), 6, TimeUnit.MINUTES);
                    } else {
                        globalQingSession.remove(shareTagSetKey);
                    }
                    Set<String> set = cacheSchemaShareTagVO.getSchemaIdSet();
                    return set;
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != lock) {
                lock.unlock();
            }
        }
        return new HashSet<String>(1);
    }

    private String createShareTag() {
        String shareTag = this.themeId + this.qingContext.getUserId() + this.themePO.getUpdateTime().getTime();
        if (this.schemaId != null) {
            shareTag = this.createShareTagWithSchemaId(shareTag);
        }
        return shareTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createShareTagWithSchemaId(String baseShareTag) {
        String shareTagSetKey = AbstractSubjectDataExtractor.getShareTagSetLockKey(baseShareTag);
        String shareTagWithSchemaId = null;
        CacheSchemaShareTagListVO cacheSchemaShareTagListVO = null;
        List<CacheSchemaShareTagVO> cacheSchemaShareTagVOList = null;
        IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
        ILock lock = null;
        try {
            lock = LockFactory.createGlobalLock((String)shareTagSetKey);
            lock.lock();
            long currentTime = System.currentTimeMillis();
            String shareTagSetContent = globalQingSession.get(shareTagSetKey);
            if (shareTagSetContent != null) {
                cacheSchemaShareTagListVO = (CacheSchemaShareTagListVO)JsonUtil.decodeFromString((String)shareTagSetContent, CacheSchemaShareTagListVO.class);
            }
            if (cacheSchemaShareTagListVO != null) {
                cacheSchemaShareTagVOList = cacheSchemaShareTagListVO.getCacheSchemaShareTagList();
            } else {
                cacheSchemaShareTagListVO = new CacheSchemaShareTagListVO();
            }
            CacheSchemaShareTagVO cacheSchemaShareTagVO = null;
            if (cacheSchemaShareTagVOList == null) {
                cacheSchemaShareTagVOList = new ArrayList<CacheSchemaShareTagVO>();
                cacheSchemaShareTagListVO.setCacheSchemaShareTagList(cacheSchemaShareTagVOList);
            } else {
                int size = cacheSchemaShareTagVOList.size();
                if (size > 0) {
                    cacheSchemaShareTagVO = cacheSchemaShareTagVOList.get(size - 1);
                }
            }
            if (cacheSchemaShareTagVO != null && currentTime - cacheSchemaShareTagVO.getTimestamp() < 1000L) {
                Set<String> schemaIdSet = cacheSchemaShareTagVO.getSchemaIdSet();
                schemaIdSet.add(this.schemaId);
                shareTagWithSchemaId = cacheSchemaShareTagVO.getShareTag();
            } else {
                shareTagWithSchemaId = baseShareTag + SCHEMAID_SHARE_TAG_FLAG + currentTime;
                HashSet<String> schemaIdSet = new HashSet<String>(16);
                schemaIdSet.add(this.schemaId);
                cacheSchemaShareTagVO = new CacheSchemaShareTagVO();
                cacheSchemaShareTagVO.setSchemaIdSet(schemaIdSet);
                cacheSchemaShareTagVO.setShareTag(shareTagWithSchemaId);
                cacheSchemaShareTagVO.setTimestamp(currentTime);
                cacheSchemaShareTagVOList.add(cacheSchemaShareTagVO);
            }
            globalQingSession.set(shareTagSetKey, JsonUtil.encodeToString((Object)cacheSchemaShareTagListVO), 6, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != lock) {
                lock.unlock();
            }
        }
        return shareTagWithSchemaId;
    }

    public String getSharedTagWhenExistSchemaId() {
        if (this.schemaId != null) {
            return this.shareTag;
        }
        return null;
    }

    private ThemeDataSource initDataSource() {
        ThemeDataSource themeDataSource = new ThemeDataSource();
        themeDataSource.setOriginalCreatorId(null == this.creatorId ? this.ownerId : this.creatorId);
        themeDataSource.setTag(this.tag);
        themeDataSource.setThemeId(this.themeId);
        themeDataSource.setBox(this.box);
        LinkageContext linkageContext = this.subjectDomain.getLinkageContext(this.box);
        themeDataSource.addAllLinkageFormInfo(linkageContext.getLinkageFormInfos());
        themeDataSource.setExtractDataTraceSpans(TracerUtil.getRootTraceSpans());
        return themeDataSource;
    }

    public void setCallBackFunction(ISubjectCallbackFunction callBackFunction) {
        this.callBackFunction = callBackFunction;
    }

    protected String checkPermission(Box box) throws UnSupportDataSourceException {
        return this.subjectDomain.checkPermission(box);
    }

    protected String checkSupportQingAnalysis(Box box) throws UnSupportDataSourceException {
        return this.subjectDomain.checkSupportQingAnalysis(box);
    }

    public abstract void saveDataSourceToSession(ThemeDataSource var1) throws AbstractDataSourceException;

    public abstract void extract();

    protected void prepareData() {
        try {
            ThemeDataSource themeDataSource = this.initDataSource();
            this.progressModel.setTotalEntity(this.box.getEntities().size());
            this.callBackFunction.start();
            SubjectDataBO subjectDataBO = this.subjectDomain.prepareData(this.box, this.themePO, this.ownerId, this.callBackFunction, this.isSaveModel, this.startBySchedule);
            this.buildFromSubjectDataBO(themeDataSource, subjectDataBO);
            this.saveDataSourceToSession(themeDataSource);
            this.callBackFunction.finishAll(null);
        }
        catch (PrepareDataException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)e));
        }
        catch (ModelParseException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectModelParseException(e)));
        }
        catch (DataSourcePersistenceSizeLimitedException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new FileSizeLimitPrepareDataException(e)));
        }
        catch (DataSourcePersistenceNoSpaceException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new DeviceNoSpacePrepareDataException(e)));
        }
        catch (DBCenterNoPermissionException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectDBCenterNoPermissionException(e)));
        }
        catch (DBCenterOwnerNoPermissionException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectDBCenterOwnerNoPermissionException((Throwable)e, e.getOwnerName())));
        }
        catch (DppNoPermissionException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectDppNoPermissionException(e)));
        }
        catch (DppOwnerNoPermissionException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectDppOwnerNoPermissionException((Throwable)e, e.getOwnerName())));
        }
        catch (DmoNoPermissionException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectDmoNoPermissionException(e)));
        }
        catch (DmoOwnerNoPermissionException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectDmoOwnerNoPermissionException((Throwable)e, e.getMessage())));
        }
        catch (DmoPermissionException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectDmoPermissionException((Throwable)e, e.getMessage())));
        }
        catch (EntityMySQLMoreThan61TableException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectEntityMySQLMoreThan61TableException(e)));
        }
        catch (AbstractDBSourceException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectDBDataSourceException(e)));
        }
        catch (AbstractSourceException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectDataSourceException(e)));
        }
        catch (Exception e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectPrepareDataException(e)));
        }
    }

    public boolean tryToGetDataSourceFromTemp() throws AbstractQingIntegratedException, SQLException, IOException, UnSupportDataSourceException {
        SubjectDataBO subjectDataBO;
        if (this.isSchedule && !this.startBySchedule && (subjectDataBO = this.subjectDomain.findNewData(this.ownerId, this.themeId)) != null) {
            try {
                String subMessage = null;
                subMessage = this.checkPermission(this.box);
                if (subMessage != null) {
                    this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectEntityNoPermissionException(subMessage)));
                    return true;
                }
                subMessage = this.checkSupportQingAnalysis(this.box);
                if (subMessage != null) {
                    this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectEntityNotSupportQingAnalysisException(subMessage)));
                    return true;
                }
                this.loadScheduleBoxIfExist(subjectDataBO);
                ThemeDataSource themeDataSource = this.initDataSource();
                this.buildFromSubjectDataBO(themeDataSource, subjectDataBO);
                AbstractDataSource oldDataSource = (AbstractDataSource)QingSessionUtil.getCache((String)AbstractDataSource.getCacheKey(this.tag), AbstractDataSource.class);
                this.callBackFunction.setMetaChanged(themeDataSource.isMetaChanged(oldDataSource));
                QingSessionUtil.setCache((ISessionCacheable)themeDataSource);
            }
            catch (AbstractDataSourceException e) {
                this.callBackFunction.finishAll((AbstractQingException)((Object)new PrepareDataException(e)));
                return true;
            }
            this.callBackFunction.finishAll(null);
            return true;
        }
        ThemeDataSource datasourceCache = (ThemeDataSource)QingSessionUtil.getCache((String)this.shareDatasourceCacheKey, ThemeDataSource.class);
        if (datasourceCache != null) {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis - datasourceCache.getLastVisitTime() > 3000L) {
                return false;
            }
            datasourceCache.setTag(this.tag);
            try {
                AbstractDataSource oldDataSource = (AbstractDataSource)QingSessionUtil.getCache((String)AbstractDataSource.getCacheKey(this.tag), AbstractDataSource.class);
                this.callBackFunction.setMetaChanged(datasourceCache.isMetaChanged(oldDataSource));
            }
            catch (AbstractDataSourceException e) {
                this.callBackFunction.finishAll((AbstractQingException)((Object)new PrepareDataException(e)));
                return true;
            }
            QingSessionUtil.setCache((ISessionCacheable)datasourceCache);
            this.callBackFunction.finishAll(null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadScheduleBoxIfExist(SubjectDataBO subjectDataBO) {
        String boxFile = subjectDataBO.getBoxModelFile();
        if (StringUtils.isEmpty((CharSequence)boxFile)) {
            return;
        }
        Box oldBox = this.box;
        QingInputStream inputStream = null;
        try {
            this.box = new Box();
            IQingFileVisitor qingFile = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)boxFile);
            inputStream = qingFile.getInputStream();
            Element element = XmlUtil.loadRootElement((InputStream)inputStream);
            this.box.fromXml(element, true);
        }
        catch (Exception e) {
            try {
                LogUtil.error((String)"loadScheduleBoxIfExist error", (Throwable)e);
                this.box = oldBox;
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildFromSubjectDataBO(ThemeDataSource themeDataSource, SubjectDataBO subjectDataBO) throws IOException {
        Map<String, String> dataFiles = subjectDataBO.getDataFile();
        HashMap<String, String> newTempDataFiles = new HashMap<String, String>();
        for (Map.Entry<String, String> dataTableEntry : dataFiles.entrySet()) {
            String dataFileName = dataFiles.get(dataTableEntry.getKey());
            IQingFileVisitor dataFile = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)dataFileName);
            if (dataFile.exists()) {
                String cachekey = "Qing.TempQsFile." + dataFileName;
                String tempDataFileName = this.globalQingSession.get(cachekey);
                IQingFileVisitor tmpDataFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)tempDataFileName);
                if (tempDataFileName == null || !tmpDataFile.exists()) {
                    ILock lock = LockFactory.createGlobalLock((String)cachekey);
                    try {
                        lock.lock();
                        tempDataFileName = this.globalQingSession.get(cachekey);
                        tmpDataFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)tempDataFileName);
                        if (tempDataFileName == null || !tmpDataFile.exists()) {
                            IQingFile tempDataFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.TEMP_QS);
                            FileFactory.copy((IQingFileVisitor)dataFile, (IQingFile)tempDataFile, (boolean)true);
                            tempDataFileName = tempDataFile.getName();
                            this.globalQingSession.set(cachekey, tempDataFileName);
                        }
                    }
                    catch (Exception e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                    finally {
                        lock.unlock();
                    }
                }
                newTempDataFiles.put(dataTableEntry.getKey(), tempDataFileName);
                continue;
            }
            dataFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)dataFileName);
            if (dataFile.exists()) {
                newTempDataFiles.put(dataTableEntry.getKey(), dataFileName);
                continue;
            }
            throw new FileNotFoundException(dataFileName);
        }
        themeDataSource.setDataFiles(newTempDataFiles);
        themeDataSource.setLastVisitTime(System.currentTimeMillis());
        themeDataSource.setExtractDataTime(subjectDataBO.getCreateTime().getTime());
    }

    private static class CacheSchemaShareTagListVO {
        private List<CacheSchemaShareTagVO> cacheSchemaShareTagList;

        private CacheSchemaShareTagListVO() {
        }

        public List<CacheSchemaShareTagVO> getCacheSchemaShareTagList() {
            return this.cacheSchemaShareTagList;
        }

        public void setCacheSchemaShareTagList(List<CacheSchemaShareTagVO> cacheSchemaShareTagList) {
            this.cacheSchemaShareTagList = cacheSchemaShareTagList;
        }
    }

    protected static class CacheSchemaShareTagVO {
        private long timestamp;
        private String shareTag;
        private Set<String> schemaIdSet;

        protected CacheSchemaShareTagVO() {
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public String getShareTag() {
            return this.shareTag;
        }

        public void setShareTag(String shareTag) {
            this.shareTag = shareTag;
        }

        public Set<String> getSchemaIdSet() {
            return this.schemaIdSet;
        }

        public void setSchemaIdSet(Set<String> schemaIdSet) {
            this.schemaIdSet = schemaIdSet;
        }

        public String toString() {
            return "CacheSchemaShareTagVO [timestamp=" + this.timestamp + ", shareTag=" + this.shareTag + ", schemaIdSet=" + this.schemaIdSet + "]";
        }
    }
}

