/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.subject;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.cache.ThemeDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.framework.manage.ClientCallManager;
import com.kingdee.bos.qing.common.framework.server.task.InvokeHealthCheckTask;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.runtime.process.FixProcesser;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.preparedata.exception.SubjectPrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.FixPubToLappExtractDataEntity;
import com.kingdee.bos.qing.preparedata.handler.ShareSourceProgressUpdateTask;
import com.kingdee.bos.qing.preparedata.handler.subject.AbstractSubjectDataExtractor;
import com.kingdee.bos.qing.preparedata.handler.subject.ShareSubjectPrepareDataCallbackImpl;
import com.kingdee.bos.qing.subject.domain.SubjectRuntimeDomain;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.Set;

public class ShareSubjectExtractor
extends AbstractSubjectDataExtractor {
    private IDBExcuter dbExcuter;

    public ShareSubjectExtractor(QingContext qingContext, SubjectRuntimeDomain subjectDomain, ProgressModel progressModel, ThemePO themePO, Box box, boolean startBySchedule, boolean isSaveModel, String creatorId, String schemaId, IDBExcuter dbExcuter) {
        super(qingContext, subjectDomain, progressModel, themePO, box, startBySchedule, isSaveModel, creatorId, schemaId);
        this.dbExcuter = dbExcuter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExtract(ServerRequestInvokeContext requestInvokeContext) {
        ServerRequestInvokeContext newRequestInvokeContext = null;
        try {
            newRequestInvokeContext = new ServerRequestInvokeContext(ServerRequestInvokeContext.CheckerName.RPCServer, requestInvokeContext.getAppID(), this.shareTag, this.shareTag);
            newRequestInvokeContext.getRelativeClientIDs().add(requestInvokeContext.getClientID());
            InvokeHealthCheckTask.addInvokeContext((ServerRequestInvokeContext)newRequestInvokeContext);
            ServerRequestInvokeContext.setThreadLocal((ServerRequestInvokeContext)newRequestInvokeContext);
            this.progressModel = this.progressModel.createShareModel();
            this.tag = this.shareTag;
            this.callBackFunction = new ShareSubjectPrepareDataCallbackImpl(this.progressModel);
            FixProcesser.fixBoxForExtract((QingContext)this.qingContext, (Box)this.box);
            String subMessage = null;
            subMessage = this.checkPermission(this.box);
            if (subMessage != null) {
                this.callBackFunction.finishAll(subMessage, 2101006);
                return;
            }
            subMessage = this.checkSupportQingAnalysis(this.box);
            if (subMessage != null) {
                this.callBackFunction.finishAll(subMessage, 2101018);
                return;
            }
            String publishedToLappShareTag = this.getSharedTagWhenExistSchemaId();
            if (publishedToLappShareTag != null) {
                this.isSaveModel = false;
                Thread.sleep(1000L);
                Set<String> schemaIdSet = ShareSubjectExtractor.removeCacheSchemaIdSet(this.shareTag);
                if (schemaIdSet.size() > 0) {
                    FixPubToLappExtractDataEntity fixPubToLappExtractDataEntitiy = new FixPubToLappExtractDataEntity(this.dbExcuter);
                    try {
                        fixPubToLappExtractDataEntitiy.filterUnusedEntities(this.box, schemaIdSet);
                    }
                    catch (Exception e) {
                        LogUtil.error((String)"FixPubToLappExtractDataEntity filterUnusedEntities error:", (Throwable)e);
                    }
                }
            }
            this.prepareData();
        }
        catch (UnSupportDataSourceException e1) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)e1));
        }
        catch (Exception e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectPrepareDataException(e)));
        }
        finally {
            if (newRequestInvokeContext != null) {
                newRequestInvokeContext.stopHealthCheck();
            }
            ServerRequestInvokeContext.setThreadLocal(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extract() {
        try {
            ShareSourceProgressUpdateTask.startShareExtractTask(this.progressModel);
        }
        catch (Exception e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectPrepareDataException(e)));
            return;
        }
        ServerRequestInvokeContext requestInvokeContext = ServerRequestInvokeContext.get();
        boolean isLock = false;
        ILock lock = null;
        try {
            lock = LockFactory.createLock((String)this.shareTag);
            isLock = lock.tryLock();
            if (isLock) {
                this.doExtract(requestInvokeContext);
            } else {
                requestInvokeContext.setNeedCalcCosts(false);
                ClientCallManager.addRelativeClientIDs((String)this.shareTag, (String)requestInvokeContext.getClientID());
                ServerRequestInvokeContext.setThreadLocal(null);
            }
        }
        catch (Exception e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectPrepareDataException(e)));
        }
        finally {
            if (isLock) {
                ShareSourceProgressUpdateTask.endShareExtractTask(this.shareTag, lock, null);
            } else if (lock != null) {
                lock.unlock();
            }
        }
    }

    @Override
    public void saveDataSourceToSession(ThemeDataSource themeDataSource) {
        themeDataSource.setTag(this.shareTag);
        themeDataSource.setLastVisitTime(System.currentTimeMillis());
        this.globalQingSession.setCache((ISessionCacheable)themeDataSource);
    }
}

