/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.subject;

import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.cache.ThemeDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.data.exception.entity.EntityNotSupportQingAnalysisException;
import com.kingdee.bos.qing.data.exception.entity.NoEntityPermissionException;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.runtime.process.FixProcesser;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.preparedata.exception.SubjectEntityNoPermissionException;
import com.kingdee.bos.qing.preparedata.exception.SubjectEntityNotSupportQingAnalysisException;
import com.kingdee.bos.qing.preparedata.exception.SubjectPrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.subject.AbstractSubjectDataExtractor;
import com.kingdee.bos.qing.preparedata.task.ExtractDataLock;
import com.kingdee.bos.qing.subject.domain.SubjectRuntimeDomain;

public class SubjectDataExtractor
extends AbstractSubjectDataExtractor {
    public SubjectDataExtractor(QingContext qingContext, SubjectRuntimeDomain subjectDomain, ProgressModel progressModel, ThemePO themePO, Box box, boolean startBySchedule, boolean isSaveModel, String creatorId, String schemaId) {
        super(qingContext, subjectDomain, progressModel, themePO, box, startBySchedule, isSaveModel, creatorId, schemaId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extract() {
        ILock lock = null;
        try {
            lock = LockFactory.createLock((String)this.shareTag);
            ExtractDataLock.lock(lock, this.progressModel, this.shareProgressCacheKey, this.shareDatasourceCacheKey);
            ServerRequestInvokeContext.staticCheckInterrupt();
            FixProcesser.fixBoxForExtract((QingContext)this.qingContext, (Box)this.box);
            boolean success = this.tryToGetDataSourceFromTemp();
            if (success) {
                return;
            }
            String errorMessage = null;
            errorMessage = this.checkPermission(this.box);
            if (errorMessage != null) {
                throw new NoEntityPermissionException(errorMessage);
            }
            errorMessage = this.checkSupportQingAnalysis(this.box);
            if (errorMessage != null) {
                throw new EntityNotSupportQingAnalysisException(errorMessage);
            }
            this.prepareData();
        }
        catch (NoEntityPermissionException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectEntityNoPermissionException(e.getMessage())));
        }
        catch (EntityNotSupportQingAnalysisException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectEntityNotSupportQingAnalysisException(e.getMessage())));
        }
        catch (Exception e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectPrepareDataException(e)));
        }
        finally {
            if (null != lock) {
                lock.unlock();
            }
        }
    }

    @Override
    public void saveDataSourceToSession(ThemeDataSource themeDataSource) throws AbstractDataSourceException {
        AbstractDataSource oldDataSource = (AbstractDataSource)QingSessionUtil.getCache((String)AbstractDataSource.getCacheKey(this.tag), AbstractDataSource.class);
        this.callBackFunction.setMetaChanged(themeDataSource.isMetaChanged(oldDataSource));
        themeDataSource.setLastVisitTime(System.currentTimeMillis());
        QingSessionUtil.setCache((ISessionCacheable)themeDataSource);
        themeDataSource.setTag(this.shareTag);
        QingSessionUtil.setCache((ISessionCacheable)themeDataSource);
    }
}

