/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.subject;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.framework.server.msgpublish.ServerChannelMessagePublisher;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.preparedata.handler.CommonCallBackFunction;
import com.kingdee.bos.qing.preparedata.handler.subject.ISubjectCallbackFunction;
import com.kingdee.bos.qing.preparedata.strategy.ISubjectPrepareDataLimitStrategy;

public class SubjectPrepareDataCallBackImpl
extends CommonCallBackFunction
implements ISubjectCallbackFunction {
    private ProgressProcessor progressProcessor;
    private DealtRowsChangedLisenterImpl dealtRowsChangedLisenter;

    public SubjectPrepareDataCallBackImpl(ProgressModel progressModel) {
        super(progressModel);
    }

    public void start() {
        this.dealtRowsChangedLisenter = new DealtRowsChangedLisenterImpl();
        if (this.progressModelCache == null && this.progressModel.getShareTag() != null) {
            this.progressModelCache = this.progressModel.createShareModel();
            QingSessionUtil.setCache((ISessionCacheable)this.progressModelCache);
        }
    }

    public ProgressProcessor startOneEntity() {
        this.dealtRowsChangedLisenter.fireDataChanged(0L, -1L);
        long limit = SubjectPrepareDataCallBackImpl.getSubjectPrepareDataLimitStrategyImpl();
        this.progressProcessor = new ProgressProcessor(limit);
        this.progressProcessor.setDealtRowsChangedLisenter((ProgressProcessor.IDealtRowsChangedLisenter)this.dealtRowsChangedLisenter);
        return this.progressProcessor;
    }

    public void finishOneEntity() {
        this.progressProcessor.dealtAllRows();
        this.progressModel.finishOneEntity();
        if (this.progressModel.isNeedDealProgress()) {
            ServerChannelMessagePublisher.publish((String)this.progressModel.getChannel(), (String)this.progressModel.toJson());
        }
        if (this.progressModelCache != null) {
            this.progressModelCache.finishOneEntity();
            QingSessionUtil.setCache((ISessionCacheable)this.progressModelCache);
        }
    }

    public void setTotalEntity(int totalEntitySize) {
        this.progressModel.setTotalEntity(totalEntitySize);
        if (this.progressModel.isNeedDealProgress()) {
            ServerChannelMessagePublisher.publish((String)this.progressModel.getChannel(), (String)this.progressModel.toJson());
        }
        if (this.progressModelCache != null) {
            this.progressModelCache.setTotalEntity(totalEntitySize);
            QingSessionUtil.setCache((ISessionCacheable)this.progressModelCache);
        }
    }

    @Override
    public void setMetaChanged(boolean metaChange) {
        this.progressModel.setMetaChanged(metaChange);
        if (this.progressModel.isNeedDealProgress()) {
            ServerChannelMessagePublisher.publish((String)this.progressModel.getChannel(), (String)this.progressModel.toJson());
        }
        if (this.progressModelCache != null) {
            this.progressModel.setMetaChanged(metaChange);
            QingSessionUtil.setCache((ISessionCacheable)this.progressModelCache);
        }
    }

    @Override
    public void finishAll(String subMessage, int subCode) {
        this.progressModel.finish(subMessage, subCode);
        if (this.progressModel.isNeedDealProgress()) {
            ServerChannelMessagePublisher.publish((String)this.progressModel.getChannel(), (String)this.progressModel.toJson());
        }
        if (this.progressModelCache != null) {
            this.progressModelCache.finish(subMessage, subCode);
            QingSessionUtil.setCache((ISessionCacheable)this.progressModelCache);
        }
    }

    private static int getSubjectPrepareDataLimitStrategyImpl() {
        ISubjectPrepareDataLimitStrategy subjectPrepareDataLimitStrategy = (ISubjectPrepareDataLimitStrategy)CustomStrategyRegistrar.getStrategy(ISubjectPrepareDataLimitStrategy.class);
        if (subjectPrepareDataLimitStrategy == null) {
            return -1;
        }
        return subjectPrepareDataLimitStrategy.getDataLimit();
    }

    private class DealtRowsChangedLisenterImpl
    implements ProgressProcessor.IDealtRowsChangedLisenter {
        private DealtRowsChangedLisenterImpl() {
        }

        public void fireDataChanged(long dealRows, long totalRows) {
            SubjectPrepareDataCallBackImpl.this.progressModel.setDealRows(dealRows);
            SubjectPrepareDataCallBackImpl.this.progressModel.setTotalRows(totalRows);
            if (SubjectPrepareDataCallBackImpl.this.progressModel.isNeedDealProgress()) {
                ServerChannelMessagePublisher.publish((String)SubjectPrepareDataCallBackImpl.this.progressModel.getChannel(), (String)SubjectPrepareDataCallBackImpl.this.progressModel.toJson());
            }
            if (SubjectPrepareDataCallBackImpl.this.progressModelCache != null) {
                SubjectPrepareDataCallBackImpl.this.progressModelCache.setDealRows(dealRows);
                SubjectPrepareDataCallBackImpl.this.progressModelCache.setTotalRows(totalRows);
                QingSessionUtil.setCache((ISessionCacheable)SubjectPrepareDataCallBackImpl.this.progressModelCache);
            }
        }
    }
}

