/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.timingpush;

import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.timingpush.AbstractTimingPushPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.timingpush.TimingPushPrepareDataContext;
import com.kingdee.bos.qing.preparedata.preparedatacontext.IPrepareDataContext;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.TimingPushBillPO;
import com.kingdee.bos.qing.publish.target.lapp.LappDomain;
import com.kingdee.bos.qing.publish.target.lapp.exception.ExecuteSqlException;
import com.kingdee.bos.qing.publish.target.lapp.model.LappSchedulePushConfigModel;
import com.kingdee.bos.qing.schedule.exception.ScheduleEngineException;
import java.sql.SQLException;

public class RobotTimingPushPrepareDataHandler
extends AbstractTimingPushPrepareDataHandler {
    private LappDomain lappDomain;

    public RobotTimingPushPrepareDataHandler(IPrepareDataContext extractContext) {
        super(extractContext);
        this.lappDomain = new LappDomain(extractContext.getQingContext(), extractContext.getTransManagement(), extractContext.getDBExecuter(), extractContext.getScheduleEngine());
    }

    @Override
    public void createDataSource() throws PrepareDataException {
        String tag = this.getPrepareContext().getTag();
        TimingPushPrepareDataContext timingPushPrepareDataContext = (TimingPushPrepareDataContext)this.getPrepareContext();
        String configId = timingPushPrepareDataContext.getConfigId();
        LappSchedulePushConfigModel pushConfigModel = null;
        try {
            pushConfigModel = this.lappDomain.loadConfigInfoById(configId);
        }
        catch (Exception e) {
            throw new PrepareDataException("get config error", e);
        }
        PublishSourceEnum publishSourceEnum = PublishSourceEnum.valueOf((String)pushConfigModel.getSourceType());
        this.createCommonDataSource(publishSourceEnum, tag, pushConfigModel.getTagId(), pushConfigModel.getId(), 2, pushConfigModel.getUserId());
    }

    @Override
    public TimingPushBillPO getBillPO(String configId) throws SQLException, AbstractQingIntegratedException {
        return this.lappDomain.loadBillInfo(configId);
    }

    @Override
    public void closeSchedule(String configId) throws SQLException, AbstractQingIntegratedException, ScheduleEngineException {
        try {
            this.lappDomain.updateScheduleState(false, configId, null);
        }
        catch (ExecuteSqlException e) {
            throw new ScheduleEngineException((Throwable)((Object)e));
        }
    }
}

