/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.task;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.ICustomDBStrategy;
import com.kingdee.bos.qing.common.strategy.TXDBExcuter;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.common.trace.TracerUtil;
import com.kingdee.bos.qing.data.domain.unionsource.EntityExtractContext;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.BizUnionInnerEntityRelations;
import com.kingdee.bos.qing.data.model.designtime.Relation;
import com.kingdee.bos.qing.data.model.runtime.ISubjectEntityExtractDataCallBack;
import com.kingdee.bos.qing.data.model.runtime.ISubjectPrepareDataCallBack;
import com.kingdee.bos.qing.data.service.EntityDataServiceFactory;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.manage.handler.convertQSHandler.domain.ConvertQSHandleDomain;
import com.kingdee.bos.qing.subject.model.SubjectBO;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class SubjectEntityExtractTask
implements Callable<String> {
    private ServerRequestInvokeContext serverRequestInvokeContext;
    private TraceSpan currentTraceSpan;
    private QingContext qingContext;
    private TXDBExcuter txDBExcuter;
    private String themeID;
    private AbstractEntity entity;
    private List<Relation> relations;
    private Map<String, AbstractSource> sourcesMap;
    private Map<String, AbstractEntity> entityNamesMap;
    private String ownerId;
    private IQingFile finalDataFile;
    private ISubjectPrepareDataCallBack backFunction;
    private EntityExtractContext context;
    private List<BizUnionInnerEntityRelations> bizUnionInnerEntityRelations;

    public SubjectEntityExtractTask(QingContext qingContext, AbstractEntity entity, SubjectBO subjectBO, IQingFile finalDataFile, ISubjectPrepareDataCallBack backFunction) {
        this.qingContext = qingContext;
        ICustomDBStrategy dbStrategy = (ICustomDBStrategy)CustomStrategyRegistrar.getStrategy(ICustomDBStrategy.class);
        assert (dbStrategy != null);
        this.txDBExcuter = dbStrategy.getTXAndDBExecutor(qingContext);
        this.themeID = subjectBO.getThemeID();
        this.relations = subjectBO.getBox().getRelations();
        this.bizUnionInnerEntityRelations = subjectBO.getBox().getBizUnionInnerEntityRelations();
        this.entityNamesMap = subjectBO.getEntityNamesMap();
        this.ownerId = subjectBO.getOwnerId();
        this.sourcesMap = subjectBO.getSourcesMap();
        this.entity = entity;
        this.finalDataFile = finalDataFile;
        this.backFunction = backFunction;
        this.serverRequestInvokeContext = ServerRequestInvokeContext.get();
        this.currentTraceSpan = TracerUtil.getCurrentTraceSpan();
        this.context = this.buildContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String call() throws InterruptedException, AbstractQingIntegratedException, AbstractSourceException, QingLockRequireException, AbstractDataSourceException {
        QingContext.setCurrent((QingContext)this.qingContext);
        ServerRequestInvokeContext.setThreadLocal((ServerRequestInvokeContext)this.serverRequestInvokeContext);
        String warming = null;
        try {
            ServerRequestInvokeContext.staticCheckInterrupt();
            warming = this.doEntityExecute(this.context);
            if (this.backFunction != null) {
                this.backFunction.finishOneEntity();
            }
        }
        finally {
            ServerRequestInvokeContext.removeThreadLocal();
            if (Thread.currentThread().getName().startsWith(ThreadPoolManage.QingThreadPoolName.QING_QS_WRITER_TASK_HANDLER.getPoolName())) {
                List children = this.currentTraceSpan.getChildren();
                List rootTraceSpans = TracerUtil.getRootTraceSpans();
                if (children != null && !rootTraceSpans.isEmpty()) {
                    children.addAll(rootTraceSpans);
                }
                TracerUtil.clearCurrentThreadCache();
            }
        }
        return warming;
    }

    private EntityExtractContext buildContext() {
        EntityExtractContext context = new EntityExtractContext();
        context.setDataFile(this.finalDataFile);
        context.setEntityNamesMap(this.entityNamesMap);
        context.setSourcesMap(this.sourcesMap);
        context.setRelations(this.relations);
        context.setQingContext(this.qingContext);
        context.setCallBackFunction(this.backFunction);
        context.setThemeId(this.themeID);
        context.setOwnerId(this.ownerId);
        context.setBizUnionInnerEntityRelations(this.bizUnionInnerEntityRelations);
        context.setSubjectEntityExtractDataCallBack((ISubjectEntityExtractDataCallBack)new ConvertQSHandleDomain(this.txDBExcuter.getDbExcuter(), this.txDBExcuter.getTx(), this.qingContext));
        return context;
    }

    public EntityExtractContext getContext() {
        return this.context;
    }

    private String doEntityExecute(EntityExtractContext context) throws InterruptedException, AbstractSourceException, AbstractQingIntegratedException, AbstractDataSourceException, QingLockRequireException {
        return EntityDataServiceFactory.newDataService((AbstractEntity)this.entity).extractEntityData(context);
    }
}

