/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preset.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PresetManageDao {
    private IDBExcuter dbExcuter;

    public PresetManageDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void insert(String name, String fileName, long version) throws AbstractQingIntegratedException, SQLException {
        String fid = this.dbExcuter.genStringId("T_QING_PRESET_PKG_RECORD");
        Object[] params = new Object[]{fid, name, fileName, version, new Date()};
        this.dbExcuter.execute("INSERT INTO T_QING_PRESET_PKG_RECORD (FID, FNAME, FFILENAME, FVERSION, FCREATETIME) VALUES (?, ?, ?, ?, ?)", params);
    }

    public Map<String, Long> getVersions(String name) throws AbstractQingIntegratedException, SQLException {
        return (Map)this.dbExcuter.query("SELECT FFILENAME,FVERSION FROM T_QING_PRESET_PKG_RECORD WHERE FNAME = ?", new Object[]{name}, (ResultHandler)new ResultHandler<Map<String, Long>>(){

            public Map<String, Long> handle(ResultSet rs) throws SQLException {
                HashMap<String, Long> map = new HashMap<String, Long>(16);
                while (rs.next()) {
                    map.put(rs.getString("FFILENAME"), rs.getLong("FVERSION"));
                }
                return map;
            }
        });
    }

    public void update(String name, String fileName, long version) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{version, new Date(), name, fileName};
        this.dbExcuter.execute("UPDATE T_QING_PRESET_PKG_RECORD SET FVERSION = ?, FCREATETIME = ? WHERE FNAME = ? AND FFILENAME = ?", params);
    }
}

