/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.publish.model.PublishSubjectFilePO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PublishSubjectFileDao {
    private IDBExcuter dbExcuter;

    public PublishSubjectFileDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void insert(PublishSubjectFilePO publishSubjectFilePO) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_PUB_SUBJECT_FILE (FID, FPUBLISHID, FENTITYNAME, FFILEPATH, FEXTRACTDATATIME) VALUES(?,?,?,?,?)";
        Object[] params = new Object[]{this.dbExcuter.genStringId("T_QING_PUB_SUBJECT_FILE"), publishSubjectFilePO.getPublishId(), publishSubjectFilePO.getEntityName(), publishSubjectFilePO.getFilePath(), publishSubjectFilePO.getExtractDataTime()};
        this.dbExcuter.execute(sql, params);
    }

    public List<PublishSubjectFilePO> loadPublishSubjectFile(String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FPUBLISHID, FENTITYNAME, FFILEPATH, FEXTRACTDATATIME FROM T_QING_PUB_SUBJECT_FILE WHERE FPUBLISHID = ? ";
        return (List)this.dbExcuter.query(sql, new Object[]{publishId}, (ResultHandler)new ResultHandler<List<PublishSubjectFilePO>>(){

            public List<PublishSubjectFilePO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishSubjectFilePO> publishSubjectFilePOs = new ArrayList<PublishSubjectFilePO>(10);
                while (rs.next()) {
                    PublishSubjectFilePO publishSubjectFilePO = new PublishSubjectFilePO();
                    publishSubjectFilePO.setId(rs.getString("FID"));
                    publishSubjectFilePO.setPublishId(rs.getString("FPUBLISHID"));
                    publishSubjectFilePO.setEntityName(rs.getString("FENTITYNAME"));
                    publishSubjectFilePO.setFilePath(rs.getString("FFILEPATH"));
                    publishSubjectFilePO.setExtractDataTime(rs.getTimestamp("FEXTRACTDATATIME"));
                    publishSubjectFilePOs.add(publishSubjectFilePO);
                }
                return publishSubjectFilePOs;
            }
        });
    }

    public void deleteSubjectFileByPublishId(String publishSubjectId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUB_SUBJECT_FILE WHERE FPUBLISHID = ?";
        this.dbExcuter.execute(sql, new Object[]{publishSubjectId});
    }
}

