/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.ModelPersistenceException;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.subject.dao.BoxSerializationUtil;
import com.kingdee.bos.qing.util.BoxUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class PublishSubjectModelDao {
    private IDBExcuter dbExcuter;

    public PublishSubjectModelDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void insert(String publishId, Box box, InputStream boxModelOrignalStream) throws AbstractQingIntegratedException, SQLException, ModelParseException, ModelPersistenceException, EncryptedLicenseCheckException {
        InputStream dbStream = this.loadBoxStreamByPublishId(publishId);
        byte[] boxModelBytes = BoxSerializationUtil.toBytes(box, boxModelOrignalStream, dbStream);
        if (boxModelBytes == null) {
            return;
        }
        int length = boxModelBytes.length;
        if (length > 0) {
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            ArrayList<Object[]> params = new ArrayList<Object[]>(count);
            for (int i = 0; i < count; ++i) {
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                int index = 0;
                Object[] param = new Object[4];
                param[index++] = this.dbExcuter.genStringId("T_QING_PUB_SUBJECT_MODEL");
                param[index++] = publishId;
                param[index++] = this.dbExcuter.createSqlParameterBytes(boxModelBytes, offset, contentSize);
                param[index++] = i;
                offset += contentSize;
                params.add(param);
            }
            this.dbExcuter.executeBatch("INSERT INTO T_QING_PUB_SUBJECT_MODEL (FID, FPUBLISHID, FCONTENT, FCONTENTINDEX) VALUES(?,?,?,?)", params);
        }
    }

    public InputStream loadBoxStreamByPublishId(String publishId) throws AbstractQingIntegratedException, SQLException, ModelParseException {
        String sql = "SELECT FID, FPUBLISHID, FCONTENT FROM T_QING_PUB_SUBJECT_MODEL WHERE FPUBLISHID = ? ORDER BY FCONTENTINDEX ASC";
        byte[] content = (byte[])this.dbExcuter.query(sql, new Object[]{publishId}, (ResultHandler)new ResultHandler<byte[]>(){

            public byte[] handle(ResultSet rs) throws SQLException {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                while (rs.next()) {
                    try {
                        outputStream.write(rs.getBytes("FCONTENT"));
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                }
                if (outputStream.size() > 0) {
                    return outputStream.toByteArray();
                }
                return null;
            }
        });
        return BoxUtil.parseByteToInputStream(content);
    }

    public Box loadBoxByPublishId(String publishId) throws AbstractQingIntegratedException, SQLException, ModelParseException, EncryptedLicenseCheckException {
        InputStream content = this.loadBoxStreamByPublishId(publishId);
        if (content == null) {
            return null;
        }
        return BoxSerializationUtil.toModel(content, true);
    }

    public void deleteSubjectModelByPublishId(String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUB_SUBJECT_MODEL WHERE FPUBLISHID = ?";
        this.dbExcuter.execute(sql, new Object[]{publishId});
    }
}

