/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourceVO;
import com.kingdee.bos.qing.message.domain.AbstractMessageDomain;
import com.kingdee.bos.qing.message.model.po.MessagePO;
import com.kingdee.bos.qing.message.model.vo.AbstractMessageDetailVO;
import com.kingdee.bos.qing.publish.dao.PubLappSyncRecordDao;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.model.PublishAuthMessageVO;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LappSyncPubMessageDomain
extends AbstractMessageDomain {
    private PublishInfoDao publishInfoDao;
    private PubLappSyncRecordDao pubLappSyncRecordDao;

    public LappSyncPubMessageDomain(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        super(qingContext, dbExcuter, tx);
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private PubLappSyncRecordDao getPubLappSyncRecordDao() {
        if (this.pubLappSyncRecordDao == null) {
            this.pubLappSyncRecordDao = new PubLappSyncRecordDao(this.dbExcuter);
        }
        return this.pubLappSyncRecordDao;
    }

    public AbstractMessageDetailVO queryMessageDetailById(MessagePO messagePO, String userId) throws AbstractQingIntegratedException, SQLException {
        List publishIds = this.getPubLappSyncRecordDao().queryPublishIdsByGroupId(messagePO.getBizId());
        ArrayList<FileResourceVO> fileResourceVOS = new ArrayList<FileResourceVO>();
        if (CollectionUtils.isNotEmpty((Collection)publishIds)) {
            List fileResourceVOList = this.getPublishInfoDao().findResourceFileByIds(publishIds);
            for (FileResourceVO fileResourceVO : fileResourceVOList) {
                if (!StringUtils.isNotEmpty((CharSequence)fileResourceVO.getFromId())) continue;
                fileResourceVOS.add(fileResourceVO);
            }
        }
        PublishAuthMessageVO publishAuthMessageVO = new PublishAuthMessageVO();
        publishAuthMessageVO.setFileResourceVO(fileResourceVOS);
        this.setBaseMessageVo((AbstractMessageDetailVO)publishAuthMessageVO, messagePO, userId);
        return publishAuthMessageVO;
    }
}

