/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.email.dao;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.model.runtime.compare.sqlcondition.InSqlConditionBuilder;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PushRecordConfig;
import com.kingdee.bos.qing.publish.model.PushRecordSavingStrategy;
import com.kingdee.bos.qing.publish.target.email.model.EmailConfig;
import com.kingdee.bos.qing.publish.target.email.model.EmailNameRule;
import com.kingdee.bos.qing.publish.target.email.model.EmailSendLog;
import com.kingdee.bos.qing.schedule.exception.ScheduleModelParseException;
import com.kingdee.bos.qing.schedule.model.Schedule;
import com.kingdee.bos.qing.schedule.model.ScheduleExecuteVO;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class EmailConfigDao {
    private QingContext qingContext;
    private IDBExcuter dbExcuter;

    public EmailConfigDao(QingContext qingContext, IDBExcuter dbExcuter) {
        this.qingContext = qingContext;
        this.dbExcuter = dbExcuter;
    }

    public String createEmailConfPKId() {
        return this.dbExcuter.genStringId("T_QING_PUB_EMAIL_CONF");
    }

    public String createEmailPushRecordPKId() {
        return this.dbExcuter.genStringId("T_QING_PUSH_RECORD_STORAGE_SET");
    }

    public void insert(EmailConfig emailConfig) throws AbstractQingIntegratedException, SQLException, IOException {
        String sql = "INSERT INTO T_QING_PUB_EMAIL_CONF(FID, FUSERID, FTAGID, FSCHEMASOURCETYPE, FPUBLISHSOURCETYPE, FNAMERULE, FSCHEDULE, FSCHEDULESWITCH, FISANONYMOUSVIEW, FSENDERID, FRECEIVERS, FCREATETIME, FUPDATETIME, FWARNINGRULENAME) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        byte[] nameRuleBytes = this.nameRule2Bytes(emailConfig.getNameRule());
        byte[] scheduleBytes = this.schedule2Bytes(emailConfig.getSchedule());
        Date date = new Date();
        ArrayList<Object> params1 = new ArrayList<Object>(15);
        params1.add(emailConfig.getId());
        params1.add(this.qingContext.getUserId());
        params1.add(emailConfig.getTagId());
        params1.add(emailConfig.getSchemaSourceType());
        params1.add(emailConfig.getPublishSourceType().name());
        params1.add(nameRuleBytes);
        params1.add(scheduleBytes);
        params1.add(emailConfig.getScheduleSwitch());
        params1.add(emailConfig.isAnonymousView());
        params1.add(emailConfig.getSenderId());
        params1.add(emailConfig.getReceivers());
        String emailContent = emailConfig.getContent();
        if (emailContent != null) {
            params1.add(emailContent.getBytes("UTF-8"));
            sql = "INSERT INTO T_QING_PUB_EMAIL_CONF(FID, FUSERID, FTAGID, FSCHEMASOURCETYPE, FPUBLISHSOURCETYPE, FNAMERULE, FSCHEDULE, FSCHEDULESWITCH, FISANONYMOUSVIEW, FSENDERID, FRECEIVERS, FCONTENT, FCREATETIME, FUPDATETIME, FWARNINGRULENAME) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        }
        params1.add(date);
        params1.add(date);
        params1.add(emailConfig.getWarningRuleName());
        this.dbExcuter.execute(sql, params1.toArray());
    }

    public EmailConfig getEmailConfigById(String id) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FTAGID, FSCHEMASOURCETYPE, FPUBLISHSOURCETYPE, FUSERID, FNAMERULE, FSCHEDULE, FSCHEDULESWITCH, FISANONYMOUSVIEW, FSENDERID, FRECEIVERS, FSERIALNUM, FCONTENT, FWARNINGRULENAME, FWARNINGRULESTATUS FROM T_QING_PUB_EMAIL_CONF WHERE FID=?";
        return (EmailConfig)this.dbExcuter.query(sql, new Object[]{id}, (ResultHandler)new ResultHandler<EmailConfig>(){

            public EmailConfig handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    String content;
                    byte[] scheduleBytes;
                    EmailConfig emailConfig = new EmailConfig();
                    emailConfig.setId(rs.getString("FID"));
                    emailConfig.setTagId(rs.getString("FTAGID"));
                    emailConfig.setSchemaSourceType(rs.getInt("FSCHEMASOURCETYPE"));
                    String publishSourceType = rs.getString("FPUBLISHSOURCETYPE");
                    emailConfig.setPublishSourceType(PublishSourceEnum.valueOf((String)publishSourceType));
                    emailConfig.setSenderId(rs.getString("FSENDERID"));
                    emailConfig.setReceivers(rs.getString("FRECEIVERS"));
                    byte[] nameRuleBytes = rs.getBytes("FNAMERULE");
                    if (null != nameRuleBytes) {
                        emailConfig.setNameRule(EmailConfigDao.this.bytes2NameRule(nameRuleBytes));
                    }
                    if (null != (scheduleBytes = rs.getBytes("FSCHEDULE"))) {
                        emailConfig.setSchedule(EmailConfigDao.this.bytes2Schedule(scheduleBytes));
                    }
                    emailConfig.setScheduleSwitch(rs.getBoolean("FSCHEDULESWITCH"));
                    emailConfig.setAnonymousView(rs.getBoolean("FISANONYMOUSVIEW"));
                    emailConfig.setUserId(rs.getString("FUSERID"));
                    emailConfig.setSerialNum(rs.getLong("FSERIALNUM"));
                    byte[] contentBytes = rs.getBytes("FCONTENT");
                    try {
                        content = contentBytes == null ? "" : new String(contentBytes, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SQLException(e);
                    }
                    emailConfig.setContent(content);
                    emailConfig.setWarningRuleName(rs.getString("FWARNINGRULENAME"));
                    boolean warningRuleStatus = rs.getString("FWARNINGRULESTATUS") == null ? true : rs.getBoolean("FWARNINGRULESTATUS");
                    emailConfig.setWarningRuleStatus(warningRuleStatus);
                    return emailConfig;
                }
                return null;
            }
        });
    }

    public List<EmailConfig> loadEmailConfigs() throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FTAGID, FSCHEMASOURCETYPE, FPUBLISHSOURCETYPE, FNAMERULE, FSCHEDULE, FSCHEDULESWITCH, FISANONYMOUSVIEW, FSENDERID, FRECEIVERS, FCONTENT, FWARNINGRULENAME, FWARNINGRULESTATUS, FCREATETIME FROM T_QING_PUB_EMAIL_CONF WHERE FUSERID=? ORDER BY FCREATETIME DESC";
        ArrayList<String> queryValue = new ArrayList<String>(1);
        queryValue.add(this.qingContext.getUserId());
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<List<EmailConfig>>(){

            public List<EmailConfig> handle(ResultSet rs) throws SQLException {
                ArrayList<EmailConfig> list = new ArrayList<EmailConfig>(10);
                while (rs.next()) {
                    String content;
                    byte[] scheduleBytes;
                    EmailConfig emailConfig = new EmailConfig();
                    emailConfig.setId(rs.getString("FID"));
                    emailConfig.setTagId(rs.getString("FTAGID"));
                    emailConfig.setSchemaSourceType(rs.getInt("FSCHEMASOURCETYPE"));
                    String publishSourceType = rs.getString("FPUBLISHSOURCETYPE");
                    emailConfig.setPublishSourceType(PublishSourceEnum.valueOf((String)publishSourceType));
                    emailConfig.setSenderId(rs.getString("FSENDERID"));
                    emailConfig.setReceivers(rs.getString("FRECEIVERS"));
                    byte[] nameRuleBytes = rs.getBytes("FNAMERULE");
                    if (null != nameRuleBytes) {
                        emailConfig.setNameRule(EmailConfigDao.this.bytes2NameRule(nameRuleBytes));
                    }
                    if (null != (scheduleBytes = rs.getBytes("FSCHEDULE"))) {
                        emailConfig.setSchedule(EmailConfigDao.this.bytes2Schedule(scheduleBytes));
                    }
                    emailConfig.setScheduleSwitch(rs.getBoolean("FSCHEDULESWITCH"));
                    emailConfig.setAnonymousView(rs.getBoolean("FISANONYMOUSVIEW"));
                    byte[] contentBytes = rs.getBytes("FCONTENT");
                    try {
                        content = contentBytes == null ? "" : new String(contentBytes, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SQLException(e);
                    }
                    emailConfig.setContent(content);
                    emailConfig.setWarningRuleName(rs.getString("FWARNINGRULENAME"));
                    boolean warningRuleStatus = rs.getString("FWARNINGRULESTATUS") == null ? true : rs.getBoolean("FWARNINGRULESTATUS");
                    emailConfig.setWarningRuleStatus(warningRuleStatus);
                    emailConfig.setCreateTime(rs.getTimestamp("FCREATETIME").getTime());
                    list.add(emailConfig);
                }
                return list;
            }
        });
    }

    public Map<String, Map<String, Integer>> loadCancelPermissionInfo(final List<EmailConfig> emailConfigList) throws AbstractQingIntegratedException, SQLException {
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(emailConfigList.size());
        StringBuilder sql = new StringBuilder("select ftype, fnooperauthvalue, fpublishid from t_qing_pub_oper_permissions where ");
        sql.append(inSqlConditionBuilder.build("fpublishid"));
        Object[] params = new Object[emailConfigList.size()];
        for (int i = 0; i < emailConfigList.size(); ++i) {
            params[i] = emailConfigList.get(i).getId();
        }
        return (Map)this.dbExcuter.query(sql.toString(), params, (ResultHandler)new ResultHandler<Map<String, Map<String, Integer>>>(){

            public Map<String, Map<String, Integer>> handle(ResultSet rs) throws SQLException {
                HashMap<String, Map<String, Integer>> noPermissionInfoMap = new HashMap<String, Map<String, Integer>>(emailConfigList.size());
                while (rs.next()) {
                    HashMap<String, Integer> noOperValueMap;
                    String fpublishid = rs.getString("fpublishid");
                    String ftype = rs.getString("ftype");
                    Integer fnooperauthvalue = rs.getInt("fnooperauthvalue");
                    if (noPermissionInfoMap.containsKey(fpublishid)) {
                        noOperValueMap = (HashMap<String, Integer>)noPermissionInfoMap.get(fpublishid);
                        noOperValueMap.put(ftype, fnooperauthvalue);
                        continue;
                    }
                    noOperValueMap = new HashMap<String, Integer>(3);
                    noOperValueMap.put(ftype, fnooperauthvalue);
                    noPermissionInfoMap.put(fpublishid, noOperValueMap);
                }
                return noPermissionInfoMap;
            }
        });
    }

    public void deleteEmailConfigById(String id) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUB_EMAIL_CONF WHERE FID=? AND FUSERID=?";
        this.dbExcuter.execute(sql, new Object[]{id, this.qingContext.getUserId()});
    }

    private byte[] nameRule2Bytes(EmailNameRule nameRule) throws IOException {
        if (nameRule == null) {
            return null;
        }
        Element xml = new Element("NameRule");
        nameRule.toXml(xml);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XmlUtil.save((Element)xml, (OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        return bytes;
    }

    private byte[] schedule2Bytes(Schedule schedule) throws IOException {
        if (schedule == null) {
            return null;
        }
        Element xml = new Element("Schedule");
        schedule.toXml(xml);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XmlUtil.save((Element)xml, (OutputStream)outputStream);
        byte[] scheduleModelBytes = outputStream.toByteArray();
        return scheduleModelBytes;
    }

    private Schedule bytes2Schedule(byte[] scheduleBytes) throws SQLException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Schedule schedule = new Schedule();
        try {
            outputStream.write(scheduleBytes);
            if (outputStream.size() > 0) {
                Element nodeSchedule = XmlUtil.loadRootElement((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
                schedule.fromXml(nodeSchedule);
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        catch (JDOMException e) {
            throw new SQLException(e);
        }
        catch (ScheduleModelParseException e) {
            throw new SQLException(e);
        }
        return schedule;
    }

    private EmailNameRule bytes2NameRule(byte[] nameRuleBytes) throws SQLException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        EmailNameRule nameRule = new EmailNameRule();
        try {
            outputStream.write(nameRuleBytes);
            if (outputStream.size() > 0) {
                Element NameRuleElement = XmlUtil.loadRootElement((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
                nameRule.fromXml(NameRuleElement);
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        catch (JDOMException e) {
            throw new SQLException(e);
        }
        return nameRule;
    }

    public List<EmailSendLog> loadPublishInfos(String configId) throws SQLException, AbstractQingIntegratedException {
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("SELECT FID, FCONFIGID, FPUBLISHID, FNAME, FSTATUS, FCREATETIME FROM T_QING_PUB_EMAIL_SEND_LOG WHERE FCONFIGID=? ORDER BY FCREATETIME DESC");
        Object[] params = new Object[]{configId};
        List listVO = (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new ResultHandler<List<EmailSendLog>>(){

            public List<EmailSendLog> handle(ResultSet rs) throws SQLException {
                ArrayList<EmailSendLog> listVO = new ArrayList<EmailSendLog>(10);
                while (rs.next()) {
                    EmailSendLog vo = new EmailSendLog();
                    vo.setId(rs.getString("FID"));
                    vo.setConfigId(rs.getString("FCONFIGID"));
                    vo.setPublishId(rs.getString("FPUBLISHID"));
                    vo.setName(rs.getString("FNAME"));
                    vo.setSendEmailsStatus(rs.getInt("FSTATUS"));
                    vo.setCreateTime(rs.getTimestamp("FCREATETIME").getTime());
                    listVO.add(vo);
                }
                return listVO;
            }
        });
        return listVO;
    }

    public Integer loadPublishInfoCount(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "select count(*) sum from t_qing_pub_email_send_log where fconfigid = ?";
        Object[] param = new Object[]{configId};
        return (Integer)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return Integer.parseInt(rs.getString("sum"));
                }
                return 0;
            }
        });
    }

    public Map<String, Long> loadQingFileSizeByPublishId(final List<EmailSendLog> emailSendLogList) throws AbstractQingIntegratedException, SQLException {
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(emailSendLogList.size());
        StringBuilder sql = new StringBuilder("select ffromid, ffilesize from t_qing_file_resource where ");
        sql.append(inSqlConditionBuilder.build("ffromid"));
        Object[] params = new Object[emailSendLogList.size()];
        for (int i = 0; i < emailSendLogList.size(); ++i) {
            params[i] = emailSendLogList.get(i).getPublishId();
        }
        return (Map)this.dbExcuter.query(sql.toString(), params, (ResultHandler)new ResultHandler<Map<String, Long>>(){

            public Map<String, Long> handle(ResultSet rs) throws SQLException {
                HashMap<String, Long> qingFileSizeMap = new HashMap<String, Long>(emailSendLogList.size());
                while (rs.next()) {
                    String fFromid = rs.getString("ffromid");
                    String fFilesize = rs.getString("ffilesize");
                    long fileSize = Long.parseLong(fFilesize == null ? "0" : fFilesize);
                    if (qingFileSizeMap.containsKey(fFromid)) {
                        Long fFileSize = (Long)qingFileSizeMap.get(fFromid);
                        qingFileSizeMap.put(fFromid, fileSize + fFileSize);
                        continue;
                    }
                    qingFileSizeMap.put(fFromid, fileSize);
                }
                return qingFileSizeMap;
            }
        });
    }

    public void update(EmailConfig emailConfig) throws AbstractQingIntegratedException, IOException, SQLException {
        byte[] nameRuleBytes = this.nameRule2Bytes(emailConfig.getNameRule());
        byte[] scheduleBytes = this.schedule2Bytes(emailConfig.getSchedule());
        Object[] params = new Object[]{nameRuleBytes, scheduleBytes, emailConfig.isAnonymousView(), emailConfig.getSenderId(), emailConfig.getReceivers(), emailConfig.getContent().getBytes("UTF-8"), new Date(), emailConfig.getWarningRuleName(), emailConfig.getWarningRuleStatus(), emailConfig.getId()};
        String sql = "UPDATE T_QING_PUB_EMAIL_CONF SET FNAMERULE=?, FSCHEDULE=?, FISANONYMOUSVIEW=?, FSENDERID=?, FRECEIVERS=?, FSERIALNUM=NULL, FCONTENT=?, FUPDATETIME=?, FWARNINGRULENAME=?, FWARNINGRULESTATUS=? WHERE FID=?";
        this.dbExcuter.execute(sql, params);
    }

    public void updateSerialNum(String id, long serialNum) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{serialNum, id};
        String sql = "UPDATE T_QING_PUB_EMAIL_CONF SET FSERIALNUM=? WHERE FID=?";
        this.dbExcuter.execute(sql, params);
    }

    public String insertSendEmailsLog(String configId, String publishId, String name, int sendEmailsStatus) throws AbstractQingIntegratedException, SQLException {
        String id = this.dbExcuter.genStringId("T_QING_PUB_EMAIL_SEND_LOG");
        Object[] params = new Object[]{id, configId, publishId, name, sendEmailsStatus, new Date()};
        String sql = "INSERT INTO T_QING_PUB_EMAIL_SEND_LOG(FID, FCONFIGID, FPUBLISHID, FNAME, FSTATUS, FCREATETIME, FERRORCODE) VALUES(?, ?, ?, ?, ?, ?, 0)";
        this.dbExcuter.execute(sql, params);
        return id;
    }

    public void deleteSendEmailsLogById(List<String> emailSendLogIdList) throws AbstractQingIntegratedException, SQLException {
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(emailSendLogIdList.size());
        StringBuilder sql = new StringBuilder("DELETE FROM T_QING_PUB_EMAIL_SEND_LOG WHERE ");
        sql.append(inSqlConditionBuilder.build("FID"));
        this.dbExcuter.execute(sql.toString(), emailSendLogIdList.toArray());
    }

    public void deleteSendEmailsLogByConfigId(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUB_EMAIL_SEND_LOG WHERE FCONFIGID=?";
        this.dbExcuter.execute(sql, new Object[]{configId});
    }

    public EmailSendLog loadEmailLogById(String id) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FCONFIGID, FPUBLISHID, FNAME, FSTATUS, FCREATETIME FROM T_QING_PUB_EMAIL_SEND_LOG WHERE FID=?";
        Object[] params = new Object[]{id};
        return (EmailSendLog)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<EmailSendLog>(){

            public EmailSendLog handle(ResultSet rs) throws SQLException {
                EmailSendLog vo = new EmailSendLog();
                if (rs.next()) {
                    vo.setId(rs.getString("FID"));
                    vo.setConfigId(rs.getString("FCONFIGID"));
                    vo.setPublishId(rs.getString("FPUBLISHID"));
                    vo.setName(rs.getString("FNAME"));
                    vo.setSendEmailsStatus(rs.getInt("FSTATUS"));
                    vo.setCreateTime(rs.getTimestamp("FCREATETIME").getTime());
                }
                return vo;
            }
        });
    }

    public void updateScheduleSwitch(String id, boolean scheduleSwitch) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_PUB_EMAIL_CONF SET FSCHEDULESWITCH=? WHERE FID=?";
        this.dbExcuter.execute(sql, new Object[]{scheduleSwitch, id});
    }

    public void updateScheduleSwitchAndWarningStatus(String id, boolean scheduleSwitch, boolean warningRuleStatus) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_PUB_EMAIL_CONF SET FSCHEDULESWITCH=?, FWARNINGRULESTATUS=? WHERE FID=?";
        this.dbExcuter.execute(sql, new Object[]{scheduleSwitch, warningRuleStatus, id});
    }

    public void updateWarningStatus(String id, boolean warningRuleStatus) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_PUB_EMAIL_CONF SET FWARNINGRULESTATUS=? WHERE FID=?";
        this.dbExcuter.execute(sql, new Object[]{warningRuleStatus, id});
    }

    public List<EmailConfig> loadEmailConfigsByBizId(String bizId, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FTAGID, FSCHEMASOURCETYPE, FPUBLISHSOURCETYPE, FNAMERULE, FSCHEDULE, FSCHEDULESWITCH, FISANONYMOUSVIEW, FSENDERID, FRECEIVERS, FCONTENT FROM T_QING_PUB_EMAIL_CONF WHERE FTAGID=? AND FUSERID=? ORDER BY FCREATETIME";
        ArrayList<String> queryValue = new ArrayList<String>(2);
        queryValue.add(bizId);
        queryValue.add(userId);
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<List<EmailConfig>>(){

            public List<EmailConfig> handle(ResultSet rs) throws SQLException {
                ArrayList<EmailConfig> list = new ArrayList<EmailConfig>(10);
                while (rs.next()) {
                    String content;
                    byte[] scheduleBytes;
                    EmailConfig emailConfig = new EmailConfig();
                    emailConfig.setId(rs.getString("FID"));
                    emailConfig.setTagId(rs.getString("FTAGID"));
                    emailConfig.setSchemaSourceType(rs.getInt("FSCHEMASOURCETYPE"));
                    String publishSourceType = rs.getString("FPUBLISHSOURCETYPE");
                    emailConfig.setPublishSourceType(PublishSourceEnum.valueOf((String)publishSourceType));
                    emailConfig.setSenderId(rs.getString("FSENDERID"));
                    emailConfig.setReceivers(rs.getString("FRECEIVERS"));
                    byte[] nameRuleBytes = rs.getBytes("FNAMERULE");
                    if (null != nameRuleBytes) {
                        emailConfig.setNameRule(EmailConfigDao.this.bytes2NameRule(nameRuleBytes));
                    }
                    if (null != (scheduleBytes = rs.getBytes("FSCHEDULE"))) {
                        emailConfig.setSchedule(EmailConfigDao.this.bytes2Schedule(scheduleBytes));
                    }
                    emailConfig.setScheduleSwitch(rs.getBoolean("FSCHEDULESWITCH"));
                    emailConfig.setAnonymousView(rs.getBoolean("FISANONYMOUSVIEW"));
                    byte[] contentBytes = rs.getBytes("FCONTENT");
                    try {
                        content = contentBytes == null ? "" : new String(contentBytes, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SQLException(e);
                    }
                    emailConfig.setContent(content);
                    list.add(emailConfig);
                }
                return list;
            }
        });
    }

    public List<ScheduleExecuteVO> findScheduleExecuteListByUserId(String userId, Date dateMin, Date dateMax) throws AbstractQingIntegratedException, SQLException {
        String PUSH_TARGET_TYPE_EMAIL = "-1";
        String sql = "SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FENDTIME, SE.FMETHODNAME,  PEC.FID AS PUBEMAILFID  FROM      (SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FENDTIME, SE.FMETHODNAME FROM T_QING_SCHEDULE_EXECUTE SE      WHERE SE.FUSERID=? AND SE.FMETHODNAME='emailPublishExecute' AND SE.FEXECUTETIME>=? AND SE.FEXECUTETIME<=?) SE  LEFT JOIN T_QING_PUB_EMAIL_CONF PEC ON SE.FSOURCEID=PEC.FID ";
        Object[] params = new Object[]{userId, dateMin, dateMax};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<ScheduleExecuteVO>>(){

            public List<ScheduleExecuteVO> handle(ResultSet rs) throws SQLException {
                ArrayList<ScheduleExecuteVO> voList = new ArrayList<ScheduleExecuteVO>(10);
                while (rs.next()) {
                    ScheduleExecuteVO scheduleExecute = new ScheduleExecuteVO();
                    scheduleExecute.setId(rs.getString("FID"));
                    scheduleExecute.setScheduleName(rs.getString("FSCHEDULENAME"));
                    scheduleExecute.setSourceId(rs.getString("FSOURCEID"));
                    scheduleExecute.setSourceName(rs.getString("FSOURCENAME"));
                    String methodName = rs.getString("FMETHODNAME");
                    if (StringUtils.isNotBlank((CharSequence)rs.getString("PUBEMAILFID"))) {
                        scheduleExecute.setSourceExist(true);
                        scheduleExecute.setSourceTargetType("-1");
                    }
                    scheduleExecute.setMethodName(methodName);
                    scheduleExecute.setExecuteState(rs.getInt("FEXECUTESTATE"));
                    scheduleExecute.setExecuteTime(Long.valueOf(rs.getTimestamp("FEXECUTETIME").getTime()));
                    if (rs.getTimestamp("FENDTIME") != null) {
                        scheduleExecute.setEndTime(Long.valueOf(rs.getTimestamp("FENDTIME").getTime()));
                    }
                    voList.add(scheduleExecute);
                }
                return voList;
            }
        });
    }

    public ScheduleExecuteVO findById(String id) throws AbstractQingIntegratedException, SQLException {
        String PUSH_TARGET_TYPE_EMAIL = "-1";
        String sql = "SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FENDTIME, SE.FMETHODNAME,  PEC.FID AS PUBEMAILFID  FROM      (SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FENDTIME, SE.FMETHODNAME FROM T_QING_SCHEDULE_EXECUTE SE      WHERE SE.FID=? AND SE.FMETHODNAME='emailPublishExecute' ) SE  LEFT JOIN T_QING_PUB_EMAIL_CONF PEC ON SE.FSOURCEID=PEC.FID ";
        Object[] params = new Object[]{id};
        return (ScheduleExecuteVO)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<ScheduleExecuteVO>(){

            public ScheduleExecuteVO handle(ResultSet rs) throws SQLException {
                ScheduleExecuteVO scheduleExecute = new ScheduleExecuteVO();
                if (rs.next()) {
                    scheduleExecute.setId(rs.getString("FID"));
                    scheduleExecute.setScheduleName(rs.getString("FSCHEDULENAME"));
                    scheduleExecute.setSourceId(rs.getString("FSOURCEID"));
                    String methodName = rs.getString("FMETHODNAME");
                    scheduleExecute.setSourceTargetType("-1");
                    scheduleExecute.setMethodName(methodName);
                    scheduleExecute.setExecuteState(rs.getInt("FEXECUTESTATE"));
                    scheduleExecute.setExecuteTime(Long.valueOf(rs.getTimestamp("FEXECUTETIME").getTime()));
                    if (rs.getTimestamp("FENDTIME") != null) {
                        scheduleExecute.setEndTime(Long.valueOf(rs.getTimestamp("FENDTIME").getTime()));
                    }
                }
                return scheduleExecute;
            }
        });
    }

    public PushRecordConfig loadPushRecordConfigInfo(String userId, int pushTargetType) throws AbstractQingIntegratedException, SQLException {
        String sql = "select fid, fuserid, fpushtargettype, fstrategy, fvalue from t_qing_push_record_config where fpushtargettype = ? and fuserid = ? ";
        Object[] params = new Object[]{Character.valueOf(String.valueOf(pushTargetType).charAt(0)), userId};
        return (PushRecordConfig)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<PushRecordConfig>(){

            public PushRecordConfig handle(ResultSet rs) throws SQLException {
                PushRecordConfig emailPushRecordConfig = new PushRecordConfig();
                if (rs.next()) {
                    emailPushRecordConfig.setId(rs.getString("fid"));
                    emailPushRecordConfig.setUserId(rs.getString("fuserid"));
                    emailPushRecordConfig.setPushTargetType(rs.getInt("fpushtargettype"));
                    int fStrategy = Integer.parseInt(rs.getString("fstrategy"));
                    emailPushRecordConfig.setStrategy(PushRecordSavingStrategy.getStrategyByIndex(fStrategy).name());
                    emailPushRecordConfig.setValue(rs.getString("fvalue"));
                    return emailPushRecordConfig;
                }
                return null;
            }
        });
    }

    public void saveEmailPushRecordConfig(PushRecordConfig emailPushRecordConfig) throws AbstractQingIntegratedException, SQLException {
        String sql = "insert into t_qing_push_record_config (fid, fuserid, fpushtargettype, fstrategy, fvalue) values (?, ?, ?, ?, ?)";
        Object[] params = new Object[]{emailPushRecordConfig.getId(), emailPushRecordConfig.getUserId(), Character.valueOf(String.valueOf(emailPushRecordConfig.getPushTargetType()).charAt(0)), PushRecordSavingStrategy.getStrategyByName(emailPushRecordConfig.getStrategy()), emailPushRecordConfig.getValue()};
        this.dbExcuter.execute(sql, params);
    }

    public void updateEmailPushRecordConfig(PushRecordConfig emailPushRecordConfig) throws AbstractQingIntegratedException, SQLException {
        String sql = "update t_qing_push_record_config set fstrategy = ?, fvalue = ? where fuserid = ? and fpushtargettype = ?";
        Object[] params = new Object[]{PushRecordSavingStrategy.getStrategyByName(emailPushRecordConfig.getStrategy()), emailPushRecordConfig.getValue(), emailPushRecordConfig.getUserId(), Character.valueOf(String.valueOf(emailPushRecordConfig.getPushTargetType()).charAt(0))};
        this.dbExcuter.execute(sql, params);
    }

    public void deleteEmailPushRecordConfig(PushRecordConfig emailPushRecordConfig) throws AbstractQingIntegratedException, SQLException {
        String sql = "delete from t_qing_push_record_config where fuserid = ? and fpushtargettype = ?";
        Object[] params = new Object[]{emailPushRecordConfig.getUserId(), Character.valueOf(String.valueOf(emailPushRecordConfig.getPushTargetType()).charAt(0))};
        this.dbExcuter.execute(sql, params);
    }

    public void insertUserSetPermissionInfo(EmailConfig emailConfig) throws AbstractQingIntegratedException, SQLException {
        Map<String, Integer> noOperValueMap = emailConfig.getNoOperValueMap();
        String sql = "insert into t_qing_pub_oper_permissions (fid, fpublishid, ftype, fnooperauthvalue) values (?, ?, ?, ?)";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(noOperValueMap.size());
        for (Map.Entry<String, Integer> entry : noOperValueMap.entrySet()) {
            Object[] params = new Object[]{this.createEmailConfPKId(), emailConfig.getId(), entry.getKey(), entry.getValue()};
            paramsList.add(params);
        }
        this.dbExcuter.executeBatch(sql, paramsList);
    }

    public void deleteUserSetPermissionInfo(EmailConfig emailConfig) throws AbstractQingIntegratedException, SQLException {
        String sql = "delete from t_qing_pub_oper_permissions where fpublishid = ?";
        Object[] param = new Object[]{emailConfig.getId()};
        this.dbExcuter.execute(sql, param);
    }

    public String loadEmailPushTagIdByBizTag(String biztag) throws AbstractQingIntegratedException, SQLException {
        String sql = "select ftagid from t_qing_pub_email_conf where fid = ?";
        Object[] param = new Object[]{biztag};
        return (String)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("ftagid");
                }
                return null;
            }
        });
    }

    public List<EmailSendLog> loadPushRecordNotInSpecifiedTime(String configId, Date date) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FPUBLISHID, FCONFIGID, FNAME FROM T_QING_PUB_EMAIL_SEND_LOG WHERE FCONFIGID = ? and fcreatetime < ? ORDER BY FCREATETIME DESC";
        Object[] params = new Object[]{configId, date};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<EmailSendLog>>(){

            public List<EmailSendLog> handle(ResultSet rs) throws SQLException {
                ArrayList<EmailSendLog> emailSendLogList = new ArrayList<EmailSendLog>(20);
                while (rs.next()) {
                    EmailSendLog emailSendLog = new EmailSendLog();
                    String fid = rs.getString("FID");
                    String fPublishid = rs.getString("FPUBLISHID");
                    String fConfigid = rs.getString("FCONFIGID");
                    String fName = rs.getString("FNAME");
                    emailSendLog.setId(fid);
                    emailSendLog.setName(fName);
                    emailSendLog.setPublishId(fPublishid);
                    emailSendLog.setConfigId(fConfigid);
                    emailSendLog.setSendEmailsStatus(fPublishid.isEmpty() ? 0 : 1);
                    emailSendLogList.add(emailSendLog);
                }
                return emailSendLogList;
            }
        });
    }

    public List<EmailSendLog> loadPublishInfoByMonthLimit(String configId, Date subTime) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FCONFIGID, FPUBLISHID, FNAME, FSTATUS, FCREATETIME FROM T_QING_PUB_EMAIL_SEND_LOG WHERE FCONFIGID = ? and fcreatetime < ? ORDER BY FCREATETIME ASC";
        Object[] params = new Object[]{configId, subTime};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<EmailSendLog>>(){

            public List<EmailSendLog> handle(ResultSet rs) throws SQLException {
                ArrayList<EmailSendLog> emailSendLogList = new ArrayList<EmailSendLog>(20);
                while (rs.next()) {
                    EmailSendLog emailSendLog = new EmailSendLog();
                    String fid = rs.getString("FID");
                    String fPublishid = rs.getString("FPUBLISHID");
                    String fConfigid = rs.getString("FCONFIGID");
                    String fName = rs.getString("FNAME");
                    emailSendLog.setId(fid);
                    emailSendLog.setName(fName);
                    emailSendLog.setPublishId(fPublishid);
                    emailSendLog.setConfigId(fConfigid);
                    emailSendLog.setSendEmailsStatus(fPublishid.isEmpty() ? 0 : 1);
                    emailSendLogList.add(emailSendLog);
                }
                return emailSendLogList;
            }
        });
    }

    public List<EmailSendLog> selectPublishInfoByMonthLimit(String configId, List<Date> subTime, final int setValue) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FCONFIGID, FPUBLISHID, FNAME, FSTATUS, FCREATETIME FROM T_QING_PUB_EMAIL_SEND_LOG WHERE FCONFIGID = ? and fcreatetime between ? and ? ORDER BY FCREATETIME desc";
        Object[] params = new Object[]{configId, subTime.get(1), subTime.get(0)};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<EmailSendLog>>(){

            public List<EmailSendLog> handle(ResultSet rs) throws SQLException {
                int value = setValue;
                ArrayList<EmailSendLog> listVO = new ArrayList<EmailSendLog>(10);
                while (rs.next()) {
                    EmailSendLog vo = new EmailSendLog();
                    vo.setId(rs.getString("FID"));
                    vo.setConfigId(rs.getString("FCONFIGID"));
                    vo.setPublishId(rs.getString("FPUBLISHID"));
                    vo.setName(rs.getString("FNAME"));
                    vo.setSendEmailsStatus(rs.getInt("FSTATUS"));
                    vo.setCreateTime(rs.getTimestamp("FCREATETIME").getTime());
                    if (value <= 0) continue;
                    listVO.add(vo);
                    --value;
                }
                return listVO;
            }
        });
    }

    public List<EmailConfig> loadEmailConfigsByConfigId(String configId, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FTAGID, FSCHEMASOURCETYPE, FPUBLISHSOURCETYPE, FNAMERULE, FSCHEDULE, FSCHEDULESWITCH, FISANONYMOUSVIEW, FSENDERID, FRECEIVERS, FCONTENT FROM T_QING_PUB_EMAIL_CONF WHERE FID = ? and FUSERID=? ORDER BY FCREATETIME desc";
        ArrayList<String> queryValue = new ArrayList<String>(1);
        queryValue.add(configId);
        queryValue.add(userId);
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<List<EmailConfig>>(){

            public List<EmailConfig> handle(ResultSet rs) throws SQLException {
                ArrayList<EmailConfig> list = new ArrayList<EmailConfig>(10);
                while (rs.next()) {
                    String content;
                    byte[] scheduleBytes;
                    EmailConfig emailConfig = new EmailConfig();
                    emailConfig.setId(rs.getString("FID"));
                    emailConfig.setTagId(rs.getString("FTAGID"));
                    emailConfig.setSchemaSourceType(rs.getInt("FSCHEMASOURCETYPE"));
                    String publishSourceType = rs.getString("FPUBLISHSOURCETYPE");
                    emailConfig.setPublishSourceType(PublishSourceEnum.valueOf((String)publishSourceType));
                    emailConfig.setSenderId(rs.getString("FSENDERID"));
                    emailConfig.setReceivers(rs.getString("FRECEIVERS"));
                    byte[] nameRuleBytes = rs.getBytes("FNAMERULE");
                    if (null != nameRuleBytes) {
                        emailConfig.setNameRule(EmailConfigDao.this.bytes2NameRule(nameRuleBytes));
                    }
                    if (null != (scheduleBytes = rs.getBytes("FSCHEDULE"))) {
                        emailConfig.setSchedule(EmailConfigDao.this.bytes2Schedule(scheduleBytes));
                    }
                    emailConfig.setScheduleSwitch(rs.getBoolean("FSCHEDULESWITCH"));
                    emailConfig.setAnonymousView(rs.getBoolean("FISANONYMOUSVIEW"));
                    byte[] contentBytes = rs.getBytes("FCONTENT");
                    try {
                        content = contentBytes == null ? "" : new String(contentBytes, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SQLException(e);
                    }
                    emailConfig.setContent(content);
                    list.add(emailConfig);
                }
                return list;
            }
        });
    }
}

