/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kingdee.bos.qing.behavior.BehaviorAssociate;
import com.kingdee.bos.qing.common.framework.server.msgpublish.ServerChannelMessagePublisher;
import com.kingdee.bos.qing.core.model.ExecutingModelWrapper;
import com.kingdee.bos.qing.core.model.ModelJsonDecoder;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.data.exception.CronExpressionParseException;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.ExportDomain;
import com.kingdee.bos.qing.domain.SquareExecuteDomain;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.publish.AbstractPublishManageService;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.model.PushRecordConfig;
import com.kingdee.bos.qing.publish.model.PushTargetType;
import com.kingdee.bos.qing.publish.target.lapp.LappDomain;
import com.kingdee.bos.qing.publish.target.lapp.LappSyncDomain;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.publish.target.lapp.model.LappPublishVO;
import com.kingdee.bos.qing.publish.target.lapp.model.LappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.model.PublishLappConfig;
import com.kingdee.bos.qing.publish.target.lapp.model.PublishedDataSourceInfoVO;
import com.kingdee.bos.qing.publish.target.lapp.model.PushRecord;
import com.kingdee.bos.qing.publish.target.lapp.model.ThirdPartyConfig;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractLappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractLappSchedulePushDomain;
import com.kingdee.bos.qing.publish.target.lapp.push.LappSchedulePushDomainFactory;
import com.kingdee.bos.qing.publish.thumbnail.domain.ThumbnailDomain;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailInfo;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailUrlModel;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailVO;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schedule.AbstractScheduleEngine;
import com.kingdee.bos.qing.schema.model.SchemaContentVO;
import com.kingdee.bos.qing.service.Associate;
import com.kingdee.bos.qing.service.IExecutable;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractLappService
extends AbstractPublishManageService
implements IExecutable {
    private static final String PUBLISH_ID = "publishId";
    private static final String PARAM_PATH_PREFIX = "paramPathPrefix";
    private static final String PUSH_TARGET_TYPE = "pushTargetType";
    private static final String CONFIG_ID = "configId";
    private AbstractDomain.IDataSourceCreator dataSourceCreator;
    private LappDomain lappDomain;
    private LappSyncDomain lappSyncDomain;
    private ThumbnailDomain thumbnailDomain;
    private PublishInfoDao publishInfoDao;

    protected abstract LappContext getLappContext();

    public ThumbnailDomain getThumbnailDomain() {
        if (this.thumbnailDomain == null) {
            this.thumbnailDomain = new ThumbnailDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.thumbnailDomain;
    }

    public void setDataSourceCreator(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        this.dataSourceCreator = dataSourceCreator;
    }

    protected LappDomain getPublishManageDomain() {
        if (this.lappDomain == null) {
            this.lappDomain = new LappDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.lappDomain;
    }

    protected LappSyncDomain getLappSyncDomain() {
        if (this.lappSyncDomain == null) {
            this.lappSyncDomain = new LappSyncDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.lappSyncDomain;
    }

    protected PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    @Associate(data=true)
    @BehaviorAssociate(behavior=false)
    public byte[] exportSquareImg(Map<String, String> params) {
        String modelWrapper = params.get("modelWrapper");
        String height = params.get("height");
        String width = params.get("width");
        SquareExecuteDomain executeDomain = this.createSquareExecuteDomain();
        ExportDomain exportDomain = new ExportDomain();
        IQingFile exportFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
        int iwidth = 250;
        int iheight = 120;
        if (height != null && !height.isEmpty()) {
            iheight = Integer.parseInt(height);
        }
        if (width != null && !width.isEmpty()) {
            iwidth = Integer.parseInt(width);
        }
        ExecutingModelWrapper emw = ModelJsonDecoder.decodeForExecuting((String)modelWrapper);
        try {
            exportDomain.doExportSquareImage(iwidth, iheight, exportFile, emw.getSquareModel(), executeDomain, "png");
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
        ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)exportFile.getName());
        return ResponseUtil.output((IResponseWrap)wrap);
    }

    private SquareExecuteDomain createSquareExecuteDomain() {
        SquareExecuteDomain domain = new SquareExecuteDomain(this.dataSourceCreator);
        domain.setI18nContext(this.qingContext.getIi18nContext());
        return domain;
    }

    public byte[] loadLappSchema(Map<String, String> params) {
        String publishId = params.get(PUBLISH_ID);
        try {
            SchemaContentVO rs = this.getPublishManageDomain().loadSchema(publishId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)rs));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadLappSchemaWithOper(Map<String, String> params) {
        String publishId = params.get(PUBLISH_ID);
        try {
            SchemaContentVO rs = this.getPublishManageDomain().loadSchema(publishId);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("schemaContentVo", rs);
            result.put("operation", this.getPublishManageDomain().loadPublishOperList(publishId, null, true, false));
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(result));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getPublishedDataSourceInfo(Map<String, String> params) {
        String tag = params.get("tag");
        String publishId = params.get(PUBLISH_ID);
        try {
            PublishedDataSourceInfoVO publishedDataSourceInfoVO = this.getPublishManageDomain().getPublishedDataSourceInfo(publishId, tag);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)publishedDataSourceInfoVO));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getExtractDataTime(Map<String, String> params) {
        String tag = params.get("tag");
        try {
            String extractDataTime = this.getPublishManageDomain().getExtractDataTime(tag);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)extractDataTime));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadPublishInfo(Map<String, String> params) {
        String publishId = params.get(PUBLISH_ID);
        try {
            LappPublishVO vo = new LappPublishVO();
            vo.setPublishTargetType(2);
            vo.setId(publishId);
            this.getPublishManageDomain().setPublishPermissionInfo(vo);
            ThumbnailInfo thumbnailInfo = this.getThumbnailDomain().loadThumbnailInfoByPublishId(publishId);
            vo.setThumbnailInfo(thumbnailInfo);
            vo.setNoOperValueMap(this.getPublishManageDomain().loadUserCancelPermission(publishId));
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)vo));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadPublishInfoByPublishIdArr(Map<String, String> params) {
        try {
            String[] publishIdArr = (String[])JsonUtil.decodeFromString((String)params.get("publishIdArr"), String[].class);
            List<LappPublishVO> lappPublishVOList = this.getPublishManageDomain().loadPublishInfoByPublishIdArr(publishIdArr);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(lappPublishVOList));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] saveThumbnailInfo(Map<String, String> params) {
        String thumbnailInfoJsonString = params.get("thumbnailInfo");
        boolean overWrite = Boolean.parseBoolean(params.get("overWrite"));
        String userId = this.qingContext.getUserId();
        ThumbnailInfo thumbnailInfo = (ThumbnailInfo)ModelJsonDecoder.decode((String)thumbnailInfoJsonString, ThumbnailInfo.class);
        try {
            ThumbnailVO thumbnailVO = this.getThumbnailDomain().saveThumbnailInfo(thumbnailInfo, userId, overWrite);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)thumbnailVO));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getThumbnailInfo(Map<String, String> params) {
        String publishId = params.get(PUBLISH_ID);
        try {
            ThumbnailInfo thumbnailInfo = this.getThumbnailDomain().loadThumbnailInfoByPublishId(publishId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)thumbnailInfo));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] updateThumbnailInfo(Map<String, String> params) {
        String thumbnailInfoJsonString = params.get("thumbnailInfo");
        String userId = this.qingContext.getUserId();
        ThumbnailInfo thumbnailInfo = (ThumbnailInfo)ModelJsonDecoder.decode((String)thumbnailInfoJsonString, ThumbnailInfo.class);
        try {
            this.getThumbnailDomain().saveOrUpdateThumbnailInfo(thumbnailInfo, userId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] saveConfigInfo(Map<String, String> params) {
        String tag = params.get("tag");
        String modelBookStr = params.get("modelBook");
        String thumbnailModelBookStr = params.get("thumbnailModelBook");
        String configStr = params.get("configModel");
        String dsbPublishId = params.get("dsbPublishId");
        String scene = params.get("scene");
        String paramPathPrefix = params.get(PARAM_PATH_PREFIX);
        ModelBook thumbnailModelBook = (ModelBook)ModelJsonDecoder.decode((String)thumbnailModelBookStr, ModelBook.class);
        int pushTarget = ((AbstractLappSchedulePushConfigModel)JsonUtil.decodeFromString((String)configStr, AbstractLappSchedulePushConfigModel.class)).getLappSchedulePushConfigModel().getPushTargetType();
        try {
            PushTargetType pushTargetType = PushTargetType.fromPersistance((int)pushTarget);
            AbstractLappSchedulePushDomain domain = LappSchedulePushDomainFactory.createDomain(pushTargetType, this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
            AbstractLappSchedulePushConfigModel pushConfigModel = domain.parseToModel(configStr);
            LappSchedulePushConfigModel lappSchedulePushConfigModel = pushConfigModel.getLappSchedulePushConfigModel();
            this.setQingFileTypeOfThumbnailUrlModel(lappSchedulePushConfigModel);
            domain.saveConfigInfo(tag, pushConfigModel, modelBookStr, thumbnailModelBook, paramPathPrefix, dsbPublishId, scene);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadConfigInfo(Map<String, String> params) {
        int pushTarget = Integer.parseInt(params.get(PUSH_TARGET_TYPE));
        try {
            PushTargetType pushTargetType = PushTargetType.fromPersistance((int)pushTarget);
            AbstractLappSchedulePushDomain domain = LappSchedulePushDomainFactory.createDomain(pushTargetType, this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(domain.loadConfigInfo(pushTargetType, null)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    private void setQingFileTypeOfThumbnailUrlModel(LappSchedulePushConfigModel lappSchedulePushConfigModel) {
        String thumbnailPath = lappSchedulePushConfigModel.getThumbnailPath();
        if (StringUtils.isNotEmpty((CharSequence)thumbnailPath)) {
            ThumbnailUrlModel thumbnailUrlModel = ThumbnailUrlModel.fromJsonObject(thumbnailPath);
            String qingFileType = QingPersistentFileType.IMAGE_LIBRARY.getSubFolder();
            thumbnailUrlModel.setQingFileType(qingFileType);
            thumbnailPath = thumbnailUrlModel.toJsonObject();
            lappSchedulePushConfigModel.setThumbnailPath(thumbnailPath);
        }
    }

    public byte[] updateConfigInfo(Map<String, String> params) {
        String configStr = params.get("configModel");
        String paramPathPrefix = params.get(PARAM_PATH_PREFIX);
        int pushTarget = ((AbstractLappSchedulePushConfigModel)JsonUtil.decodeFromString((String)configStr, AbstractLappSchedulePushConfigModel.class)).getLappSchedulePushConfigModel().getPushTargetType();
        try {
            PushTargetType pushTargetType = PushTargetType.fromPersistance((int)pushTarget);
            AbstractLappSchedulePushDomain domain = LappSchedulePushDomainFactory.createDomain(pushTargetType, this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
            AbstractLappSchedulePushConfigModel pushConfigModel = domain.parseToModel(configStr);
            LappSchedulePushConfigModel lappSchedulePushConfigModel = pushConfigModel.getLappSchedulePushConfigModel();
            String thumbnailPath = lappSchedulePushConfigModel.getThumbnailPath();
            if (StringUtils.isNotEmpty((CharSequence)thumbnailPath) && thumbnailPath.indexOf("{") > -1) {
                this.setQingFileTypeOfThumbnailUrlModel(lappSchedulePushConfigModel);
            }
            domain.updateConfigInfo(pushConfigModel, paramPathPrefix);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] deleteConfigInfo(Map<String, String> params) {
        String configId = params.get(CONFIG_ID);
        int pushTarget = Integer.parseInt(params.get(PUSH_TARGET_TYPE));
        try {
            PushTargetType pushTargetType = PushTargetType.fromPersistance((int)pushTarget);
            AbstractLappSchedulePushDomain domain = LappSchedulePushDomainFactory.createDomain(pushTargetType, this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
            domain.deleteConfigInfo(configId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadAllPushRecord(Map<String, String> params) {
        String configId = params.get(CONFIG_ID);
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getPublishManageDomain().loadAllPushRecord(configId)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] deletePushRecord(Map<String, String> params) {
        String yzjPushRecordModelJsonString = params.get("arrYzjPushRecordModel");
        List yzjPushRecordModelList = (List)JsonUtil.decodeFromString((String)yzjPushRecordModelJsonString, List.class);
        ArrayList<PushRecord> yzjPushRecordList = new ArrayList<PushRecord>(yzjPushRecordModelList.size());
        for (int i = 0; i < yzjPushRecordModelList.size(); ++i) {
            PushRecord yzjPushRecord = (PushRecord)ModelJsonDecoder.decode((String)JsonUtil.encodeToString(yzjPushRecordModelList.get(i)), PushRecord.class);
            yzjPushRecordList.add(yzjPushRecord);
        }
        try {
            this.getPublishManageDomain().deletePushRecordAndAnalysis(yzjPushRecordList);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] updateScheduleState(Map<String, String> params) {
        String configId = params.get(CONFIG_ID);
        boolean openSchedule = Boolean.parseBoolean(params.get("openSchedule"));
        String paramPathPrefix = params.get(PARAM_PATH_PREFIX);
        try {
            this.getPublishManageDomain().updateScheduleState(openSchedule, configId, paramPathPrefix);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadPushSchema(Map<String, String> params) {
        String configId = params.get(CONFIG_ID);
        int pushTarget = Integer.parseInt(params.get(PUSH_TARGET_TYPE));
        try {
            AbstractLappSchedulePushDomain domain = LappSchedulePushDomainFactory.createDomain(PushTargetType.fromPersistance((int)pushTarget), this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
            ModelBook modelBook = domain.loadPushSchema(configId);
            HashMap<String, ModelBook> rs = new HashMap<String, ModelBook>();
            rs.put("model", modelBook);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(rs));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] updatePushSchema(Map<String, String> params) {
        String configId = params.get(CONFIG_ID);
        int pushTarget = Integer.parseInt(params.get(PUSH_TARGET_TYPE));
        String jsonModelBook = params.get("model");
        try {
            AbstractLappSchedulePushDomain domain = LappSchedulePushDomainFactory.createDomain(PushTargetType.fromPersistance((int)pushTarget), this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
            domain.updatePushSchema(configId, jsonModelBook);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Associate(data=true)
    public byte[] updateLappThumbnail(Map<String, String> params) {
        String lappId = params.get("lappId");
        String schemaId = params.get("schemaId");
        String subscribeKey = params.get("subscribeKey");
        String clientId = params.get("fromPageClientId");
        try {
            String imagePath = this.getPublishManageDomain().updateLappThumbnail(this.createSquareExecuteDomain(), lappId, schemaId, this.getLappContext(), this.dataSourceCreator);
            if (!StringUtils.isEmpty((CharSequence)imagePath)) {
                ServerChannelMessagePublisher.publish((String)clientId, (String)subscribeKey, (String)imagePath);
            }
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)imagePath));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] cronExpression(Map<String, String> params) {
        String cronExpression = params.get("cron");
        try {
            List result = AbstractScheduleEngine.cronExpression((String)cronExpression);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (ParseException e) {
            CronExpressionParseException exception = new CronExpressionParseException((Throwable)e);
            return ResponseUtil.output((Exception)exception);
        }
    }

    public abstract byte[] loadThirdPartyConfig(Map<String, String> var1);

    public byte[] updateThirdPartyConfig(Map<String, String> params) {
        try {
            ThirdPartyConfig thirdPartyConfig = (ThirdPartyConfig)JsonUtil.decodeFromString((String)params.get("thirdPartyConfig"), ThirdPartyConfig.class);
            ThirdPartyConfig result = this.getPublishManageDomain().saveOrUpdateThirdPartyConfig(thirdPartyConfig);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)result));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] deleteThirdPartyConfig(Map<String, String> params) {
        try {
            this.getPublishManageDomain().deleteThirdPartyConfig();
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] finishSync(Map<String, String> params) {
        try {
            String datacenterUUID = params.get("datacenterUUID");
            this.getLappSyncDomain().finishSync(datacenterUUID);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public abstract byte[] loadDatacenterInfo(Map<String, String> var1);

    public abstract byte[] getLappContext(Map<String, String> var1);

    public abstract byte[] getLappContextsByIds(Map<String, String> var1);

    public abstract byte[] loadPermissionLappContexts(Map<String, String> var1);

    public byte[] updatePublishLappConfigs(Map<String, String> params) {
        try {
            List publishLappConfigs = (List)new Gson().fromJson(params.get("publishLappConfigs"), new TypeToken<List<PublishLappConfig>>(){}.getType());
            this.getPublishManageDomain().updatePublishLappConfigs(publishLappConfigs);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public abstract byte[] getAllLappContextsByUserIds(Map<String, String> var1);

    public byte[] loadPushRecordConfigInfo(Map<String, String> params) {
        try {
            int pushTargetType = Integer.parseInt(params.get(PUSH_TARGET_TYPE));
            String userId = this.qingContext.getUserId();
            PushRecordConfig lappStorageSetVO = this.getPublishManageDomain().loadPushRecordConfigInfo(userId, pushTargetType);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)lappStorageSetVO);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] saveLappPushRecordConfig(Map<String, String> params) {
        try {
            int pushTargetType = Integer.parseInt(params.get(PUSH_TARGET_TYPE));
            String strategy = params.get("strategy");
            String value = params.get("value");
            PushRecordConfig lappPushRecordConfig = new PushRecordConfig();
            lappPushRecordConfig.setUserId(this.qingContext.getUserId());
            lappPushRecordConfig.setPushTargetType(pushTargetType);
            lappPushRecordConfig.setStrategy(strategy);
            lappPushRecordConfig.setValue(value);
            this.getPublishManageDomain().saveLappPushRecordConfig(lappPushRecordConfig);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)true);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public static class LappContextResult {
        private boolean success = true;
        private List<Map<String, String>> authorizedUsers;
        private List<String> failedUserNames;
        private List<String> failedUserIds;
        private int othersCount;

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public List<Map<String, String>> getAuthorizedUsers() {
            return this.authorizedUsers;
        }

        public void setAuthorizedUsers(List<Map<String, String>> authorizedUsers) {
            this.authorizedUsers = authorizedUsers;
        }

        public List<String> getFailedUserNames() {
            return this.failedUserNames;
        }

        public void setFailedUserNames(List<String> failedUserNames) {
            this.failedUserNames = failedUserNames;
        }

        public List<String> getFailedUserIds() {
            return this.failedUserIds;
        }

        public void setFailedUserIds(List<String> failedUserIds) {
            this.failedUserIds = failedUserIds;
        }

        public int getOthersCount() {
            return this.othersCount;
        }

        public void setOthersCount(int othersCount) {
            this.othersCount = othersCount;
        }
    }
}

