/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp.env;

import com.kingdee.bos.qing.publish.target.lapp.env.AbstractLappEnv;
import com.kingdee.bos.qing.publish.target.lapp.env.LappApiEnum;
import com.kingdee.bos.qing.util.HttpUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.URLUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

public class LappPublicEnv
extends AbstractLappEnv {
    @Override
    public String getLeftTopIconUrl() {
        return this.getServerHostUrl() + "qing-lapp/core/resource/icon_qing.png";
    }

    @Override
    public String getDefaultThumbnailIconUrl() {
        return this.getServerHostUrl() + "qing-lapp/core/resource/icon_chart.png";
    }

    @Override
    public String getDownloadThumbnailUrl(String thumbnailFileName) {
        return this.getServerHostUrl() + LappApiEnum.QING_LAPP_DOWMLOAD_URL.getLappApi() + "?path=" + thumbnailFileName;
    }

    @Override
    public byte[] getDownloadThumbnail(String thumbnailFileName) {
        String url = this.getDownloadThumbnailUrl(thumbnailFileName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HttpUtil.downloadFile((String)url, null, (OutputStream)baos);
        return baos.toByteArray();
    }

    @Override
    public String post(LappApiEnum lappApiEnum, Map<String, String> headers, String bodyJson, Map<String, String> paramMap) {
        String url = this.getServerHostUrl() + lappApiEnum.getLappApi();
        url = URLUtil.appendMultipleParamsToUrl((String)url, paramMap);
        return HttpUtil.post((String)url, headers, (String)bodyJson);
    }

    @Override
    public String postByForm(LappApiEnum lappApiEnum, Map<String, String> headers, Map<String, String> formParams, Map<String, String> paramMap) {
        String url = this.getServerHostUrl() + lappApiEnum.getLappApi();
        url = URLUtil.appendMultipleParamsToUrl((String)url, paramMap);
        return HttpUtil.postByForm((String)url, headers, formParams);
    }

    @Override
    public String postFile(LappApiEnum lappApiEnum, Map<String, String> headers, InputStream inputStream, String fileName) {
        Map resultTemp;
        String url = this.getServerHostUrl() + lappApiEnum.getLappApi();
        String result = HttpUtil.postFile((String)url, headers, (InputStream)inputStream, (String)fileName);
        Map resultObj = (Map)JsonUtil.decodeFromString((String)result, HashMap.class);
        if (null != resultObj && null != (resultTemp = (Map)resultObj.get("data"))) {
            return (String)resultTemp.get("path");
        }
        return null;
    }

    @Override
    public boolean isConnAvailable() {
        try {
            URL url = new URL(this.getUploadurl());
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setConnectTimeout(1000);
            conn.setReadTimeout(1000);
            conn.connect();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getUploadurl() {
        return this.getServerHostUrl() + LappApiEnum.QING_LAPP_UPLOAD_URL.getLappApi();
    }
}

