/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp.model;

import com.kingdee.bos.qing.util.LogUtil;

public class DatacenterSyncModel
implements Cloneable {
    private String datacenterUUID;
    private SyncStatusEnum syncStatus;
    private long syncTime;
    private boolean isInit = false;

    public String getDatacenterUUID() {
        return this.datacenterUUID;
    }

    public void setDatacenterUUID(String datacenerUUID) {
        this.datacenterUUID = datacenerUUID;
    }

    public SyncStatusEnum getSyncStatus() {
        return this.syncStatus;
    }

    public void setSyncStatus(SyncStatusEnum syncStatus) {
        this.syncStatus = syncStatus;
    }

    public long getSyncTime() {
        return this.syncTime;
    }

    public void setSyncTime(long syncTime) {
        this.syncTime = syncTime;
    }

    public boolean isInit() {
        return this.isInit;
    }

    public void setInit(boolean isInit) {
        this.isInit = isInit;
    }

    public boolean isNeedSync() {
        return this.syncStatus == SyncStatusEnum.SYNCHRONIZING && (System.currentTimeMillis() > this.syncTime + 300000L || this.isInit);
    }

    public DatacenterSyncModel clone() {
        DatacenterSyncModel syncModel = null;
        try {
            syncModel = (DatacenterSyncModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LogUtil.error((String)"syncModel clone error", (Throwable)e);
        }
        return syncModel;
    }

    public static enum SyncStatusEnum {
        SYNCHRONIZING("1"),
        SYNCED("2");

        private String id;

        private SyncStatusEnum(String id) {
            this.id = id;
        }

        public String toPersistance() {
            return this.id;
        }

        public static SyncStatusEnum fromPersistance(String id) {
            for (SyncStatusEnum syncStatusEnum : SyncStatusEnum.values()) {
                if (!syncStatusEnum.toPersistance().equals(id)) continue;
                return syncStatusEnum;
            }
            return null;
        }
    }
}

