/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp.push;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.ModelJsonDecoder;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.exception.MapNotFoundException;
import com.kingdee.bos.qing.publish.exception.MismatchSourceTypeException;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishNotFoundException;
import com.kingdee.bos.qing.publish.model.PushTargetType;
import com.kingdee.bos.qing.publish.target.lapp.LappDomain;
import com.kingdee.bos.qing.publish.target.lapp.dao.LappDao;
import com.kingdee.bos.qing.publish.target.lapp.exception.ExecuteSqlException;
import com.kingdee.bos.qing.publish.target.lapp.exception.LappException;
import com.kingdee.bos.qing.publish.target.lapp.model.LappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.model.PushThumbnailInfoModel;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractLappSchedulePushConfigModel;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.exception.ScheduleEngineException;
import com.kingdee.bos.qing.schema.domain.SchemaDomain;
import com.kingdee.bos.qing.util.ModelBookUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.JDOMException;

public abstract class AbstractLappSchedulePushDomain
extends AbstractPublishManageDomain {
    protected static final int YZJ = 0;
    protected static final int WXQYH = 1;
    protected static final int DINGDING = 3;
    private LappDomain lappDomain;
    private LappDao lappDao;
    private SchemaDomain schemaDomain;

    public AbstractLappSchedulePushDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
        this.qingContext = qingContext;
        this.dbExcuter = dbExcuter;
    }

    public abstract void saveConfigInfo(String var1, AbstractLappSchedulePushConfigModel var2, String var3, ModelBook var4, String var5, String var6, String var7) throws AbstractQingIntegratedException, PublishException;

    public abstract List<? extends AbstractLappSchedulePushConfigModel> loadConfigInfo(PushTargetType var1, String var2) throws AbstractQingIntegratedException, ExecuteSqlException, MismatchSourceTypeException;

    public abstract void updateConfigInfo(AbstractLappSchedulePushConfigModel var1, String var2) throws AbstractQingIntegratedException, PublishException, PersistentModelParseException, PersistentModelTooModernException, JDOMException;

    public abstract void deleteConfigInfo(String var1) throws AbstractQingIntegratedException, PublishException;

    public abstract AbstractLappSchedulePushConfigModel parseToModel(String var1);

    protected LappDomain getLappDomain() {
        if (this.lappDomain == null) {
            this.lappDomain = new LappDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.lappDomain;
    }

    protected LappDao getLappDao() {
        if (this.lappDao == null) {
            this.lappDao = new LappDao(this.dbExcuter);
        }
        return this.lappDao;
    }

    private SchemaDomain getSchemaDomain() {
        if (this.schemaDomain == null) {
            this.schemaDomain = new SchemaDomain();
            this.schemaDomain.setDbExcuter(this.dbExcuter);
            this.schemaDomain.setTx(this.tx);
        }
        return this.schemaDomain;
    }

    protected void saveSchemaRef(List<OutsideReference> outsideRefList, String schemaId) throws AbstractQingIntegratedException, SQLException, MapNotFoundException {
        for (int i = 0; i < outsideRefList.size(); ++i) {
            OutsideReference outerRef = outsideRefList.get(i);
            if (outerRef.getUid() == null) {
                throw new MapNotFoundException();
            }
            this.getLappDao().saveSchemaRef(outerRef, schemaId);
        }
    }

    public ModelBook loadPushSchema(String configId) throws AbstractQingIntegratedException, SQLException, LappException {
        byte[] schemaContentBytes = this.getLappDao().getSchemaContent(configId);
        try {
            ModelBook modelBook = ModelBookUtil.fromByte(schemaContentBytes);
            List<OutsideReference> outsideRef = this.getLappDao().loadSchemaRef(configId);
            this.getSchemaDomain().setOutSideRefName(outsideRef);
            modelBook.fixReferences(outsideRef);
            return modelBook;
        }
        catch (PersistentModelParseException e) {
            throw new LappException(e);
        }
        catch (PersistentModelTooModernException e) {
            throw new LappException(e);
        }
        catch (JDOMException e) {
            throw new LappException(e);
        }
        catch (IOException e) {
            throw new LappException(e);
        }
    }

    public void updatePushSchema(String configId, String jsonModelbook) throws LappException, PublishNotFoundException, ScheduleEngineException {
        LappSchedulePushConfigModel configModel;
        ModelBook modelBook = ModelJsonDecoder.decode((String)jsonModelbook);
        try {
            this.tx.beginRequired();
            configModel = this.getLappDao().loadPushConfigById(configId, this.qingContext.getUserId());
            if (configModel == null || configModel.getId() == null) {
                throw new PublishNotFoundException();
            }
            byte[] modelContent = ModelBookUtil.toByte(modelBook);
            this.getLappDao().deleteSchemaRef(configId);
            this.getLappDao().deleteSchemaByConfigId(configId);
            this.getLappDao().saveSchema(configId, modelContent);
            this.saveSchemaRef(modelBook.pickReferences(), configId);
            PushThumbnailInfoModel thumbnailModel = this.getLappDao().loadThumbnailInfo(configId);
            String thumbnailInfoId = thumbnailModel.getId();
            this.getLappDao().deleteSchemaRef(thumbnailInfoId);
            this.getLappDao().deleteSchemaByConfigId(thumbnailInfoId);
            this.getLappDao().saveSchema(thumbnailInfoId, modelContent);
            this.saveSchemaRef(modelBook.pickReferences(), thumbnailInfoId);
            boolean warningRuleStatus = LappDomain.checkWarningRuleStatus(configModel, modelBook);
            if (!configModel.getWarningRuleStatus() && warningRuleStatus) {
                this.getLappDao().updateWarningState(true, configModel.getId(), this.qingContext.getUserId());
            }
            if (!warningRuleStatus) {
                this.getLappDao().updateScheduleAndWarningState(false, false, configModel.getId(), this.qingContext.getUserId());
                this.scheduleEngine.deleteJob(this.qingContext, null, configId);
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw new LappException(e);
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new LappException(e);
        }
        catch (MapNotFoundException e) {
            this.tx.markRollback();
            throw new LappException(e.getMessage(), e.getErrorCode());
        }
        catch (ScheduleEngineException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(configModel.getName());
        this.addOpLog(OpLogActionType.EDIT, configModel, params, "\u201c$param\u201d\u7684\u63a8\u9001\u65b9\u6848");
    }

    public void addOpLog(OpLogActionType opLogActionType, LappSchedulePushConfigModel configModel, List<String> params, String opLogParam) {
    }
}

