/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp.push;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.publish.target.lapp.PushScheduleExecuteDomian;
import com.kingdee.bos.qing.publish.target.lapp.dao.LappDao;
import com.kingdee.bos.qing.publish.target.lapp.model.AbstractPushMessageModel;
import com.kingdee.bos.qing.publish.target.lapp.model.LappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractLappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractPushMessageResult;
import com.kingdee.bos.qing.publish.target.lapp.util.LappHelper;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.DateUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.Date;
import java.util.Locale;

public abstract class AbstractPushMessageService {
    protected QingContext qingContext;
    protected ITransactionManagement tx;
    protected IDBExcuter dbExcuter;
    protected IScheduleEngine scheduleEngine;
    private PushScheduleExecuteDomian pushScheduleExecuteDomian;
    private LappDao lappDao;

    public abstract AbstractPushMessageModel getPushModel();

    public abstract AbstractPushMessageResult getPushResult();

    public abstract String getWebpageUrl(AbstractLappSchedulePushConfigModel var1, String var2);

    public abstract AbstractPushMessageResult doPush(String var1, LappSchedulePushConfigModel var2, String var3, String var4, String var5) throws AbstractQingException;

    public AbstractPushMessageService(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        this.qingContext = qingContext;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
        this.scheduleEngine = scheduleEngine;
    }

    private PushScheduleExecuteDomian getPushScheduleExecuteDomian() {
        if (this.pushScheduleExecuteDomian == null) {
            this.pushScheduleExecuteDomian = new PushScheduleExecuteDomian();
            this.pushScheduleExecuteDomian.setDbExcuter(this.dbExcuter);
            this.pushScheduleExecuteDomian.setQingContext(this.qingContext);
            this.pushScheduleExecuteDomian.setTx(this.tx);
            this.pushScheduleExecuteDomian.setScheduleEngine(this.scheduleEngine);
        }
        return this.pushScheduleExecuteDomian;
    }

    protected LappDao getLappDao() {
        if (this.lappDao == null) {
            this.lappDao = new LappDao(this.dbExcuter);
        }
        return this.lappDao;
    }

    protected void tryToAddSystemTimeForPushName(LappSchedulePushConfigModel pushConfigModel) {
        if (pushConfigModel.getNameRule() != null) {
            Locale locale = this.qingContext.getIi18nContext().getLanManager().getLocale();
            String dateStr = DateUtils.date2StrByLang((Locale)locale, (String)pushConfigModel.getNameRule(), (Date)new Date());
            pushConfigModel.setName(pushConfigModel.getName() + "-" + dateStr);
        }
    }

    protected void deleteGarbage(LappSchedulePushConfigModel pushConfigModel, String analysisId, String publishId) {
        this.getPushScheduleExecuteDomian().deleteGarbage(pushConfigModel, analysisId, publishId);
    }

    protected AbstractPushMessageModel getPushModel(AbstractLappSchedulePushConfigModel model, String lappEntranceUrl, String thumbnailFileName) {
        LappSchedulePushConfigModel pushConfigModel = model.getLappSchedulePushConfigModel();
        AbstractPushMessageModel pushMessageModel = this.getPushModel();
        String title = pushConfigModel.getName();
        String desc = pushConfigModel.getDescText();
        pushMessageModel.setTitle(title);
        pushMessageModel.setDesc(StringUtils.isBlank((CharSequence)desc) ? title : desc);
        String thumbnailPath = null;
        thumbnailPath = thumbnailFileName != null ? LappHelper.getDownloadThumbnailUrl(thumbnailFileName) : LappHelper.getDefaultThumbnailIconUrl();
        pushMessageModel.setPicUrl(thumbnailPath);
        pushMessageModel.setWebpageUrl(this.getWebpageUrl(model, lappEntranceUrl));
        pushMessageModel.setIconUrl(LappHelper.getLeftTopIconUrl());
        String appName = Messages.getMLS((QingContext)this.qingContext, (String)"qingAnalysis", (String)"\u8f7b\u5206\u6790", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
        pushMessageModel.setAppName(appName);
        return pushMessageModel;
    }

    public static final byte[] isMyOwnPushConfig(QingContext qingContext, IDBExcuter dbExcuter, String configId) {
        try {
            PushScheduleExecuteDomian pushScheduleExecuteDomian = new PushScheduleExecuteDomian();
            pushScheduleExecuteDomian.setDbExcuter(dbExcuter);
            pushScheduleExecuteDomian.setQingContext(qingContext);
            boolean rs = pushScheduleExecuteDomian.isMyOwnConfig(configId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)rs));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

