/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.thumbnail;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.DataEmptyException;
import com.kingdee.bos.qing.core.model.analysis.IPreferences;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.AnalyticalPreferences;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.ExhibitionStatus;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.ExecuteDomain;
import com.kingdee.bos.qing.domain.ExportDomain;
import com.kingdee.bos.qing.domain.SquareExecuteDomain;
import com.kingdee.bos.qing.export.common.exception.ExportNoContentException;
import com.kingdee.bos.qing.export.common.util.UnitUtil;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileWriter;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.filesystem.stream.QingOutputStream;
import com.kingdee.bos.qing.publish.target.lapp.env.LappApiEnum;
import com.kingdee.bos.qing.publish.target.lapp.exception.LappException;
import com.kingdee.bos.qing.publish.target.lapp.exception.LappUserIdNotFoundException;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.publish.target.lapp.util.LappHelper;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailInfo;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ThumbnailHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IQingFile generateMobileImage(ModelBook modelBook, AbstractDomain.IDataSourceCreator dataSourceCreator, II18nContext i18n, ThumbnailInfo thumbnailInfo) throws AnalysisException, IOException {
        Meta meta = modelBook.getMeta();
        ModelBook.ModelPage page = (ModelBook.ModelPage)modelBook.getPages().get(0);
        IPreferences preferences = page.getPreferences();
        IQingModel model = page.getModel();
        ModelBook.ModelPage.prepareForExecuting((Meta)meta, (IQingModel)model, (IPreferences)preferences);
        UnitUtil.ExportType exportType = UnitUtil.ExportType.valueOf((String)"PNG");
        ExportDomain exportDomain = new ExportDomain();
        IQingFile qingFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
        if (model instanceof AnalyticalModel) {
            String sFileName = "Qing-" + System.currentTimeMillis() + ".png";
            ExecuteDomain executeDomain = new ExecuteDomain(dataSourceCreator);
            executeDomain.setI18nContext(i18n);
            AnalyticalModel analyticalModel = (AnalyticalModel)model;
            AnalyticalPreferences analyticalPreferences = (AnalyticalPreferences)preferences;
            int x = thumbnailInfo.getApertureLeft();
            int y = thumbnailInfo.getApertureTop();
            int width = thumbnailInfo.getApertureWidth();
            int height = thumbnailInfo.getApertureHeight();
            int scrollX = thumbnailInfo.getScrollLeft();
            int scrollY = thumbnailInfo.getScrollTop();
            try {
                exportDomain.doExport(qingFile, sFileName, exportType, analyticalModel, executeDomain, analyticalPreferences, null, i18n);
                IQingFile iQingFile = ThumbnailHelper.generateThumbnail((IQingFileVisitor)qingFile, modelBook, x, y, width, height, scrollX, scrollY);
                return iQingFile;
            }
            catch (ExportNoContentException e) {
                IQingFile iQingFile = ThumbnailHelper.generateNoDataImg(i18n);
                return iQingFile;
            }
            catch (DataEmptyException e) {
                IQingFile iQingFile = ThumbnailHelper.generateNoDataImg(i18n);
                return iQingFile;
            }
            finally {
                qingFile.delete();
            }
        }
        if (model instanceof SquareModel) {
            SquareExecuteDomain executeDomain = new SquareExecuteDomain(dataSourceCreator);
            executeDomain.setI18nContext(i18n);
            SquareModel squareModel = (SquareModel)model;
            exportDomain.doExportSquareImage(thumbnailInfo.getApertureWidth(), thumbnailInfo.getApertureHeight(), qingFile, squareModel, executeDomain, "png");
        }
        return qingFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IQingFile generateCompressImage(IQingFileVisitor needCompressFile, int width, int height, AbstractQingFileType abstractQingFileType, QingContext qingContext, QingFileResourceInfo fileResourceInfo) throws IOException {
        IQingFile newThumbnailFile = null;
        IQingFileWriter writer = null;
        QingOutputStream os = null;
        IOException exception = null;
        try {
            BufferedImage bufferedImage = ThumbnailHelper.compressImage(needCompressFile, width, height);
            if (bufferedImage != null) {
                if (abstractQingFileType instanceof QingPersistentFileType) {
                    newThumbnailFile = FileFactory.newPersistentFile((QingContext)qingContext, (QingFileResourceInfo)fileResourceInfo, (QingPersistentFileType)((QingPersistentFileType)abstractQingFileType));
                } else {
                    if (!(abstractQingFileType instanceof QingTempFileType)) {
                        IQingFile iQingFile = null;
                        ThumbnailHelper.closeOutput(os, writer, newThumbnailFile, exception);
                        return iQingFile;
                    }
                    newThumbnailFile = FileFactory.newTempFile((QingTempFileType)((QingTempFileType)abstractQingFileType));
                }
            } else {
                IQingFile iQingFile = null;
                return iQingFile;
            }
            writer = newThumbnailFile.createWriter();
            os = writer.getOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", (OutputStream)os);
            IQingFile iQingFile = newThumbnailFile;
            ThumbnailHelper.closeOutput((OutputStream)os, writer, newThumbnailFile, exception);
            return iQingFile;
        }
        catch (IOException e) {
            exception = e;
            throw e;
        }
        finally {
            ThumbnailHelper.closeOutput(os, writer, newThumbnailFile, exception);
        }
    }

    /*
     * Loose catch block
     */
    private static BufferedImage compressImage(IQingFileVisitor needCompressFile, int width, int height) throws IOException {
        BufferedImage newImage2222222222;
        BufferedImage originalImage;
        QingInputStream inputStream;
        block7: {
            inputStream = null;
            originalImage = null;
            inputStream = needCompressFile.getInputStream();
            originalImage = ImageIO.read((InputStream)inputStream);
            if (width <= 0 || height <= 0) break block7;
            BufferedImage newImage2222222222 = new BufferedImage(width, height, originalImage.getType());
            Graphics graphics = newImage2222222222.getGraphics();
            graphics.drawImage(originalImage, 0, 0, width, height, null);
            graphics.dispose();
            BufferedImage bufferedImage = newImage2222222222;
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            return bufferedImage;
        }
        try {
            newImage2222222222 = originalImage;
        }
        catch (FileNotFoundException fileNotFoundException) {
            BufferedImage bufferedImage = null;
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            return bufferedImage;
        }
        catch (IOException e) {
            throw e;
            {
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        return newImage2222222222;
    }

    private static void closeOutput(OutputStream os, IQingFileWriter writer, IQingFile qingFile, Exception exception) {
        CloseUtil.close((Closeable[])new Closeable[]{os});
        os = null;
        if (writer != null) {
            writer.close(exception);
            writer = null;
            if (exception != null) {
                qingFile.delete();
                qingFile = null;
            }
        }
    }

    private static IQingFile generateNoDataImg(II18nContext i18n) throws IOException {
        int width = 400;
        int height = 200;
        int fontSize = 12;
        BufferedImage bi = ThumbnailHelper.generateBGImage(width, height);
        Graphics2D g2d = bi.createGraphics();
        String text = Messages.getMLS((II18nContext)i18n, (String)"noContentThumbnail", (String)"\u6ca1\u6709\u53ef\u5c55\u793a\u5185\u5bb9", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
        Font font = new Font("Microsoft Yahei", 0, fontSize);
        g2d.setFont(font);
        int textWidth = g2d.getFontMetrics().stringWidth(text);
        int x = (width - textWidth) / 2;
        g2d.drawString(text, x, height / 2 - fontSize / 2);
        g2d.dispose();
        IQingFileWriter writer = null;
        QingOutputStream os = null;
        IQingFile qingFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
        writer = qingFile.createWriter();
        IOException exception = null;
        try {
            os = writer.getOutputStream();
            ImageIO.write((RenderedImage)bi, "png", (OutputStream)os);
        }
        catch (IOException e) {
            exception = e;
            throw e;
        }
        finally {
            ThumbnailHelper.closeOutput((OutputStream)os, writer, qingFile, exception);
        }
        return qingFile;
    }

    private static void updateMobileImage(String path, String analysisId, LappContext lappCtx) throws IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        paramMap.put("lappUserId", lappCtx.getLappUserId());
        paramMap.put("lappUserType", lappCtx.getLappUserType());
        paramMap.put("id", analysisId);
        paramMap.put("path", path);
        String result = LappHelper.post(LappApiEnum.QING_LAPP_UPDATE_URL, null, null, paramMap);
        if (LogUtil.isDebugEnabled()) {
            LogUtil.debug((String)result);
        }
    }

    public static String uploadImage(IQingFile exportFile, String analysisId, LappContext lappCtx) throws IOException, LappException {
        if (StringUtils.isBlank((CharSequence)lappCtx.getLappUserId())) {
            String errorMsg = Messages.getMLS((String)"lappUserIdNotFound", (String)"\u83b7\u53d6\u8f7b\u5e94\u7528\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u540c\u6b65\u7528\u6237\u4fe1\u606f", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
            throw new LappUserIdNotFoundException(errorMsg);
        }
        String newpath = ThumbnailHelper.upload(exportFile);
        if (newpath != null) {
            ThumbnailHelper.updateMobileImage(newpath, analysisId, lappCtx);
        }
        return newpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(IQingFile exportFile) throws IOException {
        String string;
        HashMap<String, String> headers = new HashMap<String, String>();
        QingInputStream inputStream = null;
        try {
            inputStream = exportFile.getInputStream();
            String fileName = System.currentTimeMillis() + ".png";
            string = LappHelper.postFile(LappApiEnum.QING_LAPP_UPLOAD_URL, headers, (InputStream)inputStream, fileName);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            exportFile.delete();
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        exportFile.delete();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(InputStream inputStream) throws IOException {
        String string;
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            String fileName = System.currentTimeMillis() + ".png";
            string = LappHelper.postFile(LappApiEnum.QING_LAPP_UPLOAD_URL, headers, inputStream, fileName);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        return string;
    }

    private static IQingFile generateThumbnail(IQingFileVisitor schemaImageFile, ModelBook modelBook, int x, int y, int width, int height, int scrollX, int scrollY) throws IOException {
        IQingFile newThumbnailFile = null;
        IQingFileWriter writer = null;
        QingOutputStream os = null;
        IOException exception = null;
        try {
            ExhibitionStatus status = ThumbnailHelper.getExbitionStatus(modelBook);
            BufferedImage cutResult = ThumbnailHelper.generateThumbnailBuffer(status, schemaImageFile, x, y, width, height, scrollX, scrollY);
            if (cutResult.getHeight() < height || cutResult.getWidth() < width) {
                cutResult = ThumbnailHelper.fillImageBlank(cutResult, width, height);
            }
            newThumbnailFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
            writer = newThumbnailFile.createWriter();
            os = writer.getOutputStream();
            ImageIO.write((RenderedImage)cutResult, "png", (OutputStream)os);
        }
        catch (IOException e) {
            try {
                exception = e;
                throw e;
            }
            catch (Throwable throwable) {
                ThumbnailHelper.closeOutput(os, writer, newThumbnailFile, exception);
                throw throwable;
            }
        }
        ThumbnailHelper.closeOutput((OutputStream)os, writer, newThumbnailFile, exception);
        return newThumbnailFile;
    }

    private static ExhibitionStatus getExbitionStatus(ModelBook modelBook) {
        ModelBook.ModelPage page = (ModelBook.ModelPage)modelBook.getPages().get(0);
        IPreferences preferences = page.getPreferences();
        AnalyticalPreferences analyticalPreferences = (AnalyticalPreferences)preferences;
        ExhibitionStatus status = analyticalPreferences.getExhibitionStatus();
        return status;
    }

    private static BufferedImage generateThumbnailBuffer(ExhibitionStatus status, IQingFileVisitor schemaImageFile, int x, int y, int width, int height, int scrollX, int scrollY) {
        if (scrollX == 0 && scrollY == 0) {
            return ThumbnailHelper.cutImage(schemaImageFile, x, y, width, height, 0, 0, scrollX, scrollY);
        }
        int[] statusWidth = status.getPaintableColumnWidth();
        int[] statusHeight = status.getPaintableRowHeight();
        int freezeRowHeight = 0;
        for (int i = 0; i < statusHeight.length - 1; ++i) {
            freezeRowHeight += statusHeight[i];
        }
        int freezeColWidth = 0;
        for (int i = 0; i < statusWidth.length - 1; ++i) {
            freezeColWidth += statusWidth[i];
        }
        if (freezeColWidth >= 560) {
            freezeColWidth = 0;
        }
        BufferedImage image1 = ThumbnailHelper.cutLeftTopImage(schemaImageFile, x, y, freezeColWidth, freezeRowHeight, width, height);
        BufferedImage image2 = ThumbnailHelper.cutRightTopImage(schemaImageFile, x + width, y, freezeColWidth, freezeRowHeight, width, height, scrollX);
        BufferedImage image3 = ThumbnailHelper.cutLeftBottomImage(schemaImageFile, x, y + height, freezeColWidth, freezeRowHeight, width, height, scrollY);
        BufferedImage image4 = ThumbnailHelper.cutRightBottomImage(schemaImageFile, x + width, y + height, freezeColWidth, freezeRowHeight, width, height, scrollX, scrollY);
        return ThumbnailHelper.mergeImage(image1, image2, image3, image4, width, height);
    }

    private static BufferedImage cutLeftTopImage(IQingFileVisitor exportFileName, int x, int y, int freezeColWidth, int freezeRowHeight, int width, int height) {
        BufferedImage bi = null;
        if (x < freezeColWidth && y < freezeRowHeight) {
            int trueWidth = Math.min(width, freezeColWidth - x);
            int trueHeight = Math.min(height, freezeRowHeight - y);
            bi = ThumbnailHelper.cutImage(exportFileName, x, y, trueWidth + 1, trueHeight + 1, freezeColWidth, freezeRowHeight, 0, 0);
        }
        return bi;
    }

    private static BufferedImage cutRightTopImage(IQingFileVisitor exportFileName, int x, int y, int freezeColWidth, int freezeRowHeight, int width, int height, int scrollX) {
        BufferedImage bi = null;
        if (x >= freezeColWidth && y < freezeRowHeight) {
            int trueWidth = Math.min(width, x - freezeColWidth);
            int trueHeight = Math.min(height, freezeRowHeight - y);
            bi = ThumbnailHelper.cutImage(exportFileName, x - trueWidth, y, trueWidth, trueHeight + 1, freezeColWidth, freezeRowHeight, scrollX, 0);
        }
        return bi;
    }

    private static BufferedImage cutLeftBottomImage(IQingFileVisitor exportFileName, int x, int y, int freezeColWidth, int freezeRowHeight, int width, int height, int scrollY) {
        BufferedImage bi = null;
        if (x < freezeColWidth && y >= freezeRowHeight) {
            int trueWidth = Math.min(width, freezeColWidth - x);
            int trueHeight = Math.min(height, y - freezeRowHeight);
            bi = ThumbnailHelper.cutImage(exportFileName, x, y - trueHeight, trueWidth + 1, trueHeight, freezeColWidth, freezeRowHeight, 0, scrollY);
        }
        return bi;
    }

    private static BufferedImage cutRightBottomImage(IQingFileVisitor exportFileName, int x, int y, int freezeColWidth, int freezeRowHeight, int width, int height, int scrollX, int scrollY) {
        BufferedImage bi = null;
        if (x >= freezeColWidth && y >= freezeRowHeight) {
            int trueWidth = Math.min(width, x - freezeColWidth);
            int trueHeight = Math.min(height, y - freezeRowHeight);
            bi = ThumbnailHelper.cutImage(exportFileName, x - trueWidth, y - trueHeight, trueWidth, trueHeight, freezeColWidth, freezeRowHeight, scrollX, scrollY);
        }
        return bi;
    }

    private static BufferedImage mergeImage(BufferedImage image1, BufferedImage image2, BufferedImage image3, BufferedImage image4, int width, int height) {
        BufferedImage mergedImage = ThumbnailHelper.generateBGImage(width, height);
        Graphics2D g2d = mergedImage.createGraphics();
        int startX = 0;
        int startY = 0;
        if (null != image1) {
            g2d.drawImage(image1, startX, startY, image1.getWidth(), image1.getHeight(), null);
            startX += image1.getWidth();
        }
        if (null != image2) {
            g2d.drawImage(image2, startX, startY, image2.getWidth(), image2.getHeight(), null);
            startX = 0;
            startY += image2.getHeight();
        }
        if (null != image3) {
            g2d.drawImage(image3, startX, startY, image3.getWidth(), image3.getHeight(), null);
            startX += image3.getWidth();
        }
        if (null != image4) {
            g2d.drawImage(image4, startX, startY, image4.getWidth(), image4.getHeight(), null);
        }
        return mergedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BufferedImage cutImage(IQingFileVisitor exportFile, int x, int y, int width, int height, int freezeColWidth, int freezeRowHeight, int scrollX, int scrollY) {
        BufferedImage bufferedImage;
        BufferedImage bi = null;
        y += scrollY;
        x += scrollX;
        QingInputStream inputStream = null;
        ImageInputStream imageInputStream = null;
        try {
            inputStream = exportFile.getInputStream();
            imageInputStream = ImageIO.createImageInputStream(inputStream);
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            ImageReader imageReader = iterator.next();
            imageReader.setInput(imageInputStream, true);
            int originImageWidth = imageReader.getWidth(0);
            int originImageHeight = imageReader.getHeight(0);
            if (x + width > originImageWidth) {
                x = Math.max(freezeColWidth, originImageWidth - width);
            }
            if (y + height > originImageHeight) {
                y = Math.max(freezeRowHeight, originImageHeight - height);
            }
            x = Math.max(0, x);
            y = Math.max(0, y);
            ImageReadParam readParam = imageReader.getDefaultReadParam();
            Rectangle rect = new Rectangle(x, y, width, height);
            readParam.setSourceRegion(rect);
            bufferedImage = bi = imageReader.read(0, readParam);
        }
        catch (IOException e) {
            try {
                LogUtil.error((String)"cut image fail : ", (Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            return null;
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        return bufferedImage;
    }

    private static BufferedImage fillImageBlank(BufferedImage originBI, int width, int height) {
        BufferedImage bgBufferedImage = ThumbnailHelper.generateBGImage(width, height);
        Graphics2D g2d = bgBufferedImage.createGraphics();
        g2d.drawImage(originBI, 0, 0, originBI.getWidth(), originBI.getHeight(), null);
        g2d.dispose();
        return bgBufferedImage;
    }

    private static BufferedImage generateBGImage(int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g2d = bi.createGraphics();
        Color color = new Color(233, 236, 241);
        g2d.setColor(color);
        g2d.fillRect(0, 0, width, height);
        g2d.dispose();
        return bi;
    }
}

