/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.thumbnail.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishNotFoundException;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.publish.target.lapp.util.LappHelper;
import com.kingdee.bos.qing.publish.thumbnail.ThumbnailHelper;
import com.kingdee.bos.qing.publish.thumbnail.domain.ThumbnailDomain;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailInfo;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.model.Schedule;
import com.kingdee.bos.qing.subject.dao.ISubjectDao;
import com.kingdee.bos.qing.subject.dao.impl.SubjectDaoImpl;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.ModelBookUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.jdom2.JDOMException;

public abstract class AbstractThumbnailForExcuteDomain
extends ThumbnailDomain {
    private boolean checkConnBeforeExe = true;
    private IThemeDao themeDao;
    private ISubjectDao subjectDao;

    public AbstractThumbnailForExcuteDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    private IThemeDao getThemeDao() {
        if (this.themeDao == null) {
            this.themeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.themeDao;
    }

    private ISubjectDao getSubjectDao() {
        if (this.subjectDao == null) {
            this.subjectDao = new SubjectDaoImpl(this.dbExcuter);
        }
        return this.subjectDao;
    }

    public void setConnCheckBeforeExe(boolean needCheck) {
        this.checkConnBeforeExe = needCheck;
    }

    public void batchGenerateAndUpdateMobileImage(AbstractDomain.IDataSourceCreator dataSourceCreator, String themeId, LappContext lappCtx) {
        if (this.checkConnBeforeExe && !LappHelper.isConnAvailable()) {
            return;
        }
        try {
            List publishIds = this.getPublishInfoDao().getPublishIdBythemeId(themeId);
            if (publishIds != null && !publishIds.isEmpty()) {
                for (String publishId : publishIds) {
                    ThumbnailInfo thumbnailInfo = this.loadThumbnailInfoByPublishId(publishId);
                    if (null == thumbnailInfo) continue;
                    PublishPO publishInfo = this.getPublishInfoDao().getPublishInfoByInfoId(thumbnailInfo.getPublishId());
                    this.singleGenerateAndUpdateMobileImage(dataSourceCreator, thumbnailInfo, publishInfo, false, lappCtx);
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
    }

    private boolean needToSchedule(ThumbnailInfo thumbnailInfo, PublishPO publishInfo, boolean checkPublishSourceSchedule) throws SQLException, AbstractQingIntegratedException, ModelParseException, EncryptedLicenseCheckException {
        if (this.checkConnBeforeExe && !LappHelper.isConnAvailable()) {
            return false;
        }
        Schedule schedule = thumbnailInfo.getSchedule();
        if (schedule == null || schedule.getPeriod() == null) {
            return false;
        }
        if (checkPublishSourceSchedule) {
            if (publishInfo == null) {
                return false;
            }
            String tagId = publishInfo.getTagId();
            if (publishInfo.isCarryData()) {
                return false;
            }
            if (PublishSourceEnum.subject == publishInfo.getPublishSourceType()) {
                ThemePO themePO = this.getThemeDao().getThemeByID(tagId);
                if (themePO != null) {
                    Box box = this.getSubjectDao().loadSubjectModelIncludePreset(themePO.getUserID(), tagId);
                    schedule = box.getSchedule();
                    return schedule == null || schedule.getPeriod() == null;
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public void singleGenerateAndUpdateMobileImage(AbstractDomain.IDataSourceCreator dataSourceCreator, ThumbnailInfo thumbnailInfo, PublishPO publishInfo, boolean checkPublishSourceSchedule, LappContext lappCtx) throws AbstractQingException {
        try {
            if (!this.needToSchedule(thumbnailInfo, publishInfo, checkPublishSourceSchedule)) {
                return;
            }
            byte[] schemaContent = this.getSchemaManageDao().loadSchemaContent(thumbnailInfo.getSchemaId());
            ModelBook modelBook = ModelBookUtil.fromByte(schemaContent);
            IQingFile localImagePath = ThumbnailHelper.generateMobileImage(modelBook, dataSourceCreator, this.qingContext.getIi18nContext(), thumbnailInfo);
            ThumbnailHelper.uploadImage(localImagePath, thumbnailInfo.getAnalysisId(), lappCtx);
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
        catch (IOException e) {
            throw new PublishException((Throwable)e);
        }
        catch (JDOMException e) {
            throw new PublishException((Throwable)e);
        }
    }

    public void singleGenerateAndUpdateMobileImage(String analysisId, boolean checkPublishSourceSchedule, LappContext lappCtx) throws AbstractQingException {
        try {
            ThumbnailInfo thumbnailInfo = this.loadThumbnailInfoByAnalysisId(analysisId);
            if (thumbnailInfo == null) {
                throw new PublishNotFoundException();
            }
            PublishPO publishInfo = this.getPublishInfoDao().getPublishInfoByInfoId(thumbnailInfo.getPublishId());
            if (publishInfo == null) {
                throw new PublishNotFoundException();
            }
            if (!this.needToSchedule(thumbnailInfo, publishInfo, checkPublishSourceSchedule)) {
                return;
            }
            ModelBook modelBook = this.getSchemaManageDao().loadSchemaModelBook(thumbnailInfo.getSchemaId());
            AbstractDomain.IDataSourceCreator dataSourceCreator = this.getDataSource(UUID.randomUUID().toString(), thumbnailInfo.getPublishId());
            IQingFile localImagePath = ThumbnailHelper.generateMobileImage(modelBook, dataSourceCreator, this.qingContext.getIi18nContext(), thumbnailInfo);
            ThumbnailHelper.uploadImage(localImagePath, thumbnailInfo.getAnalysisId(), lappCtx);
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
        catch (IOException e) {
            throw new PublishException((Throwable)e);
        }
        catch (JDOMException e) {
            throw new PublishException((Throwable)e);
        }
    }

    protected abstract AbstractDomain.IDataSourceCreator getDataSource(String var1, String var2) throws AbstractQingException;
}

