/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schema.domain;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.map.MapRefUpdater;
import com.kingdee.bos.qing.map.model.MapType;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.SQLException;
import java.util.List;

public class SchemaMapRefUpdater
implements MapRefUpdater {
    private IDBExcuter dbExcuter;
    private SchemaManageDao schemaDao;

    @Override
    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private SchemaManageDao getSchemaDao() {
        if (this.schemaDao == null) {
            this.schemaDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaDao;
    }

    @Override
    public void updateMapIdOfRefWithoutTx(String mapId, String fullPath) {
        try {
            List<String> outSideRefList = this.getSchemaDao().loadRefToIdIsNullOutSideRef(fullPath, MapType.valueOf("Map").toPersistance());
            for (int i = 0; i < outSideRefList.size(); ++i) {
                String fId = outSideRefList.get(i);
                this.getSchemaDao().updateRefToId(fId, mapId);
            }
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)"update schema refToId erro", (Throwable)e);
        }
        catch (SQLException e) {
            LogUtil.error((String)"update schema refToId erro", (Throwable)e);
        }
    }

    @Override
    public void updateMapFullPathOfRefWithoutTx(String mapId, String fullPath) {
        try {
            List<String> outSideRefList = this.getSchemaDao().loadRefByRefToId(mapId, MapType.valueOf("Map").toPersistance());
            for (int i = 0; i < outSideRefList.size(); ++i) {
                String fId = outSideRefList.get(i);
                this.getSchemaDao().updateRefFullPath(fullPath, fId);
            }
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)"update schema refFullPath erro", (Throwable)e);
        }
        catch (SQLException e) {
            LogUtil.error((String)"update schema refFullPath erro", (Throwable)e);
        }
    }
}

