/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.subject;

import com.kingdee.bos.qing.behavior.BehaviorAssociate;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.data.exception.file.qs.QSFileNotFoundException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.DesigntimeMacro;
import com.kingdee.bos.qing.data.model.designtime.DmDynamicData;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.ModelDecoder;
import com.kingdee.bos.qing.data.model.runtime.process.FixProcesser;
import com.kingdee.bos.qing.data.model.vo.RecentUsedSources;
import com.kingdee.bos.qing.data.model.vo.Sources;
import com.kingdee.bos.qing.data.service.AbstractDesigntimeServiceImpl;
import com.kingdee.bos.qing.dbmanage.model.DBConnection;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.macro.domain.MacroCommonDomain;
import com.kingdee.bos.qing.macro.model.po.SQLMacroPO;
import com.kingdee.bos.qing.macro.model.vo.SQLMacro;
import com.kingdee.bos.qing.manage.domain.impl.SubjectManageDomain;
import com.kingdee.bos.qing.manage.handler.convertQSHandler.domain.ConvertQSHandleDomain;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.IScheduleEngineable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSubjectModelingService
extends AbstractDesigntimeServiceImpl
implements IDBAccessable,
IScheduleEngineable {
    protected IDBExcuter dbExcuter;
    protected ITransactionManagement tx;
    protected IScheduleEngine scheduleEngine;
    private SubjectManageDomain subjectManageDomain;

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setScheduleEngine(IScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    private SubjectManageDomain getSubjectManageDomain() {
        if (this.subjectManageDomain == null) {
            this.subjectManageDomain = new SubjectManageDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.subjectManageDomain;
    }

    @BehaviorAssociate(behavior=true)
    public byte[] saveModel(Map<String, String> params) {
        Box boxModel = (Box)ModelDecoder.decode((String)params.get("model"), Box.class);
        String themeID = params.get("themeID");
        try {
            Box box = this.getSubjectManageDomain().saveModel(themeID, boxModel);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)box);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] getFileSize(Map<String, String> params) {
        String fileUrl = params.get("fileUrl");
        try {
            int fileSize = this.getSubjectManageDomain().getFileSize(fileUrl);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)fileSize));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] downloadFile(Map<String, String> params) {
        String fileUrl = params.get("fileUrl");
        try {
            String filename = this.getSubjectManageDomain().downloadFile(fileUrl);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)filename));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] loadModel(Map<String, String> params) {
        String themeID = params.get("themeID");
        String userId = this.qingContext.getUserId();
        try {
            this.getSubjectManageDomain().checkThemeExist(themeID);
            Box box = this.getSubjectManageDomain().loadModel(userId, themeID);
            FixProcesser.fixBoxForDataModeling((QingContext)this.qingContext, (Box)box);
            DmDynamicData dmDynamicData = new DmDynamicData();
            dmDynamicData.setBoxModel(box);
            Set varTypes = this.qingContext.getSupportedSystemVarTypes();
            ArrayList<String> varTypeStringList = new ArrayList<String>(varTypes.size());
            for (SystemVarType varType : varTypes) {
                varTypeStringList.add(varType.name());
            }
            dmDynamicData.setSystemVarTypes(varTypeStringList);
            if (null != box) {
                Sources sources = new Sources();
                sources.setSources(box.getSources());
                List macroUids = box.collectMacroUid();
                if (macroUids.size() > 0) {
                    MacroCommonDomain macroDomain = new MacroCommonDomain(this.dbExcuter, this.qingContext);
                    List macroPOs = macroDomain.getDataModelDesignTimeMacro(macroUids);
                    ArrayList<DesigntimeMacro> designtimeMacros = new ArrayList<DesigntimeMacro>(10);
                    HashMap dbCenterSourcePermissionCache = new HashMap();
                    HashMap dbSourcePermissionCache = new HashMap();
                    for (SQLMacroPO macroPO : macroPOs) {
                        DesigntimeMacro designtimeMacro = new DesigntimeMacro();
                        SQLMacro sqlMacro = macroPO.toSQLMacro();
                        boolean usable = macroDomain.checkMacroAvailable(dbCenterSourcePermissionCache, dbSourcePermissionCache, sqlMacro.getDBInfo(), macroPO.getModifierId());
                        designtimeMacro.setUsable(usable);
                        designtimeMacro.setId(macroPO.getUid());
                        designtimeMacro.setName(macroPO.getName());
                        designtimeMacros.add(designtimeMacro);
                    }
                    dmDynamicData.setDesignTimeMacro(designtimeMacros);
                } else {
                    dmDynamicData.setDesignTimeMacro(new ArrayList(1));
                }
            }
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)dmDynamicData);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    private Set<String> getConnectionIds(List<DBConnection> dbConnections) {
        Iterator<DBConnection> iterator = dbConnections.iterator();
        HashSet<String> connIds = new HashSet<String>(16);
        while (iterator.hasNext()) {
            connIds.add(iterator.next().getId());
        }
        return connIds;
    }

    public byte[] loadUserRecentUsedSourceList(Map<String, String> params) {
        String userId = this.qingContext.getUserId();
        try {
            Sources needexcludeSources = (Sources)ModelDecoder.decode((String)params.get("needexcludeSources"), Sources.class);
            boolean showMoreFlag = Boolean.parseBoolean(params.get("needShowMoreFlag"));
            RecentUsedSources userRecentUsedSources = this.getSubjectManageDomain().loadUserRecentUsedSourceList(userId, needexcludeSources, showMoreFlag);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)userRecentUsedSources);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    protected Map<Entity, IQingFileVisitor> getQingFileVisitorMap(AbstractEntity abstractEntity, Sources sources) throws QSFileNotFoundException {
        try {
            return new ConvertQSHandleDomain(this.dbExcuter, this.tx, this.qingContext).getQingFileVisitorMap(abstractEntity, sources);
        }
        catch (Exception e) {
            throw new QSFileNotFoundException((Throwable)e);
        }
    }
}

