/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.subject.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.manage.domain.ThemeDomain;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.message.domain.AbstractMessageDomain;
import com.kingdee.bos.qing.message.model.po.MessagePO;
import com.kingdee.bos.qing.message.model.vo.AbstractMessageDetailVO;
import com.kingdee.bos.qing.schedule.model.ScheduleExecuteVO;
import com.kingdee.bos.qing.subject.model.PreparedateMessageVO;
import java.sql.SQLException;

public class DataExtractorMessageDomain
extends AbstractMessageDomain {
    private ThemeDomain themeDomain;

    public DataExtractorMessageDomain(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        super(qingContext, dbExcuter, tx);
    }

    private ThemeDomain getThemeDomain() {
        if (this.themeDomain == null) {
            this.themeDomain = new ThemeDomain(this.context, this.dbExcuter);
        }
        return this.themeDomain;
    }

    public AbstractMessageDetailVO queryMessageDetailById(MessagePO messagePO, String userId) throws AbstractQingIntegratedException, SQLException {
        PreparedateMessageVO messageVO = new PreparedateMessageVO();
        ScheduleExecuteVO scheduleExecuteVO = new ScheduleExecuteVO();
        ThemePO themePO = this.getThemeDomain().getThemeByID(messagePO.getBizId());
        if (themePO != null) {
            scheduleExecuteVO.setSourceName(themePO.getThemeName());
            scheduleExecuteVO.setSourceId(themePO.getThemeID());
            scheduleExecuteVO.setSourcePathName(themePO.getThemeGroupName() + "/" + themePO.getThemeName());
        }
        scheduleExecuteVO.setId(messagePO.getBizId());
        scheduleExecuteVO.setUserId(messagePO.getSenderId());
        scheduleExecuteVO.setExecuteState(Integer.parseInt(messagePO.getBizType()));
        scheduleExecuteVO.setExecuteTime(Long.valueOf(messagePO.getSendDate().getTime()));
        messageVO.setScheduleExecuteVO(scheduleExecuteVO);
        this.setBaseMessageVo(messageVO, messagePO, userId);
        return messageVO;
    }
}

