/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.qinganalysis.ui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kds.model.struct.embed.browser.jfx.KDWebViewPanel;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.cp.eip.sso.SSOHandleFacadeFactory;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.rpts.qinganalysis.js.QingAnalysisJSFacade;
import com.kingdee.eas.rpts.qinganalysis.js.handler.QingAnalysisExitFullScreenFunction;
import com.kingdee.eas.rpts.qinganalysis.js.handler.QingAnalysisFullScreenFunction;
import com.kingdee.eas.rpts.qinganalysis.js.handler.QingAnalysisMouseMoveFunction;
import com.kingdee.eas.rpts.qinganalysis.js.handler.QingAnalysisNewTabFunction;
import com.kingdee.eas.rpts.qinganalysis.ui.QingAnalysisComponentUtil;
import java.awt.BorderLayout;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class AbstractQingAnalysisCommonExplorer
extends CoreUI {
    private static final long serialVersionUID = 1L;
    protected QingAnalysisJSFacade jsFacade;
    private String url;
    private String ssoUrl;
    private String title;
    protected String idKey;
    public UIContext uiContext;
    public String closeUrl;
    public String logoutUrl;
    public String ssoLogoutUrl;
    public KDWebViewPanel browser;
    public boolean isManualLogout = false;

    public AbstractQingAnalysisCommonExplorer() throws Exception {
        QingAnalysisComponentUtil.loadComponent();
        String serverURL = this.getServerUrl();
        String url = serverURL.substring(0, serverURL.length() - ("portal".length() + 1));
        this.closeUrl = url + "/easweb/webviews/qinganalysis/error.html?type=closing&language=zh_CN";
        this.logoutUrl = url + "/portal/web_frame/uncheck/easrpc/logoutAndReleaseResource.action?ticked=true";
        this.ssoLogoutUrl = url + "/eassso/logout";
    }

    public UIContext getUIContext() {
        if (this.uiContext == null) {
            this.uiContext = new UIContext((Object)this);
            this.uiContext.putAll(super.getUIContext());
        }
        return this.uiContext;
    }

    public void onLoad() throws Exception {
        this.init();
    }

    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
    }

    public void load(String url) {
        this.browser.load(url);
    }

    public void initUIContentLayout() {
        this.browser = new KDWebViewPanel("", p -> {
            this.jsFacade = new QingAnalysisJSFacade(this.browser);
            this.jsFacade.registerFunction(new QingAnalysisNewTabFunction(this.uiContext), true);
            this.jsFacade.registerFunction(new QingAnalysisFullScreenFunction(this.uiContext), true);
            this.jsFacade.registerFunction(new QingAnalysisExitFullScreenFunction(), true);
            this.jsFacade.registerFunction(new QingAnalysisMouseMoveFunction(), true);
        });
        this.browser.setFromQing(true);
        this.setLayout(new BorderLayout());
        this.add(this.browser.getMainComponent());
    }

    public void init() throws BOSException, UnsupportedEncodingException {
        this.title = (String)this.uiContext.get((Object)"qingAnalysisTitle");
        this.idKey = (String)this.uiContext.get((Object)"qingAnalysisId");
        String context_url = (String)this.uiContext.get((Object)"qingAnalysisUrl");
        this.initUrl(context_url);
    }

    public void initUrl(String url) throws BOSException, UnsupportedEncodingException {
        String serverURL = this.getServerUrl();
        SysContext ctx = SysContext.getSysContext();
        String orgId = ctx.getCurrentOrgUnit().get("id").toString();
        String changeToSSOUrl = SSOHandleFacadeFactory.getRemoteInstance().getGUItoPortalUrl(URLEncoder.encode(url, "utf-8") + "&curOrgId=" + URLEncoder.encode(orgId, "utf-8"), true, ctx.getLocale().toString(), ctx.getDCNumber());
        this.ssoUrl = serverURL + "/" + changeToSSOUrl;
        serverURL = serverURL.substring(0, serverURL.indexOf("/portal"));
        this.url = serverURL + url;
        if (QingAnalysisComponentUtil.isNeedSSO) {
            this.url = this.ssoUrl;
        }
    }

    private String getServerUrl() {
        String serverURL = System.getProperty("EASPORTAL_ROOT");
        String isHttps = System.getProperty("EAS_SERVER");
        if (StringUtil.isEmptyString((String)serverURL)) {
            serverURL = "http://localhost:6888/portal";
        }
        if (!serverURL.startsWith("https") && null != isHttps && isHttps.startsWith("https")) {
            StringBuilder sb = new StringBuilder();
            String[] urlArr = serverURL.split("://");
            serverURL = sb.append(urlArr[0]).append('s').append("://").append(urlArr[1]).toString();
        }
        if (serverURL.indexOf("easportal") != -1) {
            serverURL = serverURL.replace("easportal", "portal");
        }
        return serverURL;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.browser.load(this.url);
    }

    public boolean destroyWindow() {
        if (QingAnalysisComponentUtil.isAllClose()) {
            QingAnalysisComponentUtil.isNeedSSO = true;
            this.isManualLogout = true;
            this.browser.load(this.ssoLogoutUrl);
            this.browser.load(this.logoutUrl);
        }
        return super.destroyWindow();
    }

    public String getUITitle() {
        return this.title;
    }
}

