/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.explorer.common.server;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.explorer.manage.exception.ExistSourceException;
import com.kingdee.bos.ctrl.explorer.manage.exception.NotExitSourceException;
import com.kingdee.bos.ctrl.explorer.model.ILightSource;
import com.kingdee.bos.ctrl.explorer.model.LightSource;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ExtManageAccess {
    public static final Logger log = LogUtil.getPackageLogger(ExtManageAccess.class);
    public static final String TABLE_FILE_INFO = "T_EXT_ExplorerInfo";
    public static final String TABLE_USER = "T_PM_USER";
    public static final int BLOCK_SIZE = 32768;

    public static boolean checkIdExist(String id) throws SQLException {
        return DbUtil.checkExist(TABLE_FILE_INFO, "FID", id);
    }

    public static boolean checkExist(String name, String path, String orgID, String ID) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from ");
        sql.append(TABLE_FILE_INFO);
        sql.append(" where FName ='");
        sql.append(name);
        sql.append("' and FPath ='");
        sql.append(path);
        sql.append("' and FOrgID ='");
        sql.append(orgID);
        if (ID != null) {
            sql.append("' and FID <>'");
            sql.append(ID);
        }
        sql.append("'");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql.toString()));
        }
        IRowSet rs = DbUtil.executeQuery(sql.toString(), null);
        return rs.next();
    }

    public static String getUerName(String uerID) throws SQLException {
        Context context = ServerUtil.getContext();
        String language = context.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append("FNAME_" + language).append(" from ");
        sql.append(TABLE_USER);
        sql.append(" where FID ='");
        sql.append(uerID);
        sql.append("'");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql.toString()));
        }
        IRowSet rs = DbUtil.executeQuery(sql.toString(), null);
        String uerName = null;
        while (rs.next()) {
            uerName = rs.getString(1);
        }
        return uerName;
    }

    public static List getLightGroupSource(String[] group) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_EXT_ExplorerInfo");
        ArrayList<ILightSource> result = new ArrayList<ILightSource>();
        String groups = "";
        for (int i = 0; i < group.length; ++i) {
            groups = groups + "'" + group[i] + "'";
            if (i == group.length - 1) continue;
            groups = groups + ",";
        }
        sql.append(" where FGroup in (" + groups + ")");
        sql.append(" and FName <>'ClxOwe88SRAMeb0P'");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql.toString()));
        }
        IRowSet rs = DbUtil.executeQuery(sql.toString(), null);
        while (rs.next()) {
            result.add(ExtManageAccess.createLightSource(rs));
        }
        return result;
    }

    public static List getLightOrgSource(String orgID) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_EXT_ExplorerInfo");
        ArrayList<ILightSource> result = new ArrayList<ILightSource>();
        sql.append(" where FOrgID ='" + orgID + "'");
        sql.append(" and FName <>'ClxOwe88SRAMeb0P'");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql.toString()));
        }
        IRowSet rs = DbUtil.executeQuery(sql.toString(), null);
        while (rs.next()) {
            result.add(ExtManageAccess.createLightSource(rs));
        }
        return result;
    }

    public static List getPathSource(String path, String orgID) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_EXT_ExplorerInfo");
        sql.append(" where FPath ='" + path + "'");
        sql.append(" and FOrgID ='" + orgID + "'");
        sql.append(" and FName <>'ClxOwe88SRAMeb0P'");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql.toString()));
        }
        IRowSet rs = DbUtil.executeQuery(sql.toString(), null);
        ArrayList<ILightSource> result = new ArrayList<ILightSource>();
        while (rs.next()) {
            result.add(ExtManageAccess.createLightSource(rs));
        }
        return result;
    }

    public static List getFullPathSource(String path, String orgID) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_EXT_ExplorerInfo");
        sql.append(" where FPath like '" + path + "%'");
        sql.append(" and FOrgID ='" + orgID + "'");
        sql.append(" and FName <>'ClxOwe88SRAMeb0P'");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql.toString()));
        }
        IRowSet rs = DbUtil.executeQuery(sql.toString(), null);
        ArrayList<ILightSource> result = new ArrayList<ILightSource>();
        while (rs.next()) {
            result.add(ExtManageAccess.createLightSource(rs));
        }
        return result;
    }

    public static ILightSource getLightSource(String id) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_EXT_ExplorerInfo");
        sql.append(" where FID ='" + id + "'");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql.toString()));
        }
        IRowSet rs = DbUtil.executeQuery(sql.toString(), null);
        return ExtManageAccess.createLightSource(rs);
    }

    public static void saveSource(ILightSource source) throws ExistSourceException, SQLException {
        if (ExtManageAccess.checkIdExist(source.getID())) {
            throw new ExistSourceException("id: " + source.getID() + " exit");
        }
        if (ExtManageAccess.checkExist(source.getName(), source.getPath(), source.getOrg(), null)) {
            throw new ExistSourceException(source.getName(), source.getPath());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_EXT_ExplorerInfo");
        sql.append("(FBreviary, FUserID, FCreateTime, FWidth, FHeight, FOrgID, FName, FPath, FSize, FType, FID )");
        sql.append(" values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        Object[] ps = ExtManageAccess.createLightObject(source);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql.toString()));
        }
        DbUtil.executeUpdate(sql.toString(), ps);
    }

    public static void createFlolderSource(ILightSource source) throws ExistSourceException, SQLException {
        if (ExtManageAccess.checkIdExist(source.getID())) {
            throw new ExistSourceException("id: " + source.getID() + " exit");
        }
        if (ExtManageAccess.checkExist(source.getName(), source.getPath(), source.getOrg(), null)) {
            throw new ExistSourceException(source.getName(), source.getPath());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_EXT_ExplorerInfo");
        sql.append("(FUserID, FCreateTime, FWidth, FHeight, FOrgID, FName, FPath, FSize, FType, FID )");
        sql.append(" values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        Object[] ps = ExtManageAccess.createFloderObject(source);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql.toString()));
        }
        DbUtil.executeUpdate(sql.toString(), ps);
    }

    public static void updateSource(ILightSource source) throws NotExitSourceException, SQLException, ExistSourceException {
        if (!ExtManageAccess.checkIdExist(source.getID())) {
            throw new NotExitSourceException("id: " + source.getID() + " not exit");
        }
        if (ExtManageAccess.checkExist(source.getName(), source.getPath(), source.getOrg(), source.getID())) {
            throw new ExistSourceException(source.getName(), source.getPath());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_EXT_ExplorerInfo");
        sql.append(" set FBreviary=?, FUserID=?, FCreateTime=?, FWidth=?, FHeight=?, FOrgID=?, FName=?, FPath=?, FSize=?, FType=?");
        sql.append(" where FID=?");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql.toString()));
        }
        DbUtil.executeUpdate(sql.toString(), ExtManageAccess.createLightObject(source));
    }

    public static void updataPath(String oldPath, String newPath, String ordID) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_EXT_ExplorerInfo");
        sql.append(" set FPath =");
        sql.append("replace(FPath, '").append(oldPath).append("' , '").append(newPath).append("')");
        sql.append(" where FPath like '").append(oldPath).append("%'");
        sql.append(" and FOrgID ='").append(ordID).append("'");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql.toString()));
        }
        DbUtil.executeUpdate(sql.toString(), null);
    }

    public static byte[] getBreviary(String id) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FBreviary from ");
        sql.append(TABLE_FILE_INFO);
        sql.append(" where FID ='");
        sql.append(id);
        sql.append("'");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will exec:" + sql.toString()));
        }
        IRowSet rs = DbUtil.executeQuery(sql.toString(), null);
        Blob blob = null;
        while (rs.next()) {
            try {
                blob = rs.getBlob("FBreviary");
            }
            catch (SQLException e) {
                return rs.getBytes("FBreviary");
            }
        }
        return ExtManageAccess.blob2byte(blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] blob2byte(Blob blob) throws SQLException {
        byte[] binarys = new byte[]{};
        if (blob != null) {
            InputStream is = null;
            ByteArrayOutputStream baos = null;
            try {
                is = blob.getBinaryStream();
                baos = new ByteArrayOutputStream();
                int len = 0;
                byte[] c = new byte[16384];
                while ((len = is.read(c, 0, c.length)) != -1) {
                    baos.write(c, 0, len);
                }
                baos.flush();
                binarys = baos.toByteArray();
            }
            catch (IOException iOException) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                    is = null;
                }
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                    baos = null;
                }
            }
        }
        return binarys;
    }

    public static ILightSource createLightSource(IRowSet rs) throws SQLException {
        LightSource source = new LightSource();
        source.setID(rs.getString("FID"));
        source.setCreator(ExtManageAccess.getUerName(rs.getString("FUserID")));
        source.setCreteTime(rs.getDate("FCreateTime"));
        source.setWidth(rs.getInt("FWidth"));
        source.setHeight(rs.getInt("FHeight"));
        source.setOrg(rs.getString("FOrgID"));
        source.setName(rs.getString("FName"));
        source.setPath(rs.getString("FPath"));
        source.setSize(rs.getInt("FSize"));
        source.setType(rs.getInt("FType"));
        return source;
    }

    public static Object[] createLightObject(ILightSource source) {
        Object[] obj = new Object[11];
        int i = 0;
        obj[i] = source.getBreviary();
        obj[++i] = source.getCreatorID();
        obj[++i] = source.getCreateTime();
        obj[++i] = new Integer(source.getWidth());
        obj[++i] = new Integer(source.getHeight());
        obj[++i] = source.getOrg();
        obj[++i] = source.getName();
        obj[++i] = source.getPath();
        obj[++i] = new Integer(source.getSize());
        obj[++i] = new Integer(source.getType());
        obj[++i] = source.getID();
        return obj;
    }

    public static Object[] createFloderObject(ILightSource source) {
        Object[] obj = new Object[10];
        int i = 0;
        obj[i] = source.getCreatorID();
        obj[++i] = source.getCreateTime();
        obj[++i] = new Integer(source.getWidth());
        obj[++i] = new Integer(source.getHeight());
        obj[++i] = source.getOrg();
        obj[++i] = source.getName();
        obj[++i] = source.getPath();
        obj[++i] = new Integer(source.getSize());
        obj[++i] = new Integer(source.getType());
        obj[++i] = source.getID();
        return obj;
    }
}

