/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.server;

import com.kingdee.bos.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.ctrl.semantic.common.Util;
import com.kingdee.bos.ctrl.semantic.design.exception.ConflictException;
import com.kingdee.bos.ctrl.semantic.design.exception.ExistException;
import com.kingdee.bos.ctrl.semantic.design.exception.LockedException;
import com.kingdee.bos.ctrl.semantic.design.exception.NotExistException;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.design.server.UserActiveMark;
import com.kingdee.bos.ctrl.semantic.model.trans.HeavyContent;
import com.kingdee.bos.ctrl.semantic.model.trans.InfoWrapper;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.semantic.model.trans.kicker.KickerModel;
import com.kingdee.eas.rpts.ctrlreport.bo.ExtReportOutDBBO;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SchemaDesigntimeState {
    private static final Logger log = LogUtil.getPackageLogger(SchemaDesigntimeState.class);
    private String _schemaId;
    private DataCenterInfo _outDcInfo;
    private Map _schemaEditRegister = new HashMap();
    private Map _locks = new HashMap();
    private Map _cache;
    private String _importLock;

    public SchemaDesigntimeState(String schemaId, String outDbName) throws SemanticDesignException {
        this._schemaId = schemaId;
        try {
            this.setOutDcInfo(outDbName);
        }
        catch (ExtReportOutDBBO.OutDbNotFoundException ex) {
            log.error((Object)("OutDb not found: " + outDbName));
        }
    }

    public String getSchemaId() {
        return this._schemaId;
    }

    public synchronized void setImportLock(String user) {
        this._importLock = user;
    }

    public synchronized void setImportUnlock(String user) {
        if (StringUtil.equalsIgnoreCase((String)this._importLock, (String)user)) {
            this._importLock = null;
        }
    }

    public synchronized boolean isImportLock(String user) {
        if (StringUtil.equalsIgnoreCase((String)this._importLock, (String)user)) {
            return false;
        }
        return this.isImportLock();
    }

    public synchronized boolean isImportLock() {
        return this._importLock != null;
    }

    public synchronized DataCenterInfo getOutDcInfo() {
        return this._outDcInfo;
    }

    public synchronized void setOutDcInfo(String outDbName) throws SemanticDesignException, ExtReportOutDBBO.OutDbNotFoundException {
        if (StringUtil.isEmptyString((String)outDbName)) {
            this._outDcInfo = null;
        } else {
            try {
                this._outDcInfo = ExtReportOutDBBO.getDataCenterFromCache(ServerUtil.getContext(), outDbName);
            }
            catch (ExtReportOutDBBO.OutDbNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw SemanticDesignException.wrap(ex);
            }
        }
    }

    public synchronized boolean registerEdit(String user) throws LockedException {
        return this.innerRegisterEdit(user, false);
    }

    private boolean innerRegisterEdit(String user, boolean innerCall) throws LockedException {
        if (!innerCall && this.isImportLock()) {
            throw new LockedException("Schema is imported.", this._importLock);
        }
        UserActiveMark reg = (UserActiveMark)this._schemaEditRegister.get(user);
        if (reg == null) {
            reg = new UserActiveMark(user);
            this._schemaEditRegister.put(user, reg);
            return true;
        }
        reg.keepAlive();
        return false;
    }

    public synchronized void unregisterEdit(String user) {
        this._schemaEditRegister.remove(user);
        Iterator it = this._locks.values().iterator();
        while (it.hasNext()) {
            UserActiveMark reg = (UserActiveMark)it.next();
            if (!reg.isSameUser(user)) continue;
            it.remove();
        }
    }

    public synchronized List getAllEditRegister(String schemaName) {
        long current = System.currentTimeMillis();
        ArrayList<KickerModel> result = new ArrayList<KickerModel>(this._schemaEditRegister.size());
        for (UserActiveMark reg : this._schemaEditRegister.values()) {
            result.add(new KickerModel(this._schemaId, schemaName, reg.getUser(), current - reg.getLastActiveTime()));
        }
        return result;
    }

    public synchronized List getAllEntityLock(String schemaName) throws SemanticDesignException {
        long current = System.currentTimeMillis();
        ArrayList<KickerModel> result = new ArrayList<KickerModel>(this._locks.size());
        for (String entityId : this._locks.keySet()) {
            UserActiveMark lock = (UserActiveMark)this._locks.get(entityId);
            LazyInfo info = (LazyInfo)this.getCache().get(entityId);
            result.add(new KickerModel(this._schemaId, schemaName, entityId, info == null ? null : info.getLogicalName(), info == null ? null : info.getPath(), lock.getUser(), current - lock.getLastActiveTime()));
        }
        return result;
    }

    public synchronized boolean isBusy() {
        return this._schemaEditRegister.size() > 0;
    }

    private void lockEntity(String entityId) throws LockedException {
        String user = ServerUtil.getUserName();
        this.innerRegisterEdit(user, true);
        UserActiveMark reg = (UserActiveMark)this._locks.get(entityId);
        if (reg == null) {
            this._locks.put(entityId, new UserActiveMark(user));
        } else if (reg.isSameUser(user)) {
            reg.keepAlive();
        } else {
            throw new LockedException(entityId + " is Locked.", reg.getUser());
        }
    }

    private boolean checkLocked(String entityId, String user) {
        return this._locks.containsKey(entityId) && !((UserActiveMark)this._locks.get(entityId)).isSameUser(user);
    }

    public synchronized boolean isSelfLocked(String entityId) {
        return this._locks.containsKey(entityId) && ((UserActiveMark)this._locks.get(entityId)).isSameUser(ServerUtil.getUserName());
    }

    public synchronized void unlockEntity(String entityId, String user) {
        UserActiveMark reg;
        if (StringUtil.isEmptyString((String)user)) {
            user = ServerUtil.getUserName();
        }
        if ((reg = (UserActiveMark)this._locks.get(entityId)) != null && reg.isSameUser(user)) {
            this._locks.remove(entityId);
        }
    }

    public synchronized boolean autoKickIdler(int period) {
        long current = System.currentTimeMillis();
        Iterator it = this._schemaEditRegister.values().iterator();
        while (it.hasNext()) {
            UserActiveMark reg = (UserActiveMark)it.next();
            if (current - reg.getLastActiveTime() <= (long)period) continue;
            it.remove();
        }
        it = this._locks.values().iterator();
        while (it.hasNext()) {
            UserActiveMark lock = (UserActiveMark)it.next();
            if (current - lock.getLastActiveTime() <= (long)period) continue;
            it.remove();
        }
        return this._schemaEditRegister.isEmpty() && this._locks.isEmpty();
    }

    public synchronized boolean clearCache() {
        this._cache = null;
        return true;
    }

    private Map getCache() throws SemanticDesignException {
        if (this._cache == null) {
            this.initCache();
        }
        return this._cache;
    }

    public synchronized Map getPNameMap() throws SemanticDesignException {
        Map cache = this.getCache();
        HashMap<String, LazyInfo> result = new HashMap<String, LazyInfo>(cache.size());
        for (LazyInfo tempInfo : cache.values()) {
            result.put(tempInfo.getPhysicalName().toUpperCase(), tempInfo);
        }
        return result;
    }

    private boolean checkIdExist(String entityId) throws SemanticDesignException {
        return this.getCache().containsKey(entityId);
    }

    private void checkNameExist(LazyInfo info) throws SemanticDesignException {
        Map cache = this.getCache();
        for (LazyInfo tempInfo : cache.values()) {
            if (tempInfo.getId().equals(info.getId())) continue;
            if (info.getPhysicalName().equalsIgnoreCase(tempInfo.getPhysicalName())) {
                throw new ExistException(info.getPhysicalName(), 1);
            }
            if (!info.getLogicalName().equalsIgnoreCase(tempInfo.getLogicalName())) continue;
            throw new ExistException(info.getLogicalName(), 2);
        }
    }

    public synchronized LazyInfo[] getSubTree(String path) throws SemanticDesignException {
        String user = ServerUtil.getUserName();
        ArrayList<LazyInfo> result = new ArrayList<LazyInfo>(this.getCache().size());
        for (LazyInfo info : this.getCache().values()) {
            String p = info.getPath();
            if (!Util.isSubPath(path, p)) continue;
            info.setLocked(this.checkLocked(info.getId(), user));
            result.add(info);
        }
        return result.toArray(new LazyInfo[0]);
    }

    private void initCache() throws SemanticDesignException {
        this._cache = new HashMap();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FPath, FPysicalName, FLogicalName, FType, FStandard");
        sql.append(" from T_EXT_SemanticEntity");
        sql.append(" where FSchemaID=?");
        try {
            IRowSet rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{this._schemaId});
            this.initEntity(rowSet);
        }
        catch (SQLException ex) {
            this._cache = null;
            throw SemanticDesignException.wrap(ex);
        }
    }

    private void reloadEntity(String entityId) throws SemanticDesignException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FPath, FPysicalName, FLogicalName, FType, FStandard");
        sql.append(" from T_EXT_SemanticEntity");
        sql.append(" where FID=?");
        try {
            IRowSet rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{entityId});
            this.initEntity(rowSet);
        }
        catch (SQLException ex) {
            throw SemanticDesignException.wrap(ex);
        }
    }

    private void initEntity(IRowSet rowSet) throws SQLException {
        while (rowSet.next()) {
            String id = rowSet.getString("FID");
            LazyInfo info = new LazyInfo();
            info.setId(id);
            info.setPath(rowSet.getString("FPath"));
            info.setPhysicalName(rowSet.getString("FPysicalName"));
            info.setLogicalName(rowSet.getString("FLogicalName"));
            info.setType(rowSet.getInt("FType"));
            info.setStandard(rowSet.getDate("FStandard") != null);
            info.setStandardStamp(ServerUtil.formatDate(rowSet.getDate("FStandard")));
            this._cache.put(id, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveEntities(LazyInfo[] infos, String[] newPaths, boolean isUpdateStamp) throws SemanticDesignException {
        LazyInfo info;
        int i;
        Connection conn = null;
        try {
            conn = DbUtil.getConnection();
            conn.setAutoCommit(false);
            for (i = 0; i < infos.length; ++i) {
                info = infos[i];
                if (!this.checkIdExist(info.getId())) {
                    throw new NotExistException("The entity " + info.getId() + " not exist.");
                }
                LazyInfo serverInfo = (LazyInfo)this.getCache().get(info.getId());
                this.checkConfict(info, serverInfo);
                boolean isSelfLocked = this.isSelfLocked(info.getId());
                if (!isSelfLocked) {
                    this.lockEntity(info.getId());
                }
                info.setPath(newPaths[i]);
                try {
                    this.modifyEntityPath(conn, info, isUpdateStamp);
                    continue;
                }
                finally {
                    if (!isSelfLocked) {
                        this.unlockEntity(info.getId(), null);
                    }
                }
            }
            conn.commit();
        }
        catch (SemanticDesignException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw SemanticDesignException.wrap(ex);
        }
        finally {
            DbUtil.closeConnection(conn);
        }
        for (i = 0; i < infos.length; ++i) {
            info = infos[i];
            this.getCache().put(info.getId(), info);
        }
        this.syncSchemaLastUpdate();
    }

    public synchronized LazyInfo[] saveEntity(LazyInfo info, HeavyContent heavyContent) throws SemanticDesignException {
        return this.saveEntity(info, heavyContent, true);
    }

    public synchronized LazyInfo[] saveEntity(LazyInfo info, HeavyContent heavyContent, boolean isUpdateStamp) throws SemanticDesignException {
        this.checkNameExist(info);
        Connection conn = null;
        try {
            boolean isNew;
            conn = DbUtil.getConnection();
            conn.setAutoCommit(false);
            boolean bl = isNew = StringUtil.isEmptyString((String)info.getId()) || Boolean.TRUE.equals(info.getProperty("isNew"));
            if (isNew) {
                String id = this.createEntity(conn, info, heavyContent, isUpdateStamp);
                info.setId(id);
                this.lockEntity(info.getId());
            } else {
                if (!this.checkIdExist(info.getId())) {
                    throw new NotExistException("The entity " + info.getId() + " not exist.");
                }
                this.lockEntity(info.getId());
                this.modifyEntity(conn, info, heavyContent, isUpdateStamp);
            }
            this.saveRelations(conn, info.getId(), heavyContent);
            conn.commit();
        }
        catch (SemanticDesignException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw SemanticDesignException.wrap(ex);
        }
        finally {
            DbUtil.closeConnection(conn);
        }
        this.getCache().put(info.getId(), info);
        info.setContent(heavyContent);
        this.syncSchemaLastUpdate();
        return new LazyInfo[]{info};
    }

    private void saveRelations(Connection conn, String clientId, HeavyContent heavyContent) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_EXT_SemanticRelation");
        sql.append(" where FClientEntityID=?");
        DbUtil.executeUpdate(conn, sql.toString(), new Object[]{clientId});
        int c = heavyContent.getRelationContentCount();
        for (int i = 0; i < c; ++i) {
            HeavyContent.RelationContent rc = heavyContent.getRelationContent(i);
            sql = new StringBuffer();
            sql.append("insert into T_EXT_SemanticRelation (");
            sql.append("FClientEntityID, FSupplierEntityID, FContent");
            sql.append(") values (");
            sql.append("?, ?, ?");
            sql.append(")");
            DbUtil.executeUpdate(conn, sql.toString(), new Object[]{clientId, rc.getSupplierId(), rc.getXml()});
        }
    }

    private void modifyEntityPath(Connection conn, LazyInfo info, boolean isUpdateStamp) throws SQLException {
        Object[] ps;
        boolean isStandard = info.isStandard();
        StringBuffer sql = new StringBuffer();
        sql.append("update T_EXT_SemanticEntity set");
        sql.append(" FPath=?");
        if (isStandard && isUpdateStamp) {
            sql.append(",FStandard=?");
        }
        sql.append(" where FID=?");
        if (isStandard && isUpdateStamp) {
            String date = ServerUtil.getCurrentDate();
            Timestamp ts = Timestamp.valueOf(date);
            ps = new Object[]{info.getPath(), ts, info.getId()};
            info.setStandardStamp(date);
        } else {
            ps = new Object[]{info.getPath(), info.getId()};
        }
        DbUtil.executeUpdate(conn, sql.toString(), ps);
    }

    private void modifyEntity(Connection conn, LazyInfo info, HeavyContent heavyContent, boolean isUpdateStamp) throws SQLException {
        Object[] ps;
        boolean isStandard = info.isStandard();
        StringBuffer sql = new StringBuffer();
        sql.append("update T_EXT_SemanticEntity set");
        sql.append(" FPath=?");
        sql.append(",FPysicalName=?");
        sql.append(",FLogicalName=?");
        sql.append(",FContent=?");
        if (isStandard && isUpdateStamp) {
            sql.append(",FStandard=?");
        }
        sql.append(" where FID=?");
        if (isStandard && isUpdateStamp) {
            String date = ServerUtil.getCurrentDate();
            Timestamp ts = Timestamp.valueOf(date);
            ps = new Object[]{info.getPath(), info.getPhysicalName(), info.getLogicalName(), heavyContent.getXml(), ts, info.getId()};
            info.setStandardStamp(date);
        } else {
            ps = new Object[]{info.getPath(), info.getPhysicalName(), info.getLogicalName(), heavyContent.getXml(), info.getId()};
        }
        DbUtil.executeUpdate(conn, sql.toString(), ps);
    }

    private String createEntity(Connection conn, LazyInfo info, HeavyContent heavyContent, boolean isUpdateStamp) throws SQLException {
        Object[] ps;
        info.putProperty("isNew", null);
        boolean isStandard = info.isStandard();
        String uid = info.getId();
        if (uid == null) {
            uid = UID.create16();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_EXT_SemanticEntity (");
        sql.append("FID, FSchemaID, FPath, FPysicalName");
        sql.append(", FLogicalName, FType, FContent");
        if (isStandard) {
            sql.append(", FStandard");
        }
        sql.append(") values (");
        sql.append("?, ?, ?, ?, ?, ?, ?");
        if (isStandard) {
            sql.append(", ?");
        }
        sql.append(")");
        String path = info.getPath();
        String phyName = info.getPhysicalName();
        String logName = info.getLogicalName();
        Integer type = new Integer(info.getType());
        if (isStandard) {
            String date = info.getStandardStamp();
            if (isUpdateStamp || StringUtil.isEmptyString((String)date)) {
                date = ServerUtil.getCurrentDate();
                info.setStandardStamp(date);
            }
            Timestamp ts = Timestamp.valueOf(date);
            ps = new Object[]{uid, this._schemaId, path, phyName, logName, type, heavyContent.getXml(), ts};
        } else {
            ps = new Object[]{uid, this._schemaId, path, phyName, logName, type, heavyContent.getXml()};
        }
        DbUtil.executeUpdate(conn, sql.toString(), ps);
        return uid;
    }

    public synchronized InfoWrapper loadEntity(LazyInfo info, boolean isWithSuppliers, boolean isEdit) throws SemanticDesignException {
        HeavyContent heavyContent;
        String entityId = info.getId();
        if (!this.checkIdExist(entityId)) {
            throw new NotExistException("The entity " + entityId + " not exist.");
        }
        if (isEdit) {
            this.lockEntity(entityId);
        }
        Map mapSuppliers = null;
        try {
            LazyInfo clientInfo = info;
            info = (LazyInfo)this.getCache().get(entityId);
            this.checkConfict(clientInfo, info);
            info.setLocked(false);
            heavyContent = info.getContent();
            if (heavyContent == null) {
                heavyContent = this.loadHeavyContent(entityId);
                info.setContent(heavyContent);
            }
            if (isWithSuppliers) {
                mapSuppliers = this.loadSuppliers(heavyContent);
            }
        }
        catch (SemanticDesignException ex) {
            if (isEdit) {
                this.unlockEntity(entityId, ServerUtil.getUserName());
            }
            throw ex;
        }
        return new InfoWrapper(info, heavyContent, mapSuppliers);
    }

    private Map loadSuppliers(HeavyContent heavyContent) throws SemanticDesignException {
        HashMap<String, InfoWrapper> mapSuppliers = null;
        int c = heavyContent.getRelationContentCount();
        for (int i = 0; i < c; ++i) {
            if (mapSuppliers == null) {
                mapSuppliers = new HashMap<String, InfoWrapper>();
            }
            String supplierId = heavyContent.getRelationContent(i).getSupplierId();
            LazyInfo supplierInfo = (LazyInfo)this.getCache().get(supplierId);
            if (supplierInfo == null) continue;
            HeavyContent hc = supplierInfo.getContent();
            if (hc == null) {
                hc = this.loadHeavyContent(supplierId);
                supplierInfo.setContent(hc);
            }
            mapSuppliers.put(supplierId, new InfoWrapper(supplierInfo, hc, null));
        }
        return mapSuppliers;
    }

    private HeavyContent loadHeavyContent(String entityId) throws SemanticDesignException {
        IRowSet rowSet;
        HeavyContent heavyContent = new HeavyContent();
        StringBuffer sql = new StringBuffer();
        sql.append("select FContent from T_EXT_SemanticEntity");
        sql.append(" where FID=?");
        try {
            rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{entityId});
            if (rowSet.next()) {
                heavyContent.setXml(rowSet.getString("FContent"));
            }
        }
        catch (SQLException ex) {
            throw SemanticDesignException.wrap(ex);
        }
        sql = new StringBuffer();
        sql.append("select FSupplierEntityID, FContent");
        sql.append(" from T_EXT_SemanticRelation");
        sql.append(" where FClientEntityID=?");
        try {
            rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{entityId});
            while (rowSet.next()) {
                heavyContent.addRelation(rowSet.getString("FSupplierEntityID"), rowSet.getString("FContent"));
            }
        }
        catch (SQLException ex) {
            throw SemanticDesignException.wrap(ex);
        }
        return heavyContent;
    }

    private void checkConfict(LazyInfo clientInfo, LazyInfo serverInfo) throws ConflictException {
        if (!StringUtil.equalsIgnoreCase((String)clientInfo.getLogicalName(), (String)serverInfo.getLogicalName())) {
            throw new ConflictException(clientInfo.getLogicalName() + " has renamed to " + serverInfo.getLogicalName());
        }
        if (!StringUtil.equalsIgnoreCase((String)clientInfo.getPhysicalName(), (String)serverInfo.getPhysicalName())) {
            throw new ConflictException(clientInfo.getLogicalName() + " 's physical name has been changed. " + clientInfo.getPhysicalName() + " -> " + serverInfo.getPhysicalName());
        }
        if (!StringUtil.equalsIgnoreCase((String)clientInfo.getPath(), (String)serverInfo.getPath())) {
            throw new ConflictException(clientInfo.getLogicalName() + " 's path has been changed. " + clientInfo.getPath() + " -> " + serverInfo.getPath());
        }
    }

    public synchronized LazyInfo[] deleteEntities(LazyInfo[] infos) throws SemanticDesignException {
        int i;
        int c;
        String user = ServerUtil.getUserName();
        int c2 = infos.length;
        for (int i2 = 0; i2 < c2; ++i2) {
            LazyInfo clientInfo = infos[i2];
            String entityId = clientInfo.getId();
            if (!this.checkIdExist(entityId)) {
                throw new NotExistException("The entity " + entityId + " not exist.");
            }
            LazyInfo serverInfo = (LazyInfo)this.getCache().get(entityId);
            this.checkConfict(clientInfo, serverInfo);
            if (!this.checkLocked(entityId, user)) continue;
            throw new LockedException(entityId + " is Locked.", ((UserActiveMark)this._locks.get(entityId)).getUser());
        }
        String sqlDelEntity = "delete from T_EXT_SemanticEntity where FID=?";
        String sqlDelRelation = "delete from T_EXT_SemanticRelation where FClientEntityID=?";
        String sqlDelBeRelatived = "delete from T_EXT_SemanticRelation where FSupplierEntityID=?";
        String sqlSyncBeRelatived = "select FClientEntityID from T_EXT_SemanticRelation where FSupplierEntityID=?";
        Connection conn = null;
        HashSet<String> beRelativeds = new HashSet<String>();
        try {
            conn = DbUtil.getConnection();
            conn.setAutoCommit(false);
            c = infos.length;
            for (i = 0; i < c; ++i) {
                Object[] p = new Object[]{infos[i].getId()};
                IRowSet rowSet = DbUtil.executeQuery(sqlSyncBeRelatived, p);
                while (rowSet.next()) {
                    beRelativeds.add(rowSet.getString("FClientEntityID"));
                }
                DbUtil.executeUpdate(sqlDelEntity, p);
                DbUtil.executeUpdate(sqlDelRelation, p);
                DbUtil.executeUpdate(sqlDelBeRelatived, p);
            }
            conn.commit();
        }
        catch (SQLException ex) {
            throw SemanticDesignException.wrap(ex);
        }
        finally {
            DbUtil.closeConnection(conn);
        }
        c = infos.length;
        for (i = 0; i < c; ++i) {
            this.getCache().remove(infos[i].getId());
        }
        for (String clientId : beRelativeds) {
            this.getCache().remove(clientId);
            this.reloadEntity(clientId);
        }
        this.syncSchemaLastUpdate();
        return null;
    }

    private void syncSchemaLastUpdate() throws SemanticDesignException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_EXT_SemanticSchema set");
        sql.append(" FLastUpdateUserID=?");
        sql.append(",FLastUpdateTime=?");
        sql.append(" where FID=?");
        try {
            DbUtil.executeUpdate(sql.toString(), new Object[]{ServerUtil.getContext().getCaller().toString(), Timestamp.valueOf(ServerUtil.getCurrentDate()), this._schemaId});
        }
        catch (SQLException ex) {
            throw SemanticDesignException.wrap(ex);
        }
    }
}

