/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.server;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.semantic.design.ISemanticDesignFacade;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.design.server.SemanticDesignFacade;
import com.kingdee.bos.ctrl.semantic.model.trans.HeavyContent;
import com.kingdee.bos.ctrl.semantic.model.trans.InfoWrapper;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.semantic.model.trans.checkin.BosCheckinModel;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import org.apache.log4j.Logger;

public class SemanticDesignFacadeBridge
extends ORMObject
implements ISemanticDesignFacade {
    private static final Logger log = LogUtil.getPackageLogger(SemanticDesignFacadeBridge.class);
    private static final String SERVER_LOCATION = "CtrlExtSemantic";
    private ISemanticDesignFacade _facadeImpl;

    public SemanticDesignFacadeBridge() {
        this.registerInterface(ISemanticDesignFacade.class, this);
    }

    private String getORMRPCServerURL() {
        ORMServiceLocation loc = new ORMServiceLocation(SERVER_LOCATION);
        if (loc != null && !loc.isLocal()) {
            String url = loc.getServiceURL();
            log.info((Object)("CtrlExt Semantic designtime facade appoint to server: " + url));
            return url;
        }
        log.info((Object)"CtrlExt Semantic has no config about exceptional cluster.");
        return null;
    }

    private ISemanticDesignFacade getFacadeImpl() {
        if (this._facadeImpl == null) {
            String bosConfigAppointUrl = this.getORMRPCServerURL();
            if (StringUtil.isEmptyString((String)bosConfigAppointUrl)) {
                this._facadeImpl = new SemanticDesignFacade();
                log.info((Object)"CtrlExt Semantic designtime facade created a local impl.");
            } else {
                IORMModel bosObject = RPCEngineFactory.getEngine((String)bosConfigAppointUrl).createObject(SemanticDesignFacade.class.getName(), ISemanticDesignFacade.class);
                this._facadeImpl = (ISemanticDesignFacade)bosObject;
                log.info((Object)"CtrlExt Semantic designtime facade created a remote object.");
            }
        }
        return this._facadeImpl;
    }

    @Override
    public void lifeDetector() {
        this.getFacadeImpl().lifeDetector();
    }

    @Override
    public LazyInfo[] refreshTree(String schemaId, String path) throws SemanticDesignException {
        return this.getFacadeImpl().refreshTree(schemaId, path);
    }

    @Override
    public void unlockEntity(String schemaId, String entityId, String user) throws SemanticDesignException {
        this.getFacadeImpl().unlockEntity(schemaId, entityId, user);
    }

    @Override
    public InfoWrapper loadEntity(String schemaId, LazyInfo info, boolean isWithSuppliers) throws SemanticDesignException {
        return this.getFacadeImpl().loadEntity(schemaId, info, isWithSuppliers);
    }

    @Override
    public LazyInfo[] saveEntity(String schemaId, LazyInfo info, HeavyContent heavyContent, boolean isUpdateStamp) throws SemanticDesignException {
        return this.getFacadeImpl().saveEntity(schemaId, info, heavyContent, isUpdateStamp);
    }

    @Override
    public void moveEntities(String schemaId, LazyInfo[] infos, String[] newPaths, boolean isUpdateStamp) throws SemanticDesignException {
        this.getFacadeImpl().moveEntities(schemaId, infos, newPaths, isUpdateStamp);
    }

    @Override
    public LazyInfo[] deleteEntities(String schemaId, LazyInfo[] infos) throws SemanticDesignException {
        return this.getFacadeImpl().deleteEntities(schemaId, infos);
    }

    @Override
    public boolean clearCache(String schemaId) throws SemanticDesignException {
        return this.getFacadeImpl().clearCache(schemaId);
    }

    @Override
    public LazyInfo[] dbCheckinRefresh(String schemaId, int type, String filter) throws SemanticDesignException {
        return this.getFacadeImpl().dbCheckinRefresh(schemaId, type, filter);
    }

    @Override
    public void dbCheckin(String schemaId, LazyInfo[] infos) throws SemanticDesignException {
        this.getFacadeImpl().dbCheckin(schemaId, infos);
    }

    @Override
    public BosCheckinModel.Response[] bosMetaCheckin(String schemaId, BosCheckinModel.Request[] requests, BosCheckinModel.Preference preference) throws SemanticDesignException {
        return this.getFacadeImpl().bosMetaCheckin(schemaId, requests, preference);
    }
}

