/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.server.checkin.frombos;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.ctrl.semantic.design.exception.BosCheckinException;
import com.kingdee.bos.ctrl.semantic.design.exception.ExistException;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.design.server.SchemaDesigntimeState;
import com.kingdee.bos.ctrl.semantic.design.server.checkin.fromdb.DbCheckin;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticDataType;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticRelation;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticTable;
import com.kingdee.bos.ctrl.semantic.model.trans.HeavyContent;
import com.kingdee.bos.ctrl.semantic.model.trans.HeavyContentIO;
import com.kingdee.bos.ctrl.semantic.model.trans.InfoWrapper;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.semantic.model.trans.checkin.BosCheckinModel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BosEntityCheckin {
    private SchemaDesigntimeState _state;
    private Map _willAppend = new HashMap();
    private Map _existInfos;
    private BosCheckinModel.Preference _preferencs;

    public BosEntityCheckin(SchemaDesigntimeState state, Map pNameMap, BosCheckinModel.Preference prefernces) {
        this._state = state;
        this._existInfos = pNameMap;
        this._preferencs = prefernces;
    }

    public BosCheckinModel.Response[] checkin(BosCheckinModel.Request[] requests) throws SemanticDesignException {
        int i;
        int size = requests.length;
        BosCheckinModel.Response[] responses = new BosCheckinModel.Response[size];
        EntityObjectInfo[] bosEntities = new EntityObjectInfo[size];
        for (i = 0; i < size; ++i) {
            String strPk = requests[i].getPk();
            MetaDataPK pk = new MetaDataPK(strPk);
            EntityObjectInfo bosEntity = MetaDataLoader.getEntity((Context)ServerUtil.getContext(), (IMetaDataPK)pk);
            DataTableInfo tableInfo = (DataTableInfo)bosEntity.get("table");
            responses[i] = BosCheckinModel.Response.create(requests[i]);
            responses[i].setLName(bosEntity.getAlias() == null ? bosEntity.getName() : bosEntity.getAlias());
            if (tableInfo == null) {
                responses[i].setException(new BosCheckinException(1, strPk));
                continue;
            }
            String tableName = tableInfo.getName();
            responses[i].setPName(tableName);
            bosEntities[i] = bosEntity;
            SemanticTable table = new SemanticTable();
            table.setProperty("id", UID.create16());
            table.setPhysicalName(tableName);
            if (this._willAppend.containsKey(tableName)) {
                responses[i].setException(new BosCheckinException(2, strPk));
                continue;
            }
            this._willAppend.put(tableName, table);
        }
        for (i = 0; i < size; ++i) {
            if (responses[i].getException() != null) continue;
            EntityObjectInfo bosEntity = bosEntities[i];
            String tableName = responses[i].getPName();
            LazyInfo existInfo = (LazyInfo)this._existInfos.get(tableName.toUpperCase());
            try {
                if (existInfo == null) {
                    this.checkin_new(bosEntity, tableName, requests[i].getPath());
                    responses[i].setResultType(1);
                    continue;
                }
                responses[i].setResultType(2);
                if (this._preferencs.getExistPolicy() == 0) continue;
                if (existInfo.getType() == 2) {
                    responses[i].setResultType(4);
                    continue;
                }
                if (existInfo.isStandard() && !this._preferencs.isStandardMaker()) {
                    responses[i].setResultType(3);
                    continue;
                }
                existInfo.setStandard(this._preferencs.isStandardMaker());
                this.checkin_modify(existInfo, bosEntity);
                continue;
            }
            catch (SemanticDesignException ex) {
                responses[i].setException(ex);
                continue;
            }
            catch (Exception ex) {
                responses[i].setException(SemanticDesignException.wrap(ex));
            }
        }
        return responses;
    }

    private void checkin_new(EntityObjectInfo bosEntity, String tableName, String oriPath) throws SemanticDesignException {
        SemanticTable table = (SemanticTable)this._willAppend.get(tableName);
        this.updateTable(table, bosEntity, true);
        HeavyContent heavyContent = new HeavyContent();
        HeavyContentIO.save(table, heavyContent);
        LazyInfo info = new LazyInfo();
        info.setType(1);
        info.setStandard(this._preferencs.isStandardMaker());
        info.setLogicalName(table.getLogicalName());
        info.setPhysicalName(table.getPhysicalName());
        if (this._preferencs.getPathPolicy() == 1) {
            info.setPath(oriPath);
        } else {
            info.setPath(this._preferencs.getPath());
        }
        info.putProperty("isNew", Boolean.TRUE);
        info.setId((String)table.getProperty("id"));
        this.saveEntity(info, heavyContent);
        this._state.unlockEntity(info.getId(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkin_modify(LazyInfo existInfo, EntityObjectInfo bosEntity) throws SemanticDesignException {
        SemanticTable table = this.createTableFromInfo(existInfo);
        InfoWrapper wrapper = this._state.loadEntity(existInfo, true, false);
        HeavyContent heavyContent = wrapper.getContent();
        HeavyContentIO.load(heavyContent, table, wrapper.getSuppliers());
        this.updateTable(table, bosEntity, false);
        existInfo.setLogicalName(table.getLogicalName());
        HeavyContentIO.save(table, heavyContent);
        boolean isOriLocked = this._state.isSelfLocked(existInfo.getId());
        try {
            this.saveEntity(existInfo, heavyContent);
        }
        finally {
            if (!isOriLocked) {
                this._state.unlockEntity(existInfo.getId(), null);
            }
        }
    }

    private void saveEntity(LazyInfo info, HeavyContent heavyContent) throws SemanticDesignException {
        boolean reTry = true;
        String lName = info.getLogicalName();
        int postFix = 2;
        while (reTry) {
            try {
                this._state.saveEntity(info, heavyContent);
                reTry = false;
            }
            catch (ExistException ex) {
                if (ex.getType() == 2) {
                    info.setLogicalName(lName + postFix++);
                    continue;
                }
                throw ex;
            }
        }
    }

    private void updateTable(SemanticTable table, EntityObjectInfo bosEntity, boolean isNew) throws SemanticDesignException {
        if (isNew || this._preferencs.isContainsExistPolicy(1)) {
            String lName = bosEntity.getAlias();
            if (StringUtil.isEmptyString((String)lName)) {
                lName = bosEntity.getName();
            }
            table.setLogicalName(lName);
        }
        boolean isUFO = this._preferencs.isContainsExistPolicy(2);
        boolean isUFM = this._preferencs.isContainsExistPolicy(4);
        boolean isUpdateFields = isNew || isUFO || isUFM;
        boolean isURO = this._preferencs.isContainsExistPolicy(8);
        boolean isURM = this._preferencs.isContainsExistPolicy(16);
        boolean isUpdateRelations = isNew || isURO || isURM;
        ArrayList fields = new ArrayList();
        ArrayList relations = new ArrayList();
        if (isUpdateFields || isUpdateRelations) {
            this.searchPropertis(table, bosEntity, fields, new HashMap(), relations);
        }
        if (isUpdateFields) {
            if (isUFO) {
                table.removeFields();
            }
            int c = fields.size();
            for (int i = 0; i < c; ++i) {
                SemanticField field = (SemanticField)fields.get(i);
                if (isUFM) {
                    SemanticField existField = table.getField(field.getPhysicalName());
                    table.removeField(existField);
                }
                table.addField(field);
            }
        }
        if (isUpdateRelations) {
            int i;
            ArrayList<SemanticRelation> existRelations = new ArrayList<SemanticRelation>();
            if (isURO) {
                table.removeRelations();
            } else {
                for (int j = table.getRelationsCount() - 1; j >= 0; --j) {
                    existRelations.add(table.getRelation(j));
                }
            }
            int x = 10;
            int y = 10;
            int ySup = 0;
            int xSup = x + 120 + 150;
            int hSupWithGap = 100;
            int c = relations.size();
            for (i = 0; i < c; ++i) {
                SemanticRelation relation = (SemanticRelation)relations.get(i);
                if (isURM) {
                    for (int j = existRelations.size() - 1; j >= 0; --j) {
                        SemanticRelation existRelation = (SemanticRelation)existRelations.get(j);
                        if (!SemanticRelation.looseCompare(existRelation, relation)) continue;
                        table.removeRelation(existRelation);
                        existRelations.remove(j);
                        break;
                    }
                }
                ySup = y + i * hSupWithGap;
                relation.getSupplier().setProperty("rect", new Rectangle(xSup, ySup, 120, 80));
                table.addRelation(relation);
                if (isUpdateFields) continue;
                this.fixForeignKey(table, relation, fields);
            }
            for (i = 0; i < existRelations.size(); ++i) {
                SemanticRelation relation = (SemanticRelation)existRelations.get(i);
                relation.getSupplier().setProperty("rect", new Rectangle(xSup, ySup += hSupWithGap, 120, 80));
            }
            int calculateHeight = (table.getRelationsCount() - 1) * hSupWithGap - 2;
            int height = Math.max(calculateHeight, 180);
            table.setProperty("rect", new Rectangle(x, y, 120, height));
        }
    }

    private void fixForeignKey(SemanticTable table, SemanticRelation relation, List fields) {
        String clientField = ((SemanticRelation.JoinLine)relation.getCondition(0)).getClientField();
        if (table.getField(clientField) == null) {
            for (int i = fields.size() - 1; i >= 0; --i) {
                SemanticField f = (SemanticField)fields.get(i);
                if (!StringUtil.equalsIgnoreCase((String)f.getPhysicalName(), (String)clientField)) continue;
                table.addField(f);
                break;
            }
        }
    }

    private Set getLogicalKeys(EntityObjectInfo bosEntity) {
        HashSet<String> result = new HashSet<String>();
        if (bosEntity.getLogicalKey() != null) {
            PropertyCollection pc = bosEntity.getLogicalKey().getKeyPropertys();
            int c = pc.size();
            for (int i = 0; i < c; ++i) {
                ColumnInfo col = pc.get(i).getMappingField();
                if (col == null) continue;
                result.add(col.getName());
            }
        }
        return result;
    }

    private void searchPropertis(SemanticTable client, EntityObjectInfo bosEntity, List fields, Map mapFieldsName, List relations) throws SemanticDesignException {
        PropertyCollection pc;
        Set primaryKeys = this.getLogicalKeys(bosEntity);
        EntityObjectInfo parentEntity = (EntityObjectInfo)bosEntity.get("baseEntity");
        if (parentEntity != null) {
            this.searchPropertis(client, parentEntity, fields, mapFieldsName, relations);
        }
        if ((pc = (PropertyCollection)bosEntity.get("properties")) == null) {
            return;
        }
        int c = pc.size();
        for (int i = 0; i < c; ++i) {
            SemanticTable supplier;
            PropertyInfo p = pc.get(i);
            ColumnInfo col = p.getMappingField();
            if (col == null) continue;
            String name = col.getName();
            if (mapFieldsName.containsKey(name)) {
                SemanticField field = (SemanticField)mapFieldsName.remove(name);
                fields.remove(field);
            }
            if (p instanceof OwnPropertyInfo) {
                DataType type = ((OwnPropertyInfo)p).getDataType();
                SemanticField field = this.createField(p, type, primaryKeys);
                fields.add(field);
                mapFieldsName.put(name, field);
                continue;
            }
            if (!(p instanceof LinkPropertyInfo)) continue;
            boolean toThrow = this._preferencs.getErrorPolicy() == 0;
            LinkPropertyInfo lp = (LinkPropertyInfo)p;
            if (lp.getMappingField() == null) continue;
            RelationshipInfo bosRelation = lp.getRelationship();
            EntityObjectInfo clientBosEnty = bosRelation.getClientObject();
            PropertyInfo propClient = bosRelation.getClientProperty();
            EntityObjectInfo supplierBosEnty = bosRelation.getSupplierObject();
            PropertyInfo propSupplier = bosRelation.getSupplierProperty();
            if (clientBosEnty == null || supplierBosEnty == null || propSupplier == null || propClient == null || propSupplier.getMappingField() == null || propClient.getMappingField() == null) {
                if (!toThrow) continue;
                throw new BosCheckinException(3, p.getName());
            }
            boolean isClientItself = this.checkLink(bosEntity, clientBosEnty.getName());
            if (!isClientItself) {
                if (this.checkLink(bosEntity, supplierBosEnty.getName())) {
                    EntityObjectInfo tempEntity = clientBosEnty;
                    clientBosEnty = supplierBosEnty;
                    supplierBosEnty = tempEntity;
                    PropertyInfo tempProperty = propClient;
                    propClient = propSupplier;
                    propSupplier = tempProperty;
                } else {
                    if (!toThrow) continue;
                    throw new BosCheckinException(4, p.getName());
                }
            }
            if (propSupplier instanceof OwnPropertyInfo) {
                DataType type = ((OwnPropertyInfo)propSupplier).getDataType();
                SemanticField field = this.createField(p, type, primaryKeys);
                fields.add(field);
                mapFieldsName.put(name, field);
            }
            if ((supplier = this.getTableForRelation(supplierBosEnty)) == null) continue;
            String desc = propClient.getAlias();
            if (StringUtil.isEmptyString((String)desc)) {
                desc = propClient.getName();
            }
            SemanticRelation relation = new SemanticRelation();
            relation.setClient(client);
            relation.setSupplier(supplier);
            relation.setDescription(desc);
            relation.setJoinType(SemanticRelation.JoinType.INNER);
            relation.setStandard(this._preferencs.isStandardMaker());
            SemanticRelation.JoinLine condition = new SemanticRelation.JoinLine(propClient.getMappingField().getName(), propSupplier.getMappingField().getName());
            relation.addCondition(condition);
            relations.add(relation);
        }
    }

    private boolean checkLink(EntityObjectInfo eoi, String clientEntyName) {
        while (!StringUtil.equalsIgnoreCase((String)eoi.getName(), (String)clientEntyName)) {
            if ((eoi = (EntityObjectInfo)eoi.get("baseEntity")) != null) continue;
            return false;
        }
        return true;
    }

    private HeavyContent getHeavyContent(LazyInfo info) throws SemanticDesignException {
        HeavyContent hc = info.getContent();
        if (hc == null) {
            InfoWrapper wrapper = this._state.loadEntity(info, false, false);
            hc = wrapper.getContent();
        }
        return hc;
    }

    private SemanticTable getTableForRelation(EntityObjectInfo bosEntity) throws SemanticDesignException {
        DataTableInfo tableInfo = (DataTableInfo)bosEntity.get("table");
        if (tableInfo == null) {
            return null;
        }
        String tableName = tableInfo.getName();
        LazyInfo info = (LazyInfo)this._existInfos.get(tableName.toUpperCase());
        if (info != null) {
            SemanticTable table = this.createTableFromInfo(info);
            HeavyContent hc = this.getHeavyContent(info);
            HeavyContentIO.loadEntity(hc, table);
            return table;
        }
        SemanticTable table = (SemanticTable)this._willAppend.get(tableName);
        if (table != null) {
            SemanticTable tableClone = new SemanticTable();
            tableClone.setProperty("id", table.getProperty("id"));
            tableClone.setPhysicalName(table.getPhysicalName());
            table = tableClone;
        }
        return table;
    }

    private SemanticTable createTableFromInfo(LazyInfo info) throws SemanticDesignException {
        SemanticTable table = new SemanticTable();
        table.setPhysicalName(info.getPhysicalName());
        table.setLogicalName(info.getLogicalName());
        table.setProperty("id", info.getId());
        return table;
    }

    private SemanticField createField(PropertyInfo propertyInfo, DataType dataType, Set primaryKeys) {
        SemanticField f = new SemanticField();
        f.setStandard(this._preferencs.isStandardMaker());
        f.setHide(BosEntityCheckin.isFieldHide(dataType));
        ColumnInfo mappingField = propertyInfo.getMappingField();
        SQLType sqlType = mappingField.getTypeName();
        f.setDataType(DbCheckin.parseType(sqlType.getSQLType()));
        String pName = mappingField.getName();
        f.setPhysicalName(pName);
        String lName = propertyInfo.getAlias();
        if (StringUtil.isEmptyString((String)lName)) {
            lName = pName;
        }
        f.setLogicalName(lName);
        f.setPK(primaryKeys.contains(pName));
        return f;
    }

    private static boolean isFieldHide(DataType dt) {
        return DataType.BOSUUID.equals((Object)dt) || DataType.UUID.equals((Object)dt);
    }

    private static SemanticDataType parseType(DataType dt) {
        if (DataType.SHORT.equals((Object)dt) || DataType.INTEGER.equals((Object)dt) || DataType.LONG.equals((Object)dt) || DataType.BOOLEAN.equals((Object)dt) || DataType.BYTE.equals((Object)dt) || DataType.CHAR.equals((Object)dt)) {
            return SemanticDataType.INT;
        }
        if (DataType.FLOAT.equals((Object)dt) || DataType.DOUBLE.equals((Object)dt) || DataType.DECIMAL.equals((Object)dt)) {
            return SemanticDataType.DECIMAL;
        }
        if (DataType.DATE.equals((Object)dt)) {
            return SemanticDataType.DATE;
        }
        if (DataType.TIME.equals((Object)dt)) {
            return SemanticDataType.TIME;
        }
        if (DataType.TIMESTAMP.equals((Object)dt)) {
            return SemanticDataType.DATETIME;
        }
        if (DataType.STRING.equals((Object)dt)) {
            return SemanticDataType.NVARCHAR;
        }
        if (DataType.BYTEARRAY.equals((Object)dt)) {
            return SemanticDataType.VARBINARY;
        }
        if (DataType.BOSUUID.equals((Object)dt) || DataType.UUID.equals((Object)dt)) {
            return SemanticDataType.VARCHAR;
        }
        return SemanticDataType.Unsure;
    }
}

