/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.server.checkin.fromdb;

import com.kingdee.bos.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.semantic.design.server.checkin.fromdb.DbCheckin;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

class FromOracle
extends DbCheckin {
    FromOracle(DataCenterInfo outDcInfo) {
        super(outDcInfo);
    }

    @Override
    protected IRowSet doLookForTables(boolean isT, boolean isV, String filter) throws SQLException {
        Object[] objectArray;
        StringBuffer sql = new StringBuffer();
        if (isT && isV) {
            sql.append(this.getTablesSql());
            sql.append(" union ");
            sql.append(this.getViewsSql());
        } else if (isT) {
            sql.append(this.getTablesSql());
        } else if (isV) {
            sql.append(this.getViewsSql());
        }
        boolean hasFilter = false;
        if (!StringUtil.isEmptyString((String)filter)) {
            hasFilter = true;
            sql.insert(0, "select * from(");
            sql.append(")");
            sql.append(" where");
            sql.append(" TABLE_NAME like ?");
            sql.append(" escape '/'");
        }
        sql.append(" order by TABLE_NAME");
        sql.insert(0, "/*dialect*/");
        Connection connection = this.getConn();
        String string = sql.toString();
        if (hasFilter) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = filter;
        } else {
            objectArray = null;
        }
        return DbUtil.executeQuery(connection, string, objectArray);
    }

    private String getTablesSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("select TABLE_NAME, 1 as TABLE_TYPE");
        sql.append(" from USER_TABLES");
        return sql.toString();
    }

    private String getViewsSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("select VIEW_NAME as TABLE_NAME, 2 as TABLE_TYPE");
        sql.append(" from USER_VIEWS");
        return sql.toString();
    }

    @Override
    protected int getTableType(IRowSet rowSet) throws SQLException {
        int type = rowSet.getInt("TABLE_TYPE");
        if (1 == type) {
            return 1;
        }
        if (2 == type) {
            return 2;
        }
        throw new RuntimeException("Impossible");
    }

    @Override
    protected String getTableName(IRowSet rowSet) throws SQLException {
        return rowSet.getString("TABLE_NAME");
    }

    @Override
    protected List doSearchPk(String tableName) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/");
        sql.append("select COLUMN_NAME");
        sql.append(" from USER_CONS_COLUMNS");
        sql.append(" where CONSTRAINT_NAME=(");
        sql.append("select CONSTRAINT_NAME from USER_CONSTRAINTS");
        sql.append(" where TABLE_NAME=? and CONSTRAINT_TYPE='P')");
        sql.append(" order by POSITION asc");
        ArrayList<String> result = null;
        IRowSet rowSet = DbUtil.executeQuery(this.getConn(), sql.toString(), new Object[]{tableName});
        while (rowSet.next()) {
            if (result == null) {
                result = new ArrayList<String>();
            }
            result.add(rowSet.getString("COLUMN_NAME"));
        }
        return result;
    }
}

