/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.base.license;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.ModuleLicenseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.rpts.base.license.EXTLicenseException;
import com.kingdee.eas.rpts.base.license.LicenseUtil;

public class EXTLicenseService {
    private Context _ctx;
    private ILicenseSrvAgent _agent;
    private static int _systemExtLicType = -1;

    public EXTLicenseService(Context ctx) {
        this._ctx = ctx;
    }

    private ILicenseSrvAgent getAgent() throws EXTLicenseException {
        if (this._agent == null) {
            try {
                this._agent = this._ctx == null ? LicenseSrvAgentFactory.getRemoteInstance() : LicenseSrvAgentFactory.getLocalInstance((Context)this._ctx);
            }
            catch (LicenseException e) {
                throw EXTLicenseException.wrap((Exception)((Object)e));
            }
        }
        return this._agent;
    }

    public int sysLicenseModuleType() throws EXTLicenseException {
        if (_systemExtLicType == -1) {
            _systemExtLicType = this.retrieveSysLicenseModeleType();
        }
        return _systemExtLicType;
    }

    private int retrieveSysLicenseModeleType() throws EXTLicenseException {
        int type = 0;
        try {
            ModuleLicenseInfo[] licenses = this.getAgent().getModuleLicenseInfo();
            if (licenses.length == 0) {
                return 1;
            }
            for (int i = 0; i < licenses.length; ++i) {
                if (licenses[i].containModule("BOS_EXTRPT_RUNTIME") || licenses[i].getModuleName().equals("BOS_EXTRPT_RUNTIME")) {
                    type |= 1;
                }
                if (licenses[i].containModule("BOS_RPTC_RUNTIME") || licenses[i].getModuleName().equals("BOS_RPTC_RUNTIME")) {
                    type |= 2;
                }
                if (LicenseUtil.isContainModule(licenses[i])) {
                    type = 3;
                }
                if (type != 3) continue;
                return type;
            }
            return type;
        }
        catch (LicenseException e) {
            throw EXTLicenseException.wrap("\u68c0\u67e5License\u9519\u8bef", (Exception)((Object)e));
        }
    }

    public boolean sysLicenseContain(String model) throws EXTLicenseException {
        try {
            ModuleLicenseInfo[] licenses = this.getAgent().getModuleLicenseInfo();
            if (licenses.length == 0) {
                return false;
            }
            for (int i = 0; i < licenses.length; ++i) {
                if (licenses[i].containModule(model) || licenses[i].getModuleName().equals(model)) {
                    return true;
                }
                if (licenses[i].containModule(model) || licenses[i].getModuleName().equals(model)) {
                    return true;
                }
                if (!LicenseUtil.isContainModule(licenses[i])) continue;
                return true;
            }
        }
        catch (LicenseException e) {
            throw EXTLicenseException.wrap("\u68c0\u67e5License\u9519\u8bef", (Exception)((Object)e));
        }
        return false;
    }

    public Context getContext() {
        return this._ctx;
    }

    public void setContext(Context ctx) {
        this._ctx = ctx;
    }
}

