/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.base.license;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.eas.rpts.base.license.EXTLicenseException;
import com.kingdee.eas.rpts.base.license.ILicenseChecker;
import com.kingdee.eas.rpts.ctrlreport.bo.LicenseBo;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import org.apache.log4j.Logger;

public class EXTREPORTLicenseChecker
implements ILicenseChecker {
    private Context _ctx;
    private Logger _log = CommonLogger.getLogger(EXTREPORTLicenseChecker.class);

    public EXTREPORTLicenseChecker(Context ctx) {
        this._ctx = ctx;
    }

    @Override
    public boolean checkLicense() throws EXTLicenseException {
        try {
            int spareCount = LicenseBo.getCacheSpareCount(this._ctx);
            if (spareCount < 0) {
                throw EXTLicenseException.REQUEST_EXT_INVALID_EXCEPTION;
            }
            return true;
        }
        catch (CtrlReportException e) {
            this._log.error((Object)"EXT6.0:\u68c0\u67e5License\u5931\u8d25", (Throwable)e);
            throw EXTLicenseException.wrap(e);
        }
    }

    @Override
    public boolean releaseLicense() throws EXTLicenseException {
        return true;
    }

    public Context getContext() {
        return this._ctx;
    }

    public void setContext(Context ctx) {
        this._ctx = ctx;
    }
}

