/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.base.license;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.ModuleLicenseInfo;
import com.kingdee.eas.base.license.client.LicenseController;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.base.license.EXTLicenseException;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Date;
import org.apache.log4j.Logger;

public class LicenseUtil {
    public static final String[] OTHER_MODULES = new String[]{"RESO_RPT"};
    public static final String MODULENAME = "RESO_RPT";
    private static Logger _log = CommonLogger.getLogger(LicenseUtil.class);

    public static boolean isContainModule(ModuleLicenseInfo info) {
        for (String moduleName : OTHER_MODULES) {
            if (!info.containModule(moduleName) && !info.getModuleName().equals(moduleName)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkLicense(Context ctx) throws EXTLicenseException {
        if (ctx == null) {
            return LicenseUtil.checkClientLicense();
        }
        return LicenseUtil.checkSrvLicense(ctx);
    }

    public static boolean releaseLicense(Context ctx) throws EXTLicenseException {
        if (ctx == null) {
            return LicenseUtil.releaseClientLicense();
        }
        return LicenseUtil.releaseSrvLicense(ctx);
    }

    private static boolean checkSrvLicense(Context ctx) throws EXTLicenseException {
        try {
            LicenseUserInfo userInfo = LicenseUtil.getLicenseUserInfo(ctx);
            int flag = LicenseUtil.getLicenseAgent(ctx).requestLicense(userInfo, "com.kingdee.eas.rpts.ctrlreport.client.ReportRunTimeUI");
            switch (flag) {
                case 4: {
                    throw EXTLicenseException.REQUEST_INVALID_EXCEPTION;
                }
                case 2: {
                    throw EXTLicenseException.REQUEST_NO_SURPLUS_EXCEPTION;
                }
                case 1: {
                    return true;
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)"EXT: \u670d\u52a1\u7aef \u68c0\u67e5\u623f\u5730\u4ea7license\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            StringBuilder sb = new StringBuilder();
            try {
                String module = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getModuleByPackage("com.kingdee.eas.rpts.ctrlreport.client.ReportRunTimeUI");
                sb.append(e.getMessage() + "\n");
                sb.append("\u5bf9\u5e94\u7684license\u6a21\u5757\u540d\u79f0\uff1a");
                String moduleName = (String)LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getModuleAliasMap().get(module);
                sb.append(moduleName + "[");
                sb.append(module);
                sb.append("]\n");
                sb.append("\u5bf9\u5e94\u7684\u5b50\u7cfb\u7edf\u540d\u79f0\uff1a\u6269\u5c55\u62a5\u8868\u4e2d\u5fc3[");
                String subSystemName = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getSubSystemByModule(module);
                sb.append(subSystemName + "]");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            throw EXTLicenseException.wrap(sb.toString(), e);
        }
        return false;
    }

    private static LicenseUserInfo getLicenseUserInfo(Context ctx) {
        LicenseUserInfo info = new LicenseUserInfo();
        info.setSessionID(ctx.getContextID());
        info.setUserID(ctx.getCaller().toString());
        info.setUserIP(ctx.getClientHostIP());
        info.setUserLoginAis(ctx.getAIS());
        info.setUserName(ctx.getUserName());
        info.setUserLoginTime(new Date());
        OrgUnitInfo info2 = ContextUtil.getCurrentOrgUnit((Context)ctx);
        if (info2 != null) {
            info.setUserCompany(info2.getName());
        }
        return info;
    }

    private static boolean checkClientLicense() throws EXTLicenseException {
        LicenseController licController = LicenseController.getInstance();
        LicenseUserInfo userInfo = (LicenseUserInfo)SysContext.getSysContext().getProperty((Object)"License.UserInfo");
        try {
            int flag = licController.requestLicense(userInfo, "com.kingdee.eas.rpts.ctrlreport.client.ReportRunTimeUI");
            switch (flag) {
                case 4: {
                    throw EXTLicenseException.REQUEST_INVALID_EXCEPTION;
                }
                case 2: {
                    throw EXTLicenseException.REQUEST_NO_SURPLUS_EXCEPTION;
                }
                case 1: {
                    return true;
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)"EXT: \u5ba2\u6237\u7aef \u68c0\u67e5\u623f\u5730\u4ea7license\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw EXTLicenseException.wrap(e);
        }
        return false;
    }

    private static boolean releaseSrvLicense(Context ctx) throws EXTLicenseException {
        try {
            LicenseUtil.getLicenseAgent(ctx).releaseLicense(ctx.getContextID(), MODULENAME);
            return true;
        }
        catch (LicenseException e) {
            _log.error((Object)"EXT:\u670d\u52a1\u7aef\u91ca\u653e\u623f\u5730\u4ea7License\u5931\u8d25", (Throwable)e);
            throw EXTLicenseException.wrap((Exception)((Object)e));
        }
    }

    private static boolean releaseClientLicense() throws EXTLicenseException {
        LicenseController licController = LicenseController.getInstance();
        String sessionID = SysContext.getSysContext().getSessionID();
        try {
            licController.releaseLicense(sessionID, MODULENAME);
        }
        catch (LicenseException e) {
            _log.error((Object)"EXT: \u5ba2\u6237\u7aef\u91ca\u653e\u623f\u5730\u4ea7License\u5931\u8d25", (Throwable)e);
            throw EXTLicenseException.wrap((Exception)((Object)e));
        }
        return false;
    }

    private static ILicenseSrvAgent getLicenseAgent(Context ctx) throws EXTLicenseException {
        try {
            if (ctx != null) {
                return LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
            }
            return LicenseSrvAgentFactory.getRemoteInstance();
        }
        catch (LicenseException e) {
            _log.error((Object)"\u670d\u52a1\u7aef\u5c1d\u8bd5\u83b7\u5f97\u623fLicense\u4ee3\u7406\u5931\u8d25", (Throwable)e);
            throw EXTLicenseException.wrap((Exception)((Object)e));
        }
    }
}

