/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.base.license;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.rpts.base.license.EXTLicenseException;
import com.kingdee.eas.rpts.base.license.ILicenseChecker;
import com.kingdee.eas.rpts.base.license.LicenseUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Date;
import org.apache.log4j.Logger;

public class ReportCenterLicenseSrvChecker
implements ILicenseChecker {
    private String _module;
    private Context _ctx;
    private static Logger _log = CommonLogger.getLogger(ReportCenterLicenseSrvChecker.class);
    private static ILicenseSrvAgent _agent;
    private LicenseUserInfo _userInfo;

    public ReportCenterLicenseSrvChecker(String module, Context ctx) {
        this._module = module;
        this._ctx = ctx;
        this._userInfo = this.getLicenseUserInfo();
    }

    private ILicenseSrvAgent getLicenseAgent() throws EXTLicenseException {
        if (_agent == null) {
            try {
                _agent = this._ctx != null ? LicenseSrvAgentFactory.getLocalInstance((Context)this._ctx) : LicenseSrvAgentFactory.getRemoteInstance();
            }
            catch (LicenseException e) {
                _log.error((Object)"\u670d\u52a1\u7aef\u5c1d\u8bd5\u83b7\u5f97License\u4ee3\u7406\u5931\u8d25", (Throwable)e);
                throw EXTLicenseException.wrap((Exception)((Object)e));
            }
        }
        return _agent;
    }

    @Override
    public boolean checkLicense() throws EXTLicenseException {
        try {
            int flag = this.getLicenseAgent().requestLicense(this._userInfo, this._module);
            switch (flag) {
                case 4: {
                    throw EXTLicenseException.REQUEST_INVALID_EXCEPTION;
                }
                case 2: {
                    throw EXTLicenseException.REQUEST_NO_SURPLUS_EXCEPTION;
                }
                case 1: {
                    return true;
                }
            }
        }
        catch (Exception e) {
            try {
                LicenseUtil.checkLicense(this._ctx);
            }
            catch (Exception ex) {
                _log.error((Object)"EXT: \u5ba2\u6237\u7aef Check License\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
                throw EXTLicenseException.wrap(ex.getMessage(), ex);
            }
        }
        return false;
    }

    @Override
    public boolean releaseLicense() throws EXTLicenseException {
        try {
            this.getLicenseAgent().releaseLicense(this._ctx.getContextID(), this._module);
            boolean bl = true;
            return bl;
        }
        catch (LicenseException e) {
            _log.error((Object)"EXT:\u670d\u52a1\u7aef\u91ca\u653eLicense\u5931\u8d25", (Throwable)e);
            throw EXTLicenseException.wrap((Exception)((Object)e));
        }
        finally {
            try {
                LicenseUtil.releaseLicense(this._ctx);
            }
            catch (Exception e) {
                _log.error((Object)"EXT:\u670d\u52a1\u7aef\u91ca\u653eLicense\u5931\u8d25", (Throwable)e);
                throw EXTLicenseException.wrap(e);
            }
        }
    }

    public void setContext(Context ctx) {
        this._ctx = ctx;
        this._userInfo = this.getLicenseUserInfo();
    }

    private LicenseUserInfo getLicenseUserInfo() {
        LicenseUserInfo info = new LicenseUserInfo();
        info.setSessionID(this._ctx.getContextID());
        info.setUserID(this._ctx.getCaller().toString());
        info.setUserIP(this._ctx.getClientHostIP());
        info.setUserLoginAis(this._ctx.getAIS());
        info.setUserName(this._ctx.getUserName());
        info.setUserLoginTime(new Date());
        OrgUnitInfo info2 = ContextUtil.getCurrentOrgUnit((Context)this._ctx);
        if (info2 != null) {
            info.setUserCompany(info2.getName());
        }
        return info;
    }

    public String getModule() {
        return this._module;
    }

    public void setModule(String module) {
        this._module = module;
    }
}

