/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.cardschedule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.rpts.cardschedule.CardScheduleEntityFactory;
import com.kingdee.eas.rpts.cardschedule.CardScheduleEntityInfo;
import com.kingdee.eas.rpts.cardschedule.ICardScheduleEntity;
import com.kingdee.eas.rpts.cardschedule.exception.SchedulerException;
import com.kingdee.eas.rpts.cardschedule.model.JobParam;
import com.kingdee.eas.rpts.cardschedule.model.Schedule;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ScheduleEngine {
    private static Logger logger = CommonLogger.getLogger(ScheduleEngine.class);

    public void saveJob(Context ctx, String scheduleName, Schedule schedule, JobParam param) throws SchedulerException {
        String xmlString = this.convertToXml(schedule);
        MetaDataPK functionPK = MetaDataPK.create((String)"com.kingdee.eas.rpts.cardschedule.app.CardScheduleFunction");
        FunctionObjectInfo func = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)functionPK) : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)functionPK);
        OperationCollection operCols = func.getOperation();
        OperationInfo operation = operCols.get(0);
        HashMap<String, String> jobContext = new HashMap<String, String>();
        jobContext.put("userId", param.getUserId());
        jobContext.put("reportId", param.getReportId());
        IEnactmentService service = null;
        String jobDefId = null;
        try {
            service = ctx == null ? EnactmentServiceFactory.createRemoteEnactService() : EnactmentServiceFactory.createEnactService((Context)ctx);
            jobDefId = service.createJobProcessDef(scheduleName, func, operation, jobContext, xmlString, null);
        }
        catch (BOSException e) {
            String msg = "save job failed";
            logger.error((Object)msg, (Throwable)e);
            throw new SchedulerException(msg, e);
        }
        CardScheduleEntityInfo scheduleInfo = new CardScheduleEntityInfo();
        scheduleInfo.setJobDefid(jobDefId);
        scheduleInfo.setCreator(param.getUserId());
        scheduleInfo.setCreateTime(new Date());
        scheduleInfo.setPkid(param.getReportId());
        try {
            ICardScheduleEntity cardEntity = ctx == null ? CardScheduleEntityFactory.getRemoteInstance() : CardScheduleEntityFactory.getLocalInstance(ctx);
            cardEntity.addnew(scheduleInfo);
        }
        catch (Exception e) {
            try {
                service.removeJobProcessDef(jobDefId);
            }
            catch (WfException e1) {
                logger.error((Object)"rollback jobprocess failed", (Throwable)e);
            }
            String msg = "save job failed";
            logger.error((Object)msg, (Throwable)e);
            throw new SchedulerException(msg, e);
        }
    }

    public CardScheduleEntityInfo getCardScheduleEntityInfoByPkId(Context ctx, String pkId) throws SchedulerException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("pkid", (Object)pkId, CompareType.EQUALS));
        filterInfo.setMaskString("(#0)");
        SorterItemCollection sorterItem = new SorterItemCollection();
        SorterItemInfo sorterInfo = new SorterItemInfo();
        sorterInfo.setPropertyName("createTime");
        sorterInfo.setSortType(SortType.DESCEND);
        sorterItem.add(sorterInfo);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSorter(sorterItem);
        CoreBaseCollection collection = null;
        ICardScheduleEntity cardEntity = null;
        try {
            cardEntity = ctx == null ? CardScheduleEntityFactory.getRemoteInstance() : CardScheduleEntityFactory.getLocalInstance(ctx);
            collection = cardEntity.getCollection(entityViewInfo);
        }
        catch (BOSException e) {
            String msg = "delete job failed";
            logger.error((Object)msg, (Throwable)e);
            throw new SchedulerException(msg, e);
        }
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        CardScheduleEntityInfo entityInfo = (CardScheduleEntityInfo)collection.get(0);
        return entityInfo;
    }

    public void deleteJob(Context ctx, String pkId) throws SchedulerException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("pkid", (Object)pkId, CompareType.EQUALS));
        filterInfo.setMaskString("(#0)");
        SorterItemCollection sorterItem = new SorterItemCollection();
        SorterItemInfo sorterInfo = new SorterItemInfo();
        sorterInfo.setPropertyName("createTime");
        sorterInfo.setSortType(SortType.DESCEND);
        sorterItem.add(sorterInfo);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSorter(sorterItem);
        CoreBaseCollection collection = null;
        ICardScheduleEntity cardEntity = null;
        try {
            cardEntity = ctx == null ? CardScheduleEntityFactory.getRemoteInstance() : CardScheduleEntityFactory.getLocalInstance(ctx);
            collection = cardEntity.getCollection(entityViewInfo);
        }
        catch (BOSException e) {
            String msg = "delete job failed";
            logger.error((Object)msg, (Throwable)e);
            throw new SchedulerException(msg, e);
        }
        if (collection == null || collection.isEmpty()) {
            return;
        }
        CardScheduleEntityInfo entityInfo = (CardScheduleEntityInfo)collection.get(0);
        String jobDefId = entityInfo.getJobDefid();
        try {
            IEnactmentService service = null;
            service = ctx == null ? EnactmentServiceFactory.createRemoteEnactService() : EnactmentServiceFactory.createEnactService((Context)ctx);
            service.removeJobProcessDef(jobDefId);
            cardEntity.delete(filterInfo);
        }
        catch (Exception e) {
            String msg = "delete job failed";
            logger.error((Object)msg, (Throwable)e);
            throw new SchedulerException(msg, e);
        }
    }

    private String convertToXml(Schedule schedule) {
        ScheduleDef sDef = new ScheduleDef(null);
        sDef.setInstructionType(0);
        Date date = new Date();
        sDef.setBeginTime(date);
        sDef.setEndTime(date);
        sDef.setDefine(this.getExecuteCron(schedule));
        switch (schedule.getPeriod()) {
            case Daily: {
                sDef.setType(ScheduleType.EVERYDAY);
                break;
            }
            case Monthly: {
                sDef.setType(ScheduleType.EVERYMONTH);
                break;
            }
            case Weekly: {
                sDef.setType(ScheduleType.EVERYWEEK);
                break;
            }
            case Custom: {
                sDef.setType(ScheduleType.USERDEFINE);
            }
        }
        return KpdlParser.scheduleToString((ScheduleDef)sDef);
    }

    protected String getExecuteCron(Schedule scheduleInfo) {
        int time = scheduleInfo.getTime();
        int hour = time / 3600;
        int minute = (time - hour * 3600) / 60;
        int second = (time - hour * 3600) % 60;
        switch (scheduleInfo.getPeriod()) {
            case Daily: {
                return String.format("%s %s %s * * ? *", second, minute, hour);
            }
            case Weekly: {
                String week = "*";
                if (!scheduleInfo.isWeek(127)) {
                    StringBuffer weeks = new StringBuffer();
                    int weekValue = scheduleInfo.getWeek();
                    for (int weekIndex = 1; weekIndex < 8; ++weekIndex) {
                        if ((weekValue & 1) == 1) {
                            weeks = weeks.length() == 0 ? weeks.append(weekIndex) : weeks.append(",").append(weekIndex);
                        }
                        weekValue >>>= 1;
                    }
                    week = weeks.toString();
                }
                return String.format("%s %s %s ? * %s *", second, minute, hour, week);
            }
            case Monthly: {
                int dayAtMonthly = scheduleInfo.getDay();
                String day = dayAtMonthly >= 1 ? dayAtMonthly + "" : "L";
                return String.format("%s %s %s %s * ? *", second, minute, hour, day);
            }
            case Custom: {
                return scheduleInfo.getCron();
            }
        }
        return null;
    }
}

