/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.cloud.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.io.kds.KDSConstants;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IMainMenuItem;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.base.uiframe.MenuCacheFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.base.license.EXTLicenseException;
import com.kingdee.eas.rpts.base.license.EXTLicenseService;
import com.kingdee.eas.rpts.cloud.model.CloudReportData;
import com.kingdee.eas.rpts.cloud.service.CloudRptPublishHelper;
import com.kingdee.eas.rpts.cloud.service.ExtCloudRptCategoryControllerFacade;
import com.kingdee.eas.rpts.cloud.service.ICloudRptCenterController;
import com.kingdee.eas.rpts.cloud.service.IExtCloudRptCategoryController;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.IReportFacade;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.rpts.ctrlreport.bo.CloudReportAuthBO;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.bo.LicenseBo;
import com.kingdee.eas.rpts.ctrlreport.data.PublishType;
import com.kingdee.eas.rpts.ctrlreport.deploy.EASAppCenterTreeFacade;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlreport.mobile.util.MobileTemplateUtil;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CloudRptCenterControllerBean
implements ICloudRptCenterController {
    private IExtCloudRptCategoryController extCloudRptCategoryController;
    private Context easCtx;
    private static final Logger logger = CommonLogger.getLogger(CloudRptCenterControllerBean.class);

    public CloudRptCenterControllerBean() {
        this.easCtx = ContextUtils.getContextFromSession();
        this.extCloudRptCategoryController = ExtCloudRptCategoryControllerFacade.getLocalInst(this.easCtx);
    }

    public CloudRptCenterControllerBean(Context easCtx) {
        this.easCtx = easCtx;
        this.extCloudRptCategoryController = ExtCloudRptCategoryControllerFacade.getLocalInst(easCtx);
    }

    @Override
    public boolean isCloudRptCenterEnable() {
        String sql = "select * from T_EXT_CloudReport_Setting";
        try {
            IRowSet rowSet = ExtDBUtil.executeQuery(this.easCtx, sql, null);
            if (rowSet.next()) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void setCloudRptCenterEnable(boolean enable) {
        String sql;
        if (this.isCloudRptCenterEnable() == enable) {
            return;
        }
        if (!enable) {
            String uuid = Uuid.create().toString();
            sql = "insert into T_EXT_CloudReport_Setting(Fid,FIsShow) values('" + uuid + "',0)";
        } else {
            sql = "delete from T_EXT_CloudReport_Setting";
        }
        try {
            ExtDBUtil.maintainRecord(this.easCtx, sql, null);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteDemoDataAuth(String userId, String cloudRptId) {
        CloudReportAuthBO.deleteDemoAuth(this.easCtx, cloudRptId, userId);
        this.refreshMenu();
    }

    @Override
    public boolean hasDemoAuth(String userId, String cloudRptId) {
        return CloudReportAuthBO.hasDemoAuthByCloudRptId(this.easCtx, cloudRptId, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Object requestAuth(List<String> reports, String userId, boolean isPublish) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap returnReports = new HashMap();
        result.put("isPublish", isPublish);
        result.put("reports", returnReports);
        if (!isPublish) {
            Iterator<String> iterator = reports.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    result.put("isRequestAuth", false);
                    return result;
                }
                String cloudRptId = iterator.next();
                HashMap<String, Boolean> reportResult = new HashMap<String, Boolean>();
                reportResult.put("isPublishSuccess", false);
                returnReports.put(cloudRptId, reportResult);
            }
        }
        ArrayList<String> requestReportIds = new ArrayList<String>();
        for (String cloudRptId : reports) {
            HashMap<String, Object> reportResult = new HashMap<String, Object>();
            returnReports.put(cloudRptId, reportResult);
            DefineReportInfo reportInfo = null;
            try {
                String reportId;
                boolean hasCloudReportAuth;
                Class<CloudRptCenterControllerBean> clazz = CloudRptCenterControllerBean.class;
                // MONITORENTER : com.kingdee.eas.rpts.cloud.service.CloudRptCenterControllerBean.class
                try {
                    reportInfo = DefineReportBO.getCloudReportInfo(this.easCtx, cloudRptId);
                }
                catch (BOSException e) {
                    throw ExtRptBizException.newFailed2LoadCloudRptsException(e);
                }
                if (reportInfo != null) {
                    this.publishReport(reportInfo);
                }
                // MONITOREXIT : clazz
                if (reportInfo != null && !(hasCloudReportAuth = CloudReportAuthBO.hasCloudReportAuth(this.easCtx, reportId = reportInfo.getId().toString(), userId))) {
                    requestReportIds.add(reportId);
                    CloudReportAuthBO.insertDemoAuth(this.easCtx, cloudRptId, userId);
                }
                reportResult.put("isPublishSuccess", true);
            }
            catch (ExtRptBizException e) {
                reportResult.put("isPublishSuccess", false);
                reportResult.put("errorCode", e.getErrorCode());
                reportResult.put("errorMessage", e.getErrorMessage());
            }
        }
        try {
            CloudReportAuthBO.saveCloudReportAuthInfo(this.easCtx, requestReportIds);
            result.put("isRequestAuth", true);
            return result;
        }
        catch (Exception e) {
            result.put("isRequestAuth", false);
            ExtRptBizException ex = ExtRptBizException.newFailed2AuthCloudRptsException(e);
            result.put("errorCode", ex.getErrorCode());
            result.put("errorMessage", ex.getErrorMessage());
        }
        return result;
    }

    @Override
    public Map<String, Object> checkCloudRpt(CloudReportData reportData, String userId) throws ExtRptBizException {
        DefineReportInfo reportInfo;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (KDSConstants.isHigherVersion((int)reportData.getRptTemplateVersion())) {
            result.put("isHigherVersion", true);
            return result;
        }
        result.put("isHigherVersion", false);
        String mobileType = "2";
        if (mobileType.equals(reportData.getReportType())) {
            String rptCategoryFid = this.extCloudRptCategoryController.getMobileRptCategoryIdByName(reportData.getReportCategoryName());
        } else {
            String rptCategoryFid = this.extCloudRptCategoryController.getRptCategoryIdByName(reportData.getReportCategoryName());
        }
        try {
            reportInfo = DefineReportBO.getCloudReportInfo(this.easCtx, reportData.getReportID());
        }
        catch (BOSException e) {
            throw ExtRptBizException.newFailed2LoadCloudRptsException(e);
        }
        if (reportInfo == null) {
            result.put("isExist", false);
            result.put("updatable", true);
            result.put("hasAuth", false);
            return result;
        }
        result.put("isExist", true);
        result.put("reportId", reportInfo.getId().toString());
        if (reportData.getRptContentVersion() > reportInfo.getCloudRptVersion()) {
            result.put("updatable", true);
        } else {
            result.put("updatable", false);
        }
        result.put("easCloudRptVersion", reportInfo.getCloudRptVersion());
        boolean hasCloudReportAuth = CloudReportAuthBO.hasCloudReportAuth(this.easCtx, reportInfo.getId().toString(), userId);
        if (hasCloudReportAuth) {
            result.put("hasAuth", true);
        } else {
            result.put("hasAuth", false);
        }
        return result;
    }

    @Override
    public Object collect(CloudReportData reportData, int dataIndex, String dataString) throws ExtRptBizException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        reportData.setData(dataIndex, dataString);
        result.put("isAll", reportData.isAll());
        if (reportData.isAll()) {
            this.saveReport(reportData);
            result.put("isSaved", true);
        } else {
            result.put("isSaved", false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefineReportInfo saveReport(CloudReportData reportData) throws ExtRptBizException {
        Class<CloudRptCenterControllerBean> clazz = CloudRptCenterControllerBean.class;
        synchronized (CloudRptCenterControllerBean.class) {
            DefineReportInfo reportInfo = null;
            String fid = null;
            try {
                reportInfo = DefineReportBO.getCloudReportInfo(this.easCtx, reportData.getReportID());
                if (reportInfo != null && reportData.getRptContentVersion() <= reportInfo.getCloudRptVersion()) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return reportInfo;
                }
                String mobileType = "2";
                String rptCategoryFid = mobileType.equals(reportData.getReportType()) ? this.extCloudRptCategoryController.getMobileRptCategoryIdByName(reportData.getReportCategoryName()) : this.extCloudRptCategoryController.getRptCategoryIdByName(reportData.getReportCategoryName());
                byte[] reportBytes = reportData.getReportDataByte();
                Book book = BookIOUtil.unpack((byte[])reportBytes);
                fid = book.getSourceEASUuid();
                if (StringUtil.isEmptyString((String)fid)) {
                    throw ExtRptBizException.newCloudRptTempleException(reportData.getReportName());
                }
                HashMap<String, String> mapName = new HashMap<String, String>();
                mapName.put("l1", reportData.getReportName());
                mapName.put("l2", reportData.getReportName());
                mapName.put("l3", STConverter.sc2tc((String)reportData.getReportName()));
                String flastupdatetime = CtrlReportUtil.formatDateTime(new Date());
                BOSUuid orgUuid = ContextUtil.getCurrentOrgUnit((Context)this.easCtx).getId();
                fid = DefineReportBO.saveCloudReport(this.easCtx, reportBytes, fid, mapName, rptCategoryFid, flastupdatetime, reportData.getReportType(), orgUuid, reportData.getReportID(), reportData.getRptContentVersion());
                reportInfo = DefineReportBO.getReportInfo(this.easCtx, fid);
            }
            catch (Exception e) {
                throw ExtRptBizException.newFailed2SaveCloudRptsException(e);
            }
            return reportInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishReport(String reportId) throws ExtRptBizException {
        Class<CloudRptCenterControllerBean> clazz = CloudRptCenterControllerBean.class;
        synchronized (CloudRptCenterControllerBean.class) {
            DefineReportInfo reportInfo = null;
            try {
                reportInfo = DefineReportBO.getReportInfo(this.easCtx, reportId);
            }
            catch (Exception e) {
                throw ExtRptBizException.newFailed2LoadCloudRptsException(e);
            }
            if (reportInfo == null) {
                throw ExtRptBizException.newFailed2LoadCloudRptsException(null);
            }
            this.publishReport(reportInfo);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void publishReport(DefineReportInfo reportInfo) throws ExtRptBizException {
        block22: {
            if (reportInfo == null) {
                return;
            }
            String fid = reportInfo.getId().toString();
            try {
                if (reportInfo.getTempletType() != 2 && reportInfo.getTempletType() != -1) break block22;
                String fname = reportInfo.getName();
                String[] names = new String(fname).split("\uff08CRC_.+_[0-9]{4}(\\$[0-9]{2}){0,2}\uff09(\\.kds)?");
                if (names != null && names.length == 1) {
                    fname = names[0];
                }
                int licenseTypeOld = reportInfo.getLicenseStrategy();
                int fisstdproduct = reportInfo.getIsStdProduct();
                int pubishType = PublishType.getPublishTypeAll(reportInfo);
                boolean isMobileTemple = reportInfo.getTempletType() == 2;
                String menuUiClassName = "com.kingdee.eas.rpts.ctrlreport.client.ExtReportRunUI";
                int licenseType = this.getLicenseType(isMobileTemple);
                if (1 == fisstdproduct || licenseType == 1) {
                    menuUiClassName = "com.kingdee.eas.rpts.ctrlreport.client.ExtReportRunUI";
                } else if (licenseType == 2) {
                    menuUiClassName = "com.kingdee.eas.rpts.ctrlreport.client.ReportRunTimeUI";
                }
                if (reportInfo.getTempletType() == 2) {
                    boolean isRePublish;
                    if (PublishType.isPublished2Mobile(pubishType)) {
                        return;
                    }
                    String newPublishName = CloudRptPublishHelper.getCloudReportPublishName(this.easCtx, reportInfo);
                    boolean bl = isRePublish = !newPublishName.equals(fname);
                    if (isRePublish || (pubishType & 8) != 0) {
                        ArrayList<String> mobileReportFid = new ArrayList<String>();
                        mobileReportFid.add(fid);
                        try {
                            CloudRptPublishHelper.unPublishMobile(this.easCtx, mobileReportFid);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw ExtRptBizException.newFailed2PublishCloudRpts2MobileException(e);
                        }
                    }
                    this.publish2MobileMenu(fid, newPublishName, licenseType, menuUiClassName);
                    break block22;
                }
                if (reportInfo.getTempletType() == -1) {
                    String fbipath;
                    String pageID;
                    boolean isRePublish;
                    if ((pubishType & 1) != 0 && (pubishType & 0x10) != 0 && (pubishType & 2) != 0 && licenseType == licenseTypeOld) {
                        return;
                    }
                    String newPublishName = CloudRptPublishHelper.getCloudReportPublishName(this.easCtx, reportInfo);
                    boolean bl = isRePublish = !newPublishName.equals(fname);
                    if ((isRePublish || (pubishType & 1) != 0) && reportInfo.getMenuID() != null) {
                        String menuID = reportInfo.getMenuID().toString();
                        boolean updateLicenseStrategy = StringUtil.isEmptyString((String)reportInfo.getBIPath()) && StringUtil.isEmptyString((String)reportInfo.getPortletID()) && StringUtil.isEmptyString((String)reportInfo.getEasWebAppCenterId());
                        HashMap<String, Boolean> stdInfo = new HashMap<String, Boolean>();
                        stdInfo.put("isDelMenuUI", 1 != reportInfo.getIsStdProduct());
                        CloudRptPublishHelper.unDeployReport(this.easCtx, fid, menuID, updateLicenseStrategy, stdInfo);
                    }
                    this.publish2GUIMenu(fid, newPublishName, licenseType, menuUiClassName);
                    if ((isRePublish || (pubishType & 0x10) != 0) && !StringUtil.isEmptyString((String)(pageID = reportInfo.getEasWebAppCenterId()))) {
                        RptParams params = new RptParams();
                        params.setString("PAGE_UUID", pageID);
                        EASAppCenterTreeFacade.deleteEasAppCenterPage(this.easCtx, params);
                    }
                    this.publish2PortalMenu(fid, newPublishName, licenseType, menuUiClassName);
                    if ((isRePublish || (pubishType & 2) != 0) && !StringUtil.isEmptyString((String)(fbipath = reportInfo.getBIPath()))) {
                        boolean updateLicenseStrategy = StringUtil.isEmptyString((String)reportInfo.getBIPath()) && StringUtil.isEmptyString((String)reportInfo.getPortletID()) && StringUtil.isEmptyString((String)reportInfo.getEasWebAppCenterId());
                        CloudRptPublishHelper.unDeployToBI(this.easCtx, fid, fbipath, updateLicenseStrategy);
                    }
                    this.publish2BIMenu(fid, newPublishName, licenseType, menuUiClassName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw ExtRptBizException.newFailed2PublishCloudRptsException(e);
            }
            finally {
                this.refreshMenu();
            }
        }
    }

    private void publish2GUIMenu(String fid, String fname, int licenseType, String menuUiClassName) throws ExtRptBizException {
        DefObj object = (DefObj)this.extCloudRptCategoryController.getCloudRptDeployPath(fid, 1);
        if (object == null) {
            throw ExtRptBizException.newFailed2PublishCloudRpts2GUIException(null);
        }
        MainMenuItemInfo parent = (MainMenuItemInfo)object.getProperty("data");
        String longNumber = (String)object.getProperty("number");
        String alias = object.getAlias();
        try {
            MainMenuItemInfo mi = CloudRptPublishHelper.getMenuItemInfo(parent, fname, fid, menuUiClassName);
            String deployPath = longNumber + "!" + mi.getNumber() + "@@" + alias + "/" + mi.getName();
            this.insertMenu(mi, deployPath, fid, licenseType);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ExtRptBizException.newFailed2PublishCloudRpts2GUIException(e);
        }
    }

    private void publish2PortalMenu(String fid, String fname, int licenseType, String menuUiClassName) throws ExtRptBizException {
        DefObj object = (DefObj)this.extCloudRptCategoryController.getCloudRptDeployPath(fid, 16);
        if (object == null) {
            throw ExtRptBizException.newFailed2PublishCloudRpts2PortalException(null);
        }
        String easAppCenterId = object.getName();
        String pathName = object.getAlias();
        try {
            RptParams params = new RptParams();
            params.setString("EAS_APP_CENTER_PARENTID", easAppCenterId);
            params.setString("EAS_APP_CENTER_PATH_NAME", pathName);
            params.setString("EAS_APP_CENTER_REPORT_MENU_NAME", menuUiClassName);
            params.setString("EAS_APP_CENTER_REPORT_NAME", fname);
            params.setString("EAS_APP_CENTER_REPORT_ID", fid);
            params.setInt("EAS_APP_CENTER_REPORT_LICENSE_STRATEGY", licenseType);
            EASAppCenterTreeFacade.savePageToPortal(this.easCtx, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ExtRptBizException.newFailed2PublishCloudRpts2PortalException(e);
        }
    }

    private void publish2BIMenu(String reportId, String reportName, int licenseType, String menuUiClassName) throws ExtRptBizException {
        IReportFacade reportFacade;
        DefObj object = (DefObj)this.extCloudRptCategoryController.getCloudRptDeployPath(reportId, 2);
        if (object == null) {
            throw ExtRptBizException.newFailed2PublishCloudRpts2BIException(null);
        }
        String path = object.getStrProperty("path");
        String pathText = object.getStrProperty("pathText");
        RptParams pr = new RptParams();
        pr.setString("MethodName", "saveBIMenu");
        pr.setString("parentNodePath", path.toString());
        pr.setString("reportFullPathCaption", pathText);
        pr.setString("parentBILabel", pathText.toString());
        pr.setString("displayName", reportName);
        pr.setString("FID", reportId);
        String biPath = "";
        RptParams pr_r = null;
        try {
            reportFacade = ReportFacadeFactory.getLocalInstance(this.easCtx);
            pr_r = reportFacade.commonExecute(pr);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
            throw ExtRptBizException.newFailed2PublishCloudRpts2BIException(e1);
        }
        biPath = pr_r.getString("biPath");
        pr.clear();
        pr.setString("MethodName", "deployReport");
        pr.setString("deployTo", "1");
        pr.setString("biPath", biPath);
        pr.setString("FID", reportId);
        pr.setInt("LicenseStrategy", licenseType);
        pr.setString("UserID", ContextUtil.getCurrentUserInfo((Context)this.easCtx).getId().toString());
        pr.setString("IP", ContextUtil.getClientIP((Context)this.easCtx));
        pr.setObject("descriptionMap", new HashMap());
        try {
            pr_r = reportFacade.commonExecute(pr);
            StringBuffer sqlBuf = new StringBuffer("update T_BAS_DEFINEREPORT set FMenuUi = ? where fid = ?");
            ArrayList<String> queryValue = new ArrayList<String>();
            queryValue.add(menuUiClassName);
            queryValue.add(reportId);
            ExtDBUtil.maintainRecord(this.easCtx, sqlBuf.toString(), queryValue);
        }
        catch (BOSException e) {
            int n;
            e.printStackTrace();
            if (biPath.equals("")) {
                return;
            }
            if (biPath.length() > 0 && (n = biPath.indexOf("@@")) != -1) {
                biPath = biPath.substring(0, n);
            }
            pr.clear();
            pr.setString("MethodName", "delBIMenu");
            pr.setString("bipath", biPath);
            try {
                reportFacade.commonExecute(pr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExtRptBizException.newFailed2PublishCloudRpts2BIException(e);
        }
    }

    private void publish2MobileMenu(String reportId, String publishName, Integer licenseStrategy, String menuui) throws ExtRptBizException {
        DefObj object = (DefObj)this.extCloudRptCategoryController.getCloudRptDeployPath(reportId, 8);
        if (object == null) {
            throw ExtRptBizException.newFailed2PublishCloudRpts2MobileException(null);
        }
        String mobileTypeId = object.getName();
        StringBuffer sqlBuf = new StringBuffer("update T_BAS_DEFINEREPORT set FMobileName = ?, FMobileTypeId = ?, FMenuUi = ?, FMobileDeployTime = now(), FPubAcctId=? ");
        if (licenseStrategy != null) {
            sqlBuf.append(",FLicenseStrategy = ?");
        }
        sqlBuf.append(" where fid = ?");
        ArrayList<Object> queryValue = new ArrayList<Object>();
        queryValue.add(publishName);
        queryValue.add(mobileTypeId);
        queryValue.add(menuui);
        queryValue.add("718ea531-103a-467a-9cf5-7e07410373a5");
        if (licenseStrategy != null) {
            queryValue.add(licenseStrategy);
        }
        queryValue.add(reportId);
        IRowSet rowSet = null;
        try {
            ExtDBUtil.maintainRecord(this.easCtx, sqlBuf.toString(), queryValue);
            String sqlSelect = "select min(forderNumber) from t_ext_mobileOrderNum where fmobileTypeId='" + mobileTypeId + "'";
            queryValue = new ArrayList();
            int minOrderNumber = 0;
            rowSet = ExtDBUtil.executeQuery(this.easCtx, sqlSelect, null);
            if (rowSet != null && rowSet.next()) {
                minOrderNumber = rowSet.getInt(1);
            }
            if (minOrderNumber > 0) {
                --minOrderNumber;
            } else {
                String sqlUpdate = "update t_ext_mobileOrderNum set forderNumber=forderNumber+1 where fmobileTypeId=?";
                queryValue.add(mobileTypeId);
                ExtDBUtil.maintainRecord(this.easCtx, sqlUpdate, queryValue);
            }
            String sqlInsert = "insert into t_ext_mobileOrderNum(freportId, fmobileTypeId, forderNumber) values(?,?,?)";
            queryValue.clear();
            queryValue.add(reportId);
            queryValue.add(mobileTypeId);
            queryValue.add(minOrderNumber);
            ExtDBUtil.maintainRecord(this.easCtx, sqlInsert, queryValue);
            DefineReportInfo report = DefineReportBO.getReportInfo(this.easCtx, reportId);
            MobileTemplateUtil.installExtMobileRptScheduleDefine(this.easCtx, reportId, mobileTypeId, publishName, report.getContent());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ExtRptBizException.newFailed2PublishCloudRpts2MobileException(e);
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    private int getLicenseType(boolean isMobileTemple) {
        if (isMobileTemple) {
            return 2;
        }
        EXTLicenseService srsv = new EXTLicenseService(this.easCtx);
        int licenseType = 0;
        try {
            licenseType = srsv.sysLicenseModuleType();
        }
        catch (EXTLicenseException eXTLicenseException) {
            // empty catch block
        }
        if (licenseType != 1) {
            licenseType = 2;
        }
        return licenseType;
    }

    private void insertMenu(MainMenuItemInfo mi, String deployPath, String reportId, Integer licenseStrategy) throws BOSException, EASBizException {
        IMainMenuItem menu = MainMenuItemFactory.getLocalInstance((Context)this.easCtx);
        IObjectPK menuPk = menu.addnew((CoreBaseInfo)mi);
        StringBuffer sqlBuf = new StringBuffer("update T_BAS_DEFINEREPORT set FdeployPath = ?, FMenuID = ?, FMenuUi = ?");
        if (licenseStrategy != null) {
            sqlBuf.append(",FLicenseStrategy = ?");
        }
        sqlBuf.append(" where fid = ?");
        ArrayList<Object> queryValue = new ArrayList<Object>();
        queryValue.add(deployPath);
        queryValue.add(menuPk.toString());
        queryValue.add(mi.getUiClassName());
        if (licenseStrategy != null) {
            queryValue.add(licenseStrategy);
        }
        queryValue.add(reportId);
        ExtDBUtil.maintainRecord(this.easCtx, sqlBuf.toString(), queryValue);
    }

    private void refreshMenu() {
        RptParams params = new RptParams();
        params.setString("FullName", EASAppCenterTreeFacade.class.getName());
        params.setString("MethodName", "refreshPortalMenu");
        try {
            ReportFacadeFactory.getLocalInstance(this.easCtx).commonExecute(params);
            LicenseBo.updateCacheSpareCount(this.easCtx);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        try {
            String flastupdatetime = CtrlReportUtil.getToDay();
            MainFunctionMenuFactory.getLocalInstance((Context)this.easCtx).updateMenuCache(flastupdatetime);
            MenuCacheFactory.getLocalInstance((Context)this.easCtx).updateAllMenuCache();
        }
        catch (EASBizException ex) {
            logger.error((Object)"\u66f4\u65b0\u83dc\u5355\u7f13\u5b58", (Throwable)ex);
        }
        catch (BOSException ex) {
            logger.error((Object)"\u66f4\u65b0\u83dc\u5355\u7f13\u5b58", (Throwable)ex);
        }
    }

    public Context getContext() {
        return this.easCtx;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public BOSObjectType getType() {
        return new BOSObjectType("326B333E2WW");
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return this;
    }
}

