/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.adapter;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.adapter.IFilter;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.tree.TreePath;

public class TreeManager {
    IFilter reportUI;
    String systemID;
    public static String filter_name = "name";
    public static String filter_alias = "alias";
    public static String filter_f7 = "F7";
    public static String filter_systemID = "systemID";

    public TreeManager(IFilter reportUI) {
        this.reportUI = reportUI;
    }

    public void expandExtTreeSelected(KDTree kDTree1, String systemID) {
        this.systemID = systemID;
        String preSystemID = this.reportUI.getSystemID();
        if (null != preSystemID && preSystemID.equals(systemID)) {
            return;
        }
        if (systemID.length() <= 0) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)kDTree1.getModel().getRoot();
        this.expandSelected(kDTree1, root, systemID);
        this.reportUI.setSystemID(systemID);
    }

    private boolean expandSelected(KDTree kDTree1, DefaultKingdeeTreeNode nodeRoot, String selectedPath) {
        boolean flag = true;
        Enumeration enume = nodeRoot.children();
        while (enume.hasMoreElements()) {
            DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
            Object userObject = repNode.getUserObject();
            if (!(userObject instanceof IBriefViewTreeNode)) continue;
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)userObject;
            if (bvNode.getFullName().equals(selectedPath)) {
                boolean isExtend = false;
                Enumeration enumeLeaf = repNode.children();
                while (enumeLeaf.hasMoreElements()) {
                    DefaultKingdeeTreeNode repNodeLeaf = (DefaultKingdeeTreeNode)enumeLeaf.nextElement();
                    Object userObjectLeaf = repNodeLeaf.getUserObject();
                    if (!(userObjectLeaf instanceof String) || !userObjectLeaf.toString().equals(this.reportUI.getTableFlag())) continue;
                    Object[] pathtoRoot = repNodeLeaf.getPath();
                    TreePath path = new TreePath(pathtoRoot);
                    this.reportUI.setStopChange(true);
                    kDTree1.expandPath(path);
                    kDTree1.setSelectionPath(path);
                    kDTree1.scrollPathToVisible(path);
                    isExtend = true;
                    break;
                }
                if (!isExtend) {
                    Object[] pathtoRoot = repNode.getPath();
                    TreePath path = new TreePath(pathtoRoot);
                    this.reportUI.setStopChange(true);
                    kDTree1.expandPath(path);
                    kDTree1.setSelectionPath(path);
                    kDTree1.scrollPathToVisible(path);
                }
                flag = false;
                break;
            }
            flag = this.expandSelected(kDTree1, repNode, selectedPath);
            if (flag) continue;
            break;
        }
        return flag;
    }

    public static boolean treeSelected(KDTree kDTree1, DefaultKingdeeTreeNode nodeRoot, String tableFlag, String selectedTreeNode) {
        if (CtrlReportUtil.getObjectString(selectedTreeNode).equals("")) {
            return false;
        }
        boolean flag = true;
        Enumeration enume = nodeRoot.children();
        while (enume.hasMoreElements()) {
            DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
            Object userObject = repNode.getUserObject();
            if (!(userObject instanceof IBriefViewTreeNode)) continue;
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)userObject;
            if (bvNode.getFullName().equals(selectedTreeNode)) {
                boolean isExtend = false;
                Enumeration enumeLeaf = repNode.children();
                while (enumeLeaf.hasMoreElements()) {
                    DefaultKingdeeTreeNode repNodeLeaf = (DefaultKingdeeTreeNode)enumeLeaf.nextElement();
                    Object userObjectLeaf = repNodeLeaf.getUserObject();
                    if (!(userObjectLeaf instanceof String) || !userObjectLeaf.toString().equals(tableFlag)) continue;
                    Object[] pathtoRoot = repNodeLeaf.getPath();
                    TreePath path = new TreePath(pathtoRoot);
                    kDTree1.expandPath(path);
                    kDTree1.setSelectionPath(path);
                    kDTree1.scrollPathToVisible(path);
                    isExtend = true;
                    break;
                }
                if (!isExtend) {
                    Object[] pathtoRoot = repNode.getPath();
                    TreePath path = new TreePath(pathtoRoot);
                    kDTree1.expandPath(path);
                    kDTree1.setSelectionPath(path);
                    kDTree1.scrollPathToVisible(path);
                }
                flag = false;
                break;
            }
            flag = TreeManager.treeSelected(kDTree1, repNode, tableFlag, selectedTreeNode);
            if (flag) continue;
            break;
        }
        return flag;
    }

    public static final void filterTree(ArrayList lstData, IBriefViewTreeNode root, HashMap mapFilter) throws Exception {
        MetaDataBriefInfo info;
        String filterSystemID = CtrlReportUtil.getObjectString(mapFilter.get(filter_systemID));
        if (filterSystemID.equals("") && (info = root.getMetaDataObjectBriefInfo()) != null && null != info.getFullName()) {
            TreeManager.filterNode(lstData, root, mapFilter, info.getFullName());
        }
        Enumeration enu = root.children();
        while (enu.hasMoreElements()) {
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)enu.nextElement();
            MetaDataBriefInfo info2 = bvNode.getMetaDataObjectBriefInfo();
            if (!filterSystemID.equals("")) {
                if (info2 != null && info2.getFullName().equals(filterSystemID)) {
                    TreeManager.filterNode(lstData, bvNode, mapFilter, info2.getFullName());
                    break;
                }
                TreeManager.filterTree(lstData, bvNode, mapFilter);
                continue;
            }
            TreeManager.filterTree(lstData, bvNode, mapFilter);
        }
    }

    private static final void filterNode(ArrayList lstData, IBriefViewTreeNode ibf, HashMap mapFilter, String parentSystemID) throws Exception {
        String name = CtrlReportUtil.getObjectString(mapFilter.get(filter_name)).toLowerCase();
        String alias = CtrlReportUtil.getObjectString(mapFilter.get(filter_alias)).toLowerCase();
        boolean F7 = new Boolean(CtrlReportUtil.getObjectString(mapFilter.get(filter_systemID)));
        Locale locale = SysContext.getSysContext().getLocale();
        MetaDataBriefInfo info = null;
        Enumeration enu = ibf.children();
        while (enu.hasMoreElements()) {
            boolean isHidden;
            IBriefViewTreeNode ibf1 = (IBriefViewTreeNode)enu.nextElement();
            if (ibf1.isPackage()) continue;
            info = ibf1.getMetaDataObjectBriefInfo();
            boolean isNameHidden = false;
            boolean isAliasHidden = false;
            boolean isF7Hidden = false;
            String nodeName = CtrlReportUtil.getObjectString(ibf1.getName()).toLowerCase();
            String nodeAlias = CtrlReportUtil.getObjectString(ibf1.getAlias()).toLowerCase();
            nodeAlias = nodeAlias + " [" + nodeName + "]";
            if (name.length() > 0 && nodeName.indexOf(name) == -1) {
                isNameHidden = true;
            }
            if (alias.length() > 0 && nodeAlias.indexOf(alias) == -1) {
                isAliasHidden = true;
            }
            if (F7 && (nodeName.indexOf("f7") != -1 || nodeAlias.indexOf("f7") != -1)) {
                isF7Hidden = true;
            }
            if (isHidden = isNameHidden || isAliasHidden || isF7Hidden) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            String fid = info.getFullName();
            String currentName = CtrlReportUtil.getObjectString(info.getName());
            String currentAlias = CtrlReportUtil.getObjectString(info.getAlias(locale));
            if ("".equals(currentAlias)) {
                // empty if block
            }
            if ("".equals(currentAlias = CtrlReportUtil.getObjectString(info.getAlias(locale = SysContext.getSysContext().getOriginLocale())))) {
                currentAlias = currentName;
            }
            currentAlias = currentAlias + " [" + currentName + "]";
            map.put("fid", fid);
            map.put("fname", currentAlias);
            map.put("fsystemid", parentSystemID);
            lstData.add(map);
        }
    }
}

