/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.audittool;

import com.kingdee.bos.ctrl.kdf.table.CellTreeNode;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.NodeClickListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.eas.rpts.ctrlreport.audittool.DeployRptStat;
import com.kingdee.eas.rpts.ctrlreport.audittool.IReportAudit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class ReportAuditPanel
extends KDSplitPane {
    private KDTree reportTree;
    private IReportAudit extAudit;
    private KDTable table;
    private int orgIsolate = 1;
    private KDPanel toolPanel;

    public ReportAuditPanel(IReportAudit extAudit, int type, KDPanel toolPanel) {
        this.extAudit = extAudit;
        this.toolPanel = toolPanel;
        this.init();
        this.initReportTree(type, this.orgIsolate);
        this.initListeners();
    }

    private void init() {
        KDTreeView treeView = new KDTreeView();
        treeView.setShowButton(false);
        treeView.setMinimumSize(new Dimension(50, treeView.getHeight()));
        this.reportTree = new KDTree();
        this.reportTree.setShowCheckBox(false);
        this.reportTree.setRootVisible(true);
        treeView.setTree(this.reportTree);
        KDPanel containPanel = new KDPanel();
        containPanel.setLayout((LayoutManager)new BorderLayout());
        containPanel.add("North", (Component)this.toolPanel);
        containPanel.add("Center", (Component)treeView);
        this.table = new KDTable();
        this.table.getSelectManager().setSelectMode(2);
        this.table.addColumns(7);
        this.table.getColumn(0).setWidth(150);
        this.table.getColumn(4).setWidth(200);
        IRow headRow = this.table.addHeadRow();
        headRow.getCell(0).setValue((Object)"\u7edf\u8ba1\u65e5\u671f");
        headRow.getCell(1).setValue((Object)"\u64cd\u4f5c");
        headRow.getCell(2).setValue((Object)"\u6267\u884c\u8017\u65f6(ms)");
        headRow.getCell(3).setValue((Object)"\u6267\u884c\u8d26\u53f7");
        headRow.getCell(4).setValue((Object)"\u6267\u884c\u8def\u5f84");
        headRow.getCell(5).setValue((Object)"\u5f53\u5929\u67e5\u770b\u6b21\u6570");
        headRow.getCell(6).setValue((Object)"\u7d2f\u8ba1\u67e5\u770b\u6b21\u6570");
        this.setLeftComponent((Component)containPanel);
        this.setRightComponent((Component)this.table);
        this.setDividerLocation(220);
    }

    private void initReportTree(int type, int orgIsolat) {
        if (this.extAudit != null) {
            this.extAudit.initReportTree(this.reportTree, type, orgIsolat);
        }
    }

    public void refreshRptsTree(int type, int orgIsolat) {
        this.initReportTree(type, orgIsolat);
    }

    private void initListeners() {
        this.reportTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)ReportAuditPanel.this.reportTree.getLastSelectedPathComponent();
                ReportAuditPanel.this.table.removeRows();
                if (selectedNode != null && !selectedNode.isRoot() && selectedNode.isLeaf()) {
                    ReportAuditPanel.this.setTableData(ReportAuditPanel.this.extAudit.queryRptAuditSum((ITreeNode)selectedNode));
                }
            }
        });
    }

    private void setTableData(List statResult) {
        NodeClickListener nodeClickListener = new NodeClickListener(){

            public void doClick(CellTreeNode source, ICell cell, int type) {
                if (!source.isCollapse() && source.isVirtualModel()) {
                    DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)ReportAuditPanel.this.reportTree.getLastSelectedPathComponent();
                    ReportAuditPanel.this.setTableDetail(ReportAuditPanel.this.extAudit.queryRptAuditDetail((ITreeNode)selectedNode, cell.getValue().toString()), cell.getRowIndex());
                    source.setVirtualModel(false);
                }
            }
        };
        int size = statResult.size();
        for (int i = 0; i < size; ++i) {
            DeployRptStat stat = (DeployRptStat)statResult.get(i);
            IRow row = this.table.addRow();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            CellTreeNode node = new CellTreeNode();
            node.addClickListener(nodeClickListener);
            node.setValue((Object)format.format(stat.getStatDate()));
            node.setHasChildren(true);
            node.setCollapse(true);
            node.setTreeLevel(0);
            node.setVirtualModel(true);
            row.getCell(0).setValue((Object)node);
            row.getCell(5).setValue((Object)new Integer(stat.getViews()));
            row.getCell(6).setValue((Object)new Integer(stat.getAllViews()));
        }
    }

    private void setTableDetail(List statResult, int clickRowIndex) {
        int size = statResult.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.table.addRow(++clickRowIndex);
            DeployRptStat stat = (DeployRptStat)statResult.get(i);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            CellTreeNode node = new CellTreeNode();
            node.setValue((Object)format.format(stat.getStatDate()));
            node.setHasChildren(false);
            node.setTreeLevel(1);
            row.getCell(0).setValue((Object)node);
            row.getCell(1).setValue((Object)stat.getType());
            row.getCell(2).setValue((Object)new Integer(stat.getExecuteTime()));
            row.getCell(3).setValue((Object)stat.getExecutor());
            row.getCell(4).setValue((Object)stat.getExecutePath());
        }
    }
}

