/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.bo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.base.uiframe.MenuCacheFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.CloudReportAuthBaseFactory;
import com.kingdee.eas.rpts.ctrlreport.CloudReportAuthBaseInfo;
import com.kingdee.eas.rpts.ctrlreport.CloudReportAuthCollection;
import com.kingdee.eas.rpts.ctrlreport.CloudReportAuthInfo;
import com.kingdee.eas.rpts.ctrlreport.ICloudReportAuthBase;
import com.kingdee.eas.rpts.ctrlreport.bo.PermissionBO;
import com.kingdee.eas.rpts.ctrlreport.data.CloudReportAuthVO;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.rpts.statistics.util.ServiceUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class CloudReportAuthBO {
    public static final String RPT_PERMITEM = "036cd666-e8d6-45d1-a45c-929a1dda08dcPERMITEM";
    public static final String MOBILERPT_PERMITEM = "3b56909c-5352-4f54-a36f-a06a3f174653PERMITEM";
    public static final int AUTH_ALL = 0;
    public static final int AUTH_PART = 1;
    public static final int AUTH_NONE = 2;

    public static String saveCloudReportAuthInfo(Context ctx, List<String> reportIds) throws BOSException, EASBizException {
        if (reportIds == null || reportIds.isEmpty()) {
            return null;
        }
        CloudReportAuthBaseInfo baseInfo = new CloudReportAuthBaseInfo();
        CloudReportAuthCollection authCollection = baseInfo.getCloudReportAuth();
        for (String reportId : reportIds) {
            CloudReportAuthInfo authInfo = new CloudReportAuthInfo();
            authInfo.setReportId(BOSUuid.read((String)reportId));
            authCollection.add(authInfo);
        }
        if (authCollection.isEmpty()) {
            return null;
        }
        ICloudReportAuthBase authBase = ctx == null ? CloudReportAuthBaseFactory.getRemoteInstance() : CloudReportAuthBaseFactory.getLocalInstance(ctx);
        IObjectPK pk = authBase.addnew(baseInfo);
        String baseInfoId = pk.toString();
        return baseInfoId;
    }

    public static String[] getReportToolAuthUserIds(Context ctx, String authId) throws BOSException {
        String sqlRpt = "select distinct fid, ftemplettype tempType from t_bas_definereport where fid in(select freportid from t_ext_cloudReportAuth where fcloudReportAuthBaseId=?)";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(authId);
        ArrayList tempTypes = ExtDBUtil.getResultListBySql1(ctx, sqlRpt, queryValue);
        boolean hasNormal = false;
        boolean hasMobile = false;
        for (Object mapType : tempTypes) {
            int type = Integer.valueOf(String.valueOf(((HashMap)mapType).get("temptype")));
            if (type == -1) {
                hasNormal = true;
                continue;
            }
            if (type != 2) continue;
            hasMobile = true;
        }
        String permItem = null;
        if (!hasNormal && !hasMobile) {
            return null;
        }
        permItem = "'036cd666-e8d6-45d1-a45c-929a1dda08dcPERMITEM','3b56909c-5352-4f54-a36f-a06a3f174653PERMITEM'";
        String sql = "select distinct fowner userid from T_PM_USERORGPERM where FPERMITEMID in(" + permItem + ")";
        String sql1 = "select distinct ur.fuserid userid from T_PM_ROLEPERM r left join T_PM_USERROLEORG ur on r.froleid = ur.froleid where r.FPERMITEMID in(" + permItem + ")";
        sql = "select distinct userid from (" + sql + " union " + sql1 + ") as tempUser";
        ArrayList userIds = ExtDBUtil.getResultListBySql1(ctx, sql, null);
        String[] userIdArr = new String[userIds.size()];
        int i = 0;
        for (Object mapIds : userIds) {
            userIdArr[i] = (String)((HashMap)mapIds).get("userid");
            ++i;
        }
        return userIdArr;
    }

    public static CloudReportAuthVO getCloudReportAuthUser(Context ctx, String authId) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select u.fid userId, u.fname_l2 userName,");
        sbSQL.append("authBase.fcreatetime createTime, authBase.flastupdatetime lastupdatetime,");
        sbSQL.append("u.fofficephone telNumber, org.fname_l2 orgName ");
        sbSQL.append("from T_EXT_CloudReportAuthBase authBase ");
        sbSQL.append("left join t_pm_user u on authBase.fcreatorid = u.fid ");
        sbSQL.append("left join t_org_admin org on org.fid = u.fcontrolunitid ");
        sbSQL.append("where authBase.fid = ? ");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(authId);
        ArrayList resultList = ExtDBUtil.getResultListBySql(ctx, sbSQL.toString(), queryValue);
        Iterator iterResult = resultList.iterator();
        CloudReportAuthVO vo = null;
        while (iterResult.hasNext()) {
            vo = new CloudReportAuthVO();
            HashMap mapResult = (HashMap)iterResult.next();
            vo.setAuthId(authId);
            vo.setUserId((String)mapResult.get("userid"));
            vo.setUserName((String)mapResult.get("username"));
            vo.setTelNumber((String)mapResult.get("telnumber"));
            vo.setOrgName((String)mapResult.get("orgname"));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = null;
            try {
                date = format.parse(((Timestamp)mapResult.get("createtime")).toString());
                vo.setCreateTime(format.format(date));
                date = format.parse(((Timestamp)mapResult.get("lastupdatetime")).toString());
                vo.setLastUpdateTime(format.format(date));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return vo;
    }

    public static List<CloudReportAuthVO> getCloudReportAuth(Context ctx, String authId) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select rpt.fid reportId, ");
        sbSQL.append("rpt.fname_l2 reportName, rpt.ftemplettype templateType, p.fpermission permission ");
        sbSQL.append("from T_EXT_CloudReportAuthBase authBase ");
        sbSQL.append("left join T_EXT_CloudReportAuth auth on authBase.fid = auth.fcloudreportauthbaseid ");
        sbSQL.append("left join t_bas_definereport rpt on auth.freportid = rpt.fid ");
        sbSQL.append("left join T_EXT_Permission p on p.freportid = rpt.fid and authBase.fcreatorid = p.fuserid ");
        sbSQL.append("where authBase.fid = ? ");
        sbSQL.append("order by rpt.ftemplettype ");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(authId);
        ArrayList resultList = ExtDBUtil.getResultListBySql(ctx, sbSQL.toString(), queryValue);
        Iterator iterResult = resultList.iterator();
        CloudReportAuthVO vo = null;
        ArrayList<CloudReportAuthVO> voList = new ArrayList<CloudReportAuthVO>();
        while (iterResult.hasNext()) {
            vo = new CloudReportAuthVO();
            HashMap mapResult = (HashMap)iterResult.next();
            String rptId = (String)mapResult.get("reportid");
            if (StringUtil.isEmptyString((String)rptId)) break;
            vo.setReportId(rptId);
            vo.setReportName((String)mapResult.get("reportname"));
            Object obj = mapResult.get("templatetype");
            if (obj != null) {
                int tempType = Integer.valueOf(String.valueOf(obj));
                vo.setTemplateType(tempType);
            }
            vo.setPermission((String)mapResult.get("permission"));
            voList.add(vo);
        }
        return voList;
    }

    public static void updateCloudReportAuth(Context ctx, List<CloudReportAuthVO> listVo) throws BOSException {
        if (listVo == null || listVo.isEmpty()) {
            return;
        }
        String regex = "\\?";
        ArrayList<String> sqlList = new ArrayList<String>();
        for (CloudReportAuthVO vo : listVo) {
            String sqlPerm;
            String perm = vo.getPermission();
            if (!StringUtil.isEmptyString((String)perm) && perm.startsWith("0;0;0")) {
                String sqlDelete = "delete from T_EXT_Permission where freportid='?' and fuserid='?';";
                sqlDelete = sqlDelete.replaceFirst(regex, vo.getReportId()).replaceFirst(regex, vo.getUserId());
                sqlList.add(sqlDelete);
                continue;
            }
            String sqlQuery = "select fuserid from T_EXT_Permission where fuserid=? and freportid=?;";
            ArrayList<String> queryValue = new ArrayList<String>();
            queryValue.add(vo.getUserId());
            queryValue.add(vo.getReportId());
            ArrayList valueList = ExtDBUtil.getResultListBySql(ctx, sqlQuery, queryValue);
            if (valueList != null && !valueList.isEmpty()) {
                sqlPerm = "update T_EXT_Permission set fpermission='?' where fuserid='?' and freportid='?';";
                sqlPerm = sqlPerm.replaceFirst(regex, perm).replaceFirst(regex, vo.getUserId()).replaceFirst(regex, vo.getReportId());
            } else {
                sqlPerm = "insert into T_EXT_Permission(fuserid,freportid,fpermission,fpermissiontype) values('?','?','?',2);";
                sqlPerm = sqlPerm.replaceFirst(regex, vo.getUserId()).replaceFirst(regex, vo.getReportId()).replaceFirst(regex, perm);
            }
            sqlList.add(sqlPerm);
        }
        ExtDBUtil.executeBatch(ctx, sqlList);
        CloudReportAuthVO vo = listVo.get(0);
        CloudReportAuthBO.updateAuthTime(ctx, vo);
        CloudReportAuthBO.refreshCache(ctx);
    }

    private static void refreshCache(Context ctx) {
        try {
            if (ctx == null) {
                MainFunctionMenuFactory.getRemoteInstance().updateMenuCache("");
                MenuCacheFactory.getRemoteInstance().updateAllMenuCache();
            } else {
                MainFunctionMenuFactory.getLocalInstance((Context)ctx).updateMenuCache("");
                MenuCacheFactory.getLocalInstance((Context)ctx).updateAllMenuCache();
            }
            PermissionBO.clearClientUserPermission();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void updateAuthTime(Context ctx, CloudReportAuthVO vo) throws BOSException {
        Timestamp time;
        String sqlUpdate = "update T_EXT_CloudReportAuthBase set flastUpdateUserId=?, flastUpdateTime=? where fid=?;";
        String lastUpdateUserId = vo.getLastUpdateUserId();
        if (StringUtil.isEmptyString((String)lastUpdateUserId) && ctx != null) {
            lastUpdateUserId = ctx.getCaller().toString();
        }
        if (ctx != null) {
            time = new Timestamp(new Date().getTime());
        } else {
            RptParams pr = new RptParams();
            pr.setString("MethodName", "getInfoFromServer");
            try {
                RptParams ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
                time = new Timestamp(((Date)ps_r.getObject("Date")).getTime());
            }
            catch (BOSException e) {
                time = new Timestamp(new Date().getTime());
            }
        }
        ArrayList<Object> updateValues = new ArrayList<Object>();
        updateValues.add(lastUpdateUserId);
        updateValues.add(time);
        updateValues.add(vo.getAuthId());
        ExtDBUtil.maintainRecord(ctx, sqlUpdate, updateValues);
    }

    public static boolean hasCloudReportAuth(Context ctx, String reportid, String userId) {
        List listUserPermission = Collections.EMPTY_LIST;
        String sqlPart1 = "select distinct p.FReportID, p.fpermission, r.FMenuID, r.FEasWebAppMenuId, r.FEasWebAppCenterId from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r on p.FReportID=r.fid where r.Fid =? and p.FUserID = ? and p.FOrgID in (";
        String sqlPart2 = " ) union all select distinct p.FReportID, p.fpermission, r.FMenuID, r.FEasWebAppMenuId, r.FEasWebAppCenterId from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r on p.FReportID=r.fid where  r.Fid =? and p.FUserID = ? and p.FOrgID is null  union all select distinct p.FReportID, p.fpermission, r.FMenuID, r.FEasWebAppMenuId, r.FEasWebAppCenterId from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r on p.FReportID=r.fid where  r.Fid =? and p.froleid is not null and p.froleid in (select froleid from  t_pm_userroleorg uro where uro.FUserID = ? and uro.FOrgID in ( ";
        String sqlPart3 = " ))";
        try {
            ObjectUuidPK currentUserPK = new ObjectUuidPK(userId);
            String orgRangeSQL = PermissionRangeHelper.getUserOrgIdRangeSQL((Context)ctx, (IObjectPK)currentUserPK, (OrgRangeType)OrgRangeType.BIZ_ORG_TYPE);
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append(sqlPart1).append(orgRangeSQL).append(sqlPart2).append(orgRangeSQL).append(sqlPart3);
            ArrayList<String> queryValue = new ArrayList<String>();
            queryValue.add(reportid);
            queryValue.add(userId);
            queryValue.add(reportid);
            queryValue.add(userId);
            queryValue.add(reportid);
            queryValue.add(userId);
            listUserPermission = ExtDBUtil.getResultListBySql(ctx, sqlBuffer.toString(), queryValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !listUserPermission.isEmpty();
    }

    public static boolean hasDemoAuthByCloudRptId(Context ctx, String cloudReportId, String userId) {
        ArrayList<Object> queryValues = new ArrayList<Object>();
        queryValues.add(cloudReportId);
        queryValues.add(userId);
        String sql = "SELECT crdl.* FROM T_EXT_CloudReportDownloadList crdl  LEFT JOIN (select * from t_bas_definereport where FCloudRptVersion IS NOT NULL ) rpt ON crdl.FCloudRptId = rpt.FCloudRptCenterId   WHERE rpt.FID is not NULL AND crdl.FCloudRptId = ? AND crdl.FUserId = ? ";
        try {
            IRowSet rowSet = ServiceUtil.DBUtil.executeQuery(ctx, sql, queryValues);
            if (rowSet.next()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean hasDemoAuthByRptId(Context ctx, String reportId, String userId) {
        ArrayList<Object> queryValues = new ArrayList<Object>();
        queryValues.add(reportId);
        queryValues.add(userId);
        String sql = "select crdl.* from T_EXT_CloudReportDownloadList crdl left join (select * from t_bas_definereport where FCloudRptVersion IS NOT NULL ) rpt on crdl.FCloudRptId=rpt.FCloudRptCenterId where rpt.FID=? and crdl.FUserId = ?";
        try {
            IRowSet rowSet = ServiceUtil.DBUtil.executeQuery(ctx, sql, queryValues);
            if (rowSet.next()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static void deleteDemoAuth(Context ctx, String cloudReportId, String userId) {
        String sql = "delete from T_EXT_CloudReportDownloadList where FCloudRptId=? and FUserId = ?";
        try {
            ServiceUtil.DBUtil.executeMaintainRecord(ctx, sql, cloudReportId, userId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void insertDemoAuth(Context ctx, String cloudReportId, String userId) {
        String id = UUID.randomUUID().toString();
        ArrayList<Object> queryValues = new ArrayList<Object>();
        queryValues.add(cloudReportId);
        queryValues.add(userId);
        String sql = "select 1 from T_EXT_CloudReportDownloadList where FCloudRptId=? and FUserId = ?";
        try {
            IRowSet rowSet = ServiceUtil.DBUtil.executeQuery(ctx, sql, queryValues);
            if (!rowSet.next()) {
                sql = "insert into T_EXT_CloudReportDownloadList(Fid,FCloudRptId,FUserId) values(?,?,?)";
                ServiceUtil.DBUtil.executeMaintainRecord(ctx, sql, id, cloudReportId, userId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean hasReportToolAuth(Context ctx, String userId) throws BOSException {
        return CloudReportAuthBO.hasReportToolAuth(ctx, userId, RPT_PERMITEM);
    }

    public static boolean hasMobileReportToolAuth(Context ctx, String userId) throws BOSException {
        String sql = "select 1 from T_PM_PermItem where fid =?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(MOBILERPT_PERMITEM);
        ArrayList valueList = ExtDBUtil.getResultListBySql(ctx, sql, queryValue);
        if (valueList == null || valueList.isEmpty()) {
            return false;
        }
        return CloudReportAuthBO.hasReportToolAuth(ctx, userId, MOBILERPT_PERMITEM);
    }

    private static boolean hasReportToolAuth(Context ctx, String userId, String permItem) throws BOSException {
        String sql = "select 1 from t_pm_userorgperm where fowner=? and fpermitemid=? and fpermtype=?";
        ArrayList<Object> queryValue = new ArrayList<Object>();
        queryValue.add(userId);
        queryValue.add(permItem);
        queryValue.add(10);
        ArrayList valueList = ExtDBUtil.getResultListBySql(ctx, sql, queryValue);
        if (valueList != null && !valueList.isEmpty()) {
            return true;
        }
        sql = "select 1 from T_PM_USERROLEORG ur left join t_pm_roleperm r on ur.froleid = r.froleid where fuserid=? and r.fpermitemid=? and fpermtype=?";
        valueList = ExtDBUtil.getResultListBySql(ctx, sql, queryValue);
        return valueList != null && !valueList.isEmpty();
    }

    public static String getAuthIdByAssignId(Context ctx, String assignId) {
        String sql = "select fbizobjid from t_wfr_assign where fassignid = ?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(assignId);
        ArrayList resultList = null;
        try {
            resultList = ExtDBUtil.getResultListBySql(ctx, sql, queryValue);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (resultList != null && !resultList.isEmpty()) {
            return (String)((HashMap)resultList.get(0)).get("fbizobjid");
        }
        sql = "select fbizobjid from T_WFR_ASSIGNVIEW where fassignid = ?";
        try {
            resultList = ExtDBUtil.getResultListBySql(ctx, sql, queryValue);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (resultList != null && !resultList.isEmpty()) {
            return (String)((HashMap)resultList.get(0)).get("fbizobjid");
        }
        return null;
    }

    public static int getStatusOfReportAuth(Context ctx, String userId, String authId) {
        String sql = "select freportid from T_EXT_CloudReportAuth where fcloudreportauthbaseid=?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(authId);
        ArrayList resultList = null;
        try {
            resultList = ExtDBUtil.getResultListBySql1(ctx, sql, queryValue);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (resultList != null && !resultList.isEmpty()) {
            int applySize = resultList.size();
            StringBuffer rptIdBuf = new StringBuffer("'");
            for (int i = 0; i < applySize; ++i) {
                String rptId = (String)((HashMap)resultList.get(i)).get("freportid");
                rptIdBuf.append(rptId).append("'");
                if (i >= applySize - 1) continue;
                rptIdBuf.append(",'");
            }
            sql = "select freportid from t_ext_permission where fuserId=? and freportId in ('?')";
            sql = sql.replaceFirst("'\\?'", rptIdBuf.toString());
            queryValue = new ArrayList();
            queryValue.add(userId);
            try {
                resultList = ExtDBUtil.getResultListBySql1(ctx, sql, queryValue);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (resultList != null && !resultList.isEmpty()) {
                int authedSize = resultList.size();
                if (authedSize == 0) {
                    return 2;
                }
                if (applySize > authedSize) {
                    return 1;
                }
                if (applySize == authedSize) {
                    return 0;
                }
            }
        }
        return 2;
    }
}

