/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.bo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.behavior.ExtReportUserBehaviorUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.MenuCacheFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.DefineReportFactory;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.IDefineReport;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.rpts.ctrlreport.client.CtrlReportDiscreteDataSelector;
import com.kingdee.eas.rpts.ctrlreport.client.DeployBatchUI;
import com.kingdee.eas.rpts.ctrlreport.client.EditBatchUI;
import com.kingdee.eas.rpts.ctrlreport.client.ReportAttemperSetupUI;
import com.kingdee.eas.rpts.ctrlreport.data.PublishType;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.model.ExtCallbackImpl;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtContextUtils;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.rpts.snapshot.dispatch.client.ReportDispatchUI;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefineReportBO {
    private static Logger log = LogUtil.getPackageLogger(DefineReportBO.class);

    public static final ArrayList getDefineReporListBySystemID(String systemID, boolean withoutOrg) throws BOSException, SQLException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(systemID);
        if (!withoutOrg) {
            queryValue.add(strOrgID);
            queryValue.add("qUvvbL4yQsyQYFIDSlvngID2+FI=");
        }
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.forgtype, d.fsnaptype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FsystemID, d.ftemplettype,d.FLICENSESTRATEGY,");
        sbSQL.append("d.FPortletName,d.FPortletID, ");
        sbSQL.append("d.FMobileName,d.FMobileTypeId,d.FPubAcctId,m.fname as fmobileTypeName, pu.fpubacctname,");
        sbSQL.append("d.feaswebappcenterid,d.feaswebappcenterpath, ");
        sbSQL.append("d.fdeploypath,d.fmenuid,d.FMenuUi, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime, d.fisdeploy,d.FCloudRptCenterId ");
        sbSQL.append("from T_BAS_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("LEFT OUTER JOIN t_ext_mobileType m on d.fmobiletypeid=m.fid ");
        sbSQL.append("LEFT OUTER JOIN T_EXT_XUNT_PUBACCT pu on d.fpubacctid=pu.fid ");
        sbSQL.append("where d.FsystemID = ? ");
        if (!withoutOrg) {
            sbSQL.append("and (d.FOrgID = ? or d.FOrgID = ?)");
        }
        sbSQL.append("order by d.flastupdatetime desc");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static final ArrayList getDeployedReportListBySystemID(String systemID, boolean withoutOrg) throws BOSException, SQLException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(systemID);
        if (!withoutOrg) {
            queryValue.add(strOrgID);
            queryValue.add("qUvvbL4yQsyQYFIDSlvngID2+FI=");
        }
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.forgtype, d.fsnaptype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FsystemID, d.ftemplettype,d.FLICENSESTRATEGY,d.FPortletName,d.FPortletID, ");
        sbSQL.append("d.FMobileName,d.feaswebappcenterid,d.feaswebappcenterpath, m.fname as fmobileTypeName, pu.fpubacctname, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime, d.fisdeploy, d.fdeploypath, d.fmenuid, d.FMenuUi ");
        sbSQL.append("from T_BAS_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("LEFT OUTER JOIN t_ext_mobileType m on d.fmobiletypeid=m.fid ");
        sbSQL.append("LEFT OUTER JOIN T_EXT_XUNT_PUBACCT pu on d.fpubacctid=pu.fid ");
        sbSQL.append("where d.fpubacctid = ? ");
        if (!withoutOrg) {
            sbSQL.append("and (d.FOrgID = ? or d.FOrgID = ?) ");
        }
        sbSQL.append("and (d.fdeploypath is not null or d.FPortletID is not null or d.FBIPath is not null or d.feaswebappcenterid is not null or pu.fpubacctname is not null)");
        sbSQL.append("order by d.flastupdatetime desc");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static final ArrayList getPermDefineReporListBySystemID(String systemID) throws BOSException, SQLException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(systemID);
        queryValue.add(userId);
        queryValue.add(orgId);
        queryValue.add(userId);
        queryValue.add(userId);
        queryValue.add(orgId);
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" select d.fid, d.forgtype, d.fsnaptype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FsystemID, d.ftemplettype,d.FLICENSESTRATEGY, ");
        sbSQL.append(" org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append(" d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append(" u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append(" d.fcreatorid, d.flastupdatetime, d.fisdeploy, d.fdeploypath, d.fmenuid, d.FMenuUi ");
        sbSQL.append(" from T_BAS_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append(" LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append(" where d.FsystemID = ?  and (fmenuid is not null or fbipath is not null or (fportletid is not null and fportletname is not null) or feaswebappcenterid is not null) and d.fid in ( ");
        sbSQL.append(" select p.FReportID from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r ");
        sbSQL.append(" on p.FReportID = r.fid where p.FUserID = ? and p.FOrgID = ? ");
        sbSQL.append(" union all select p.FReportID from T_EXT_Permission p");
        sbSQL.append(" INNER JOIN T_BAS_DefineReport r on p.FReportID = r.fid where p.FUserID = ? ");
        sbSQL.append(" and p.FOrgID is null ");
        sbSQL.append(" union all select p.FReportID ");
        sbSQL.append(" from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r ");
        sbSQL.append(" on p.FReportID = r.fid INNER JOIN t_pm_userroleorg uro ON p.froleid = uro.froleid");
        sbSQL.append(" where uro.FUserID = ? and uro.FOrgID = ? )");
        sbSQL.append(" order by d.flastupdatetime desc");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static final ArrayList getDeployPortalListByPath(String path) throws BOSException, SQLException {
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(path);
        queryValue.add(strOrgID);
        queryValue.add("qUvvbL4yQsyQYFIDSlvngID2+FI=");
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.FPortalAliasName as portalAliasName ");
        sbSQL.append("from T_BAS_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("where d.fbipath = ? ");
        sbSQL.append("and (d.FOrgID = ? or d.FOrgID = ?)");
        sbSQL.append("order by d.flastupdatetime desc");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static final ArrayList getReportListBySystemID(String systemID, String uiFlag, boolean withOutOrg) throws BOSException, SQLException {
        if (uiFlag.equals(DeployBatchUI.class.getName())) {
            return DefineReportBO.getUnDeployReporListToEASBySystemID(systemID, withOutOrg);
        }
        if (uiFlag.equals(EditBatchUI.class.getName())) {
            return DefineReportBO.getDefineReporListBySystemID(systemID, false);
        }
        if (uiFlag.equals(CtrlReportDiscreteDataSelector.class.getName())) {
            return DefineReportBO.getDepReportList(systemID, withOutOrg);
        }
        if (uiFlag.equals(ReportAttemperSetupUI.class.getName())) {
            return DefineReportBO.getDeployReporListBySystemID(systemID);
        }
        if (uiFlag.equals(ExtCallbackImpl.class.getName()) || uiFlag.equals("SnapF7UI")) {
            return DefineReportBO.getReportListByOrgID(systemID);
        }
        if (uiFlag.equals("StdProductF7UI")) {
            return DefineReportBO.getStdReportList(systemID);
        }
        if (uiFlag.equals(ReportDispatchUI.class.getName())) {
            return DefineReportBO.getPermDefineReporListBySystemID(systemID);
        }
        return null;
    }

    public static final ArrayList getReportListBySystemID(String systemID, int publishType, boolean withOutOrg) throws BOSException, SQLException {
        Object reportList = null;
        if (publishType == 1) {
            return DefineReportBO.getUnDeployReporListToEASBySystemID(systemID, withOutOrg);
        }
        if (publishType == 2) {
            return DefineReportBO.getUnDeployReporListToBIBySystemID(systemID, withOutOrg);
        }
        if (publishType == 4) {
            return DefineReportBO.getUnDeployReporListToPortletBySystemID(systemID, withOutOrg);
        }
        if (publishType == 8) {
            return DefineReportBO.getUnDeployReporListToMobileBySystemID(systemID, withOutOrg);
        }
        if (publishType == 16) {
            return DefineReportBO.getUnDeployReporListToEASAppCenterBySystemID(systemID, withOutOrg);
        }
        return null;
    }

    public static final ArrayList getStdReportListBySystemID(String systemID, int publishType) throws BOSException, SQLException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(strOrgID);
        queryValue.add(systemID);
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.forgtype, d.fsnaptype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FsystemID, d.ftemplettype, d.FlicenseStrategy, d.FMobileName, d.FPortletId, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime, d.fisdeploy, d.fdeploypath, d.fmenuid, d.FMenuUi ");
        sbSQL.append("from T_BAS_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=? ");
        sbSQL.append("where d.FsystemID = ? ");
        if (publishType == 1) {
            sbSQL.append("and d.fmenuid is null ");
        } else if (publishType == 2) {
            sbSQL.append("and d.FBIPath is null ");
        } else if (publishType == 4) {
            sbSQL.append("and d.FPortletId is null ");
        } else if (publishType == 8) {
            sbSQL.append("and d.FMobileName is null ");
            sbSQL.append("and d.ftemplettype = ").append(2);
        } else if (publishType == 16) {
            sbSQL.append("and d.FEasWebAppCenterId is null ");
        }
        sbSQL.append("and d.FIsStdProduct='1' ");
        sbSQL.append("order by d.flastupdatetime desc");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static final ArrayList getUnDeployReporListToEASBySystemID(String systemID, boolean withOutOrg) throws BOSException, SQLException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(systemID);
        if (!withOutOrg) {
            queryValue.add(strOrgID);
        }
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.forgtype, d.fsnaptype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FsystemID, d.ftemplettype, d.FlicenseStrategy, d.FMobileName, d.FPortletId, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime, d.fisdeploy, d.fdeploypath, d.fmenuid, d.FMenuUi ");
        sbSQL.append("from T_BAS_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("where d.FsystemID = ? ");
        if (!withOutOrg) {
            sbSQL.append("and d.FOrgID = ? ");
        }
        sbSQL.append("and d.fmenuid is null ");
        sbSQL.append("order by d.flastupdatetime desc");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static final ArrayList getUnDeployReporListToBIBySystemID(String systemID, boolean withOutOrg) throws BOSException, SQLException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(systemID);
        if (!withOutOrg) {
            queryValue.add(strOrgID);
        }
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.forgtype, d.fsnaptype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FsystemID, d.ftemplettype, d.FlicenseStrategy, d.FMobileName, d.FPortletId, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime, d.fisdeploy, d.fdeploypath, d.fmenuid, d.FMenuUi ");
        sbSQL.append("from T_BAS_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("where d.FsystemID = ? ");
        if (!withOutOrg) {
            sbSQL.append("and d.FOrgID = ? ");
        }
        sbSQL.append("and d.FBIPath is null ");
        sbSQL.append("order by d.flastupdatetime desc");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static final ArrayList getUnDeployReporListToPortletBySystemID(String systemID, boolean withOutOrg) throws BOSException, SQLException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(systemID);
        if (!withOutOrg) {
            queryValue.add(strOrgID);
        }
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.forgtype, d.fsnaptype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FsystemID, d.ftemplettype, d.FlicenseStrategy, d.FMobileName, d.FPortletId, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime, d.fisdeploy, d.fdeploypath, d.fmenuid, d.FMenuUi ");
        sbSQL.append("from T_BAS_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("where d.FsystemID = ? ");
        if (!withOutOrg) {
            sbSQL.append("and d.FOrgID = ? ");
        }
        sbSQL.append("and d.FPortletId is null ");
        sbSQL.append("order by d.flastupdatetime desc");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static final ArrayList getUnDeployReporListToMobileBySystemID(String systemID, boolean withOutOrg) throws BOSException, SQLException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(systemID);
        if (!withOutOrg) {
            queryValue.add(strOrgID);
        }
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.forgtype, d.fsnaptype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FsystemID, d.ftemplettype, d.FlicenseStrategy, d.FMobileName, d.FPortletId, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime, d.fisdeploy, d.fdeploypath, d.fmenuid, d.FMenuUi ");
        sbSQL.append("from T_BAS_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("where d.FsystemID = ? ");
        if (!withOutOrg) {
            sbSQL.append("and d.FOrgID = ? ");
        }
        sbSQL.append("and d.FMobileName is null ");
        sbSQL.append("and d.ftemplettype = ").append(2);
        sbSQL.append("order by d.flastupdatetime desc");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static final ArrayList getUnDeployReporListToEASAppCenterBySystemID(String systemID, boolean withOutOrg) throws BOSException, SQLException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(systemID);
        if (!withOutOrg) {
            queryValue.add(strOrgID);
        }
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.forgtype, d.fsnaptype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FsystemID, d.ftemplettype, d.FlicenseStrategy, d.FMobileName, d.FPortletId, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime, d.fisdeploy, d.fdeploypath, d.fmenuid, d.FMenuUi ");
        sbSQL.append("from T_BAS_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("where d.FsystemID = ? ");
        if (!withOutOrg) {
            sbSQL.append("and d.FOrgID = ? ");
        }
        sbSQL.append("and d.FEasWebAppCenterId is null ");
        sbSQL.append("order by d.flastupdatetime desc");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static final ArrayList getDeployReporListBySystemID(String systemID) throws BOSException, SQLException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(systemID);
        queryValue.add(strOrgID);
        queryValue.add("qUvvbL4yQsyQYFIDSlvngID2+FI=");
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.forgtype, d.fsnaptype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FsystemID, d.ftemplettype, FlicenseStrategy,");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime, d.fisdeploy, d.fdeploypath, d.fmenuid, d.FMenuUi ");
        sbSQL.append("from T_BAS_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("where d.FsystemID = ? ");
        sbSQL.append("and (d.FOrgID = ? or d.FOrgID = ?) ");
        sbSQL.append("and d.fmenuid is not null ");
        sbSQL.append("order by d.flastupdatetime desc");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static final ArrayList getDepReportList(String systemID, boolean withOutOrg) throws BOSException, SQLException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(systemID);
        if (!withOutOrg) {
            queryValue.add(strOrgID);
            queryValue.add("qUvvbL4yQsyQYFIDSlvngID2+FI=");
        }
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select r.fid, forgtype, fsnaptype, FOrgID, FFilterType, FBIPath, FIsStdProduct, FsystemID, ftemplettype, ");
        sbSQL.append("r.fmobilename, m.fname as fmobiletypename, pu.fpubacctname, ");
        sbSQL.append("Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("fdeploypath, fmenuid ");
        sbSQL.append("from T_BAS_DefineReport r ");
        sbSQL.append("LEFT OUTER JOIN t_ext_mobileType m on r.fmobiletypeid=m.fid ");
        sbSQL.append("LEFT OUTER JOIN T_EXT_XUNT_PUBACCT pu on r.fpubacctid=pu.fid ");
        sbSQL.append("where FsystemID = ? ");
        if (!withOutOrg) {
            sbSQL.append("and (FOrgID = ? or FOrgID = ?)");
        }
        ArrayList dataList = ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
        return dataList;
    }

    public static final List getReportStdList(Context ctx, String reportName) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid as reportid, d.fsystemid as systemid, d.forgid as orgid, d.fisstdproduct as isstdproduct, ");
        sbSQL.append("d.Fname_l2 as reportname ");
        sbSQL.append("from T_BAS_DefineReport d ");
        sbSQL.append("where d.fisstdproduct = 1 ");
        if (!CtrlReportUtil.getObjectString(reportName).equals("")) {
            sbSQL.append("and d.Fname_l2 like  '%").append(reportName).append("%'");
        }
        return ExtDBUtil.getResultListBySql(ctx, sbSQL.toString(), null);
    }

    public static final HashMap getDeployListCount(Context ctx) throws BOSException, SQLException {
        int intNoStdcount = 0;
        int intStdcount = 0;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT fmenuid, FBIPath, FIsStdProduct, fportletname, fmobilename, feaswebappcenterid FROM T_BAS_DefineReport where ftemplettype != 2  and FLicenseStrategy <> ");
        sb.append(2);
        ArrayList dataList = ExtDBUtil.getResultListBySql(ctx, sb.toString(), null);
        for (HashMap map : dataList) {
            String fmenuid = CtrlReportUtil.getObjectString(map.get("fmenuid"));
            String fbipath = CtrlReportUtil.getObjectString(map.get("fbipath"));
            String fisstdproduct = CtrlReportUtil.getObjectString(map.get("fisstdproduct"));
            String fportletname = CtrlReportUtil.getObjectString(map.get("fportletname"));
            if (!PublishType.isPublished(PublishType.getPublishTypeAll(map))) continue;
            if (fisstdproduct.equals("1")) {
                ++intStdcount;
                continue;
            }
            ++intNoStdcount;
        }
        HashMap<String, String> mapCount = new HashMap<String, String>();
        mapCount.put("intNoStdcount", String.valueOf(intNoStdcount));
        mapCount.put("intStdcount", String.valueOf(intStdcount));
        return mapCount;
    }

    public static final ArrayList getAllReportList() throws BOSException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.FOrgID, d.FsystemID,d.FLicenseStrategy, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("d.fdeploypath, d.fmenuid, d.FMenuUi ");
        sbSQL.append("from T_BAS_DefineReport d ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("where d.FMenuID is not null ");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), null);
    }

    public static final ArrayList getMenuNoReportList() throws BOSException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select m.fid, m.fuiclassparam, d.fid as reportid, ");
        sbSQL.append("m.fdisplayname_").append(strLocal).append(" as displayname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as reprotname ");
        sbSQL.append("from t_pm_mainMenuItem m LEFT OUTER JOIN T_BAS_DefineReport d on m.fuiclassparam = d.fid ");
        sbSQL.append("where m.fnumber like 'KDRS%' and m.fisleaf = 1 and d.fmenuid is null ");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), null);
    }

    public static final ArrayList getReportListByOrgID(String systemID) throws BOSException, SQLException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(systemID);
        queryValue.add(strOrgID);
        queryValue.add("qUvvbL4yQsyQYFIDSlvngID2+FI=");
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.forgtype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FsystemID, d.flicenseStrategy,");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime, d.fisdeploy, d.fdeploypath, d.fmenuid, d.FMenuUi ");
        sbSQL.append("from T_BAS_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("where d.FsystemID = ? ");
        sbSQL.append("and (d.FOrgID = ? or d.FOrgID = ? ) ");
        sbSQL.append("order by d.flastupdatetime desc");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static final ArrayList getReportsByType(int type) throws BOSException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        ArrayList<Integer> queryValue = new ArrayList<Integer>();
        queryValue.add(new Integer(type));
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select d.fid,");
        sqlBuf.append("d.Fname_").append(strLocal).append(" as fname from T_BAS_DefineReport where ");
        sqlBuf.append(" d.fid = ?");
        return ExtDBUtil.getResultListBySql(null, sqlBuf.toString(), queryValue);
    }

    public static final ArrayList getStdReportList(String systemID) throws BOSException, SQLException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(systemID);
        queryValue.add("qUvvbL4yQsyQYFIDSlvngID2+FI=");
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.forgtype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FsystemID, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime, d.fisdeploy, d.fdeploypath, d.fmenuid ");
        sbSQL.append("from T_BAS_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("where d.FsystemID = ? ");
        sbSQL.append("and d.FOrgID = ? ");
        sbSQL.append("order by d.flastupdatetime desc");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static final String getOrgNameByID(Context ctx, String id, String strLocal) {
        String name = "";
        ArrayList dataList = new ArrayList();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(id);
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select Fname_").append(strLocal).append(" as orgname from T_ORG_BaseUnit where fid = ?");
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getDBInfoBySQL");
        pr.setString("sql", sbSQL.toString());
        pr.setObject("lstValue", queryValue);
        try {
            RptParams ps_r = FacadeFactory.commonExecute(ctx, pr);
            IRowSet irs = (IRowSet)ps_r.getObject("object");
            dataList = ExtDBUtil.setDataToList((ResultSet)irs);
            irs.close();
            if (!dataList.isEmpty()) {
                name = CtrlReportUtil.getObjectString(((HashMap)dataList.get(0)).get("orgname"));
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return name;
    }

    public static final DefineReportInfo getCloudRport(Context ctx, String rptsName, String rptCategoryName) throws BOSException {
        IDefineReport report = null;
        report = ctx == null ? DefineReportFactory.getRemoteInstance() : DefineReportFactory.getLocalInstance(ctx);
        DefineReportInfo info = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)rptsName, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = report.getCollection(entityViewInfo);
        if (collection != null && !collection.isEmpty()) {
            DefineReportInfo[] infoes = new DefineReportInfo[collection.size()];
            int length = infoes.length;
            if (length > 1) {
                log.info((Object)"\u627e\u5230\u591a\u4e2a\u62a5\u8868\uff0c\u53ef\u80fd\u5f15\u8d77\u9519\u8bef");
            }
            for (int i = 0; i < length; ++i) {
                info = (DefineReportInfo)collection.get(i);
            }
        }
        return info;
    }

    public static final boolean isCloudReport(Context ctx, String fid) throws BOSException {
        DefineReportInfo reportInfo = DefineReportBO.getReportInfo(ctx, fid);
        if (reportInfo != null) {
            return !StringUtil.isEmptyString((String)reportInfo.getCloudRptCenterId());
        }
        return false;
    }

    public static final DefineReportInfo getReportInfo(Context ctx, String fid) throws BOSException {
        IDefineReport report = null;
        report = ctx == null ? DefineReportFactory.getRemoteInstance() : DefineReportFactory.getLocalInstance(ctx);
        DefineReportInfo info = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)fid, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = report.getCollection(entityViewInfo);
        if (collection != null && !collection.isEmpty()) {
            DefineReportInfo[] infoes = new DefineReportInfo[collection.size()];
            int length = infoes.length;
            if (length > 1) {
                log.info((Object)"\u627e\u5230\u591a\u4e2a\u62a5\u8868\uff0c\u53ef\u80fd\u5f15\u8d77\u9519\u8bef");
            }
            for (int i = 0; i < length; ++i) {
                info = (DefineReportInfo)collection.get(i);
            }
        }
        return info;
    }

    public static final HashMap getReportInfoByID(Context ctx, String fid) throws BOSException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(fid);
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.forgtype, d.FOrgID, d.FFilterType, d.FSnapType, d.FBIPath, d.fcreatorid, d.flastupdatetime, d.fdeploypath, d.fmenuid, d.FMenuUi, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname ");
        sbSQL.append("from T_BAS_DefineReport d ");
        sbSQL.append("where d.fid = ? ");
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoMapBySQL");
        pr.setString("sql", sbSQL.toString());
        pr.setObject("lstValue", queryValue);
        RptParams ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
        HashMap map = (HashMap)ps_r.getObject("object");
        return map;
    }

    public static final ArrayList getReportList(int type) throws BOSException, SQLException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        ArrayList<Integer> queryValue = new ArrayList<Integer>();
        queryValue.add(new Integer(type));
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select t.fid as id, t.fname_").append(strLocal).append(" as name from t_bas_definereport t where t.ftemplettype = ? order by t.flastupdatetime asc");
        return ExtDBUtil.getResultListBySql(null, sqlBuf.toString(), queryValue);
    }

    public static ArrayList getMobileReportList(Context easCtx, String pubAcctId) throws BOSException {
        return DefineReportBO.getMobileReportList(easCtx, pubAcctId, -1);
    }

    public static ArrayList getMobileReportList(Context easCtx, String pubAcctId, int topN) throws BOSException {
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)easCtx);
        String userId = currentUserInfo.getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        queryValue.add(userId);
        queryValue.add(userId);
        queryValue.add(userId);
        queryValue.add(pubAcctId);
        boolean isXTPubAcct = pubAcctId.startsWith("XT-");
        StringBuffer sbSQL = new StringBuffer();
        if (topN == -1) {
            sbSQL.append(" select d.fmobilename,d.fid,t.fname as fmobiletype ");
        } else {
            sbSQL.append(" select top ");
            sbSQL.append(topN);
            sbSQL.append(" d.fmobilename,d.fid,t.fname as fmobiletype ");
        }
        sbSQL.append(" from T_BAS_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        if (isXTPubAcct) {
            sbSQL.append(" LEFT OUTER JOIN T_EXT_XUNT_PUBACCT p on p.fid=d.fpubacctid");
        }
        sbSQL.append(" LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append(" LEFT OUTER JOIN t_ext_mobiletype t on d.fmobiletypeid=t.fid ");
        sbSQL.append(" LEFT OUTER JOIN t_ext_mobileOrderNum o on o.freportid=d.fid ");
        sbSQL.append(" where d.fid in");
        sbSQL.append(" (select p.FReportID from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r ");
        sbSQL.append(" on p.FReportID = r.fid where p.FUserID = ? and fmobilename is not null ");
        sbSQL.append(" union all select p.FReportID from T_EXT_Permission p");
        sbSQL.append(" INNER JOIN T_BAS_DefineReport r on p.FReportID = r.fid where p.FUserID = ? ");
        sbSQL.append(" and p.FOrgID is null and fmobilename is not null ");
        sbSQL.append(" union all select p.FReportID ");
        sbSQL.append(" from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r ");
        sbSQL.append(" on p.FReportID = r.fid INNER JOIN t_pm_userroleorg uro ON p.froleid = uro.froleid");
        sbSQL.append(" where uro.FUserID = ? and fmobilename is not null");
        sbSQL.append(" union all  select r.FID as FReportID from T_EXT_CloudReportDownloadList crdl ");
        sbSQL.append(" left join (select * from t_bas_definereport where FCloudRptVersion IS NOT NULL ) r on r.FCloudRptCenterId = crdl.FCloudRptId ");
        sbSQL.append(" where crdl.FUserId = ? and r.FTempletType=2 and r.FPubAcctId is not null )");
        if (isXTPubAcct) {
            sbSQL.append(" and p.fpubacctid = ?");
        } else {
            sbSQL.append(" and d.fpubacctid = ?");
        }
        sbSQL.append(" order by t.fordernumber, o.fordernumber, d.fmobiledeploytime desc");
        log.info((Object)sbSQL);
        log.info(queryValue);
        return ExtDBUtil.getResultListBySql1(easCtx, sbSQL.toString(), queryValue);
    }

    public static ArrayList<Map<String, String>> getExtManagerList(Context easCtx, boolean isMobile) throws BOSException {
        StringBuilder sb = new StringBuilder("select");
        sb.append(" u.fnumber,").append("u.fname_l2 as uname,").append("p.fname_l2 as pname,").append("p.fcell,").append("p.femail,").append("p.fofficephone,").append("u.fdeforgunitid,").append("o.fname_l2 as oname,").append("u.fcell as ucell,").append("u.femail as uemail,").append("u.fofficephone as uofficephone").append(" from t_pm_user u").append(" left join t_bd_person p on u.fpersonid=p.fid").append(" left join t_org_admin o on u.fdeforgunitid=o.fid").append(" where u.fpersonid is not null and").append(" u.fid in").append(" (select fowner from T_PM_UserOrgPerm where fpermitemid in").append("(select fid from T_PM_PermItem where flongnumber = '").append("EAS\u7cfb\u7edf!0\u5546\u4e1a\u5206\u6790!\u6269\u5c55\u62a5\u8868\u4e2d\u5fc3!\u62a5\u8868\u5e73\u53f0!\u62a5\u8868\u5de5\u5177!ctrl_report_management'").append(" or flongnumber = '").append("EAS\u7cfb\u7edf!0\u5546\u4e1a\u5206\u6790!\u6269\u5c55\u62a5\u8868\u4e2d\u5fc3!\u62a5\u8868\u5e73\u53f0!\u79fb\u52a8\u62a5\u8868\u5de5\u5177!ctrl_mobile_report_management").append("')) order by u.fnumber");
        ArrayList ret = ExtDBUtil.getResultListBySql(easCtx, sb.toString(), new ArrayList());
        for (Map map : ret) {
            if (StringUtil.isEmptyString((String)((String)map.get("pname")))) {
                map.put("pname", map.get("uname"));
            }
            if (StringUtil.isEmptyString((String)((String)map.get("fcell")))) {
                map.put("fcell", map.get("ucell"));
            }
            if (StringUtil.isEmptyString((String)((String)map.get("femail")))) {
                map.put("femail", map.get("uemail"));
            }
            if (!StringUtil.isEmptyString((String)((String)map.get("fofficephone")))) continue;
            map.put("fofficephone", map.get("uofficephone"));
        }
        return ret;
    }

    public static String getRptCloudUuid(Context easCtx, String rptId) {
        try {
            return MiscUtil.unpack((byte[])DefineReportBO.getReportInfo(easCtx, rptId).getContent()).getCloudRptUuid();
        }
        catch (Throwable e) {
            log.error((Object)"-------------failed to fetche cloud rpt uuid------------------", e);
            return null;
        }
    }

    public static final DefineReportInfo getReportInfo(Context ctx, String systemid, String name, String orgid, String fid) throws BOSException {
        IDefineReport report = null;
        report = ctx == null ? DefineReportFactory.getRemoteInstance() : DefineReportFactory.getLocalInstance(ctx);
        DefineReportInfo info = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (CtrlReportUtil.getObjectString(fid).equals("")) {
            fid = "qUvvbL4yQsyQYFIDSlvngID2+FI=";
        }
        if (CtrlReportUtil.getObjectString(systemid).equals("")) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)fid, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgid, CompareType.EQUALS));
            filterInfo.setMaskString("(#0 and #1)");
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)fid, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgid, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("systemID", (Object)systemid, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgid, CompareType.EQUALS));
            filterInfo.setMaskString("(#0 and #1) or (#2 and #3 and #4)");
            entityViewInfo.setFilter(filterInfo);
        }
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = report.getCollection(entityViewInfo);
        if (collection == null || collection.isEmpty()) {
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("systemID", (Object)systemid, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)"qUvvbL4yQsyQYFIDSlvngID2+FI=", CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)("std_" + name), CompareType.EQUALS));
            filterInfo.setMaskString("(#0 and #1 and #2)");
            entityViewInfo.setFilter(filterInfo);
            collection = report.getCollection(entityViewInfo);
        }
        if (collection != null && !collection.isEmpty()) {
            DefineReportInfo[] infoes = new DefineReportInfo[collection.size()];
            int length = infoes.length;
            if (length > 1) {
                log.error((Object)"\u627e\u5230\u591a\u4e2a\u62a5\u8868\uff0c\u53ef\u80fd\u5f15\u8d77\u9519\u8bef");
            }
            for (int i = 0; i < length; ++i) {
                info = (DefineReportInfo)collection.get(i);
            }
        }
        return info;
    }

    public static final DefineReportInfo getCloudReportInfo(Context ctx, String cloudRptCenterId) throws BOSException {
        IDefineReport report = null;
        report = ctx == null ? DefineReportFactory.getRemoteInstance() : DefineReportFactory.getLocalInstance(ctx);
        DefineReportInfo info = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cloudRptCenterId", (Object)cloudRptCenterId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("cloudRptVersion", null, CompareType.NOTEQUALS));
        filterInfo.setMaskString("(#0 and #1)");
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = report.getCollection(entityViewInfo);
        if (collection != null && !collection.isEmpty()) {
            DefineReportInfo[] infoes = new DefineReportInfo[collection.size()];
            int length = infoes.length;
            if (length > 1) {
                log.error((Object)"\u627e\u5230\u591a\u4e2a\u62a5\u8868\uff0c\u53ef\u80fd\u5f15\u8d77\u9519\u8bef");
            }
            for (int i = 0; i < length; ++i) {
                info = (DefineReportInfo)collection.get(i);
            }
        }
        return info;
    }

    public static boolean checkCloudRptCanBeAuthorized(String reportId, String userId) {
        return false;
    }

    public static final DefineReportInfo getReportInfo(Context ctx, String systemid, String name, String orgid) throws BOSException {
        IDefineReport report = null;
        report = ctx == null ? DefineReportFactory.getRemoteInstance() : DefineReportFactory.getLocalInstance(ctx);
        DefineReportInfo info = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("systemID", (Object)systemid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgid, CompareType.EQUALS));
        filterInfo.setMaskString("(#0 and #1 and #2)");
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = report.getCollection(entityViewInfo);
        if (collection != null && !collection.isEmpty()) {
            DefineReportInfo[] infoes = new DefineReportInfo[collection.size()];
            int length = infoes.length;
            if (length > 1) {
                log.error((Object)"\u627e\u5230\u591a\u4e2a\u62a5\u8868\uff0c\u53ef\u80fd\u5f15\u8d77\u9519\u8bef");
            }
            for (int i = 0; i < length; ++i) {
                info = (DefineReportInfo)collection.get(i);
            }
        }
        return info;
    }

    public static final DefineReportInfo getStdReportInfo(Context ctx, String systemid, String name, String fid) throws BOSException {
        IDefineReport report = null;
        report = ctx == null ? DefineReportFactory.getRemoteInstance() : DefineReportFactory.getLocalInstance(ctx);
        DefineReportInfo info = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)fid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)"qUvvbL4yQsyQYFIDSlvngID2+FI=", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("systemID", (Object)systemid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)"qUvvbL4yQsyQYFIDSlvngID2+FI=", CompareType.EQUALS));
        filterInfo.setMaskString("(#0 and #1) or (#2 and #3 and #4)");
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = report.getCollection(entityViewInfo);
        if (collection != null && !collection.isEmpty()) {
            DefineReportInfo[] infoes = new DefineReportInfo[collection.size()];
            int length = infoes.length;
            if (length > 1) {
                log.error((Object)"\u627e\u5230\u591a\u4e2a\u62a5\u8868\uff0c\u53ef\u80fd\u5f15\u8d77\u9519\u8bef");
            }
            for (int i = 0; i < length; ++i) {
                info = (DefineReportInfo)collection.get(i);
            }
        }
        return info;
    }

    public static final DefineReportInfo getReportInfoTest(Context ctx, String fname) throws BOSException {
        IDefineReport report = null;
        report = ctx == null ? DefineReportFactory.getRemoteInstance() : DefineReportFactory.getLocalInstance(ctx);
        DefineReportInfo info = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)fname, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = report.getCollection(entityViewInfo);
        if (collection != null && !collection.isEmpty()) {
            DefineReportInfo[] infoes = new DefineReportInfo[collection.size()];
            int length = infoes.length;
            if (length > 1) {
                log.info((Object)"\u627e\u5230\u591a\u4e2a\u62a5\u8868\uff0c\u53ef\u80fd\u5f15\u8d77\u9519\u8bef");
            }
            for (int i = 0; i < length; ++i) {
                info = (DefineReportInfo)collection.get(i);
            }
        }
        return info;
    }

    public static final HashMap getReportInfoOfExportStd(String fSystemID, String fname) throws BOSException, SQLException {
        ArrayList dataList = new ArrayList();
        HashMap dataMap = new HashMap();
        String strLocal = SysContext.getSysContext().getLocale().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(fSystemID);
        queryValue.add("qUvvbL4yQsyQYFIDSlvngID2+FI=");
        queryValue.add(fname);
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select fid, fsystemid, FDeployPath, FMenuID, FBIPath ");
        sbSQL.append("from T_BAS_DefineReport ");
        sbSQL.append("where FsystemID = ? and FOrgID = ? ").append("and Fname_").append(strLocal).append(" = ?");
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getDBInfoBySQL");
        pr.setString("sql", sbSQL.toString());
        pr.setObject("lstValue", queryValue);
        RptParams ps_r = ReportFacadeFactory.getRemoteInstance().commonExecute(pr);
        IRowSet irs = (IRowSet)ps_r.getObject("object");
        dataList = ExtDBUtil.setDataToList((ResultSet)irs);
        if (!dataList.isEmpty()) {
            dataMap = (HashMap)dataList.get(0);
        }
        return dataMap;
    }

    public static final ArrayList getImportReportInfo(String strId, String fSystemID, String fname, String strLocal, boolean isStdProduct) throws BOSException {
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuffer sbSQL = new StringBuffer();
        String fOrgID = "";
        fOrgID = !isStdProduct ? SysContext.getSysContext().getCurrentOrgUnit().getId().toString() : "qUvvbL4yQsyQYFIDSlvngID2+FI=";
        if (strId == null || strId.length() == 0) {
            sbSQL.append("SELECT FID, flastupdatetime, FDeployPath, FMenuID, FIsStdProduct, FTempletType FROM T_BAS_DefineReport WHERE fSystemID = ? And fOrgID = ?");
            sbSQL.append(" and FName_").append(strLocal).append(" = ?");
            queryValue.add(fSystemID);
            queryValue.add(fOrgID);
            queryValue.add(fname);
        } else {
            sbSQL.append("SELECT FID, flastupdatetime, FDeployPath, FMenuID, FIsStdProduct, FTempletType FROM T_BAS_DefineReport WHERE fid <> ? AND fSystemID = ? And fOrgID = ?");
            sbSQL.append(" and FName_").append(strLocal).append(" = ?");
            queryValue.add(strId);
            queryValue.add(fSystemID);
            queryValue.add(fOrgID);
            queryValue.add(fname);
        }
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static final String saveReport(byte[] data, String fid, HashMap mapName, String systemID, String cloudRptId, String flastupdatetime, String templettype, boolean isStdProduct) throws EASBizException, BOSException {
        return DefineReportBO.saveReport(data, fid, mapName, systemID, cloudRptId, flastupdatetime, templettype, isStdProduct, 14);
    }

    public static final String saveReport(byte[] data, String fid, HashMap mapName, String systemID, String cloudRptId, String flastupdatetime, String templettype, boolean isStdProduct, int intValue) throws EASBizException, BOSException {
        DefineReportInfo info = new DefineReportInfo();
        IDefineReport report = DefineReportFactory.getRemoteInstance();
        if (null == templettype) {
            templettype = String.valueOf(-1);
        }
        if (null != data) {
            info.setContent(data);
            info.setLength(data.length);
        }
        if (null != cloudRptId) {
            info.setCloudRptCenterId(cloudRptId);
        }
        if (null != mapName && !mapName.isEmpty()) {
            LanguageCollection lc = ExtContextUtils.getMetaDataLoader().getSolution().getLanguages();
            int z = lc.size();
            for (int i = 0; i < z; ++i) {
                LanguageInfo li = lc.get(i);
                String alias = (String)mapName.get(li.getLocale().toString());
                info.setName(alias, li.getLocale());
            }
        }
        if (isStdProduct) {
            info.setIsStdProduct(1);
            info.setOrgID(BOSUuid.read((String)"qUvvbL4yQsyQYFIDSlvngID2+FI="));
        } else {
            info.setIsStdProduct(0);
            info.setOrgID(SysContext.getSysContext().getCurrentOrgUnit().getId());
        }
        if (fid == null || fid.length() == 0) {
            info.setSystemID(systemID);
            info.setTempletType(Integer.parseInt(templettype));
            IObjectPK reportPk = report.addnew(info);
            fid = reportPk.toString();
        } else {
            BOSUuid bid = BOSUuid.read((String)fid);
            ObjectUuidPK reportPK = new ObjectUuidPK("id", bid);
            info.setId(bid);
            report.update((IObjectPK)reportPK, info);
        }
        if (flastupdatetime != null && flastupdatetime.length() > 0) {
            String sql = "update T_BAS_DefineReport set flastupdatetime = {ts'" + flastupdatetime + "'} where fid = '" + fid + "'";
            ExtDBUtil.maintainRecord(null, sql, null);
        }
        if (intValue != 14) {
            String forgid = info.getOrgID().toString();
            String locale = SysContext.getSysContext().getLocale().getLanguage();
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            ExtReportUserBehaviorUtil.recordExtUserBehaviorLog((String)fid, (String)info.getName(), (String)forgid, (String)DefineReportBO.getOrgNameByID(null, forgid, locale), (String)userInfo.getId().toString(), (String)userInfo.getName(), (String)userInfo.getNumber(), (int)intValue);
        }
        return fid;
    }

    public static final synchronized String saveCloudReport(Context context, byte[] data, String fid, HashMap mapName, String systemID, String flastupdatetime, String templettype, BOSUuid orgUUID, String cloudRptCenterID, int cloudRptVersion) throws EASBizException, BOSException {
        BOSUuid bid;
        if (StringUtil.isEmptyString((String)fid)) {
            throw new BOSException("\u4e91\u62a5\u8868\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u4e0d\u5b58\u5728ExtCloudRptSourceEASUuid");
        }
        DefineReportInfo info = new DefineReportInfo();
        IDefineReport report = context == null ? DefineReportFactory.getRemoteInstance() : DefineReportFactory.getLocalInstance(context);
        if (null == templettype) {
            templettype = String.valueOf(-1);
        }
        if (null != data) {
            info.setContent(data);
            info.setLength(data.length);
        }
        if (null != mapName && !mapName.isEmpty()) {
            LanguageCollection lc = ExtContextUtils.getMetaDataLoader().getSolution().getLanguages();
            int z = lc.size();
            for (int i = 0; i < z; ++i) {
                LanguageInfo li = lc.get(i);
                String alias = (String)mapName.get(li.getLocale().toString());
                info.setName(alias, li.getLocale());
            }
        }
        info.setCloudRptCenterId(cloudRptCenterID);
        info.setCloudRptVersion(cloudRptVersion);
        info.setOrgID(orgUUID);
        DefineReportInfo rptInfo = DefineReportBO.getReportInfo(null, fid);
        if (rptInfo == null) {
            bid = BOSUuid.read((String)fid);
            ObjectUuidPK reportPK = new ObjectUuidPK("id", bid);
            info.setSystemID(systemID);
            info.setTempletType(Integer.parseInt(templettype));
            info.setId(bid);
            report.addnew((IObjectPK)reportPK, info);
        } else {
            bid = BOSUuid.read((String)fid);
            ObjectUuidPK reportPK = new ObjectUuidPK("id", bid);
            info.setId(bid);
            report.update((IObjectPK)reportPK, info);
        }
        if (flastupdatetime != null && flastupdatetime.length() > 0) {
            String sql = "update T_BAS_DefineReport set flastupdatetime = {ts'" + flastupdatetime + "'} where fid = '" + fid + "'";
            ExtDBUtil.maintainRecord(null, sql, null);
        }
        return fid;
    }

    public static final void delReport(String systemID, String name) throws EASBizException, BOSException {
        RptParams pr = new RptParams();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(systemID);
        queryValue.add("qUvvbL4yQsyQYFIDSlvngID2+FI=");
        queryValue.add(name);
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String sql = "delete T_BAS_DefineReport where fsystemid = ? and forgid = ? and fname_" + strLocal + " = ?";
        pr.setString("sql", sql);
        pr.setObject("lstValue", queryValue);
        pr.setString("MethodName", "maintainRecord");
        ReportFacadeFactory.getRemoteInstance().commonExecute(pr);
    }

    public static final boolean isApplyMenuPermission(Context ctx) {
        return true;
    }

    public static final void updateMenuPermission(boolean isApply) throws BOSException {
        String apply = "0";
        if (isApply) {
            apply = "1";
        }
        RptParams pr = new RptParams();
        ArrayList queryValue = new ArrayList();
        String sql = "delete T_EXT_MenuPermission";
        pr.setString("sql", sql);
        pr.setObject("lstValue", queryValue);
        pr.setString("MethodName", "maintainRecord");
        ReportFacadeFactory.getRemoteInstance().commonExecuteNever(pr);
        sql = "insert into T_EXT_MenuPermission(FApply) values(" + apply + ")";
        pr.setString("sql", sql);
        pr.setObject("lstValue", queryValue);
        pr.setString("MethodName", "maintainRecord");
        ReportFacadeFactory.getRemoteInstance().commonExecuteNever(pr);
        try {
            MenuCacheFactory.getRemoteInstance().updateAllMenuCache();
        }
        catch (Exception e) {
            log.error((Object)"\u66f4\u65b0\u83dc\u5355\u7f13\u5b58", (Throwable)e);
        }
    }

    public static final String getReportMenuName(String reportID) throws BOSException {
        StringBuffer sqlBuf = new StringBuffer("select pm.fname_l2 as fname from t_pm_mainmenuitem pm, ");
        sqlBuf.append("t_bas_definereport sd where sd.fid = ? and pm.fid = sd.fmenuid");
        try {
            RptParams pr = new RptParams();
            pr.setString("MethodName", "getInfoMapBySQL");
            pr.setString("sql", sqlBuf.toString());
            ArrayList<String> paramLst = new ArrayList<String>(1);
            paramLst.add(reportID);
            pr.setObject("lstValue", paramLst);
            RptParams ps_r = FacadeFactory.commonExecute(null, pr);
            HashMap map = (HashMap)ps_r.getObject("object");
            return (String)map.get("fname");
        }
        catch (BOSException e) {
            throw new BOSException("\u83b7\u5f97\u83dc\u5355\u540d\u79f0\u5931\u8d25", (Throwable)e);
        }
    }

    public static final List<Map<String, Object>> getReportListByOrgID() throws BOSException {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(strOrgID);
        queryValue.add("qUvvbL4yQsyQYFIDSlvngID2+FI=");
        StringBuilder sbSQL = new StringBuilder();
        sbSQL.append("select d.fcontent, d.fid, d.forgtype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FsystemID, d.flicenseStrategy,");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime, d.fisdeploy, d.fdeploypath, d.fmenuid, d.FMenuUi, t.fpubacctname ");
        sbSQL.append("from T_BAS_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("LEFT OUTER JOIN T_EXT_XUNT_PUBACCT t on d.FsystemID = t.fid ");
        sbSQL.append("where d.FOrgID = ? or d.FOrgID = ? ");
        sbSQL.append("order by d.flastupdatetime desc");
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }
}

