/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.bo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.rpts.ctrlsqldesign.IKSQLReport;
import com.kingdee.eas.rpts.ctrlsqldesign.KSQLReportFactory;
import com.kingdee.eas.rpts.ctrlsqldesign.KSQLReportInfo;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.NoFoundQueryException;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignInputStream;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtContextUtils;
import com.kingdee.eas.rpts.ctrlsqldesign.model.KsqlObjectSelector;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class KSQLReportBO {
    private static Logger log = LogUtil.getPackageLogger(KSQLReportBO.class);

    public static CtrlDesignQueryModel initModel(String fid) throws CtrlReportException {
        return KSQLReportBO.initModel(null, null, null, null, fid, null);
    }

    public static CtrlDesignQueryModel initModelFromXml(String xmlContent) throws CtrlReportException {
        return KSQLReportBO.initModel(null, null, null, null, null, xmlContent);
    }

    public static CtrlDesignQueryModel initModelFromXml(Context ctx, String xmlContent) throws CtrlReportException {
        return KSQLReportBO.initModel(ctx, null, null, null, null, xmlContent);
    }

    public static CtrlDesignQueryModel initModel(Context ctx, String systemid, String dbsourcename, String orgid, String fid, String innerLinkXmlString) throws CtrlReportException {
        return KSQLReportBO.initModel(ctx, systemid, dbsourcename, orgid, fid, innerLinkXmlString, null);
    }

    public static CtrlDesignQueryModel initModel(Context ctx, String systemid, String dbsourcename, String orgid, String fid, String innerLinkXmlString, HashMap mapNoFoundQuery) throws CtrlReportException {
        CtrlDesignQueryModel model;
        block11: {
            CtrlDesignInputStream inputStream = null;
            Element root = null;
            if (null != innerLinkXmlString) {
                try {
                    StringReader reader = new StringReader(innerLinkXmlString);
                    SAXBuilder sb = new SAXBuilder();
                    Document doc = sb.build((Reader)reader);
                    root = doc.getRootElement();
                    RunReportParam.closeReader(reader);
                }
                catch (Exception e) {
                    log.debug((Object)e);
                    throw CtrlReportException.makeException("\u89e3\u6790\u5185\u5d4c\u6570\u636e\u6e90\u9519\u8bef", e);
                }
            } else {
                inputStream = new CtrlDesignInputStream(ctx, systemid, dbsourcename, orgid, fid);
                if (!inputStream.isFound()) {
                    log.error((Object)("\u627e\u4e0d\u5230\u6570\u636e\u6e90systemid = " + systemid + "dbsourcename = " + dbsourcename + ", orgid = " + orgid + ", fid = " + fid));
                    return null;
                }
            }
            model = new CtrlDesignQueryModel();
            model.setObjectSelector(new KsqlObjectSelector());
            if (root != null) {
                CtrlDesignUtil.toObject(ctx, model, root);
            } else if (null != inputStream) {
                inputStream.getInputObject(model);
            }
            if (model.getCommonQuery().getSemanticModel() == null) {
                KsqlObjectSelector selector = model.getObjectSelector();
                try {
                    selector.cacheTable2MetaClass(model.getQuery());
                }
                catch (NoFoundQueryException e) {
                    log.error((Object)"NoFoundQueryException", (Throwable)e);
                    if (mapNoFoundQuery == null) break block11;
                    mapNoFoundQuery.clear();
                    mapNoFoundQuery.put("NoFoundQueryException", e);
                }
            }
        }
        return model;
    }

    public static KSQLReportInfo getKSQLReportInfo(Context ctx, String fid, String orgid) throws BOSException {
        IKSQLReport report = null;
        if (report == null) {
            report = ctx == null ? KSQLReportFactory.getRemoteInstance() : KSQLReportFactory.getLocalInstance(ctx);
        }
        KSQLReportInfo info = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)fid, CompareType.EQUALS));
        if (!StringUtil.isEmptyString((String)orgid)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgid, CompareType.EQUALS));
            filterInfo.setMaskString("#0 and #1");
        }
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = report.getCollection(entityViewInfo);
        KSQLReportInfo[] infoes = new KSQLReportInfo[collection.size()];
        for (int i = 0; i < infoes.length; ++i) {
            info = (KSQLReportInfo)collection.get(i);
        }
        return info;
    }

    public static KSQLReportInfo getKSQLReportInfo(Context ctx, String systemid, String dbsourcename, String orgid, String fid) throws BOSException {
        IKSQLReport report = null;
        if (report == null) {
            report = ctx == null ? KSQLReportFactory.getRemoteInstance() : KSQLReportFactory.getLocalInstance(ctx);
        }
        KSQLReportInfo info = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)fid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)dbsourcename, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("systemID", (Object)systemid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgid, CompareType.EQUALS));
        filterInfo.setMaskString("(#0 and #1) or (#2 and #3 and #4)");
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = report.getCollection(entityViewInfo);
        KSQLReportInfo[] infoes = new KSQLReportInfo[collection.size()];
        for (int i = 0; i < infoes.length; ++i) {
            info = (KSQLReportInfo)collection.get(i);
        }
        return info;
    }

    public static final String saveKSQL(byte[] data, String fid, HashMap mapName, String systemID, boolean isSQL, int customType, String flastupdatetime) throws EASBizException, BOSException {
        KSQLReportInfo info = new KSQLReportInfo();
        IKSQLReport report = KSQLReportFactory.getRemoteInstance();
        info.setContent(data);
        info.setLength(data.length);
        info.setIsDynamicSQL(isSQL);
        info.setCustomType(customType);
        if (fid == null || fid.length() == 0) {
            LanguageCollection lc = ExtContextUtils.getMetaDataLoader().getSolution().getLanguages();
            int z = lc.size();
            for (int i = 0; i < z; ++i) {
                LanguageInfo li = lc.get(i);
                String alias = (String)mapName.get(li.getLocale().toString());
                info.setName(alias, li.getLocale());
            }
            info.setSystemID(systemID);
            info.setOrgID(SysContext.getSysContext().getCurrentOrgUnit().getId());
            IObjectPK reportPk = report.addnew(info);
            fid = reportPk.toString();
        } else {
            BOSUuid bid = BOSUuid.read((String)fid);
            ObjectUuidPK reportPK = new ObjectUuidPK("id", bid);
            info.setId(bid);
            report.update((IObjectPK)reportPK, info);
        }
        try {
            RptParams pr_customType = new RptParams();
            ArrayList<String> queryValue_customType = new ArrayList<String>();
            queryValue_customType.add(fid);
            String sql_customType = "update T_BAS_KSQLReport set FCustomType = " + customType + " where fid = ?";
            pr_customType.setString("sql", sql_customType);
            pr_customType.setObject("lstValue", queryValue_customType);
            pr_customType.setString("MethodName", "maintainRecord");
            ReportFacadeFactory.getRemoteInstance().commonExecute(pr_customType);
        }
        catch (Exception e) {
            log.error((Object)"update T_BAS_KSQLReport set FCustomType", (Throwable)e);
        }
        if (flastupdatetime != null && flastupdatetime.length() > 0) {
            RptParams pr = new RptParams();
            ArrayList<String> queryValue = new ArrayList<String>();
            queryValue.add(fid);
            String sql = "update T_BAS_KSQLReport set flastupdatetime = {ts'" + flastupdatetime + "'} where fid = ?";
            pr.setString("sql", sql);
            pr.setObject("lstValue", queryValue);
            pr.setString("MethodName", "maintainRecord");
            ReportFacadeFactory.getRemoteInstance().commonExecute(pr);
        }
        return fid;
    }

    public static final boolean isExitsName(String fSystemID, String fname) throws BOSException {
        RptParams pr = new RptParams();
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuffer sbSQL = new StringBuffer();
        String fOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        String strLocal = SysContext.getSysContext().getLocale().toString();
        sbSQL.append("SELECT FID FROM T_BAS_KSQLReport WHERE fSystemID = ?  And fOrgID = ? ");
        sbSQL.append("and FName_").append(strLocal).append(" = ?");
        queryValue.add(fSystemID);
        queryValue.add(fOrgID);
        queryValue.add(fname);
        pr.setString("sql", sbSQL.toString());
        pr.setObject("lstValue", queryValue);
        pr.setString("MethodName", "exitsRecordBySQL");
        RptParams ps_r = ReportFacadeFactory.getRemoteInstance().commonExecute(pr);
        return ps_r.getBoolean("flag");
    }

    public static final boolean isExitsProce(String outDB, String proceName, int dbType) throws BOSException {
        RptParams ps_r;
        HashMap mapReturn;
        RptParams pr = new RptParams();
        String strSQL = null;
        if (dbType == 3) {
            strSQL = "/*dialect*/select su.name as owner ,sb.name as procedurename from sysobjects sb, sysusers su where sb.uid = su.uid and sb.type = 'p' and sb.name = '" + proceName.toUpperCase() + "'";
        } else if (dbType == 2) {
            if (proceName.indexOf(".") != -1) {
                String[] arr = proceName.split("\\.");
                String object_name = arr[0];
                String procedure_name = arr[1];
                strSQL = "/*dialect*/select t.owner, t.object_name as procedurename from all_procedures t where t.object_name = '" + object_name.toUpperCase() + "' and t.procedure_name = '" + procedure_name.toUpperCase() + "'";
            } else {
                strSQL = "/*dialect*/select t.owner, t.object_name as procedurename from all_procedures t where t.object_name = '" + proceName.toUpperCase() + "' and t.procedure_name is null";
            }
        } else if (dbType == 1) {
            strSQL = "/*dialect*/select procschema as owner, procname as procedurename from syscat.procedures where procname= '" + proceName.toUpperCase() + "'";
        } else if (dbType == 5) {
            strSQL = "/*dialect*/select p.proowner as owner, p.proname as procedurename from pg_proc p where p.proname = '" + proceName.toLowerCase() + "'";
        }
        pr.setString("MethodName", "getInfoMapBySQL");
        pr.setString("sql", strSQL);
        if (!outDB.equals("")) {
            pr.setObject("outDB", (Object)outDB);
        }
        return !(mapReturn = (HashMap)(ps_r = FacadeFactory.commonExecuteNever(null, pr)).getObject("object")).isEmpty();
    }

    public static final ArrayList getUserProceList(String outDB, int dbType) throws BOSException {
        RptParams pr = new RptParams();
        String strSQL = null;
        if (dbType == 3) {
            strSQL = "/*dialect*/select su.name as owner ,sb.name as procedurename from sysobjects sb, sysusers su where sb.uid = su.uid and sb.type = 'p' and OBJECTPROPERTY(id, 'IsMSShipped')=0";
        } else if (dbType == 2) {
            strSQL = "/*dialect*/select t.owner, t.object_name as procedurename from all_procedures t, user_procedures u, user_objects o where t.object_name = u.object_name and t.object_name = o.object_name and o.object_type = 'PROCEDURE'";
        } else if (dbType == 1) {
            strSQL = "/*dialect*/select procschema as owner, procname as procedurename from syscat.procedures where definer <> 'SYSIBM'";
        }
        pr.setString("MethodName", "getInfoListBySQL");
        pr.setString("sql", strSQL);
        if (!outDB.equals("")) {
            pr.setObject("outDB", (Object)outDB);
        }
        RptParams ps_r = FacadeFactory.commonExecuteNever(null, pr);
        ArrayList lstReturn = (ArrayList)ps_r.getObject("object");
        return lstReturn;
    }
}

