/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.bo;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.ModuleLicenseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class LicenseBo {
    private static final Logger logger = CommonLogger.getLogger(LicenseBo.class);
    public static int LEAVE_COUNT = 0;
    public static final int FreeLicenseAccountYes = 10;
    public static final int FreeLicenseAccountNo = 3;

    public static final boolean deployChkLicense(Context ctx) {
        try {
            int spareCount = LicenseBo.spareCount(ctx);
            if (spareCount <= 0) {
                MessageUtil.showInfo("label201", true);
                return false;
            }
        }
        catch (CtrlReportException e1) {
            MessageUtil.showDetailAndOKFromResource(null, "label175", e1);
            return false;
        }
        return true;
    }

    public static final int getDeployCount(Context ctx) throws CtrlReportException {
        int deployCount = 0;
        try {
            HashMap map = DefineReportBO.getDeployListCount(ctx);
            deployCount = Integer.parseInt(CtrlReportUtil.getObjectString(map.get("intNoStdcount")));
        }
        catch (Exception e1) {
            throw CtrlReportException.makeException("\u83b7\u53d6\u5df2\u53d1\u5e03\u6570\u91cf\u5931\u8d25", e1);
        }
        return deployCount;
    }

    public static final int getLicenseCount(Context ctx) {
        int licenseCount = 0;
        try {
            String extReportLicenseName = null;
            ILicenseSrvAgent agent = null;
            agent = ctx == null ? LicenseSrvAgentFactory.getRemoteInstance() : LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
            ModuleLicenseInfo[] mli = agent.getModuleLicenseInfo();
            for (int i = 0; i < mli.length; ++i) {
                ModuleLicenseInfo info = mli[i];
                String policy = info.getControlPolicy();
                if (policy.equalsIgnoreCase("SOLUTION")) {
                    extReportLicenseName = "EASAPPS";
                    licenseCount = info.getLicenseNum();
                    return licenseCount;
                }
                if (policy.equalsIgnoreCase("SUBSYSTEM")) {
                    extReportLicenseName = "BOS_EXTRPT_RUNTIME_G";
                } else if (policy.equalsIgnoreCase("MODULE")) {
                    extReportLicenseName = "BOS_EXTRPT_RUNTIME";
                } else if (policy.equalsIgnoreCase("Register")) {
                    extReportLicenseName = "BOS_EXTRPT_RUNTIME_G";
                }
                if (null == extReportLicenseName || !extReportLicenseName.equalsIgnoreCase(info.getModuleName())) continue;
                licenseCount = info.getLicenseNum();
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6license\u8d2d\u4e70\u6570\u91cf\u5931\u8d25", (Throwable)e);
            licenseCount = 0;
        }
        return licenseCount;
    }

    public static final int spareCount(Context ctx) throws CtrlReportException {
        int deployCount = LicenseBo.getDeployCount(ctx);
        int licenseCount = LicenseBo.getLicenseCount(ctx);
        int licenseFreeCount = 3;
        if (licenseCount > 0) {
            licenseFreeCount = 10;
        }
        int leaveCount = licenseCount + licenseFreeCount - deployCount;
        return leaveCount;
    }

    public static final synchronized void updateCacheSpareCount(Context ctx) {
        try {
            LEAVE_COUNT = LicenseBo.spareCount(ctx);
        }
        catch (CtrlReportException e) {
            logger.error((Object)e);
        }
    }

    public static final synchronized int getCacheSpareCount(Context ctx) throws CtrlReportException {
        if (LEAVE_COUNT <= 0) {
            LEAVE_COUNT = LicenseBo.spareCount(ctx);
        }
        return LEAVE_COUNT;
    }
}

