/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.innerlink;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.exec.ChartInnerLinkExec;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.model.ChartDataItemInfo;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.model.InnerLinkTargetProperties;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.model.InnerLinkTransitionTarget;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.eas.rpts.ctrlreport.innerlink.AbstractInnerLinkWebExec;
import com.kingdee.eas.rpts.ctrlreport.innerlink.InnerLinkException;
import com.kingdee.eas.rpts.web.model.HyperLink;
import com.kingdee.eas.rpts.web.model.LinkModel;
import com.kingdee.eas.rpts.web.util.ReportBookHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ChartInnerLinkWebExec
extends AbstractInnerLinkWebExec {
    private FlashChartModel _chartModel;
    private ChartDataItemInfo _dataItemInfo;

    public ChartInnerLinkWebExec(Book book, String pageId, FlashChartModel chartModel, Context ctx) {
        super(book, pageId, ctx);
        this._chartModel = chartModel;
    }

    @Override
    public LinkModel execute() throws InnerLinkException {
        InnerLinkTargets targets;
        Book book = this._book;
        Cell cell = book.getActiveSheet().getActiveCell();
        if (cell == null) {
            cell = book.getActiveSheet().getCell(0, 0, true);
        }
        if ((targets = this._chartModel.getInnerTargets()) == null) {
            ETTargets etTargets = this._chartModel.getExtTargets();
            if (etTargets == null) {
                throw new InnerLinkException("\u672a\u627e\u5230\u9700\u8981\u8054\u52a8\u6216\u8054\u67e5\u7684\u76ee\u6807\uff01");
            }
            List<HyperLink> links = ReportBookHelper.buildRptHyperlink(this._ctx, etTargets, cell, this._dataItemInfo);
            LinkModel linkModel = new LinkModel();
            linkModel.setLinkType("outterLink");
            linkModel.setHyperLinks(links);
            return linkModel;
        }
        List listTarget = targets.getTargets();
        if (listTarget == null || listTarget.isEmpty()) {
            throw new InnerLinkException("\u672a\u627e\u5230\u9700\u8981\u8054\u52a8\u6216\u8054\u67e5\u7684\u76ee\u6807\uff01");
        }
        ExtProps ep = cell.getExtProps(true);
        Object result = null;
        LinkModel linkModel = new LinkModel();
        linkModel.setLinkType("innerLink");
        InnerLinkTransitionTarget target2 = null;
        ArrayList<String> linkErrorNames = new ArrayList<String>();
        for (InnerLinkTransitionTarget target2 : listTarget) {
            InnerLinkTargetProperties props;
            String linkName;
            if (target2 == null || StringUtil.isEmptyString((String)(linkName = (props = target2.getTargetProps()).getId((ICalculable)this._chartModel.getDataNode())))) continue;
            String targetType = target2.getTargetType();
            Map params = target2.getParams();
            if (params != null && params.size() > 0) {
                ep.executeParams(params);
                ChartInnerLinkExec.executeChartParams((Map)params, (ChartDataItemInfo)this._dataItemInfo);
            }
            try {
                result = this.execute(targetType, linkName, params);
                linkModel.addLinkEmbedModel(linkName, result, targetType, this._pageId);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                linkErrorNames.add(linkName);
            }
        }
        this.buildErrorMsg(linkModel, linkErrorNames);
        return linkModel;
    }

    public void setDataItemInfo(ChartDataItemInfo dataItemInfo) {
        this._dataItemInfo = dataItemInfo;
    }
}

