/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.macro.ui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.mutex.IVOChangeListener;
import com.kingdee.eas.framework.client.mutex.VOChangeListener;
import com.kingdee.eas.rpts.ctrlreport.adapter.TableManager;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroDesignException;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.ExtRptMacroControllerFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroType;
import com.kingdee.eas.rpts.ctrlreport.macro.model.IExtRptMacro;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.macro.resources.Resources;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.IExtRptMacroFilter;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.IExtRptMacroSelectionAware;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.action.ExtRptMacroManageActionFactory;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.action.IExtRptMacroActionHost;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.render.MacroIconTextRender;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.KsqlObjectSelector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class ExtRptMacroManageUI
extends CoreUI
implements IExtRptMacroActionHost {
    private static Logger logger = CommonLogger.getLogger(ExtRptMacroManageUI.class);
    private static final long serialVersionUID = 1L;
    private KDTable macroTable;
    private ArrayList<IExtRptMacroSelectionAware> actions = new ArrayList();
    private IExtRptMacroFilter filter;
    private IExtRptMacroController controller = ExtRptMacroControllerFacade.getRemoteInst();
    private MacroIconTextRender funcRender = new MacroIconTextRender();
    private MacroIconTextRender sqlRender;

    public ExtRptMacroManageUI() throws Exception {
        this.funcRender.setIcon(Resources.getResourceIcon("func.png"));
        this.sqlRender = new MacroIconTextRender();
        this.sqlRender.setIcon(Resources.getResourceIcon("sql.png"));
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.getTableForCommon();
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 10, 998, 613);
        cons.anchor = 15;
        this.macroTable.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.add((Component)this.macroTable);
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 1013, 629));
        this.setLayout((LayoutManager)new KDLayout());
        this.setPreferredSize(new Dimension(1013, 629));
    }

    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        KDToolBar toolBar = this.getUIToolBar();
        try {
            toolBar.add(ExtRptMacroManageActionFactory.newSearchAction(this));
            toolBar.add(ExtRptMacroManageActionFactory.newRefreshAction(this));
            toolBar.add((Component)new KDSeparator());
            toolBar.add(ExtRptMacroManageActionFactory.newPreviewAction(this, true));
            toolBar.add((Component)new KDSeparator());
            toolBar.add(ExtRptMacroManageActionFactory.newAddNewAction(this));
            toolBar.add(ExtRptMacroManageActionFactory.newEditAction(this));
            toolBar.add(ExtRptMacroManageActionFactory.newPropertiesAction(this));
            toolBar.add(ExtRptMacroManageActionFactory.newDeleteAction(this));
            toolBar.add((Component)new KDSeparator());
            toolBar.add(ExtRptMacroManageActionFactory.newImportAction(this));
            toolBar.add(ExtRptMacroManageActionFactory.newExportAction(this));
            toolBar.add((Component)new KDSeparator());
        }
        catch (MacroDesignException e) {
            logger.error((Object)"\u521d\u59cb\u5316\u5b8f\u7ba1\u7406\u754c\u9762\u5931\u8d25\u3002", (Throwable)e);
            this.abort(e);
        }
    }

    public void onLoad() throws Exception {
        try {
            this.loadMacros();
            this.addVOChangeListener((IVOChangeListener)new VOChangeListener());
        }
        catch (MacroDesignException e) {
            logger.error((Object)e);
            MessageUtil.msgboxWarning((Component)((Object)this), (String)Resources.getResourceString("\u52a0\u8f7d\u5b8f\u5217\u8868\u5931\u8d25\u3002"), (String)e.getMessage());
            this.abort(e);
        }
    }

    protected KDTable getTableForCommon() {
        this.macroTable = new KDTable(8, 0, 0);
        IRow headRow0 = this.macroTable.addHeadRow();
        headRow0.getCell(0).setValue((Object)Resources.getResourceString("\u540d\u79f0"));
        headRow0.getCell(1).setValue((Object)Resources.getResourceString("\u63cf\u8ff0"));
        headRow0.getCell(2).setValue((Object)Resources.getResourceString("\u5b9a\u4e49"));
        headRow0.getCell(3).setValue((Object)Resources.getResourceString("\u8fd4\u56de\u503c\u7c7b\u578b"));
        headRow0.getCell(4).setValue((Object)Resources.getResourceString("\u521b\u5efa\u4eba"));
        headRow0.getCell(5).setValue((Object)Resources.getResourceString("\u521b\u5efa\u65f6\u95f4"));
        headRow0.getCell(6).setValue((Object)Resources.getResourceString("\u4fee\u6539\u4eba"));
        headRow0.getCell(7).setValue((Object)Resources.getResourceString("\u4fee\u6539\u65f6\u95f4"));
        this.macroTable.setEditable(false);
        this.macroTable.getColumn(0).setWidth(150);
        this.macroTable.getColumn(1).setWidth(200);
        this.macroTable.getColumn(2).setWidth(350);
        this.macroTable.getColumn(3).setWidth(100);
        this.macroTable.getColumn(4).setWidth(100);
        this.macroTable.getColumn(5).setWidth(100);
        this.macroTable.getColumn(6).setWidth(100);
        this.macroTable.getColumn(7).setWidth(100);
        KDTSelectManager selectManager = this.macroTable.getSelectManager();
        selectManager.setSelectMode(10);
        selectManager.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                MacroVO[] selections = ExtRptMacroManageUI.this.getSelections();
                for (IExtRptMacroSelectionAware action : ExtRptMacroManageUI.this.actions) {
                    action.selectionChanged(selections);
                }
            }
        });
        this.macroTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() >= 2) {
                    try {
                        ExtRptMacroManageActionFactory.newPreviewAction(ExtRptMacroManageUI.this, true).actionPerformed(new ActionEvent(ExtRptMacroManageUI.this.macroTable, 0, null));
                    }
                    catch (MacroDesignException e1) {
                        logger.error((Object)Resources.getResourceString("\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5b8f\u5b9a\u4e49\u3002"), (Throwable)e1);
                        MessageUtil.msgboxWarning((Component)((Object)ExtRptMacroManageUI.this), (String)Resources.getResourceString("\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5b8f\u5b9a\u4e49\u3002"));
                    }
                }
            }
        });
        return this.macroTable;
    }

    public boolean destroyWindow() {
        return true;
    }

    public String getUITitle() {
        return com.kingdee.eas.rpts.ctrlreport.util.MessageUtil.getReportsInfo("label46");
    }

    @Override
    public MacroVO[] getSelections() {
        ArrayList<MacroVO> ret = new ArrayList<MacroVO>();
        KDTSelectManager manager = this.macroTable.getSelectManager();
        for (int i = 0; i < manager.size(); ++i) {
            KDTSelectBlock block = manager.get(i);
            for (int j = block.getBeginRow(); j <= block.getEndRow() && j >= 0; ++j) {
                ret.add((MacroVO)this.macroTable.getRow(j).getUserObject());
            }
        }
        return ret.toArray(new MacroVO[0]);
    }

    @Override
    public void setFilter(IExtRptMacroFilter filter) {
        this.filter = filter;
    }

    @Override
    public void afterAction() {
        try {
            this.loadMacros();
        }
        catch (MacroDesignException e) {
            logger.error((Object)e);
            MessageUtil.msgboxWarning((Component)((Object)this), (String)Resources.getResourceString("\u52a0\u8f7d\u5b8f\u5217\u8868\u5931\u8d25\u3002"), (String)e.getMessage());
        }
    }

    @Override
    public void register(IExtRptMacroSelectionAware action) {
        this.actions.add(action);
    }

    @Override
    public CoreUI getCoreUI() {
        return this;
    }

    /*
     * Could not resolve type clashes
     */
    private void loadMacros() throws MacroDesignException {
        MacroVO[] mList;
        ArrayList selections = TableManager.getSelectedTableIndexs(this.macroTable);
        HashSet<String> macroIds = new HashSet<String>();
        for (Object o : selections) {
            int rowIndex = Integer.parseInt(o.toString());
            if (rowIndex < 0) continue;
            macroIds.add(((MacroVO)this.macroTable.getRow(rowIndex).getUserObject()).getUuid());
        }
        this.macroTable.removeRows();
        for (MacroVO vo : mList = this.controller.l()) {
            String name = vo.getMacro().name();
            String description = vo.getDescription();
            ExtRptMacroType.VType vt = vo.getMacro().vType();
            ExtRptMacroType.MType mt = vo.getMacro().mType();
            if (this.filter != null) {
                boolean typeMatch = false;
                if (this.filter.vTypes() != null && this.filter.vTypes().length > 0) {
                    for (Enum type : this.filter.vTypes()) {
                        if (vt != type) continue;
                        typeMatch = true;
                        break;
                    }
                    if (!typeMatch) continue;
                }
                typeMatch = false;
                if (this.filter.mTypes() != null && this.filter.mTypes().length > 0) {
                    for (Enum type : this.filter.mTypes()) {
                        if (mt != type) continue;
                        typeMatch = true;
                        break;
                    }
                    if (!typeMatch) continue;
                }
                String fDesc = this.filter.description();
                String fName = this.filter.name();
                boolean isEmptyDescription = StringUtil.isEmptyString((String)fDesc);
                boolean isEmptyName = StringUtil.isEmptyString((String)fName);
                if (isEmptyDescription ? !isEmptyName && name.indexOf(fName) < 0 : (isEmptyName ? description.indexOf(fDesc) < 0 : !StringUtil.isEmptyString((String)name) && name.indexOf(fName) < 0 || !StringUtil.isEmptyString((String)fDesc) && description.indexOf(fDesc) < 0)) continue;
            }
            IRow row = this.macroTable.addRow();
            if (macroIds.contains(vo.getUuid())) {
                KDTSelectBlock sb = new KDTSelectBlock();
                sb.setTop(row.getRowIndex());
                sb.setLeft(0);
                sb.setBottom(row.getRowIndex());
                sb.setRight(0);
                sb.setMode(2);
                this.macroTable.getSelectManager().add(sb);
            }
            row.setUserObject((Object)vo);
            ICell cll = row.getCell(0);
            switch (mt) {
                case FUNCTION: {
                    cll.setRenderer((IBasicRender)this.funcRender);
                    break;
                }
                case SQL: {
                    cll.setRenderer((IBasicRender)this.sqlRender);
                }
            }
            cll.setValue((Object)name);
            row.getCell(1).setValue((Object)description);
            IExtRptMacro macro = vo.getMacro();
            switch (macro.mType()) {
                case FUNCTION: {
                    row.getCell(2).setValue((Object)((Object)((Object)macro.mType()) + "\uff1a" + macro.define()));
                    break;
                }
                case SQL: {
                    CtrlDesignQueryModel model = new CtrlDesignQueryModel();
                    model.setObjectSelector(new KsqlObjectSelector());
                    StringReader reader = new StringReader(macro.define());
                    try {
                        CtrlDesignUtil.toObject(null, model, new SAXBuilder().build((Reader)reader).getRootElement());
                        row.getCell(2).setValue((Object)((Object)((Object)macro.mType()) + "\uff1a" + CtrlDesignQueryModel.makeSQL(null, model)));
                        break;
                    }
                    catch (JDOMException e) {
                        throw MacroDesignException.newFailed2TranslateMacroContentException(e);
                    }
                    catch (IOException e) {
                        throw MacroDesignException.newFailed2TranslateMacroContentException(e);
                    }
                    catch (BOSException e) {
                        throw MacroDesignException.newFailed2TranslateMacroContentException(e);
                    }
                }
                default: {
                    row.getCell(2).setValue((Object)("UNKONW TYPE:" + macro.define()));
                }
            }
            row.getCell(3).setValue((Object)vt);
            row.getCell(4).setValue((Object)vo.getCreator());
            row.getCell(5).setValue((Object)vo.getCreateTime());
            row.getCell(6).setValue((Object)vo.getLastUpdater());
            row.getCell(7).setValue((Object)vo.getLastUpdateTime());
        }
        if (macroIds.isEmpty()) {
            this.macroTable.getSelectManager().select(0, 0);
        }
    }
}

