/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.mobile.util;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import java.awt.Component;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class LayoutParameterUtil {
    private static Logger logger = LogUtil.getPackageLogger(LayoutParameterUtil.class);
    public static final String KEY_SELECTED = "isSelected";
    public static final String COMMONPARAMS_LAYOUTINFO = "mobileparam_commonparam_layoutinfo";
    public static final String ALLPARAMS_LAYOUTINFO = "mobileparam_allparams_layoutinfo";
    public static final String ISLASTSAVEPARAM = "mobileparam_isLastSaveParam";
    public static final String FIRST_PLACE_HOLDER = "first_place_holder";
    public static final String LAST_PLACE_HOLDER = "end_place_holder";

    public static String commonParamsToXml(List<Component> allComps) {
        Element params = new Element("Parameters");
        for (Component comp : allComps) {
            DesignParameter dp = (DesignParameter)((Object)((KDLabel)comp).getUserObject());
            Element param = new Element("Parameter");
            param.setAttribute("name", dp.getName());
            param.setAttribute("x", String.valueOf(comp.getX()));
            param.setAttribute("y", String.valueOf(comp.getY()));
            param.setAttribute("width", String.valueOf(comp.getWidth()));
            param.setAttribute("height", String.valueOf(comp.getHeight()));
            params.addContent((Content)param);
        }
        Format format = Format.getPrettyFormat();
        format.setIndent(null);
        format.setEncoding("UTF-8");
        XMLOutputter outter = new XMLOutputter(format);
        String layoutInfo = outter.outputString(params);
        return layoutInfo;
    }

    public static String commonParamsToXml(Map<String, Double> paramPercentage) {
        if (paramPercentage == null) {
            return null;
        }
        Element params = new Element("Parameters");
        for (Map.Entry<String, Double> entry : paramPercentage.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            Element param = new Element("Parameter");
            param.setAttribute("name", entry.getKey());
            param.setAttribute("paramPercentage", entry.getValue().toString());
            params.addContent((Content)param);
        }
        Format format = Format.getPrettyFormat();
        format.setIndent(null);
        format.setEncoding("UTF-8");
        XMLOutputter outter = new XMLOutputter(format);
        String layoutInfo = outter.outputString(params);
        return layoutInfo;
    }

    public static String allParamsToXml(List<DesignParameter> allParams) {
        Element params = new Element("Parameters");
        int len = allParams.size();
        for (int i = 0; i < len; ++i) {
            Element param = new Element("Parameter");
            Boolean isSelected = (Boolean)allParams.get(i).getProperty(KEY_SELECTED);
            param.setAttribute("name", allParams.get(i).getName());
            param.setAttribute("index", String.valueOf(i));
            param.setAttribute(KEY_SELECTED, String.valueOf(isSelected != false ? 1 : 0));
            params.addContent((Content)param);
        }
        Format format = Format.getPrettyFormat();
        format.setIndent(null);
        format.setEncoding("UTF-8");
        XMLOutputter outter = new XMLOutputter(format);
        String layoutInfo = outter.outputString(params);
        return layoutInfo;
    }

    public static HashMap<String, Integer> allParamFromXml(String layoutInfo) {
        if (StringUtil.isEmptyString((String)layoutInfo)) {
            return null;
        }
        HashMap<String, Integer> layoutMap = null;
        try {
            StringReader in = new StringReader(layoutInfo);
            Document doc = new SAXBuilder().build((Reader)in);
            ((Reader)in).close();
            Element root = doc.getRootElement();
            layoutMap = new HashMap<String, Integer>();
            List elements = root.getChildren();
            for (Element element : elements) {
                layoutMap.put(element.getAttributeValue("name") + "_index", Integer.valueOf(element.getAttributeValue("index")));
                layoutMap.put(element.getAttributeValue("name") + "_isSelected", Integer.valueOf(element.getAttributeValue(KEY_SELECTED)));
            }
        }
        catch (Exception e) {
            logger.error((Object)("All params parase from xml error." + e));
            e.printStackTrace();
            return null;
        }
        return layoutMap;
    }

    public static HashMap<String, Double> commonParamFromXml(String layoutInfo) {
        if (StringUtil.isEmptyString((String)layoutInfo)) {
            return null;
        }
        HashMap<String, Double> layoutMap = null;
        try {
            StringReader in = new StringReader(layoutInfo);
            Document doc = new SAXBuilder().build((Reader)in);
            ((Reader)in).close();
            Element root = doc.getRootElement();
            List elements = root.getChildren();
            layoutMap = new HashMap<String, Double>();
            for (Element element : elements) {
                layoutMap.put(element.getAttributeValue("name"), Double.parseDouble(element.getAttributeValue("paramPercentage")));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Common params parase from xml error." + e));
            e.printStackTrace();
            return null;
        }
        return layoutMap;
    }

    public static boolean sortAllParams(List<DesignParameter> allParams, HashMap<String, Integer> colSpanMap) {
        boolean isSort = false;
        if (colSpanMap == null) {
            return isSort;
        }
        for (int i = 0; i < allParams.size(); ++i) {
            DesignParameter designParameter = allParams.get(i);
            Integer index = colSpanMap.get(designParameter.getName() + "_index");
            if (index == null || index == i || index >= allParams.size()) continue;
            Collections.swap(allParams, i, (int)index);
            isSort = true;
            --i;
        }
        return isSort;
    }

    public static ArrayList<DesignParameter> getAllUnionParam(Book book) {
        ExtDataSet[] datasets = MiscUtil.collectExtDataSets((Book)book);
        ArrayList<DesignParameter> allUnionParam = new ArrayList<DesignParameter>();
        String sourceReportOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        try {
            RunReportParam.cacheDbSourceModel(null, datasets, new ArrayList(), allUnionParam, null, sourceReportOrgID, null);
        }
        catch (Exception e) {
            logger.error((Object)("Get AllUnionParam error." + e));
            e.printStackTrace();
        }
        return allUnionParam;
    }
}

