/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.mobile.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.rpts.cardschedule.ScheduleEngine;
import com.kingdee.eas.rpts.cardschedule.exception.SchedulerException;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.CardContentBo;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.CardContentDAO;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.CardDAO;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.CardVO;
import com.kingdee.eas.rpts.ctrlreport.mobile.util.ParameterSetter;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MobileCardUtil {
    private static Logger logger = CommonLogger.getLogger(CardContentDAO.class);
    private static boolean pmdKnownBroken = false;

    public static void removeNoPermissionCards() throws BOSException {
        String sql = "SELECT t.FID, t.FREPORTID, t.FUSERID FROM T_EXT_MOBILECARD t where t.freportid not in (select distinct p.FReportID from T_EXT_Permission p where p.fpermission LIKE '1%' and p.FUserID = t.fuserid and p.FOrgID is null union all SELECT distinct p.FReportID from T_EXT_Permission p where p.fpermission LIKE '1%' and  p.FUserID = t.fuserid and p.FOrgID in ( select forgid from t_pm_orgrange  where  fuserid = t.fuserid and ftype = 10 ) union all SELECT distinct p.FReportID from T_EXT_Permission p where p.fpermission LIKE '1%' and p.froleid is not null and exists(select top 1 froleid from t_pm_userroleorg uro where uro.FUserID = t.fuserid and uro.froleid = p.froleid and exists (select top 1 forgid from t_pm_orgrange where fuserid = t.fuserid  and ftype = 10  and uro.FOrgID = forgid )))";
        try {
            IRowSet rs = ExtDBUtil.executeQuery(null, sql, null);
            while (rs.next()) {
                String reportid = rs.getString("FREPORTID");
                String userid = rs.getString("FUSERID");
                String fid = rs.getString("FID");
                MobileCardUtil.releaseCard(null, reportid, userid, fid);
            }
        }
        catch (BOSException e) {
            logger.debug((Object)("\u6570\u636e\u5e93\u6267\u884c\uff0c\u5220\u9664\u6ca1\u6743\u9650\u7684\u5361\u7247\u5931\u8d25\uff01" + e.getMessage()));
            throw e;
        }
        catch (SQLException e) {
            logger.debug((Object)("\u6570\u636e\u5e93\u6267\u884c\uff0c\u5220\u9664\u6ca1\u6743\u9650\u7684\u5361\u7247\u5931\u8d25\uff01" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        catch (ExtRptBizException e) {
            logger.debug((Object)("\u6570\u636e\u5e93\u6267\u884c\uff0c\u5220\u9664\u6ca1\u6743\u9650\u7684\u5361\u7247\u5931\u8d25\uff01" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        catch (SchedulerException e) {
            logger.debug((Object)("\u6570\u636e\u5e93\u6267\u884c\uff0c\u5220\u9664\u5361\u7247\u8c03\u5ea6\u5931\u8d25\uff01" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
    }

    public static void releaseCard(Context ctx, String reportId) throws ExtRptBizException, SchedulerException {
        try {
            ArrayList<CardVO> list = CardDAO.getCardByReportId(ctx, reportId);
            for (CardVO vo : list) {
                MobileCardUtil.releaseCard(ctx, vo.getReportId(), vo.getUserId(), vo.getFid());
            }
        }
        catch (ExtRptBizException e) {
            logger.debug((Object)("\u6570\u636e\u5e93\u6267\u884c\u5931\u8d25\uff01" + e.getMessage()));
            throw e;
        }
        catch (SchedulerException e) {
            logger.debug((Object)("\u8c03\u5ea6\u91ca\u653e\u5931\u8d25\uff01" + e.getMessage()));
            throw e;
        }
    }

    public static void releaseCard(Context ctx, String reportId, String userId, String fid) throws ExtRptBizException, SchedulerException {
        try {
            CardDAO.deleteCardByReportId(ctx, reportId, userId);
            CardDAO.deleteCardContent(ctx, fid);
            ArrayList<CardVO> cardByReportId = CardDAO.getCardByReportId(ctx, reportId);
            if (cardByReportId.size() == 0) {
                ScheduleEngine engine = new ScheduleEngine();
                engine.deleteJob(ctx, reportId);
            }
        }
        catch (ExtRptBizException e) {
            logger.debug((Object)("\u6570\u636e\u5e93\u6267\u884c\u5931\u8d25\uff01" + e.getMessage()));
            throw e;
        }
        catch (SchedulerException e) {
            logger.debug((Object)("\u8c03\u5ea6\u91ca\u653e\u5931\u8d25\uff01" + e.getMessage()));
            throw e;
        }
    }

    private static void setParams(PreparedStatement stmt, Object[] params) throws SQLException {
        pmdKnownBroken = false;
        if (params == null || params.length == 0) {
            return;
        }
        ParameterMetaData pmd = null;
        if (!pmdKnownBroken) {
            int paramsCount;
            pmd = stmt.getParameterMetaData();
            int stmtCount = pmd.getParameterCount();
            int n = paramsCount = params == null ? 0 : params.length;
            if (stmtCount != paramsCount) {
                throw new SQLException("Wrong number of parameters: expected " + stmtCount + ", was given " + paramsCount);
            }
        }
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param != null) {
                ParameterSetter.set(stmt, param, i + 1);
                continue;
            }
            int sqlType = 12;
            if (!pmdKnownBroken) {
                try {
                    sqlType = pmd.getParameterType(i + 1);
                }
                catch (SQLException e) {
                    pmdKnownBroken = true;
                }
            }
            stmt.setNull(i + 1, sqlType);
        }
    }

    private static void execute(Connection conn, String sql, Object[] params) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            MobileCardUtil.setParams(ps, params);
            ps.execute();
        }
        catch (SQLException e) {
            logger.debug((Object)("\u6570\u636e\u5e93\u6267\u884c\u5931\u8d25\uff01" + e.getMessage()));
            throw e;
        }
        finally {
            MobileCardUtil.close(ps);
            MobileCardUtil.close(rs);
        }
    }

    public static void execute(Context ctx, String sql, Object[] params) throws SQLException {
        Connection conn = MobileCardUtil.createConnection(ctx);
        MobileCardUtil.execute(conn, sql, params);
    }

    public static void executeBatch(Context ctx, String sql, List<Object[]> params) throws SQLException {
        Connection conn = MobileCardUtil.createConnection(ctx);
        for (Object[] param : params) {
            MobileCardUtil.execute(conn, sql, param);
        }
    }

    public static CardContentBo queryCardContent(Context ctx, String sql, Object[] params) throws SQLException {
        CardContentBo cardContentBo;
        logger.debug((Object)("\u6570\u636e\u5e93\u6267\u884csql:" + sql + "\t params:" + params.toString()));
        Connection conn = MobileCardUtil.createConnection(ctx);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            CardContentBo bo = new CardContentBo();
            ps = conn.prepareStatement(sql);
            MobileCardUtil.setParams(ps, params);
            rs = ps.executeQuery();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while (rs.next()) {
                try {
                    os.write(rs.getBytes("FCARDCONTENT"));
                    bo.setLastUpdateTime(rs.getTimestamp("FLASTUPDATETIME"));
                }
                catch (IOException e) {
                    throw new SQLException("read blod failed.", e);
                }
            }
            bo.setCardContent(os.toByteArray());
            cardContentBo = bo;
        }
        catch (SQLException e) {
            try {
                logger.debug((Object)("\u6570\u636e\u5e93\u6267\u884c\u5931\u8d25\uff01sql:" + sql + e.getMessage()));
                throw e;
            }
            catch (Throwable throwable) {
                MobileCardUtil.close(ps);
                MobileCardUtil.close(rs);
                throw throwable;
            }
        }
        MobileCardUtil.close(ps);
        MobileCardUtil.close(rs);
        return cardContentBo;
    }

    public static Object createSqlParameterBytes(byte[] buf, int offset, int length) {
        byte[] subBlock = new byte[length];
        System.arraycopy(buf, offset, subBlock, 0, length);
        return subBlock;
    }

    private static Connection createConnection(Context ctx) throws SQLException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            logger.debug((Object)"\u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            throw new SQLException("can not open an connetciton", e);
        }
    }

    public static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Statement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Statement ps, ResultSet rs) {
        MobileCardUtil.close(rs);
        MobileCardUtil.close(ps);
    }

    public static void close(Connection conn, Statement ps, ResultSet rs) {
        MobileCardUtil.close(rs);
        MobileCardUtil.close(ps);
        MobileCardUtil.close(conn);
    }
}

